/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2016-03-18 20:14:43 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=33439 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8008 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4424 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=708 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("8", "1162", "AnimailLimo Pet Taxi from CC&amp;C Ensures Pet Owners Don\'t Miss Vet and Groomer Appointments", "", "http://news.money.ca/2015/03/18/animaillimo-pet-taxi-from-ccc-ensures-pet-owners-dont-miss-vet-and-groomer-appointments/", "208.109.181.10", "2015-03-18 08:02:12", "2015-03-18 08:02:12", "[&#8230;] has recently published a series of blog posts on pet transportation safety. Learn more about this important topic by going to: [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/3.9.3", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "618", "Mobile Notary Oakland and Notary Public Castro Valley Open in East Bay &#8211; Press Release Rocket", "", "http://www.pressreleaserocket.net/mobile-notary-oakland-and-notary-public-castro-valley-open-in-east-bay/201144/", "184.95.45.161", "2015-05-31 07:14:24", "2015-05-31 07:14:24", "[&#8230;] notary services in the East Bay. In addition to notarizing standard documents, the traveling two mobile notary public services specialize in home loan packages and expediting apostille and authentication of documents [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/4.1.5", "pingback", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20160318_notarypublicsanfrancisco", "56ec619b847bd8882160318201419", "20", "2016-03-18 20:14:43", "johnny", "O:11:\"DUP_Package\":21:{s:2:\"ID\";i:1;s:4:\"Name\";s:33:\"20160318_notarypublicsanfrancisco\";s:4:\"Hash\";s:29:\"56ec619b847bd8882160318201419\";s:8:\"NameHash\";s:63:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419\";s:7:\"Version\";s:5:\"1.1.4\";s:9:\"VersionWP\";s:5:\"4.4.2\";s:9:\"VersionDB\";s:11:\"5.5.42-37.1\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:73:\"/home3/johnny/public_html/notarypublicsanfranciscoca.com/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://notarypublicsanfranciscoca.com/wp-snapshots/\";s:8:\"ScanFile\";s:73:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"johnny\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:75:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:56:\"/home3/johnny/public_html/notarypublicsanfranciscoca.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":21:{s:2:\"ID\";N;s:4:\"Name\";s:33:\"20160318_notarypublicsanfrancisco\";s:4:\"Hash\";s:29:\"56ec619b847bd8882160318201419\";s:8:\"NameHash\";s:63:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419\";s:7:\"Version\";s:5:\"1.1.4\";s:9:\"VersionWP\";s:5:\"4.4.2\";s:9:\"VersionDB\";s:11:\"5.5.42-37.1\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:73:\"/home3/johnny/public_html/notarypublicsanfranciscoca.com/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://notarypublicsanfranciscoca.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:20;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:77:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:50;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:76:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:70;s:8:\"Database\";r:83;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://notarypublicsanfranciscoca.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://notarypublicsanfranciscoca.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Notary Public San Francisco", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Notary Public - Mobile Notary - Loan Signing Agent In San Francisco", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "john@mobilenotarysanfrancisco.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "4", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:18:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:2;s:17:\"booked/booked.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:33:\"duplicate-post/duplicate-post.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:39:\"easy-theme-and-plugin-upgrades/init.php\";i:7;s:34:\"envato-wordpress-toolkit/index.php\";i:8;s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";i:9;s:35:\"insert-headers-and-footers/ihaf.php\";i:10;s:19:\"jetpack/jetpack.php\";i:11;s:27:\"js_composer/js_composer.php\";i:12;s:29:\"mailchimp-wp/mailchimp-wp.php\";i:13;s:40:\"mojo-marketplace-hg/mojo-marketplace.php\";i:14;s:38:\"recent-tweets-widget/recent-tweets.php\";i:15;s:23:\"revslider/revslider.php\";i:16;s:41:\"wordpress-importer/wordpress-importer.php\";i:17;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("41", "template", "betheme", "yes");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "betheme", "yes");
INSERT INTO `wp_options` VALUES("43", "comment_whitelist", "", "yes");
INSERT INTO `wp_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("45", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("49", "db_version", "35700", "yes");
INSERT INTO `wp_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("53", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("54", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_link_type", "file", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments", "", "yes");
INSERT INTO `wp_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("74", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("78", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_text", "a:3:{i:2;a:3:{s:5:\"title\";s:4:\"test\";s:4:\"text\";s:4:\"test\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:4:\"test\";s:4:\"text\";s:4:\"test\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("82", "uninstall_plugins", "a:3:{s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";a:2:{i:0;s:16:\"GADASH_Uninstall\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("83", "timezone_string", "America/Los_Angeles", "yes");
INSERT INTO `wp_options` VALUES("85", "page_on_front", "3170", "yes");
INSERT INTO `wp_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "initial_db_version", "29630", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_user_roles", "a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:64:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:10:\"copy_posts\";b:1;s:24:\"edit_booked_appointments\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:20:\"booked_booking_agent\";a:2:{s:4:\"name\";s:13:\"Booking Agent\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:24:\"edit_booked_appointments\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("90", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("91", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("92", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "sidebars_widgets", "a:13:{s:19:\"wp_inactive_widgets\";a:0:{}s:13:\"footer-area-1\";a:0:{}s:13:\"footer-area-2\";a:0:{}s:13:\"footer-area-3\";a:0:{}s:13:\"footer-area-4\";a:0:{}s:10:\"top-area-1\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:10:\"top-area-2\";a:0:{}s:10:\"top-area-3\";a:0:{}s:10:\"top-area-4\";a:0:{}s:5:\"forum\";a:0:{}s:6:\"events\";a:0:{}s:4:\"shop\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("96", "cron", "a:10:{i:1458332397;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1458332638;a:1:{s:14:\"mm_cron_hourly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1458352244;a:2:{s:13:\"mm_cron_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"mm_cron_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1458365556;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1458408775;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1458409540;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1458697844;a:1:{s:14:\"mm_cron_weekly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1459518644;a:1:{s:15:\"mm_cron_monthly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}i:1477958400;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"076b1c11a1e4b9cd1280bbaf1795a441\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4395;}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("123", "recently_activated", "a:1:{s:27:\"wp-super-cache/wp-cache.php\";i:1458332031;}", "yes");
INSERT INTO `wp_options` VALUES("125", "ossdl_off_cdn_url", "http://notarypublicsanfranciscoca.com/", "yes");
INSERT INTO `wp_options` VALUES("126", "ossdl_off_include_dirs", "wp-content,wp-includes", "yes");
INSERT INTO `wp_options` VALUES("127", "ossdl_off_exclude", ".php", "yes");
INSERT INTO `wp_options` VALUES("128", "ossdl_cname", "", "yes");
INSERT INTO `wp_options` VALUES("129", "jetpack_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("130", "jetpack_options", "a:3:{s:7:\"version\";s:16:\"3.1.1:1410889264\";s:11:\"old_version\";s:16:\"3.1.1:1410889264\";s:20:\"last_security_report\";i:1434727645;}", "yes");
INSERT INTO `wp_options` VALUES("135", "wpsupercache_start", "1410889364", "yes");
INSERT INTO `wp_options` VALUES("136", "wpsupercache_count", "0", "yes");
INSERT INTO `wp_options` VALUES("137", "supercache_stats", "a:3:{s:9:\"generated\";i:1410890650;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:12:\"expired_list\";a:0:{}s:6:\"cached\";i:0;s:11:\"cached_list\";a:0:{}s:2:\"ts\";i:1410890650;}s:7:\"wpcache\";a:3:{s:6:\"cached\";i:0;s:7:\"expired\";i:0;s:5:\"fsize\";s:3:\"0KB\";}}", "yes");
INSERT INTO `wp_options` VALUES("150", "jpstart_wizard_has_run", "1", "yes");
INSERT INTO `wp_options` VALUES("151", "wpsupercache_gc_time", "1427329253", "yes");
INSERT INTO `wp_options` VALUES("157", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("161", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:33:\"john@mobilenotarysanfrancisco.com\";s:7:\"version\";s:5:\"4.4.2\";s:9:\"timestamp\";i:1454436280;}", "yes");
INSERT INTO `wp_options` VALUES("165", "mm_previous_tests", "a:1:{i:0;s:18:\"spam-prevention-v1\";}", "yes");
INSERT INTO `wp_options` VALUES("172", "jetpack_file_data", "a:1:{s:5:\"3.9.4\";a:49:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:89:\"Check your spelling, style, and grammar with the After the Deadline proofreading service.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:63:\"Transform standard image galleries into full-screen slideshows.\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:79:\"Let readers comment with WordPress.com, Twitter, Facebook, or Google+ accounts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:44:\"Insert a contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:92:\"Organize and display different types of content on your site, separate from posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:57:\"Customize your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:46:\"Add support for infinite scroll to your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:69:\"Allow applications to securely access your content through the cloud.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:85:\"Use LaTeX markup language in posts and pages for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:70:\"Give visitors an easy way to show their appreciation for your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:76:\"Manage all your sites from a centralized place, https://wordpress.com/sites.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:22:\"Recommended, Jumpstart\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:64:\"Optimize your site with a mobile-friendly theme for smartphones.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:25:\"Reports on site downtime.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:84:\"Receive notification of site activity via the admin toolbar and your Mobile devices.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your Dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:27:\"Speed up images and photos.\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:44:\"Recommended, Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:58:\"Publish posts by email, using any device and email client.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:28:\"Prevent brute force attacks.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:30:\"Automatically promote content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:24:\"Display similar content.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:32:\"Visitors can share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:77:\"Embed content from YouTube, Vimeo, SlideShare, and more, no coding necessary.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:251:\"shortcodes, shortcode, embeds, media, bandcamp, blip.tv, dailymotion, digg, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:56:\"Enable WP.me-powered shortlinks for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:9:\"Site Icon\";s:11:\"description\";s:29:\"Add a site icon to your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:24:\"favicon, icon, site icon\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:75:\"Creates sitemaps to allow your site to be easily indexed by search engines.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:27:\"Secure user authentication.\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:31:\"Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:35:\"Collect traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:88:\"Allow users to subscribe to your posts and comments and receive notifications via email.\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:73:\"Display your image galleries in a variety of sleek, graphic arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:27:\"Daily or real-time backups.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:20:\"Performance-Security\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:77:\"Verify your site or domain with Google Search Console, Pinterest, and others.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:68:\"Upload and embed videos right on your site. (Subscription required.)\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:57:\"Specify which widgets appear on which pages of your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:79:\"Add images, Twitter streams, your site’s RSS links, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("173", "jetpack_available_modules", "a:1:{s:5:\"3.9.4\";a:37:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:9:\"site-icon\";s:3:\"3.2\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";}}", "yes");
INSERT INTO `wp_options` VALUES("174", "mm_master_aff", "hostgator", "yes");
INSERT INTO `wp_options` VALUES("175", "mm_install_date", "Dec 31, 2014", "yes");
INSERT INTO `wp_options` VALUES("178", "mm_cron", "a:3:{s:6:\"weekly\";a:2:{s:15:\"spam_blocked_ip\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:15:\"spam_blocked_ip\";s:2:\"el\";i:0;}s:10:\"wp_version\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:10:\"wp_version\";s:2:\"el\";s:5:\"4.4.2\";}}s:5:\"daily\";a:1:{s:14:\"plugin_version\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:14:\"plugin_version\";s:2:\"el\";s:5:\"0.5.9\";}}s:7:\"monthly\";a:3:{s:12:\"plugin_count\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:12:\"plugin_count\";s:2:\"el\";i:18;}s:11:\"theme_count\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:11:\"theme_count\";s:2:\"el\";i:6;}s:13:\"current_theme\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:13:\"current_theme\";s:2:\"el\";s:7:\"betheme\";}}}", "yes");
INSERT INTO `wp_options` VALUES("214", "theme_mods_twentyfourteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1419990676;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("215", "current_theme", "Betheme", "yes");
INSERT INTO `wp_options` VALUES("216", "theme_mods_salient", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"top_nav\";i:40;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1421878753;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;s:9:\"sidebar-7\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("217", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("218", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"375\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("219", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"630\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("220", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"130\";s:6:\"height\";s:3:\"130\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("221", "salient", "a:351:{s:8:\"last_tab\";s:1:\"4\";s:10:\"theme-skin\";s:6:\"ascend\";s:7:\"favicon\";s:0:\"\";s:11:\"back-to-top\";s:1:\"1\";s:16:\"smooth-scrolling\";s:1:\"1\";s:10:\"responsive\";s:1:\"1\";s:14:\"ext_responsive\";s:1:\"1\";s:16:\"google-analytics\";s:0:\"\";s:10:\"custom-css\";s:28:\"                            \";s:12:\"accent-color\";s:7:\"#f96566\";s:13:\"extra-color-1\";s:7:\"#f96566\";s:13:\"extra-color-2\";s:7:\"#00d8b2\";s:13:\"extra-color-3\";s:7:\"#333333\";s:16:\"background-color\";s:7:\"#f1f1f1\";s:16:\"background_image\";s:0:\"\";s:17:\"background-repeat\";s:9:\"no-repeat\";s:19:\"background-position\";s:8:\"left top\";s:21:\"background-attachment\";s:6:\"scroll\";s:16:\"use-custom-fonts\";s:1:\"1\";s:9:\"body_font\";s:1:\"-\";s:14:\"body_font_size\";s:4:\"14px\";s:21:\"body_font_line_height\";s:1:\"-\";s:15:\"body_font_style\";s:1:\"-\";s:19:\"body_font_transform\";s:1:\"-\";s:17:\"body_font_spacing\";s:1:\"-\";s:16:\"body_font_subset\";s:6:\"subset\";s:15:\"navigation_font\";s:18:\"Lovelo, sans-serif\";s:20:\"navigation_font_size\";s:4:\"12px\";s:27:\"navigation_font_line_height\";s:1:\"-\";s:21:\"navigation_font_style\";s:1:\"-\";s:25:\"navigation_font_transform\";s:9:\"uppercase\";s:23:\"navigation_font_spacing\";s:3:\"2px\";s:22:\"navigation_font_subset\";s:6:\"subset\";s:24:\"navigation_dropdown_font\";s:1:\"-\";s:29:\"navigation_dropdown_font_size\";s:1:\"-\";s:36:\"navigation_dropdown_font_line_height\";s:1:\"-\";s:30:\"navigation_dropdown_font_style\";s:1:\"-\";s:34:\"navigation_dropdown_font_transform\";s:1:\"-\";s:32:\"navigation_dropdown_font_spacing\";s:1:\"-\";s:31:\"navigation_dropdown_font_subset\";s:6:\"subset\";s:26:\"nectar_slider_heading_font\";s:18:\"Lovelo, sans-serif\";s:31:\"nectar_slider_heading_font_size\";s:4:\"71px\";s:38:\"nectar_slider_heading_font_line_height\";s:1:\"-\";s:32:\"nectar_slider_heading_font_style\";s:7:\"regular\";s:36:\"nectar_slider_heading_font_transform\";s:9:\"uppercase\";s:34:\"nectar_slider_heading_font_spacing\";s:3:\"2px\";s:33:\"nectar_slider_heading_font_subset\";s:6:\"subset\";s:24:\"home_slider_caption_font\";s:17:\"Libre Baskerville\";s:29:\"home_slider_caption_font_size\";s:4:\"22px\";s:36:\"home_slider_caption_font_line_height\";s:1:\"-\";s:30:\"home_slider_caption_font_style\";s:6:\"italic\";s:34:\"home_slider_caption_font_transform\";s:10:\"capitalize\";s:32:\"home_slider_caption_font_spacing\";s:1:\"-\";s:31:\"home_slider_caption_font_subset\";s:6:\"subset\";s:16:\"testimonial_font\";s:12:\"Merriweather\";s:21:\"testimonial_font_size\";s:4:\"19px\";s:28:\"testimonial_font_line_height\";s:1:\"-\";s:22:\"testimonial_font_style\";s:1:\"-\";s:26:\"testimonial_font_transform\";s:1:\"-\";s:24:\"testimonial_font_spacing\";s:1:\"-\";s:23:\"testimonial_font_subset\";s:6:\"subset\";s:21:\"sidebar_footer_h_font\";s:18:\"Lovelo, sans-serif\";s:26:\"sidebar_footer_h_font_size\";s:4:\"14px\";s:33:\"sidebar_footer_h_font_line_height\";s:1:\"-\";s:27:\"sidebar_footer_h_font_style\";s:7:\"regular\";s:31:\"sidebar_footer_h_font_transform\";s:1:\"-\";s:29:\"sidebar_footer_h_font_spacing\";s:3:\"2px\";s:28:\"sidebar_footer_h_font_subset\";s:6:\"subset\";s:17:\"page_heading_font\";s:18:\"Lovelo, sans-serif\";s:22:\"page_heading_font_size\";s:4:\"80px\";s:29:\"page_heading_font_line_height\";s:1:\"-\";s:23:\"page_heading_font_style\";s:1:\"-\";s:27:\"page_heading_font_transform\";s:1:\"-\";s:25:\"page_heading_font_spacing\";s:1:\"-\";s:24:\"page_heading_font_subset\";s:6:\"subset\";s:26:\"page_heading_subtitle_font\";s:17:\"Libre Baskerville\";s:31:\"page_heading_subtitle_font_size\";s:4:\"26px\";s:38:\"page_heading_subtitle_font_line_height\";s:1:\"-\";s:32:\"page_heading_subtitle_font_style\";s:6:\"italic\";s:36:\"page_heading_subtitle_font_transform\";s:1:\"-\";s:34:\"page_heading_subtitle_font_spacing\";s:1:\"-\";s:33:\"page_heading_subtitle_font_subset\";s:6:\"subset\";s:18:\"team_member_h_font\";s:1:\"-\";s:23:\"team_member_h_font_size\";s:1:\"-\";s:30:\"team_member_h_font_line_height\";s:1:\"-\";s:24:\"team_member_h_font_style\";s:1:\"-\";s:28:\"team_member_h_font_transform\";s:1:\"-\";s:26:\"team_member_h_font_spacing\";s:1:\"-\";s:25:\"team_member_h_font_subset\";s:6:\"subset\";s:7:\"h1_font\";s:18:\"Lovelo, sans-serif\";s:12:\"h1_font_size\";s:4:\"54px\";s:19:\"h1_font_line_height\";s:1:\"-\";s:13:\"h1_font_style\";s:1:\"-\";s:17:\"h1_font_transform\";s:9:\"uppercase\";s:15:\"h1_font_spacing\";s:1:\"-\";s:14:\"h1_font_subset\";s:6:\"subset\";s:7:\"h2_font\";s:12:\"Merriweather\";s:12:\"h2_font_size\";s:4:\"27px\";s:19:\"h2_font_line_height\";s:1:\"-\";s:13:\"h2_font_style\";s:1:\"-\";s:17:\"h2_font_transform\";s:1:\"-\";s:15:\"h2_font_spacing\";s:1:\"-\";s:14:\"h2_font_subset\";s:6:\"subset\";s:7:\"h3_font\";s:18:\"Lovelo, sans-serif\";s:12:\"h3_font_size\";s:4:\"20px\";s:19:\"h3_font_line_height\";s:1:\"-\";s:13:\"h3_font_style\";s:1:\"-\";s:17:\"h3_font_transform\";s:1:\"-\";s:15:\"h3_font_spacing\";s:3:\"2px\";s:14:\"h3_font_subset\";s:6:\"subset\";s:7:\"h4_font\";s:12:\"Merriweather\";s:12:\"h4_font_size\";s:1:\"-\";s:19:\"h4_font_line_height\";s:1:\"-\";s:13:\"h4_font_style\";s:1:\"-\";s:17:\"h4_font_transform\";s:1:\"-\";s:15:\"h4_font_spacing\";s:1:\"-\";s:14:\"h4_font_subset\";s:6:\"subset\";s:7:\"h5_font\";s:12:\"Merriweather\";s:12:\"h5_font_size\";s:4:\"23px\";s:19:\"h5_font_line_height\";s:1:\"-\";s:13:\"h5_font_style\";s:1:\"-\";s:17:\"h5_font_transform\";s:1:\"-\";s:15:\"h5_font_spacing\";s:5:\"0.5px\";s:14:\"h5_font_subset\";s:6:\"subset\";s:6:\"i_font\";s:17:\"Libre Baskerville\";s:11:\"i_font_size\";s:4:\"18px\";s:13:\"i_line_height\";s:1:\"-\";s:12:\"i_font_style\";s:6:\"italic\";s:16:\"i_font_transform\";s:10:\"capitalize\";s:14:\"i_font_spacing\";s:5:\"0.5px\";s:13:\"i_font_subset\";s:6:\"subset\";s:13:\"header_format\";s:7:\"default\";s:8:\"use-logo\";s:1:\"1\";s:4:\"logo\";s:104:\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/castro-valley-dog-sitter-paws-black.png\";s:11:\"retina-logo\";s:107:\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/castro-valley-dog-sitter-paws-black-2X.png\";s:11:\"logo-height\";s:2:\"60\";s:14:\"header-padding\";s:2:\"20\";s:18:\"transparent-header\";s:1:\"1\";s:20:\"header-starting-logo\";s:104:\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/castro-valley-dog-sitter-paws-white.png\";s:27:\"header-starting-retina-logo\";s:107:\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/castro-valley-dog-sitter-paws-white-2X.png\";s:25:\"header-starting-logo-dark\";s:0:\"\";s:32:\"header-starting-retina-logo-dark\";s:0:\"\";s:21:\"header-starting-color\";s:7:\"#ffffff\";s:24:\"header-inherit-row-color\";s:1:\"1\";s:23:\"header-resize-on-scroll\";s:1:\"1\";s:34:\"header-resize-on-scroll-shrink-num\";s:1:\"5\";s:16:\"header-fullwidth\";s:1:\"1\";s:26:\"header-disable-ajax-search\";s:1:\"1\";s:12:\"header-color\";s:6:\"custom\";s:23:\"header-background-color\";s:7:\"#ffffff\";s:17:\"header-font-color\";s:7:\"#333333\";s:23:\"header-font-hover-color\";s:7:\"#f6653c\";s:32:\"header-dropdown-background-color\";s:7:\"#1c1c1c\";s:38:\"header-dropdown-background-hover-color\";s:7:\"#212121\";s:26:\"header-dropdown-font-color\";s:7:\"#CCCCCC\";s:32:\"header-dropdown-font-hover-color\";s:7:\"#ffffff\";s:33:\"secondary-header-background-color\";s:7:\"#F8F8F8\";s:27:\"secondary-header-font-color\";s:7:\"#666666\";s:33:\"secondary-header-font-hover-color\";s:7:\"#222222\";s:45:\"header-slide-out-widget-area-background-color\";s:0:\"\";s:41:\"header-slide-out-widget-area-header-color\";s:0:\"\";s:34:\"header-slide-out-widget-area-color\";s:0:\"\";s:40:\"header-slide-out-widget-area-hover-color\";s:0:\"\";s:13:\"header_layout\";s:8:\"standard\";s:23:\"enable-main-footer-area\";s:1:\"1\";s:14:\"footer_columns\";s:1:\"4\";s:23:\"footer-background-color\";s:7:\"#313233\";s:17:\"footer-font-color\";s:7:\"#CCCCCC\";s:27:\"footer-secondary-font-color\";s:7:\"#777777\";s:33:\"footer-copyright-background-color\";s:7:\"#1F1F1F\";s:27:\"footer-copyright-font-color\";s:7:\"#777777\";s:21:\"footer-copyright-text\";s:20:\"All Rights Reserved.\";s:17:\"use-facebook-icon\";s:1:\"1\";s:16:\"use-twitter-icon\";s:1:\"1\";s:20:\"use-google-plus-icon\";s:1:\"1\";s:14:\"use-vimeo-icon\";s:1:\"1\";s:17:\"use-dribbble-icon\";s:1:\"1\";s:18:\"use-pinterest-icon\";s:1:\"1\";s:17:\"use-linkedin-icon\";s:1:\"1\";s:15:\"use-github-icon\";s:1:\"1\";s:22:\"use-stackexchange-icon\";s:1:\"1\";s:17:\"ajax-page-loading\";s:1:\"1\";s:17:\"transition-method\";s:4:\"ajax\";s:13:\"loading-image\";s:0:\"\";s:23:\"loading-image-animation\";s:4:\"none\";s:8:\"cta-text\";s:0:\"\";s:7:\"cta-btn\";s:0:\"\";s:12:\"cta-btn-link\";s:0:\"\";s:20:\"cta-background-color\";s:7:\"#ECEBE9\";s:14:\"cta-text-color\";s:7:\"#4B4F52\";s:13:\"cta-btn-color\";s:12:\"accent-color\";s:21:\"main_portfolio_layout\";s:1:\"3\";s:28:\"main_portfolio_project_style\";s:1:\"1\";s:16:\"portfolio_social\";s:1:\"1\";s:26:\"portfolio-facebook-sharing\";s:1:\"1\";s:25:\"portfolio-twitter-sharing\";s:1:\"1\";s:27:\"portfolio-pinterest-sharing\";s:1:\"1\";s:14:\"portfolio_date\";s:1:\"1\";s:25:\"portfolio_pagination_type\";s:7:\"default\";s:27:\"portfolio_pagination_number\";s:0:\"\";s:22:\"portfolio_rewrite_slug\";s:0:\"\";s:14:\"carousel-title\";s:0:\"\";s:13:\"carousel-link\";s:0:\"\";s:23:\"portfolio-sortable-text\";s:0:\"\";s:19:\"main-portfolio-link\";s:0:\"\";s:9:\"blog_type\";s:16:\"std-blog-sidebar\";s:10:\"author_bio\";s:1:\"1\";s:19:\"blog_excerpt_length\";s:0:\"\";s:19:\"blog_next_post_link\";s:1:\"1\";s:16:\"blog_header_type\";s:10:\"fullscreen\";s:17:\"blog_hide_sidebar\";s:1:\"1\";s:24:\"blog_hide_featured_image\";s:1:\"1\";s:11:\"blog_social\";s:1:\"1\";s:21:\"blog-facebook-sharing\";s:1:\"1\";s:20:\"blog-twitter-sharing\";s:1:\"1\";s:22:\"blog-pinterest-sharing\";s:1:\"1\";s:20:\"blog_pagination_type\";s:7:\"default\";s:18:\"recent-posts-title\";s:0:\"\";s:17:\"recent-posts-link\";s:0:\"\";s:10:\"zoom-level\";s:0:\"\";s:10:\"center-lat\";s:0:\"\";s:10:\"center-lng\";s:0:\"\";s:10:\"marker-img\";s:0:\"\";s:20:\"enable-map-animation\";s:1:\"1\";s:9:\"latitude1\";s:0:\"\";s:10:\"longitude1\";s:0:\"\";s:9:\"map-info1\";s:0:\"\";s:9:\"latitude2\";s:0:\"\";s:10:\"longitude2\";s:0:\"\";s:9:\"map-info2\";s:0:\"\";s:9:\"latitude3\";s:0:\"\";s:10:\"longitude3\";s:0:\"\";s:9:\"map-info3\";s:0:\"\";s:9:\"latitude4\";s:0:\"\";s:10:\"longitude4\";s:0:\"\";s:9:\"map-info4\";s:0:\"\";s:9:\"latitude5\";s:0:\"\";s:10:\"longitude5\";s:0:\"\";s:9:\"map-info5\";s:0:\"\";s:9:\"latitude6\";s:0:\"\";s:10:\"longitude6\";s:0:\"\";s:9:\"map-info6\";s:0:\"\";s:9:\"latitude7\";s:0:\"\";s:10:\"longitude7\";s:0:\"\";s:9:\"map-info7\";s:0:\"\";s:9:\"latitude8\";s:0:\"\";s:10:\"longitude8\";s:0:\"\";s:9:\"map-info8\";s:0:\"\";s:9:\"latitude9\";s:0:\"\";s:10:\"longitude9\";s:0:\"\";s:9:\"map-info9\";s:0:\"\";s:10:\"latitude10\";s:0:\"\";s:11:\"longitude10\";s:0:\"\";s:10:\"map-info10\";s:0:\"\";s:20:\"add-remove-locations\";s:0:\"\";s:9:\"map-color\";s:0:\"\";s:24:\"slider-caption-animation\";s:1:\"1\";s:23:\"slider-background-cover\";s:1:\"1\";s:15:\"slider-autoplay\";s:1:\"1\";s:20:\"slider-advance-speed\";s:0:\"\";s:22:\"slider-animation-speed\";s:0:\"\";s:13:\"slider-height\";s:0:\"\";s:15:\"slider-bg-color\";s:7:\"#000000\";s:24:\"sharing_btn_accent_color\";s:1:\"1\";s:12:\"facebook-url\";s:0:\"\";s:11:\"twitter-url\";s:0:\"\";s:15:\"google-plus-url\";s:0:\"\";s:9:\"vimeo-url\";s:0:\"\";s:12:\"dribbble-url\";s:0:\"\";s:13:\"pinterest-url\";s:0:\"\";s:11:\"youtube-url\";s:0:\"\";s:10:\"tumblr-url\";s:0:\"\";s:12:\"linkedin-url\";s:0:\"\";s:7:\"rss-url\";s:0:\"\";s:11:\"behance-url\";s:0:\"\";s:10:\"flickr-url\";s:0:\"\";s:11:\"spotify-url\";s:0:\"\";s:13:\"instagram-url\";s:0:\"\";s:10:\"github-url\";s:0:\"\";s:17:\"stackexchange-url\";s:0:\"\";s:14:\"soundcloud-url\";s:0:\"\";s:6:\"vk-url\";s:0:\"\";s:18:\"one-page-scrolling\";i:0;s:10:\"disable-vc\";i:0;s:16:\"default-lightbox\";i:0;s:20:\"external-dynamic-css\";i:0;s:12:\"boxed_layout\";i:0;s:16:\"background-cover\";i:0;s:19:\"extended-theme-font\";i:0;s:20:\"header-remove-border\";i:0;s:28:\"header-slide-out-widget-area\";i:0;s:21:\"header-disable-search\";i:0;s:23:\"enable_social_in_header\";i:0;s:24:\"use-facebook-icon-header\";i:0;s:23:\"use-twitter-icon-header\";i:0;s:27:\"use-google-plus-icon-header\";i:0;s:21:\"use-vimeo-icon-header\";i:0;s:24:\"use-dribbble-icon-header\";i:0;s:25:\"use-pinterest-icon-header\";i:0;s:23:\"use-youtube-icon-header\";i:0;s:22:\"use-tumblr-icon-header\";i:0;s:24:\"use-linkedin-icon-header\";i:0;s:19:\"use-rss-icon-header\";i:0;s:23:\"use-behance-icon-header\";i:0;s:25:\"use-instagram-icon-header\";i:0;s:22:\"use-flickr-icon-header\";i:0;s:23:\"use-spotify-icon-header\";i:0;s:22:\"use-github-icon-header\";i:0;s:29:\"use-stackexchange-icon-header\";i:0;s:26:\"use-soundcloud-icon-header\";i:0;s:18:\"use-vk-icon-header\";i:0;s:19:\"footer-custom-color\";i:0;s:29:\"disable-copyright-footer-area\";i:0;s:22:\"disable-auto-copyright\";i:0;s:16:\"use-youtube-icon\";i:0;s:15:\"use-tumblr-icon\";i:0;s:12:\"use-rss-icon\";i:0;s:16:\"use-behance-icon\";i:0;s:18:\"use-instagram-icon\";i:0;s:15:\"use-flickr-icon\";i:0;s:16:\"use-spotify-icon\";i:0;s:19:\"use-soundcloud-icon\";i:0;s:11:\"use-vk-icon\";i:0;s:21:\"portfolio_use_masonry\";i:0;s:24:\"portfolio_inline_filters\";i:0;s:24:\"portfolio_sidebar_follow\";i:0;s:29:\"portfolio-google-plus-sharing\";i:0;s:26:\"portfolio-linkedin-sharing\";i:0;s:20:\"portfolio_pagination\";i:0;s:26:\"portfolio_extra_pagination\";i:0;s:17:\"blog_auto_excerpt\";i:0;s:24:\"blog-google-plus-sharing\";i:0;s:21:\"blog-linkedin-sharing\";i:0;s:12:\"display_tags\";i:0;s:17:\"display_full_date\";i:0;s:16:\"extra_pagination\";i:0;s:15:\"enable-map-zoom\";i:0;s:14:\"use-marker-img\";i:0;s:11:\"map-point-1\";i:0;s:11:\"map-point-2\";i:0;s:11:\"map-point-3\";i:0;s:11:\"map-point-4\";i:0;s:11:\"map-point-5\";i:0;s:11:\"map-point-6\";i:0;s:11:\"map-point-7\";i:0;s:11:\"map-point-8\";i:0;s:11:\"map-point-9\";i:0;s:12:\"map-point-10\";i:0;s:13:\"map-greyscale\";i:0;s:14:\"map-ultra-flat\";i:0;s:21:\"map-dark-color-scheme\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("223", "wpcf7", "a:1:{s:7:\"version\";s:3:\"4.4\";}", "yes");
INSERT INTO `wp_options` VALUES("265", "slider-locations_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("266", "project-type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("267", "project-attributes_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("928", "wpb_js_composer_templates_slashes_updated", "yes", "yes");
INSERT INTO `wp_options` VALUES("1071", "ihaf_insert_header", "<script>\r\n  (function(i,s,o,g,r,a,m){i[\\\'GoogleAnalyticsObject\\\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\\\'script\\\',\\\'//www.google-analytics.com/analytics.js\\\',\\\'ga\\\');\r\n\r\n  ga(\\\'create\\\', \\\'UA-62390243-1\\\', \\\'auto\\\');\r\n  ga(\\\'send\\\', \\\'pageview\\\');\r\n\r\n</script>", "yes");
INSERT INTO `wp_options` VALUES("1072", "ihaf_insert_footer", "", "yes");
INSERT INTO `wp_options` VALUES("1159", "ultimate_row", "enable", "yes");
INSERT INTO `wp_options` VALUES("1160", "ultimate_animation", "disable", "yes");
INSERT INTO `wp_options` VALUES("1163", "ultimate_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1164", "ultimate_selected_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1165", "ultimate_updater", "enabled", "yes");
INSERT INTO `wp_options` VALUES("1166", "ultimate_constants", "a:3:{s:24:\"ULTIMATE_NO_UPDATE_CHECK\";b:0;s:28:\"ULTIMATE_NO_EDIT_PAGE_NOTICE\";b:0;s:30:\"ULTIMATE_NO_PLUGIN_PAGE_NOTICE\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1167", "ultimate_modules", "a:28:{i:0;s:18:\"ultimate_animation\";i:1;s:16:\"ultimate_buttons\";i:2;s:18:\"ultimate_countdown\";i:3;s:17:\"ultimate_flip_box\";i:4;s:20:\"ultimate_google_maps\";i:5;s:22:\"ultimate_google_trends\";i:6;s:17:\"ultimate_headings\";i:7;s:22:\"ultimate_icon_timeline\";i:8;s:17:\"ultimate_info_box\";i:9;s:20:\"ultimate_info_circle\";i:10;s:18:\"ultimate_info_list\";i:11;s:20:\"ultimate_info_tables\";i:12;s:28:\"ultimate_interactive_banners\";i:13;s:29:\"ultimate_interactive_banner_2\";i:14;s:15:\"ultimate_modals\";i:15;s:17:\"ultimate_parallax\";i:16;s:23:\"ultimate_pricing_tables\";i:17;s:15:\"ultimate_spacer\";i:18;s:22:\"ultimate_stats_counter\";i:19;s:20:\"ultimate_swatch_book\";i:20;s:14:\"ultimate_icons\";i:21;s:18:\"ultimate_list_icon\";i:22;s:17:\"ultimate_carousel\";i:23;s:18:\"ultimate_fancytext\";i:24;s:22:\"ultimate_highlight_box\";i:25;s:20:\"ultimate_info_banner\";i:26;s:15:\"ultimate_ihover\";i:27;s:11:\"woocomposer\";}", "yes");
INSERT INTO `wp_options` VALUES("1168", "ultimate_js", "enable", "yes");
INSERT INTO `wp_options` VALUES("1169", "ultimate_css", "enable", "yes");
INSERT INTO `wp_options` VALUES("1170", "smile_fonts", "a:1:{s:8:\"Defaults\";a:4:{s:7:\"include\";s:20:\"smile_fonts/Defaults\";s:6:\"folder\";s:20:\"smile_fonts/Defaults\";s:5:\"style\";s:21:\"Defaults/Defaults.css\";s:6:\"config\";s:11:\"charmap.php\";}}", "yes");
INSERT INTO `wp_options` VALUES("1171", "ultimate_google_map", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1334", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("1436", "wpseo", "a:21:{s:14:\"blocking_files\";a:0:{}s:26:\"ignore_blog_public_warning\";b:0;s:31:\"ignore_meta_description_warning\";b:0;s:20:\"ignore_page_comments\";b:0;s:16:\"ignore_permalink\";b:0;s:15:\"ms_defaults_set\";b:0;s:23:\"theme_description_found\";s:0:\"\";s:21:\"theme_has_description\";b:0;s:7:\"version\";s:5:\"3.1.1\";s:11:\"alexaverify\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("1437", "wpseo_permalinks", "a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:0;s:12:\"hide-rsdlink\";b:0;s:14:\"hide-shortlink\";b:0;s:16:\"hide-wlwmanifest\";b:0;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1438", "wpseo_titles", "a:76:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:6:\"noydir\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:17:\"title-home_slider\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:20:\"metadesc-home_slider\";s:0:\"\";s:19:\"metakey-home_slider\";s:0:\"\";s:19:\"noindex-home_slider\";b:0;s:20:\"showdate-home_slider\";b:0;s:23:\"hideeditbox-home_slider\";b:0;s:15:\"title-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"metakey-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";b:0;s:18:\"showdate-portfolio\";b:0;s:21:\"hideeditbox-portfolio\";b:0;s:22:\"title-tax-project-type\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-project-type\";s:0:\"\";s:24:\"metakey-tax-project-type\";s:0:\"\";s:28:\"hideeditbox-tax-project-type\";b:0;s:24:\"noindex-tax-project-type\";b:0;s:28:\"title-tax-project-attributes\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-project-attributes\";s:0:\"\";s:30:\"metakey-tax-project-attributes\";s:0:\"\";s:34:\"hideeditbox-tax-project-attributes\";b:0;s:30:\"noindex-tax-project-attributes\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1439", "wpseo_social", "a:15:{s:9:\"fb_admins\";a:0:{}s:6:\"fbapps\";a:0:{}s:12:\"fbconnectkey\";s:32:\"071b0dddea7f6946880a0afd38e0ba9f\";s:13:\"facebook_site\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:0;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:10:\"fbadminapp\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("1440", "wpseo_rss", "a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";}", "yes");
INSERT INTO `wp_options` VALUES("1441", "wpseo_internallinks", "a:13:{s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;s:28:\"post_types-portfolio-maintax\";i:0;s:30:\"taxonomy-project-type-ptparent\";i:0;s:36:\"taxonomy-project-attributes-ptparent\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("1442", "wpseo_xml", "a:27:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;s:32:\"post_types-client-not_in_sitemap\";b:1;s:31:\"post_types-offer-not_in_sitemap\";b:1;s:32:\"post_types-layout-not_in_sitemap\";b:0;s:35:\"post_types-portfolio-not_in_sitemap\";b:1;s:31:\"post_types-slide-not_in_sitemap\";b:0;s:37:\"post_types-testimonial-not_in_sitemap\";b:1;s:49:\"taxonomies-booked_custom_calendars-not_in_sitemap\";b:0;s:38:\"taxonomies-client-types-not_in_sitemap\";b:0;s:37:\"taxonomies-offer-types-not_in_sitemap\";b:0;s:41:\"taxonomies-portfolio-types-not_in_sitemap\";b:0;s:37:\"taxonomies-slide-types-not_in_sitemap\";b:0;s:43:\"taxonomies-testimonial-types-not_in_sitemap\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1580", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1676", "ultimate_notify_update", "3.12.1", "yes");
INSERT INTO `wp_options` VALUES("1808", "theme_mods_betheme", "a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:5:{s:9:\"main-menu\";i:40;s:14:\"secondary-menu\";i:0;s:9:\"lang-menu\";i:0;s:11:\"social-menu\";i:0;s:18:\"social-menu-bottom\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("1809", "betheme", "a:310:{s:8:\"last_tab\";s:6:\"footer\";s:5:\"style\";s:0:\"\";s:6:\"layout\";s:10:\"full-width\";s:10:\"grid-width\";s:0:\"\";s:7:\"grid960\";s:1:\"0\";s:11:\"img-page-bg\";s:0:\"\";s:16:\"position-page-bg\";s:22:\"repeat;center bottom;;\";s:11:\"favicon-img\";s:104:\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/04/favicon-notary-public-castro-valley.ico\";s:16:\"apple-touch-icon\";s:0:\"\";s:8:\"logo-img\";s:90:\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/10/notary-san-francisco1.png\";s:15:\"retina-logo-img\";s:90:\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/10/notary-san-francisco1.png\";s:15:\"sticky-logo-img\";s:0:\"\";s:22:\"sticky-retina-logo-img\";s:0:\"\";s:9:\"logo-text\";s:0:\"\";s:10:\"logo-width\";s:0:\"\";s:19:\"slider-blog-timeout\";s:1:\"0\";s:22:\"slider-clients-timeout\";s:1:\"0\";s:20:\"slider-offer-timeout\";s:1:\"0\";s:24:\"slider-portfolio-timeout\";s:1:\"0\";s:19:\"slider-shop-timeout\";s:1:\"0\";s:21:\"slider-slider-timeout\";s:1:\"0\";s:27:\"slider-testimonials-timeout\";s:1:\"0\";s:18:\"builder-visibility\";s:0:\"\";s:13:\"display-order\";s:1:\"0\";s:22:\"content-remove-padding\";s:1:\"0\";s:17:\"image-frame-style\";s:0:\"\";s:23:\"math-animations-disable\";s:1:\"0\";s:19:\"table-hover-disable\";s:1:\"0\";s:16:\"slider-shortcode\";s:0:\"\";s:10:\"static-css\";s:1:\"0\";s:12:\"table_prefix\";s:11:\"base_prefix\";s:8:\"hook-top\";s:0:\"\";s:19:\"hook-content-before\";s:0:\"\";s:18:\"hook-content-after\";s:0:\"\";s:11:\"hook-bottom\";s:0:\"\";s:12:\"header-style\";s:5:\"fixed\";s:16:\"img-subheader-bg\";s:0:\"\";s:24:\"img-subheader-attachment\";s:0:\"\";s:17:\"minimalist-header\";s:1:\"1\";s:13:\"sticky-header\";s:1:\"1\";s:19:\"sticky-header-style\";s:5:\"white\";s:21:\"subheader-transparent\";s:1:\"0\";s:15:\"subheader-image\";s:0:\"\";s:21:\"subheader-slider-show\";s:1:\"0\";s:15:\"subheader-style\";s:0:\"\";s:19:\"header-action-title\";s:0:\"\";s:18:\"header-action-link\";s:0:\"\";s:13:\"header-banner\";s:0:\"\";s:13:\"header-search\";s:1:\"0\";s:11:\"sliding-top\";s:1:\"0\";s:16:\"sliding-top-icon\";s:0:\"\";s:11:\"header-wpml\";s:0:\"\";s:10:\"menu-style\";s:9:\"highlight\";s:10:\"action-bar\";s:1:\"0\";s:13:\"header-slogan\";s:0:\"\";s:12:\"header-phone\";s:0:\"\";s:14:\"header-phone-2\";s:0:\"\";s:12:\"header-email\";s:0:\"\";s:13:\"sidebar-width\";s:0:\"\";s:13:\"sidebar-lines\";s:0:\"\";s:18:\"single-page-layout\";s:0:\"\";s:19:\"single-page-sidebar\";s:0:\"\";s:20:\"single-page-sidebar2\";s:0:\"\";s:13:\"single-layout\";s:0:\"\";s:14:\"single-sidebar\";s:0:\"\";s:15:\"single-sidebar2\";s:0:\"\";s:23:\"single-portfolio-layout\";s:0:\"\";s:24:\"single-portfolio-sidebar\";s:0:\"\";s:25:\"single-portfolio-sidebar2\";s:0:\"\";s:19:\"pagination-show-all\";s:1:\"1\";s:4:\"love\";s:1:\"0\";s:13:\"prev-next-nav\";s:1:\"1\";s:5:\"share\";s:1:\"1\";s:13:\"title-heading\";s:1:\"1\";s:10:\"blog-posts\";s:1:\"4\";s:11:\"blog-layout\";s:7:\"classic\";s:12:\"blog-columns\";s:0:\"\";s:15:\"blog-full-width\";s:1:\"0\";s:9:\"blog-page\";s:0:\"\";s:14:\"excerpt-length\";s:2:\"26\";s:14:\"blog-load-more\";s:1:\"0\";s:9:\"blog-meta\";s:1:\"1\";s:10:\"blog-title\";s:1:\"1\";s:16:\"blog-single-zoom\";s:1:\"0\";s:11:\"blog-author\";s:1:\"1\";s:12:\"blog-related\";s:1:\"1\";s:13:\"blog-comments\";s:1:\"1\";s:18:\"blog-single-layout\";s:1:\"0\";s:16:\"blog-single-menu\";s:1:\"0\";s:15:\"portfolio-posts\";s:1:\"8\";s:16:\"portfolio-layout\";s:4:\"grid\";s:17:\"portfolio-columns\";s:0:\"\";s:20:\"portfolio-full-width\";s:1:\"0\";s:14:\"portfolio-page\";s:0:\"\";s:17:\"portfolio-orderby\";s:4:\"date\";s:15:\"portfolio-order\";s:4:\"DESC\";s:18:\"portfolio-external\";s:0:\"\";s:21:\"portfolio-hover-title\";s:1:\"0\";s:17:\"portfolio-isotope\";s:1:\"1\";s:19:\"portfolio-load-more\";s:1:\"0\";s:17:\"portfolio-related\";s:1:\"1\";s:18:\"portfolio-comments\";s:1:\"0\";s:23:\"portfolio-single-layout\";s:0:\"\";s:21:\"portfolio-single-menu\";s:1:\"0\";s:14:\"portfolio-slug\";s:14:\"portfolio-item\";s:13:\"portfolio-tax\";s:0:\"\";s:13:\"shop-products\";s:2:\"12\";s:14:\"shop-catalogue\";s:1:\"0\";s:12:\"shop-excerpt\";s:1:\"0\";s:11:\"shop-images\";s:0:\"\";s:12:\"shop-sidebar\";s:0:\"\";s:11:\"shop-slider\";s:0:\"\";s:19:\"shop-product-images\";s:0:\"\";s:12:\"shop-related\";s:1:\"1\";s:18:\"shop-product-style\";s:0:\"\";s:18:\"shop-product-title\";s:0:\"\";s:9:\"shop-cart\";s:1:\"1\";s:13:\"page-comments\";s:1:\"0\";s:13:\"error404-icon\";s:17:\"icon-traffic-cone\";s:13:\"error404-page\";s:0:\"\";s:12:\"construction\";s:1:\"0\";s:18:\"construction-title\";s:11:\"Coming Soon\";s:17:\"construction-text\";s:0:\"\";s:17:\"construction-date\";s:19:\"12/30/2014 12:00:00\";s:19:\"construction-offset\";s:1:\"0\";s:20:\"construction-contact\";s:0:\"\";s:17:\"construction-page\";s:0:\"\";s:13:\"footer-layout\";s:0:\"\";s:12:\"footer-style\";s:0:\"\";s:13:\"footer-bg-img\";s:0:\"\";s:21:\"footer-call-to-action\";s:1003:\"LEGAL DISCLAIMER<br>This website contains general information about legal matters. The information is not meant as advice, and should not be construed as such. Do not treat this information as an alternative to seeking competent legal counsel from an attorney or as a reason to discontinue legal representation. For any questions about information found on this website, consult your attorney. If you do not currently have an attorney, please visit the <a href=\"http://calbar.ca.gov\">California State Bar</a> website to locate an accredited attorney in your area.<br>While we strive to provide true and accurate information, laws and regulations change and are subject to interpretation. Mobile Notary San Francisco makes no warranties or representations about the current validity or completeness of the information on this website—it is provided “as is.”<br>This disclaimer does not limit Mobile Notary San Francisco’s liabilities in any way that would violate applicable laws and regulations.\";s:11:\"footer-copy\";s:57:\"© 2015 Notary Public San Francisco. All Rights Reserved.\";s:11:\"footer-hide\";s:0:\"\";s:12:\"back-top-top\";s:0:\"\";s:18:\"popup-contact-form\";s:0:\"\";s:23:\"popup-contact-form-icon\";s:0:\"\";s:10:\"responsive\";s:1:\"1\";s:19:\"responsive-logo-img\";s:0:\"\";s:26:\"responsive-retina-logo-img\";s:0:\"\";s:20:\"font-size-responsive\";s:1:\"0\";s:8:\"no-hover\";s:0:\"\";s:25:\"header-menu-mobile-sticky\";s:1:\"0\";s:16:\"header-menu-text\";s:0:\"\";s:13:\"no-section-bg\";s:0:\"\";s:18:\"responsive-top-bar\";s:4:\"left\";s:16:\"google-analytics\";s:428:\"<script>\r\n  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\'script\',\'//www.google-analytics.com/analytics.js\',\'ga\');\r\n\r\n  ga(\'create\', \'UA-31305350-1\', \'muffingroup.com\');\r\n  ga(\'send\', \'pageview\');\r\n\r\n</script>\";s:18:\"google-remarketing\";s:0:\"\";s:7:\"mfn-seo\";s:1:\"1\";s:16:\"meta-description\";s:27:\"Just another WordPress site\";s:13:\"meta-keywords\";s:0:\"\";s:13:\"social-target\";s:1:\"0\";s:12:\"social-skype\";s:0:\"\";s:15:\"social-facebook\";s:0:\"\";s:17:\"social-googleplus\";s:0:\"\";s:14:\"social-twitter\";s:0:\"\";s:12:\"social-vimeo\";s:0:\"\";s:14:\"social-youtube\";s:0:\"\";s:13:\"social-flickr\";s:0:\"\";s:15:\"social-linkedin\";s:0:\"\";s:16:\"social-pinterest\";s:0:\"\";s:15:\"social-dribbble\";s:0:\"\";s:16:\"social-instagram\";s:0:\"\";s:14:\"social-behance\";s:0:\"\";s:13:\"social-tumblr\";s:0:\"\";s:16:\"social-vkontakte\";s:0:\"\";s:13:\"social-viadeo\";s:0:\"\";s:11:\"social-xing\";s:0:\"\";s:10:\"social-rss\";s:1:\"0\";s:11:\"nice-scroll\";s:1:\"1\";s:17:\"nice-scroll-speed\";s:2:\"40\";s:18:\"sc-gallery-disable\";s:1:\"0\";s:11:\"prettyphoto\";s:10:\"pp_default\";s:17:\"prettyphoto-width\";s:0:\"\";s:18:\"prettyphoto-height\";s:0:\"\";s:17:\"retina-js-disable\";s:1:\"0\";s:10:\"plugin-rev\";s:0:\"\";s:12:\"plugin-layer\";s:0:\"\";s:13:\"plugin-visual\";s:0:\"\";s:4:\"skin\";s:6:\"custom\";s:15:\"background-body\";s:7:\"#444148\";s:9:\"color-one\";s:7:\"#4b29d6\";s:17:\"background-header\";s:7:\"#444148\";s:19:\"background-top-left\";s:7:\"#444148\";s:21:\"background-top-middle\";s:7:\"#e3e3e3\";s:20:\"background-top-right\";s:7:\"#444148\";s:17:\"color-top-right-a\";s:7:\"#444444\";s:17:\"background-search\";s:7:\"#2aabe4\";s:20:\"background-subheader\";s:7:\"#444148\";s:15:\"color-subheader\";s:7:\"#888888\";s:12:\"color-menu-a\";s:7:\"#ffffff\";s:19:\"color-menu-a-active\";s:7:\"#2aabe4\";s:24:\"background-menu-a-active\";s:7:\"#2aabe4\";s:18:\"background-submenu\";s:7:\"#444148\";s:15:\"color-submenu-a\";s:7:\"#2aabe4\";s:21:\"color-submenu-a-hover\";s:7:\"#2e2e2e\";s:21:\"background-action-bar\";s:7:\"#2e2e2e\";s:23:\"background-overlay-menu\";s:7:\"#2991d6\";s:25:\"background-overlay-menu-a\";s:7:\"#ffffff\";s:17:\"border-menu-plain\";s:7:\"#F2F2F2\";s:11:\"color-theme\";s:7:\"#2aabe4\";s:10:\"color-text\";s:7:\"#737E86\";s:7:\"color-a\";s:7:\"#2aabe4\";s:13:\"color-a-hover\";s:7:\"#4b50da\";s:16:\"color-fancy-link\";s:7:\"#626262\";s:21:\"background-fancy-link\";s:7:\"#2aabe4\";s:22:\"color-fancy-link-hover\";s:7:\"#2aabe4\";s:27:\"background-fancy-link-hover\";s:7:\"#da524b\";s:10:\"color-note\";s:7:\"#a8a8a8\";s:10:\"color-list\";s:7:\"#737E86\";s:20:\"background-highlight\";s:7:\"#2aabe4\";s:28:\"background-highlight-section\";s:7:\"#2aabe4\";s:8:\"color-hr\";s:7:\"#2aabe4\";s:12:\"button-style\";s:0:\"\";s:17:\"background-button\";s:7:\"#f7f7f7\";s:12:\"color-button\";s:7:\"#747474\";s:18:\"color-footer-theme\";s:7:\"#ff7770\";s:17:\"background-footer\";s:7:\"#545454\";s:12:\"color-footer\";s:7:\"#cccccc\";s:14:\"color-footer-a\";s:7:\"#e4e4e4\";s:20:\"color-footer-a-hover\";s:7:\"#ffffff\";s:20:\"color-footer-heading\";s:7:\"#ffffff\";s:17:\"color-footer-note\";s:7:\"#a8a8a8\";s:23:\"color-sliding-top-theme\";s:7:\"#ff7770\";s:22:\"background-sliding-top\";s:7:\"#545454\";s:17:\"color-sliding-top\";s:7:\"#cccccc\";s:19:\"color-sliding-top-a\";s:7:\"#ff7770\";s:25:\"color-sliding-top-a-hover\";s:7:\"#da524b\";s:25:\"color-sliding-top-heading\";s:7:\"#ffffff\";s:22:\"color-sliding-top-note\";s:7:\"#a8a8a8\";s:8:\"color-h1\";s:7:\"#555555\";s:8:\"color-h2\";s:7:\"#626262\";s:8:\"color-h3\";s:7:\"#00a99e\";s:8:\"color-h4\";s:7:\"#555555\";s:8:\"color-h5\";s:7:\"#555555\";s:8:\"color-h6\";s:7:\"#555555\";s:15:\"color-tab-title\";s:7:\"#2aabe4\";s:16:\"color-blockquote\";s:7:\"#444444\";s:17:\"color-contentlink\";s:7:\"#2aabe4\";s:13:\"color-counter\";s:7:\"#2aabe4\";s:21:\"background-getintouch\";s:7:\"#2aabe4\";s:13:\"color-iconbar\";s:7:\"#2aabe4\";s:13:\"color-iconbox\";s:7:\"#2aabe4\";s:26:\"background-imageframe-link\";s:7:\"#2aabe4\";s:21:\"color-imageframe-link\";s:7:\"#ffffff\";s:15:\"color-list-icon\";s:7:\"#2aabe4\";s:19:\"color-pricing-price\";s:7:\"#2aabe4\";s:27:\"background-pricing-featured\";s:7:\"#2aabe4\";s:22:\"background-progressbar\";s:7:\"#2aabe4\";s:22:\"color-quickfact-number\";s:7:\"#2aabe4\";s:27:\"background-slidingbox-title\";s:7:\"#2aabe4\";s:27:\"background-trailer-subtitle\";s:7:\"#2aabe4\";s:12:\"font-content\";s:6:\"Roboto\";s:9:\"font-menu\";s:6:\"Roboto\";s:10:\"font-title\";s:5:\"Arial\";s:13:\"font-headings\";s:4:\"Lato\";s:19:\"font-headings-small\";s:6:\"Roboto\";s:15:\"font-blockquote\";s:4:\"Lato\";s:11:\"font-subset\";s:0:\"\";s:17:\"font-size-content\";s:2:\"13\";s:14:\"font-size-menu\";s:2:\"14\";s:12:\"font-size-h1\";s:2:\"25\";s:12:\"font-size-h2\";s:2:\"50\";s:12:\"font-size-h3\";s:2:\"30\";s:12:\"font-size-h4\";s:2:\"27\";s:12:\"font-size-h5\";s:2:\"21\";s:12:\"font-size-h6\";s:2:\"16\";s:11:\"font-custom\";s:0:\"\";s:16:\"font-custom-woff\";s:0:\"\";s:15:\"font-custom-ttf\";s:0:\"\";s:15:\"font-custom-svg\";s:0:\"\";s:15:\"font-custom-eot\";s:0:\"\";s:12:\"font-custom2\";s:0:\"\";s:17:\"font-custom2-woff\";s:0:\"\";s:16:\"font-custom2-ttf\";s:0:\"\";s:16:\"font-custom2-svg\";s:0:\"\";s:16:\"font-custom2-eot\";s:0:\"\";s:9:\"translate\";s:1:\"1\";s:28:\"translate-search-placeholder\";s:17:\"Enter your search\";s:24:\"translate-search-results\";s:18:\"results found for:\";s:14:\"translate-home\";s:4:\"Home\";s:14:\"translate-prev\";s:9:\"Prev page\";s:14:\"translate-next\";s:9:\"Next page\";s:19:\"translate-load-more\";s:9:\"Load more\";s:17:\"translate-wpml-no\";s:39:\"No translations available for this page\";s:14:\"translate-days\";s:4:\"days\";s:15:\"translate-hours\";s:5:\"hours\";s:17:\"translate-minutes\";s:7:\"minutes\";s:17:\"translate-seconds\";s:7:\"seconds\";s:16:\"translate-filter\";s:9:\"Filter by\";s:14:\"translate-tags\";s:4:\"Tags\";s:17:\"translate-authors\";s:7:\"Authors\";s:13:\"translate-all\";s:8:\"Show all\";s:18:\"translate-item-all\";s:0:\"\";s:19:\"translate-published\";s:12:\"Published by\";s:12:\"translate-at\";s:2:\"at\";s:20:\"translate-categories\";s:10:\"Categories\";s:18:\"translate-readmore\";s:9:\"Read more\";s:14:\"translate-like\";s:15:\"Do you like it?\";s:17:\"translate-related\";s:13:\"Related posts\";s:16:\"translate-client\";s:6:\"Client\";s:14:\"translate-date\";s:4:\"Date\";s:17:\"translate-website\";s:7:\"Website\";s:14:\"translate-view\";s:12:\"View website\";s:14:\"translate-task\";s:4:\"Task\";s:19:\"translate-404-title\";s:18:\"Ooops... Error 404\";s:22:\"translate-404-subtitle\";s:62:\"We are sorry, but the page you are looking for does not exist.\";s:18:\"translate-404-text\";s:46:\"Please check entered address and try again or \";s:17:\"translate-404-btn\";s:14:\"go to homepage\";s:10:\"custom-css\";s:1849:\"#Wrapper { -webkit-box-shadow: 0 0 0 0; box-shadow: 0 0 0 0; }\r\n\r\n.sliding_box .desc_wrapper h4 { \r\nfont-size: 20px; \r\nline-height: 24px; \r\ncolor: white;\r\n}\r\n\r\n.google-map { border-width: 0; }\r\n\r\n.section:not(.dark) .fancy_heading .title { color: #9d9f9e; }\r\n.column_fancy_heading { margin-bottom: 30px; }\r\n\r\n\r\n.list_item.lists_2 .list_right h4 { font-size: 18px; line-height: 31px; }\r\n\r\ninput[type=\"text\"], input[type=\"tel\"], input[type=\"password\"], input[type=\"email\"], textarea, select, .woocommerce .quantity input.qty { background-color: white; }\r\n\r\n\r\na.button_theme, a.tp-button.button_theme, button, input[type=\"submit\"], input[type=\"reset\"], input[type=\"button\"] {\r\nbackground-color: white;\r\ncolor: #2aabe4;\r\n}\r\n\r\n/* Form */\r\ninput[type=\"text\"], input[type=\"tel\"], input[type=\"password\"], input[type=\"email\"], textarea, select, .woocommerce .quantity input.qty { \r\n	background-color: #f5f5f5; border: 2px solid #c49b2c; border-radius: 2px;\r\n}\r\ninput[type=\"date\"]:focus, input[type=\"email\"]:focus, input[type=\"number\"]:focus, input[type=\"password\"]:focus, input[type=\"search\"]:focus, input[type=\"tel\"]:focus, input[type=\"text\"]:focus, input[type=\"url\"]:focus, select:focus, textarea:focus { \r\n	/* border: 2px solid #ffffff; */\r\n}\r\n.order_form input[type=\"submit\"] { font-size: 140%; padding: 12px 40px; }\r\n\r\n.phone {\r\n    font-family: \"Roboto Slab\";\r\n    font-size: 48px;\r\n    line-height: 48px;\r\n    color: #2aabe4;\r\n    font-weight: 700;\r\n    padding-bottom: 20px;\r\n    background: url(http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/10/phone_line.png) no-repeat 5px bottom;\r\n}\r\n\r\n\r\ninput[type=\"text\"], input[type=\"tel\"], input[type=\"password\"], input[type=\"email\"], textarea, select, .woocommerce .quantity input.qty {\r\n    background-color: #f5f5f5;\r\n    border: 2px solid #ffffff !important;\r\n    border-radius: 2px;\r\n}\r\n\r\n\";s:9:\"custom-js\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("1825", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("1826", "revslider-static-css", ".tp-caption a {\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}", "yes");
INSERT INTO `wp_options` VALUES("1827", "revslider-update-check-short", "1458327523", "yes");
INSERT INTO `wp_options` VALUES("1828", "ls-plugin-version", "5.2.0", "yes");
INSERT INTO `wp_options` VALUES("1829", "ls-db-version", "5.0.0", "yes");
INSERT INTO `wp_options` VALUES("1830", "ls-installed", "1", "yes");
INSERT INTO `wp_options` VALUES("1831", "ls-google-fonts", "a:4:{i:0;a:2:{s:5:\"param\";s:28:\"Lato:100,300,regular,700,900\";s:5:\"admin\";b:0;}i:1;a:2:{s:5:\"param\";s:13:\"Open+Sans:300\";s:5:\"admin\";b:0;}i:2;a:2:{s:5:\"param\";s:20:\"Indie+Flower:regular\";s:5:\"admin\";b:0;}i:3;a:2:{s:5:\"param\";s:22:\"Oswald:300,regular,700\";s:5:\"admin\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("1832", "ls-date-installed", "1421878863", "yes");
INSERT INTO `wp_options` VALUES("1833", "vc_version", "4.3.5", "yes");
INSERT INTO `wp_options` VALUES("1834", "duplicate_post_copyexcerpt", "1", "yes");
INSERT INTO `wp_options` VALUES("1835", "duplicate_post_copyattachments", "0", "yes");
INSERT INTO `wp_options` VALUES("1836", "duplicate_post_copychildren", "0", "yes");
INSERT INTO `wp_options` VALUES("1837", "duplicate_post_copystatus", "0", "yes");
INSERT INTO `wp_options` VALUES("1838", "duplicate_post_taxonomies_blacklist", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1839", "duplicate_post_show_row", "1", "yes");
INSERT INTO `wp_options` VALUES("1840", "duplicate_post_show_adminbar", "1", "yes");
INSERT INTO `wp_options` VALUES("1841", "duplicate_post_show_submitbox", "1", "yes");
INSERT INTO `wp_options` VALUES("1842", "duplicate_post_version", "2.6", "yes");
INSERT INTO `wp_options` VALUES("2181", "revslider-latest-version", "5.2.3.5", "yes");
INSERT INTO `wp_options` VALUES("4632", "client-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4633", "offer-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4634", "portfolio-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4635", "slide-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4636", "testimonial-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5474", "booked_profile_page", "3526", "yes");
INSERT INTO `wp_options` VALUES("5475", "booked_timeslot_intervals", "30", "yes");
INSERT INTO `wp_options` VALUES("5476", "booked_appointment_buffer", "0", "yes");
INSERT INTO `wp_options` VALUES("5477", "booked_appointment_limit", "10", "yes");
INSERT INTO `wp_options` VALUES("5478", "booked_cancellation_buffer", "24", "yes");
INSERT INTO `wp_options` VALUES("5479", "booked_email_logo", "", "yes");
INSERT INTO `wp_options` VALUES("5480", "booked_new_appointment_default", "publish", "yes");
INSERT INTO `wp_options` VALUES("5481", "booked_light_color", "#2aabe4", "yes");
INSERT INTO `wp_options` VALUES("5482", "booked_dark_color", "#444148", "yes");
INSERT INTO `wp_options` VALUES("5483", "booked_button_color", "#56C477", "yes");
INSERT INTO `wp_options` VALUES("5484", "booked_registration_email_subject", "Thank you for registering!", "yes");
INSERT INTO `wp_options` VALUES("5485", "booked_registration_email_content", "Hey %name%!\r\n\r\nThanks for registering at Notary Public San Francisco. You can now login to manage your account and appointments using the following credentials:\r\n\r\nUsername: %username%\r\nPassword: %password%\r\n\r\nSincerely,\r\nYour friends at Notary Public San Francisco", "yes");
INSERT INTO `wp_options` VALUES("5486", "booked_approval_email_content", "Hey %name%!\r\n\r\nThis is just an email to confirm that we received your appointment request. We will reach out to you shortly to confirm the appointment. \r\n\r\nDate: %date%\r\nTime: %time%\r\n\r\nSincerely,\r\nYour friends at Notary Public San Francisco", "yes");
INSERT INTO `wp_options` VALUES("5487", "booked_approval_email_subject", "Your appointment has been approved!", "yes");
INSERT INTO `wp_options` VALUES("5488", "booked_cancellation_email_content", "Hey %name%!\r\n\r\nThe appointment you requested at Notary Public San Francisco has been cancelled. For reference, here\'s the appointment information:\r\n\r\nDate: %date%\r\nTime: %time%\r\n\r\nSincerely,\r\nYour friends at Notary Public San Francisco", "yes");
INSERT INTO `wp_options` VALUES("5489", "booked_cancellation_email_subject", "Your appointment has been cancelled.", "yes");
INSERT INTO `wp_options` VALUES("5490", "booked_appt_confirmation_email_content", "Hey %name%!\r\n\r\nThis is just an email to confirm that we received your appointment request. We will reach out to you shortly to confirm the appointment. \r\n\r\nDate: %date%\r\nTime: %time%\r\n\r\nSincerely,\r\nYour friends at Notary Public San Francisco", "yes");
INSERT INTO `wp_options` VALUES("5491", "booked_appt_confirmation_email_subject", "Your notary request has been received by Notary Public San Francisco!", "yes");
INSERT INTO `wp_options` VALUES("5492", "booked_admin_appointment_email_content", "You have a new appointment request! Here\'s the appointment information:\r\n\r\nCustomer: %name%\r\nDate: %date%\r\nTime: %time%\r\n%customfields%\r\n\r\nLog into your website here: http://notarypublicsanfranciscoca.com/wp-admin/ to approve this appointment.\r\n\r\nSFNotary", "yes");
INSERT INTO `wp_options` VALUES("5493", "booked_admin_appointment_email_subject", "You have a new appointment request!", "yes");
INSERT INTO `wp_options` VALUES("5494", "booked_admin_cancellation_email_content", "One of your customers has cancelled their appointment. Here\'s the appointment information:\r\n\r\nCustomer: %name%\r\nDate: %date%\r\nTime: %time%\r\n%customfields%\r\n\r\nSFNotary", "yes");
INSERT INTO `wp_options` VALUES("5495", "booked_admin_cancellation_email_subject", "An appointment has been cancelled.", "yes");
INSERT INTO `wp_options` VALUES("5498", "booked_custom_fields", "[{\\\"name\\\":\\\"single-line-text-label---7562200___required\\\",\\\"value\\\":\\\"Phone Number\\\"},{\\\"name\\\":\\\"checkboxes-label---4747505___required\\\",\\\"value\\\":\\\"Which notary service would you like to schedule?\\\"},{\\\"name\\\":\\\"single-checkbox---4747505\\\",\\\"value\\\":\\\"Mobile Notary\\\"},{\\\"name\\\":\\\"single-checkbox---4747505\\\",\\\"value\\\":\\\"Loan Signing Agent\\\"},{\\\"name\\\":\\\"single-checkbox---4747505\\\",\\\"value\\\":\\\"Expedited apostille or authentication\\\"},{\\\"name\\\":\\\"single-checkbox---4747505\\\",\\\"value\\\":\\\"Other\\\"},{\\\"name\\\":\\\"paragraph-text-label---4473877\\\",\\\"value\\\":\\\"If Mobile Notary is checked, please tell us your address: \\\"},{\\\"name\\\":\\\"required---7562200\\\",\\\"value\\\":true},{\\\"name\\\":\\\"required---4747505\\\",\\\"value\\\":true},{\\\"name\\\":\\\"required---4473877\\\",\\\"value\\\":false}]", "yes");
INSERT INTO `wp_options` VALUES("5503", "booked_defaults", "a:7:{s:3:\"Mon\";a:24:{s:9:\"0700-0730\";i:1;s:9:\"0730-0800\";i:1;s:9:\"0800-0830\";i:1;s:9:\"0830-0900\";i:1;s:9:\"0900-0930\";i:1;s:9:\"0930-1000\";i:1;s:9:\"1000-1030\";i:1;s:9:\"1030-1100\";i:1;s:9:\"1100-1130\";i:1;s:9:\"1130-1200\";i:1;s:9:\"1200-1230\";i:1;s:9:\"1230-1300\";i:1;s:9:\"1300-1330\";i:1;s:9:\"1330-1400\";i:1;s:9:\"1400-1430\";i:1;s:9:\"1430-1500\";i:1;s:9:\"1500-1530\";i:1;s:9:\"1530-1600\";i:1;s:9:\"1600-1630\";i:1;s:9:\"1630-1700\";i:1;s:9:\"1700-1730\";i:1;s:9:\"1730-1800\";i:1;s:9:\"1800-1830\";i:1;s:9:\"1830-1900\";i:1;}s:3:\"Sat\";a:24:{s:9:\"0700-0730\";i:1;s:9:\"0730-0800\";i:1;s:9:\"0800-0830\";i:1;s:9:\"0830-0900\";i:1;s:9:\"0900-0930\";i:1;s:9:\"0930-1000\";i:1;s:9:\"1000-1030\";i:1;s:9:\"1030-1100\";i:1;s:9:\"1100-1130\";i:1;s:9:\"1130-1200\";i:1;s:9:\"1200-1230\";i:1;s:9:\"1230-1300\";i:1;s:9:\"1300-1330\";i:1;s:9:\"1330-1400\";i:1;s:9:\"1400-1430\";i:1;s:9:\"1430-1500\";i:1;s:9:\"1500-1530\";i:1;s:9:\"1530-1600\";i:1;s:9:\"1600-1630\";i:1;s:9:\"1630-1700\";i:1;s:9:\"1700-1730\";i:1;s:9:\"1730-1800\";i:1;s:9:\"1800-1830\";i:1;s:9:\"1830-1900\";i:1;}s:3:\"Sun\";a:24:{s:9:\"0700-0730\";i:1;s:9:\"0730-0800\";i:1;s:9:\"0800-0830\";i:1;s:9:\"0830-0900\";i:1;s:9:\"0900-0930\";i:1;s:9:\"0930-1000\";i:1;s:9:\"1000-1030\";i:1;s:9:\"1030-1100\";i:1;s:9:\"1100-1130\";i:1;s:9:\"1130-1200\";i:1;s:9:\"1200-1230\";i:1;s:9:\"1230-1300\";i:1;s:9:\"1300-1330\";i:1;s:9:\"1330-1400\";i:1;s:9:\"1400-1430\";i:1;s:9:\"1430-1500\";i:1;s:9:\"1500-1530\";i:1;s:9:\"1530-1600\";i:1;s:9:\"1600-1630\";i:1;s:9:\"1630-1700\";i:1;s:9:\"1700-1730\";i:1;s:9:\"1730-1800\";i:1;s:9:\"1800-1830\";i:1;s:9:\"1830-1900\";i:1;}s:3:\"Tue\";a:24:{s:9:\"0700-0730\";i:1;s:9:\"0730-0800\";i:1;s:9:\"0800-0830\";i:1;s:9:\"0830-0900\";i:1;s:9:\"0900-0930\";i:1;s:9:\"0930-1000\";i:1;s:9:\"1000-1030\";i:1;s:9:\"1030-1100\";i:1;s:9:\"1100-1130\";i:1;s:9:\"1130-1200\";i:1;s:9:\"1200-1230\";i:1;s:9:\"1230-1300\";i:1;s:9:\"1300-1330\";i:1;s:9:\"1330-1400\";i:1;s:9:\"1400-1430\";i:1;s:9:\"1430-1500\";i:1;s:9:\"1500-1530\";i:1;s:9:\"1530-1600\";i:1;s:9:\"1600-1630\";i:1;s:9:\"1630-1700\";i:1;s:9:\"1700-1730\";i:1;s:9:\"1730-1800\";i:1;s:9:\"1800-1830\";i:1;s:9:\"1830-1900\";i:1;}s:3:\"Wed\";a:24:{s:9:\"0700-0730\";i:1;s:9:\"0730-0800\";i:1;s:9:\"0800-0830\";i:1;s:9:\"0830-0900\";i:1;s:9:\"0900-0930\";i:1;s:9:\"0930-1000\";i:1;s:9:\"1000-1030\";i:1;s:9:\"1030-1100\";i:1;s:9:\"1100-1130\";i:1;s:9:\"1130-1200\";i:1;s:9:\"1200-1230\";i:1;s:9:\"1230-1300\";i:1;s:9:\"1300-1330\";i:1;s:9:\"1330-1400\";i:1;s:9:\"1400-1430\";i:1;s:9:\"1430-1500\";i:1;s:9:\"1500-1530\";i:1;s:9:\"1530-1600\";i:1;s:9:\"1600-1630\";i:1;s:9:\"1630-1700\";i:1;s:9:\"1700-1730\";i:1;s:9:\"1730-1800\";i:1;s:9:\"1800-1830\";i:1;s:9:\"1830-1900\";i:1;}s:3:\"Thu\";a:24:{s:9:\"0700-0730\";i:1;s:9:\"0730-0800\";i:1;s:9:\"0800-0830\";i:1;s:9:\"0830-0900\";i:1;s:9:\"0900-0930\";i:1;s:9:\"0930-1000\";i:1;s:9:\"1000-1030\";i:1;s:9:\"1030-1100\";i:1;s:9:\"1100-1130\";i:1;s:9:\"1130-1200\";i:1;s:9:\"1200-1230\";i:1;s:9:\"1230-1300\";i:1;s:9:\"1300-1330\";i:1;s:9:\"1330-1400\";i:1;s:9:\"1400-1430\";i:1;s:9:\"1430-1500\";i:1;s:9:\"1500-1530\";i:1;s:9:\"1530-1600\";i:1;s:9:\"1600-1630\";i:1;s:9:\"1630-1700\";i:1;s:9:\"1700-1730\";i:1;s:9:\"1730-1800\";i:1;s:9:\"1800-1830\";i:1;s:9:\"1830-1900\";i:1;}s:3:\"Fri\";a:24:{s:9:\"0700-0730\";i:1;s:9:\"0730-0800\";i:1;s:9:\"0800-0830\";i:1;s:9:\"0830-0900\";i:1;s:9:\"0900-0930\";i:1;s:9:\"0930-1000\";i:1;s:9:\"1000-1030\";i:1;s:9:\"1030-1100\";i:1;s:9:\"1100-1130\";i:1;s:9:\"1130-1200\";i:1;s:9:\"1200-1230\";i:1;s:9:\"1230-1300\";i:1;s:9:\"1300-1330\";i:1;s:9:\"1330-1400\";i:1;s:9:\"1400-1430\";i:1;s:9:\"1430-1500\";i:1;s:9:\"1500-1530\";i:1;s:9:\"1530-1600\";i:1;s:9:\"1600-1630\";i:1;s:9:\"1630-1700\";i:1;s:9:\"1700-1730\";i:1;s:9:\"1730-1800\";i:1;s:9:\"1800-1830\";i:1;s:9:\"1830-1900\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("7867", "gadwp_version", "4.5.1", "yes");
INSERT INTO `wp_options` VALUES("7877", "widget_gadash_frontend_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("8424", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("9819", "jetpack_security_report", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("9933", "jetpack_updates", "a:7:{s:7:\"plugins\";i:0;s:6:\"themes\";i:0;s:9:\"wordpress\";i:0;s:12:\"translations\";i:0;s:5:\"total\";i:0;s:10:\"wp_version\";s:3:\"4.3\";s:26:\"site_is_version_controlled\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("10422", "tt_eoi_mailing_list", "no", "yes");
INSERT INTO `wp_options` VALUES("11053", "_transient_random_seed", "918ba957afbbc6b4aaac69f7aedd9d8a", "yes");
INSERT INTO `wp_options` VALUES("11054", "_site_transient_timeout_envato-wordpress-toolkit/index.php_new_v", "1427429528", "yes");
INSERT INTO `wp_options` VALUES("11055", "_site_transient_envato-wordpress-toolkit/index.php_new_version", "1.7.2", "yes");
INSERT INTO `wp_options` VALUES("11056", "_site_transient_timeout_envato-wordpress-toolkit/index.php_githu", "1427429528", "yes");
INSERT INTO `wp_options` VALUES("11057", "_site_transient_envato-wordpress-toolkit/index.php_github_data", "O:8:\"stdClass\":70:{s:2:\"id\";i:2558893;s:4:\"name\";s:24:\"envato-wordpress-toolkit\";s:9:\"full_name\";s:31:\"envato/envato-wordpress-toolkit\";s:5:\"owner\";O:8:\"stdClass\":17:{s:5:\"login\";s:6:\"envato\";s:2:\"id\";i:14786;s:10:\"avatar_url\";s:49:\"https://avatars.githubusercontent.com/u/14786?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:35:\"https://api.github.com/users/envato\";s:8:\"html_url\";s:25:\"https://github.com/envato\";s:13:\"followers_url\";s:45:\"https://api.github.com/users/envato/followers\";s:13:\"following_url\";s:58:\"https://api.github.com/users/envato/following{/other_user}\";s:9:\"gists_url\";s:51:\"https://api.github.com/users/envato/gists{/gist_id}\";s:11:\"starred_url\";s:58:\"https://api.github.com/users/envato/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:49:\"https://api.github.com/users/envato/subscriptions\";s:17:\"organizations_url\";s:40:\"https://api.github.com/users/envato/orgs\";s:9:\"repos_url\";s:41:\"https://api.github.com/users/envato/repos\";s:10:\"events_url\";s:52:\"https://api.github.com/users/envato/events{/privacy}\";s:19:\"received_events_url\";s:51:\"https://api.github.com/users/envato/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:7:\"private\";b:0;s:8:\"html_url\";s:50:\"https://github.com/envato/envato-wordpress-toolkit\";s:11:\"description\";s:53:\"WordPress Toolkit for Envato Marketplace hosted items\";s:4:\"fork\";b:0;s:3:\"url\";s:60:\"https://api.github.com/repos/envato/envato-wordpress-toolkit\";s:9:\"forks_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/forks\";s:8:\"keys_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/keys{/key_id}\";s:17:\"collaborators_url\";s:89:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/collaborators{/collaborator}\";s:9:\"teams_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/teams\";s:9:\"hooks_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/hooks\";s:16:\"issue_events_url\";s:83:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues/events{/number}\";s:10:\"events_url\";s:67:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/events\";s:13:\"assignees_url\";s:77:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/assignees{/user}\";s:12:\"branches_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/branches{/branch}\";s:8:\"tags_url\";s:65:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/tags\";s:9:\"blobs_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/blobs{/sha}\";s:12:\"git_tags_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/tags{/sha}\";s:12:\"git_refs_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/refs{/sha}\";s:9:\"trees_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/trees{/sha}\";s:12:\"statuses_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/statuses/{sha}\";s:13:\"languages_url\";s:70:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/languages\";s:14:\"stargazers_url\";s:71:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/stargazers\";s:16:\"contributors_url\";s:73:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/contributors\";s:15:\"subscribers_url\";s:72:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/subscribers\";s:16:\"subscription_url\";s:73:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/subscription\";s:11:\"commits_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/commits{/sha}\";s:15:\"git_commits_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/commits{/sha}\";s:12:\"comments_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/comments{/number}\";s:17:\"issue_comment_url\";s:85:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues/comments{/number}\";s:12:\"contents_url\";s:77:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/contents/{+path}\";s:11:\"compare_url\";s:84:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/compare/{base}...{head}\";s:10:\"merges_url\";s:67:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/merges\";s:11:\"archive_url\";s:83:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/{archive_format}{/ref}\";s:13:\"downloads_url\";s:70:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/downloads\";s:10:\"issues_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues{/number}\";s:9:\"pulls_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/pulls{/number}\";s:14:\"milestones_url\";s:80:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/milestones{/number}\";s:17:\"notifications_url\";s:100:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/notifications{?since,all,participating}\";s:10:\"labels_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/labels{/name}\";s:12:\"releases_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/releases{/id}\";s:10:\"created_at\";s:20:\"2011-10-11T22:58:26Z\";s:10:\"updated_at\";s:20:\"2015-03-25T20:54:35Z\";s:9:\"pushed_at\";s:20:\"2015-02-13T05:28:57Z\";s:7:\"git_url\";s:52:\"git://github.com/envato/envato-wordpress-toolkit.git\";s:7:\"ssh_url\";s:50:\"git@github.com:envato/envato-wordpress-toolkit.git\";s:9:\"clone_url\";s:54:\"https://github.com/envato/envato-wordpress-toolkit.git\";s:7:\"svn_url\";s:50:\"https://github.com/envato/envato-wordpress-toolkit\";s:8:\"homepage\";s:0:\"\";s:4:\"size\";i:582;s:16:\"stargazers_count\";i:233;s:14:\"watchers_count\";i:233;s:8:\"language\";s:3:\"PHP\";s:10:\"has_issues\";b:1;s:13:\"has_downloads\";b:1;s:8:\"has_wiki\";b:1;s:9:\"has_pages\";b:0;s:11:\"forks_count\";i:81;s:10:\"mirror_url\";N;s:17:\"open_issues_count\";i:12;s:5:\"forks\";i:81;s:11:\"open_issues\";i:12;s:8:\"watchers\";i:233;s:14:\"default_branch\";s:6:\"master\";s:12:\"organization\";O:8:\"stdClass\":17:{s:5:\"login\";s:6:\"envato\";s:2:\"id\";i:14786;s:10:\"avatar_url\";s:49:\"https://avatars.githubusercontent.com/u/14786?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:35:\"https://api.github.com/users/envato\";s:8:\"html_url\";s:25:\"https://github.com/envato\";s:13:\"followers_url\";s:45:\"https://api.github.com/users/envato/followers\";s:13:\"following_url\";s:58:\"https://api.github.com/users/envato/following{/other_user}\";s:9:\"gists_url\";s:51:\"https://api.github.com/users/envato/gists{/gist_id}\";s:11:\"starred_url\";s:58:\"https://api.github.com/users/envato/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:49:\"https://api.github.com/users/envato/subscriptions\";s:17:\"organizations_url\";s:40:\"https://api.github.com/users/envato/orgs\";s:9:\"repos_url\";s:41:\"https://api.github.com/users/envato/repos\";s:10:\"events_url\";s:52:\"https://api.github.com/users/envato/events{/privacy}\";s:19:\"received_events_url\";s:51:\"https://api.github.com/users/envato/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:13:\"network_count\";i:81;s:17:\"subscribers_count\";i:79;}", "yes");
INSERT INTO `wp_options` VALUES("11792", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("14421", "widget_tp_widget_recent_tweets", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14422", "widget_booked_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14423", "widget_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14424", "widget_nav_menu", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14425", "widget_layerslider_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14426", "widget_mojo_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14427", "widget_widget_mfn_flickr", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14428", "widget_widget_mfn_login", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14429", "widget_widget_mfn_menu", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14430", "widget_widget_mfn_recent_comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14431", "widget_widget_mfn_recent_posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14432", "widget_widget_mfn_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14433", "widget_easy-opt-in-widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14434", "widget_pages", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14435", "widget_rev-slider-widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("14437", "widget_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("17325", "tp_twitter_global_notification", "1", "yes");
INSERT INTO `wp_options` VALUES("17429", "paf", "a:1:{s:19:\"eoi_powerup_new_css\";a:1:{i:0;s:2:\"on\";}}", "yes");
INSERT INTO `wp_options` VALUES("17430", "fca_eoi_plugin_version", "1.4.2", "yes");
INSERT INTO `wp_options` VALUES("19738", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("21933", "booked_plugin_version_number", "1.6.10", "yes");
INSERT INTO `wp_options` VALUES("21939", "booked_addon_viewed_booked-calendar-feeds", "1", "yes");
INSERT INTO `wp_options` VALUES("21940", "booked_addon_viewed_booked-woocommerce-payments", "1", "yes");
INSERT INTO `wp_options` VALUES("21941", "revslider-valid-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("25665", "booked_disable_avatar", "", "yes");
INSERT INTO `wp_options` VALUES("25666", "booked_disable_website", "", "yes");
INSERT INTO `wp_options` VALUES("25667", "booked_disable_bio", "", "yes");
INSERT INTO `wp_options` VALUES("25668", "booked_login_redirect_page", "", "yes");
INSERT INTO `wp_options` VALUES("25669", "booked_appointment_success_redirect_page", "", "yes");
INSERT INTO `wp_options` VALUES("25670", "booked_booking_type", "guest", "yes");
INSERT INTO `wp_options` VALUES("25671", "booked_hide_default_calendar", "", "yes");
INSERT INTO `wp_options` VALUES("25672", "booked_hide_unavailable_timeslots", "", "yes");
INSERT INTO `wp_options` VALUES("25673", "booked_hide_google_link", "", "yes");
INSERT INTO `wp_options` VALUES("25674", "booked_hide_weekends", "", "yes");
INSERT INTO `wp_options` VALUES("25675", "booked_dont_allow_user_cancellations", "", "yes");
INSERT INTO `wp_options` VALUES("25676", "booked_hide_end_times", "", "yes");
INSERT INTO `wp_options` VALUES("25677", "booked_redirect_non_admins", "", "yes");
INSERT INTO `wp_options` VALUES("25678", "booked_default_email_user", "", "yes");
INSERT INTO `wp_options` VALUES("30050", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("30051", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("30052", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("30054", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1458331803;s:7:\"checked\";a:6:{s:7:\"betheme\";s:4:\"10.0\";s:7:\"salient\";s:3:\"5.0\";s:13:\"twentyfifteen\";s:3:\"1.4\";s:14:\"twentyfourteen\";s:3:\"1.6\";s:14:\"twentythirteen\";s:3:\"1.7\";s:12:\"twentytwelve\";s:3:\"1.9\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("30577", "_site_transient_timeout_browser_884e862a0f7254ce3f0c1ea7f0f363dd", "1451505655", "yes");
INSERT INTO `wp_options` VALUES("30578", "_site_transient_browser_884e862a0f7254ce3f0c1ea7f0f363dd", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.106\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("30597", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("30610", "_site_transient_timeout_available_translations", "1450911762", "yes");
INSERT INTO `wp_options` VALUES("30611", "_site_transient_available_translations", "a:72:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-11 13:23:06\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 10:15:45\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/4.4/ary.zip\";s:3:\"iso\";a:2:{i:1;s:5:\"ar_MA\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 20:53:51\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 08:50:29\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-16 05:09:40\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 21:20:44\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 16:27:03\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 16:20:56\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 22:48:20\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 14:19:21\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 12:47:08\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 12:58:17\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/4.4/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-23 12:51:08\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 13:34:17\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-15 11:52:35\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 04:39:48\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-06 23:10:59\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 10:23:11\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 12:35:15\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 13:19:37\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-19 14:33:57\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-04 06:10:33\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.3-RC/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.2.5\";s:7:\"updated\";s:19:\"2015-10-29 16:32:18\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.5/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 17:35:10\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-23 00:46:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 20:26:46\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 05:14:35\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 21:19:15\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-20 13:36:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-23 06:49:15\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 13:47:35\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 02:16:19\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 14:45:38\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-24 15:25:30\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 11:44:09\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.8/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 18:10:01\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 05:11:43\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 22:05:31\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 18:07:25\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-17 13:36:47\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-21 16:17:50\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 00:20:24\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-21 08:04:30\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-13 01:36:53\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 07:35:25\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 20:07:24\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-15 05:49:00\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.8/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 10:01:09\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 15:30:43\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-14 12:19:44\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-02 07:53:33\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.3-RC/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-19 13:20:56\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.8/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-10 18:05:56\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 12:28:15\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 18:41:28\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-11 16:33:02\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-19 14:21:23\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-06 16:10:24\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 09:13:24\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 09:09:51\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 23:28:56\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 03:22:55\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-20 03:52:15\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-17 23:12:27\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.8/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:7:\"4.4-RC1\";s:7:\"updated\";s:19:\"2015-12-04 10:22:09\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4-RC1/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-27 09:19:03\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-11 18:51:41\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 22:55:08\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "yes");
INSERT INTO `wp_options` VALUES("31654", "_site_transient_timeout_browser_e69998cd166d0a716e585b452d0a9806", "1454339945", "yes");
INSERT INTO `wp_options` VALUES("31655", "_site_transient_browser_e69998cd166d0a716e585b452d0a9806", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.111\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("32085", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.4.2\";s:7:\"version\";s:5:\"4.4.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1458331803;s:15:\"version_checked\";s:5:\"4.4.2\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("32691", "_transient_timeout_wpseo_sitemap_cache_page_1", "1456244944", "no");
INSERT INTO `wp_options` VALUES("32692", "_transient_wpseo_sitemap_cache_page_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/mobile-notary/</loc>\n		<lastmod>2016-01-25T07:20:37-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/blog/</loc>\n		<lastmod>2015-02-13T11:23:01-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/</loc>\n		<lastmod>2016-01-25T07:29:02-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>1</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/san-francisco-mobile-notary/</loc>\n		<lastmod>2015-10-27T18:20:32-07:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/about-notary-public/</loc>\n		<lastmod>2015-10-19T00:39:18-07:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/apostille-authentication/</loc>\n		<lastmod>2015-10-06T06:15:21-07:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/scheduling/</loc>\n		<lastmod>2015-10-19T08:16:25-07:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/certified-notary-signing-agent/</loc>\n		<lastmod>2015-10-06T06:13:21-07:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `wp_options` VALUES("32816", "_transient_timeout_wpseo_sitemap_cache_post_tag_1", "1456576315", "no");
INSERT INTO `wp_options` VALUES("32817", "_transient_wpseo_sitemap_cache_post_tag_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/financial-district-notary/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/mobile-notary-san-francisco/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/soma-notary-public/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/traveling-notary-sf/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `wp_options` VALUES("32893", "_transient_timeout_wpseo_sitemap_cache_category_1", "1456784748", "no");
INSERT INTO `wp_options` VALUES("32894", "_transient_wpseo_sitemap_cache_category_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/category/uncategorized/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `wp_options` VALUES("32954", "wpseo_sitemap_cache_validator_global", "8Hwkd3", "yes");
INSERT INTO `wp_options` VALUES("32989", "wpseo_sitemap_1_cache_validator", "96yTZi", "yes");
INSERT INTO `wp_options` VALUES("32990", "wpseo_sitemap_booked_appointments_cache_validator", "9x4osp", "yes");
INSERT INTO `wp_options` VALUES("33007", "wpseo_sitemap_page_cache_validator", "5h126U", "yes");
INSERT INTO `wp_options` VALUES("33008", "_transient_timeout_yst_sm_page_1:8ICy8a_5h126U", "1457085599", "no");
INSERT INTO `wp_options` VALUES("33073", "wpseo_sitemap_post_tag_cache_validator", "5dNV6P", "yes");
INSERT INTO `wp_options` VALUES("33076", "wpseo_sitemap_category_cache_validator", "5dOfa5", "yes");
INSERT INTO `wp_options` VALUES("33077", "_transient_timeout_yst_sm_category_1:8ICy8a_5dOfa5", "1457257957", "no");
INSERT INTO `wp_options` VALUES("33079", "wpseo_sitemap_post_cache_validator", "96yU9G", "yes");
INSERT INTO `wp_options` VALUES("33144", "_transient_timeout_yst_sm_post_tag_1:8ICy8a_5dNV6P", "1457409357", "no");
INSERT INTO `wp_options` VALUES("33204", "rewrite_rules", "a:257:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^scheduling/([^/]*)/?\";s:29:\"index.php?profile=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"booked_appointments/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"booked_appointments/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"booked_appointments/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"booked_appointments/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"booked_appointments/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"booked_appointments/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"booked_appointments/([^/]+)/embed/?$\";s:52:\"index.php?booked_appointments=$matches[1]&embed=true\";s:40:\"booked_appointments/([^/]+)/trackback/?$\";s:46:\"index.php?booked_appointments=$matches[1]&tb=1\";s:48:\"booked_appointments/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?booked_appointments=$matches[1]&paged=$matches[2]\";s:55:\"booked_appointments/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?booked_appointments=$matches[1]&cpage=$matches[2]\";s:44:\"booked_appointments/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?booked_appointments=$matches[1]&page=$matches[2]\";s:36:\"booked_appointments/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"booked_appointments/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"booked_appointments/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"booked_appointments/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"booked_appointments/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"booked_appointments/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"custom-calendar/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?booked_custom_calendars=$matches[1]&feed=$matches[2]\";s:51:\"custom-calendar/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?booked_custom_calendars=$matches[1]&feed=$matches[2]\";s:44:\"custom-calendar/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?booked_custom_calendars=$matches[1]&paged=$matches[2]\";s:26:\"custom-calendar/([^/]+)/?$\";s:45:\"index.php?booked_custom_calendars=$matches[1]\";s:40:\"easy-opt-ins/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"easy-opt-ins/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"easy-opt-ins/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"easy-opt-ins/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"easy-opt-ins/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"easy-opt-ins/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"easy-opt-ins/([^/]+)/embed/?$\";s:45:\"index.php?easy-opt-ins=$matches[1]&embed=true\";s:33:\"easy-opt-ins/([^/]+)/trackback/?$\";s:39:\"index.php?easy-opt-ins=$matches[1]&tb=1\";s:41:\"easy-opt-ins/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?easy-opt-ins=$matches[1]&paged=$matches[2]\";s:48:\"easy-opt-ins/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?easy-opt-ins=$matches[1]&cpage=$matches[2]\";s:37:\"easy-opt-ins/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?easy-opt-ins=$matches[1]&page=$matches[2]\";s:29:\"easy-opt-ins/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"easy-opt-ins/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"easy-opt-ins/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"easy-opt-ins/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"easy-opt-ins/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"easy-opt-ins/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"client-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"client-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"client-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"client-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"client-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"client-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"client-item/([^/]+)/embed/?$\";s:39:\"index.php?client=$matches[1]&embed=true\";s:32:\"client-item/([^/]+)/trackback/?$\";s:33:\"index.php?client=$matches[1]&tb=1\";s:40:\"client-item/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&paged=$matches[2]\";s:47:\"client-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&cpage=$matches[2]\";s:36:\"client-item/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?client=$matches[1]&page=$matches[2]\";s:28:\"client-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"client-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"client-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"client-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"client-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"client-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"client-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:48:\"client-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:41:\"client-types/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?client-types=$matches[1]&paged=$matches[2]\";s:23:\"client-types/([^/]+)/?$\";s:34:\"index.php?client-types=$matches[1]\";s:38:\"offer-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"offer-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"offer-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"offer-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"offer-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"offer-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"offer-item/([^/]+)/embed/?$\";s:38:\"index.php?offer=$matches[1]&embed=true\";s:31:\"offer-item/([^/]+)/trackback/?$\";s:32:\"index.php?offer=$matches[1]&tb=1\";s:39:\"offer-item/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&paged=$matches[2]\";s:46:\"offer-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&cpage=$matches[2]\";s:35:\"offer-item/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?offer=$matches[1]&page=$matches[2]\";s:27:\"offer-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"offer-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"offer-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"offer-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"offer-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"offer-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"offer-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:47:\"offer-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:40:\"offer-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?offer-types=$matches[1]&paged=$matches[2]\";s:22:\"offer-types/([^/]+)/?$\";s:33:\"index.php?offer-types=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"portfolio-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"portfolio-item/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:39:\"portfolio-item/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"portfolio-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"portfolio-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-types/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?portfolio-types=$matches[1]&paged=$matches[2]\";s:26:\"portfolio-types/([^/]+)/?$\";s:37:\"index.php?portfolio-types=$matches[1]\";s:38:\"slide-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"slide-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"slide-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"slide-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"slide-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"slide-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"slide-item/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:31:\"slide-item/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:39:\"slide-item/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:46:\"slide-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:35:\"slide-item/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:27:\"slide-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"slide-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"slide-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"slide-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"slide-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"slide-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"slide-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:47:\"slide-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:40:\"slide-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?slide-types=$matches[1]&paged=$matches[2]\";s:22:\"slide-types/([^/]+)/?$\";s:33:\"index.php?slide-types=$matches[1]\";s:44:\"testimonial-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"testimonial-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"testimonial-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"testimonial-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"testimonial-item/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:37:\"testimonial-item/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:45:\"testimonial-item/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:52:\"testimonial-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:41:\"testimonial-item/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:33:\"testimonial-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"testimonial-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"testimonial-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"testimonial-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"testimonial-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:53:\"testimonial-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:46:\"testimonial-types/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?testimonial-types=$matches[1]&paged=$matches[2]\";s:28:\"testimonial-types/([^/]+)/?$\";s:39:\"index.php?testimonial-types=$matches[1]\";s:39:\"layout-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"layout-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"layout-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"layout-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"layout-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"layout-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"layout-item/([^/]+)/embed/?$\";s:39:\"index.php?layout=$matches[1]&embed=true\";s:32:\"layout-item/([^/]+)/trackback/?$\";s:33:\"index.php?layout=$matches[1]&tb=1\";s:40:\"layout-item/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&paged=$matches[2]\";s:47:\"layout-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&cpage=$matches[2]\";s:36:\"layout-item/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?layout=$matches[1]&page=$matches[2]\";s:28:\"layout-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"layout-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"layout-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"layout-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"layout-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"layout-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"template-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"template-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"template-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"template-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"template-item/([^/]+)/embed/?$\";s:41:\"index.php?template=$matches[1]&embed=true\";s:34:\"template-item/([^/]+)/trackback/?$\";s:35:\"index.php?template=$matches[1]&tb=1\";s:42:\"template-item/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&paged=$matches[2]\";s:49:\"template-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&cpage=$matches[2]\";s:38:\"template-item/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?template=$matches[1]&page=$matches[2]\";s:30:\"template-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"template-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"template-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"template-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=3170&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("33258", "_transient_timeout_yst_sm_post_tag_1:8Hwkd3_5dNV6P", "1458145600", "no");
INSERT INTO `wp_options` VALUES("33259", "_transient_yst_sm_post_tag_1:8Hwkd3_5dNV6P", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/financial-district-notary/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/mobile-notary-san-francisco/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/soma-notary-public/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/tag/traveling-notary-sf/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `wp_options` VALUES("33345", "_transient_timeout_yst_sm_category_1:8Hwkd3_5dOfa5", "1458395028", "no");
INSERT INTO `wp_options` VALUES("33346", "_transient_yst_sm_category_1:8Hwkd3_5dOfa5", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://notarypublicsanfranciscoca.com/category/uncategorized/</loc>\n		<lastmod>2015-11-07T08:33:14-08:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `wp_options` VALUES("33362", "_transient_timeout_ultimate_update_checked", "1458370736", "no");
INSERT INTO `wp_options` VALUES("33363", "_transient_ultimate_update_checked", "1", "no");
INSERT INTO `wp_options` VALUES("33364", "_site_transient_timeout_browser_67bffb4457c7c00ae77275828881cb94", "1458932336", "yes");
INSERT INTO `wp_options` VALUES("33365", "_site_transient_browser_67bffb4457c7c00ae77275828881cb94", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"49.0.2623.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("33376", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1458370742", "no");
INSERT INTO `wp_options` VALUES("33377", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 04:30:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.5-beta4-37031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 04:30:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4155\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3409:\"<p>WordPress 4.5 Beta 4 is now available!</p>\n<p>This software is still in development<strong>,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta4.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">in-depth field guides on make/core</a>. This is the final <a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\">planned beta</a> of WordPress 4.5, with a release candidate scheduled for next week.</p>\n<p>Some of the changes in Beta 4 include:</p>\n<ul>\n<li>Add support for oEmbed <strong>moments and timelines from Twitter</strong> (<a href=\"https://core.trac.wordpress.org/ticket/36197\">#36197</a>).</li>\n<li>More changes to better support <strong>HHVM with Imagick</strong>.<strong> </strong>Please test with HHVM setups and resizing/rotating images (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>).</li>\n<li>Tightened up the <strong>Inline Link</strong> feature (<a href=\"https://core.trac.wordpress.org/ticket/33301\">#33301</a>, <a href=\"https://core.trac.wordpress.org/ticket/30468\">#30468</a>).</li>\n<li>Support <code>&lt;hr&gt;</code> <strong>editor shortcut</strong> with 3 or more dashes (<code>---</code>); no spaces. To give more time to study the best shortcuts for users, text patterns for bold and italic have been removed and won&#8217;t ship with for 4.5 (<a href=\"https://core.trac.wordpress.org/ticket/33300\">#33300</a>).</li>\n<li>Fixes for <strong>SSL with Responsive Images</strong>. Please test with SSL, especially on sites with mixed http/https setups (<a href=\"https://core.trac.wordpress.org/ticket/34945\">#34945</a>).</li>\n<li>Allow rewrite rules to work in nested <strong>WordPress installations on IIS</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35558\">#35558</a>).</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37025&amp;stop_rev=36932&amp;limit=200&amp;verbose=on\">almost 100 changes</a> during the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em>Llegamos al fin</em><br />\n<em>del tiempo pa&#8217; beta</em><br />\n<em>¡Pruébalo Ahora!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 06:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4128\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3631:\"<p>WordPress 4.5 Beta 3 is now available!</p>\n<p>This software is still in development<strong>,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta3.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">in-depth field guides on make/core</a>. Some of the fixes in Beta 3 include:</p>\n<ul>\n<li>Many <strong>Theme Logo Support</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33755\">#33755</a>) fixes, including support for bundled Twenty Fifteen (<a href=\"https://core.trac.wordpress.org/ticket/35944\">#35944</a>).</li>\n<li>Add <strong>Responsive Preview</strong> to theme install previewer (<a href=\"https://core.trac.wordpress.org/ticket/36017\">#36017</a>).</li>\n<li>Support <strong>Imagick in HHVM</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>).</li>\n<li><strong>Whitelist IPTC, XMP, and EXIF profiles</strong> from <code>strip_meta()</code> to maintain authorship, copyright, license, and image orientation (<a href=\"https://core.trac.wordpress.org/ticket/28634\">#28634</a>).</li>\n<li>Support <strong>Windows shares/DFS roots</strong> in <code>wp_normalize_path()</code> (<a href=\"https://core.trac.wordpress.org/ticket/35996\">#35996</a>).</li>\n<li><span class=\"s1\">New installs default to <strong>generating secret keys and salts locally</strong> instead of relying on the <span class=\"s2\">WordPress.org</span> API. Please test installing WP in situations where it can’t connect to the internet <span class=\"s1\">(like on a 🛳, ✈️, or 🛰) </span></span><span class=\"s1\">(<a href=\"https://core.trac.wordpress.org/ticket/35290\">#35290</a>).</span></li>\n<li>OPTIONS requests to REST API should <strong>return Allow header</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35975\">#35975</a>).</li>\n<li>Upgrade twemoji.js to version 2 (<a href=\"https://core.trac.wordpress.org/ticket/36059\">#36059</a>) and add extra IE11 compatibility (<a href=\"https://core.trac.wordpress.org/ticket/35977\">#35977</a>) for <strong>Emoji</strong>.</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36931&amp;stop_rev=36814&amp;limit=200&amp;verbose=on\">more than 100 changes</a> during the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em><span class=\"s1\">Beta one, two, three<br />\n</span><span class=\"s1\">so many bugs have been fixed<br />\n</span><span class=\"s2\">Closer now; four, five.</span></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 04:55:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4116\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2370:\"<p>WordPress 4.5 Beta 2 is now available!</p>\n<p>This software is still in development<strong>,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta2.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1 blog post</a>. Some of the fixes in Beta 2 include:</p>\n<ul>\n<li>Added <a href=\"https://core.trac.wordpress.org/ticket/33300\">Horizontal Rule (HR) editing shortcut</a> and <a href=\"https://core.trac.wordpress.org/ticket/28612\">dismissible &#8220;Paste as Text&#8221; notice</a> in <strong>TinyMCE</strong>.</li>\n<li><strong>Selective Refresh</strong> support is <a href=\"https://core.trac.wordpress.org/changeset/36797\">enabled for core themes titles and taglines</a>, which allows shift-click to focus on controls and PHP filters to apply in the preview.</li>\n<li>Resolved a fatal error on <strong>image upload</strong> when ImageMagick could not complete stripping meta during resize (<a href=\"https://core.trac.wordpress.org/ticket/33642\">#33642</a>).</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36813&amp;stop_rev=36701&amp;limit=200&amp;verbose=on\">just over 100 changes</a> in the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p><em>It&#8217;s peer pressure time</em><br />\n<em>Testing: all cool kids do it</em><br />\n<em>Help find ALL the bugs!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Contributor Weekend: One-Hour Video\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/02/contributor-weekend-one-hour-video/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Feb 2016 19:36:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4112\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:349:\"It&#8217;s time for our second global contributor weekend, and this time we&#8217;re focusing on the video team. For this month&#8217;s challenge, in honor of it being our second month, you have two options for how you can participate! The challenge for this month overall is to work with at least one hour worth of WordCamp video, which [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Jen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2590:\"<p>It&#8217;s time for our second global contributor weekend, and this time we&#8217;re focusing on the <a href=\"https://make.wordpress.org/tv\">video team</a>. For this month&#8217;s challenge, in honor of it being our second month, you have two options for how you can participate! The challenge for this month overall is to work with at least one hour worth of WordCamp video, which you can do by either creating subtitles or editing the video file in preparation for upload to <a href=\"http://WordPress.tv\">WordPress.tv</a>.</p>\n<p>One of the great things about contributing to the video team is that you get to learn so much, since all the work basically involves watching WordCamp presentation videos. Subtitling is a doubly important need, as it is needed to make all those WordCamp videos accessible to people who are deaf or hard of hearing and can&#8217;t listen to the audio track, as well as making it possible for the videos to be consumed (in some cases after subtitle translation) by people who speak different languages.</p>\n<p>The challenge will last from Saturday, February 27, 2016 through Sunday, February 28, 2016, and the results will be reviewed afterward by members of the video team. If you enjoy the challenge, the video team would be very excited to welcome you into their ranks! Interested? <a href=\"https://wp.me/P6onIa-28D\">Here&#8217;s how to participate</a>.</p>\n<h3>What About Last Month?</h3>\n<p>In January, the inaugural contributor weekend was focused on the support forums. That challenge had 73 participants, including 10 people who provided 20 or more correct answers to open support threads, thereby winning the challenge. Congratulations to Harris Anastasiadis, Ahmad Awais, Takis Bouyouris, Phil Erb, Eric Gunawan, Jackie McBride, Diana Nichols, Kostas Nicolacopoulos, Juhi Saxena, and Sarah Semark! To them and to everyone else who participated, thank you <strong>so much</strong> for your efforts. Every answer helps, and over the course of this contributor weekend, these amazing volunteers responded to <strong>800 support threads</strong>. The support forums queue of requests with no replies went from 28 pages to 7 pages &#8212; that was an incredible success, of which every participant was a part!</p>\n<p>So head on over to see how to <a href=\"https://wp.me/P6onIa-28D\">get involved with the one-hour video challenge</a> this weekend, and help us make next month&#8217;s post just as impressive! <img src=\"https://s.w.org/images/core/emoji/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:41:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n	\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Feb 2016 03:27:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4080\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://wordpress.org/news/files/2016/02/wp-inline-linking.mp4\";s:6:\"length\";s:6:\"409018\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://wordpress.org/news/files/2016/02/wp-editor-updates.mp4\";s:6:\"length\";s:6:\"231953\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5453:\"<p>WordPress 4.5 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta1.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>WordPress 4.5 is slated for release on <a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\" target=\"_blank\">April 12</a>, but to get there, we need your help testing what we have been working on, including:</p>\n<ul>\n<li><strong>Responsive Preview of your site in the Customizer </strong>(<a href=\"https://core.trac.wordpress.org/ticket/31195\">#31195</a>) &#8211; See how your site looks in <a href=\"https://make.wordpress.org/core/2016/01/28/previewing-site-responsiveness-in-the-customizer/\">mobile, tablet, and desktop</a> contexts before making changes to its appearance.</li>\n<li><strong>Theme Logo Support </strong>(<a href=\"https://core.trac.wordpress.org/ticket/33755\">#33755</a>) &#8211; Native support for a <a href=\"https://make.wordpress.org/core/2016/02/24/theme-logo-support/\">theme logo within the Customizer</a>.</li>\n<li><strong>Inline Link Editing</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33301\">#33301</a>) &#8211; Within the visual editor, <a href=\"https://wordpress.org/news/files/2016/02/wp-inline-linking.mp4\">edit links inline</a> for a smoother workflow.</li>\n<li><strong>Additional Editor Shortcuts</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33300\">#33300</a>) &#8211; <a href=\"https://wordpress.org/news/files/2016/02/wp-editor-updates.mp4\">Includes a few new shortcuts</a>, like <code>`..`</code> for <code>code</code> and <code>**..**</code> for <strong>bold</strong>.</li>\n<li><strong>Comment Moderation Improvements </strong>(<a href=\"https://core.trac.wordpress.org/ticket/34133\">#34133</a>) &#8211; An enhanced experience when moderating comments, including preview with rendered formatting.</li>\n<li><strong>Optimization of Image Generation </strong>(<a href=\"https://core.trac.wordpress.org/ticket/33642\">#33642</a>) &#8211; Image sizes are generated more efficiently and remove unneeded meta, while still including color profiles in Imagick, for reduced sizes of up to 50% with near identical visual quality.</li>\n</ul>\n<p>&nbsp;</p>\n<p>There have been changes for developers to explore as well:</p>\n<ul>\n<li><strong>Selective Refresh </strong>(<a href=\"https://core.trac.wordpress.org/ticket/27355\">#27355</a>)<strong> </strong>&#8211; A <a href=\"https://make.wordpress.org/core/2016/02/16/selective-refresh-in-the-customizer/\">comprehensive framework</a> for rendering parts of the customizer preview in real time. Theme and plugin authors should test their widgets specifically for compatibility with selective refresh, and note that it <a href=\"https://core.trac.wordpress.org/ticket/35855\">may ultimately be opt-in for 4.5</a>.</li>\n<li><strong>Backbone and Underscore updated to latest versions</strong> (<a href=\"https://core.trac.wordpress.org/ticket/34350\">#34350</a>)<b> </b>&#8211; Backbone is upgraded from 1.1.2 to 1.2.3 and Underscore is upgraded from 1.6.0 to 1.8.3. See the <a href=\"https://make.wordpress.org/core/2016/02/17/backbone-and-underscore-updated-to-latest-versions/\">this post</a> for important changes.</li>\n<li><strong>Embed templates</strong> (<a href=\"https://core.trac.wordpress.org/ticket/34561\">#34561</a>) &#8211; Embed templates were split into parts and can now be directly overridden by themes via the template hierarchy.</li>\n<li><strong>New WP_Site class</strong> (<a href=\"https://core.trac.wordpress.org/ticket/32450\">#32450</a>) &#8211; More object-oriented approach for managing sites in Multisite</li>\n<li><strong>Script loader</strong> (<a href=\"https://core.trac.wordpress.org/ticket/14853\">#14853</a>, <a href=\"https://core.trac.wordpress.org/ticket/35873\">#35873</a>) &#8211; Introduces <code>wp_add_inline_script()</code> for including inline JavaScript just like <code>wp_add_inline_style()</code> works for CSS, and better support for script header/footer dependencies.</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.5, <a href=\"https://make.wordpress.org/core/tag/4-5/\" target=\"_blank\">check out all 4.5-tagged posts</a> on the main development blog, or check out a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.5&amp;group=component&amp;order=priority\">list of everything</a> that&#8217;s changed.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p><em>A wonderful day</em><br />\n<em>is one that brings new WordPress</em><br />\n<em>Four Five Beta One</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Experiment: WordCamp Incubator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2016/02/experiment-wordcamp-incubator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Feb 2016 19:28:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4076\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"WordCamps are locally-organized WordPress conferences that happen all over the world (and are so fun). Sometimes people don&#8217;t realize that WordCamps are organized by local volunteers rather than a central organization, and they contact us asking, &#8220;Can you bring WordCamp to my city?&#8221; When this happens, we always suggest they start with a meetup group, and think about [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Jen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2989:\"<p><a href=\"http://wordcamp.org\">WordCamps</a> are locally-organized WordPress conferences that happen all over the world (and are so fun). Sometimes people don&#8217;t realize that WordCamps are organized by local volunteers rather than a central organization, and they contact us asking, &#8220;Can you bring WordCamp to my city?&#8221; When this happens, we always suggest they start with a meetup group, and think about organizing a WordCamp themselves after their group has been active for a few months. We emphasize that WordCamps are locally-organized events, not something that the central <a href=\"https://make.wordpress.org/community\">community team</a> plans from afar.</p>\n<p>This has been successful in many areas &#8212; there are currently 241 meetup groups on our meetup.com chapter program! In some regions, though, enthusiastic volunteers have had more of a challenge getting things started. Because of this, we&#8217;re going to try an experiment this year called the WordCamp Incubator.</p>\n<p>The intention of the incubator program is to help spread WordPress to underserved areas through providing more significant organizing support for a first event. In practical terms, this experiment means we&#8217;ll be choosing three cities in 2016 where there is not an active WordPress community &#8212; but where it seems like there is a lot of potential and where there are some people excited to become organizers &#8212; and will help to organize their first WordCamp. These WordCamps will be small, one-day, one-track events geared toward the goal of generating interest and getting people involved in creating an ongoing local community.*</p>\n<p>So, where should we do these three events?  If you have always wanted a WordCamp in your city but haven&#8217;t been able to get a meetup group going, this is a great opportunity. We will be taking applications for the next week, then will get in touch with everyone who applied to discuss the possibilities. We will announce the  cities chosen by the end of March.</p>\n<p>To apply, <a href=\"http://wordpressdotorg.polldaddy.com/s/wordcamp-incubator-application\">fill in the application</a> by February 26, 2016. You don&#8217;t need to have any specific information handy, it&#8217;s just a form to let us know you&#8217;re interested. You can apply to nominate your city even if you don&#8217;t want to be the main organizer, but for this experiment  we will need local liaisons and volunteers, so please only nominate cities where you live or work so that we have at least one local connection to begin.</p>\n<p>Thanks, and good luck!</p>\n<p><em><strong>* </strong>For the record, that describes the ideal first WordCamp even if you have an active meetup &#8212; there&#8217;s no need to wait until your group is big enough to support a large multi-day event, and small events are a lot of fun because everyone has a chance to be involved and get to know most of the other attendees.</em></p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.4.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2016/02/wordpress-4-4-2-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Feb 2016 17:57:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.4.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.4.1 and earlier are affected by two security issues: a possible SSRF for certain local URIs, reported by Ronni Skansing; and an open redirection attack, reported by Shailesh Suthar. Thank you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2072:\"<p>WordPress 4.4.2 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.4.1 and earlier are affected by two security issues: a possible SSRF for certain local URIs, reported by <a href=\"https://www.linkedin.com/in/ronni-skansing-36143b65\">Ronni Skansing</a>; and an open redirection attack, reported by <a href=\"https://twitter.com/shailesh4594\">Shailesh Suthar</a>.</p>\n<p>Thank you to both reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.4.2 fixes 17 bugs from 4.4 and 4.4.1. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.4.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.4.2\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.4.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.4.2.</p>\n<p>Thanks to everyone who contributed to 4.4.2:</p>\n<p><a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/berengerzyla\">berengerzyla</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/firebird75\">firebird75</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/salvoaranzulla\">salvoaranzulla</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Contributor Weekend: Support Forums\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/01/contributor-weekend-support-forums/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Jan 2016 18:31:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"contributors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:14:\"Support Forums\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4055\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:351:\"Our first global contributor drive is coming up next weekend, January 30-31, 2016, and we want you to be involved! Many of our current contributors first got involved at a Contributor Day at a WordCamp or WordPress Meetup event near them, but not everyone has had that opportunity, so we&#8217;re trying to create an online experience that [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Jen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2112:\"<p>Our first global contributor drive is coming up next weekend, January 30-31, 2016, and we want you to be involved!</p>\n<p>Many of our current contributors first got involved at a Contributor Day at a <a href=\"http://wordcamp.org\">WordCamp</a> or <a href=\"http://www.meetup.com/pro/wordpress/\">WordPress Meetup</a> event near them, but not everyone has had that opportunity, so we&#8217;re trying to create an online experience that will give new contributors the same kind of live support and group dynamic. We&#8217;ll be doing these as weekend challenges rather than one-day events so that WordPress users all over the world can participate without worrying about pesky time zones, but each challenge will be designed to be completed within a few hours, comparable to an in-person Contributor Day.</p>\n<p>Our inaugural Contributor Weekend is focused on the <a href=\"https://make.wordpress.org/support\">Support Team</a> &#8212; the folks who volunteer their time to help people with WordPress questions in the <a href=\"https://wordpress.org/support\">support forums</a> and <a href=\"https://make.wordpress.org/support/irc-support-channel/\">IRC</a>. Over the two day span, forum moderators will be available online to help new contributors and answer questions as needed. The challenge this month is called <em>20 Questions;</em> your mission (should you choose to accept it) is to help WordPress users by answering 20 forum support requests over the course of the weekend.</p>\n<p>You can participate on your own, or you can get together with other people from your local meetup group and work on it together. Working together in person is really fun, so we highly recommend trying to get some folks together if you&#8217;re able, but if that&#8217;s not possible you can still connect to other participants online. Either way, this is a great way to give back to the WordPress project and have some fun helping people at the same time.</p>\n<p>Interested? <a href=\"https://make.wordpress.org/support/20-questions/\">Get the details on how to participate</a>.</p>\n<p>Hope to see you next weekend!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.4.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2016/01/wordpress-4-4-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Jan 2016 20:07:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4041\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"WordPress 4.4.1 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.4 and earlier are affected by a cross-site scripting vulnerability that could allow a site to be compromised. This was reported by Crtc4L. There were also several non-security bug fixes: Emoji [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Aaron Jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5153:\"<p>WordPress 4.4.1 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.4 and earlier are affected by a cross-site scripting vulnerability that could allow a site to be compromised. This was <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">reported</a> by <a href=\"https://hackerone.com/crtc4l\">Crtc4L</a>.</p>\n<p>There were also several non-security bug fixes:</p>\n<ul>\n<li>Emoji support has been updated to include all of the latest emoji characters, including the new diverse emoji! <img src=\"https://s.w.org/images/core/emoji/72x72/1f44d.png\" alt=\"👍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f3ff.png\" alt=\"🏿\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f44c.png\" alt=\"👌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f3fd.png\" alt=\"🏽\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f44f.png\" alt=\"👏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f3fc.png\" alt=\"🏼\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></li>\n<li>Some sites with older versions of OpenSSL installed were unable to communicate with other services provided through some plugins.</li>\n<li>If a post URL was ever re-used, the site could redirect to the wrong post.</li>\n</ul>\n<p>WordPress 4.4.1 fixes 52 bugs from 4.4. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.4.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.4.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.4.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.4.1.</p>\n<p>Thanks to everyone who contributed to 4.4.1:</p>\n<p><a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/Compute\">Compute</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/DvanKooten\">Danny van Kooten</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dossy\">Dossy Shiobara</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jeffpyebrookcom/\">Jeff Pye Brook</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/JPr\">jpr</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/KrissieV\">KrissieV</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/wp-architect\">Matthew Ell</a>, <a href=\"https://profiles.wordpress.org/meitar\">Meitar</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/rogerhub\">Roger Chen</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scottbrownconsulting\">scottbrownconsulting</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/ShinichiN\">Shinichi Nishikawa</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, and <a href=\"https://profiles.wordpress.org/webaware\">webaware</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 4.4 “Clifford”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://wordpress.org/news/2015/12/clifford/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Dec 2015 03:25:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=3990\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:379:\"Version 4.4 of WordPress, named “Clifford” in honor of jazz trumpeter Clifford Brown, is available for download or update in your WordPress dashboard. New features in 4.4 make your site more connected and responsive. Clifford also introduces a new default theme, Twenty Sixteen. Introducing Twenty Sixteen Our newest default theme, Twenty Sixteen, is a modern take [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:40793:\"<p>Version 4.4 of WordPress, named “Clifford” in honor of jazz trumpeter Clifford Brown, is available for download or update in your WordPress dashboard. New features in 4.4 make your site more connected and responsive. Clifford also introduces a new default theme, Twenty Sixteen.</p>\n<p><iframe width=\'692\' height=\'388\' src=\'https://videopress.com/embed/J44FHXvg?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<hr />\n<h2 style=\"text-align: center\">Introducing Twenty Sixteen</h2>\n<p><img class=\"aligncenter size-full wp-image-3994\" src=\"https://wordpress.org/news/files/2015/12/ipad-white-desktop-2x.png\" alt=\"A screenshot of Twenty Sixteen set in an iPad frame\" width=\"1680\" height=\"1139\" srcset=\"https://wordpress.org/news/files/2015/12/ipad-white-desktop-2x-300x203.png 300w, https://wordpress.org/news/files/2015/12/ipad-white-desktop-2x-768x521.png 768w, https://wordpress.org/news/files/2015/12/ipad-white-desktop-2x-1024x694.png 1024w, https://wordpress.org/news/files/2015/12/ipad-white-desktop-2x.png 1680w\" sizes=\"(max-width: 1680px) 100vw, 1680px\" /></p>\n<p>Our newest default theme, Twenty Sixteen, is a modern take on a classic blog design.</p>\n<p>Twenty Sixteen was built to look great on any device. A fluid grid design, flexible header, fun color schemes, and more, will all make your content shine.</p>\n<hr />\n<h2 style=\"text-align: center\">Responsive Images</h2>\n<p><img class=\"aligncenter wp-image-3995 size-full\" src=\"https://wordpress.org/news/files/2015/12/responsive-devices-ipad-2x.png\" alt=\"An image of a laptop, iPad, Android phone, and iPhone containing the same image displayed at multiple sizes to demonstrate responsive image features.\" width=\"1396\" height=\"640\" srcset=\"https://wordpress.org/news/files/2015/12/responsive-devices-ipad-2x-300x138.png 300w, https://wordpress.org/news/files/2015/12/responsive-devices-ipad-2x-768x352.png 768w, https://wordpress.org/news/files/2015/12/responsive-devices-ipad-2x-1024x469.png 1024w, https://wordpress.org/news/files/2015/12/responsive-devices-ipad-2x.png 1396w\" sizes=\"(max-width: 1396px) 100vw, 1396px\" /></p>\n<p>WordPress now takes a smarter approach to displaying appropriate image sizes on any device, ensuring a perfect fit every time. You don’t need to do anything to your theme, it just works.</p>\n<hr />\n<h2 style=\"text-align: center\">Embed Everything</h2>\n<div class=\"embed-container\">\n<blockquote data-secret=\"wv4RlzOPNS\" class=\"wp-embedded-content\"><p><a href=\"https://make.wordpress.org/core/2015/10/28/new-embeds-feature-in-wordpress-4-4/\">New Embeds Feature in WordPress 4.4</a></p></blockquote>\n<p><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"display:none;\" src=\"https://make.wordpress.org/core/2015/10/28/new-embeds-feature-in-wordpress-4-4/embed/#?secret=wv4RlzOPNS\" data-secret=\"wv4RlzOPNS\" width=\"600\" height=\"338\" title=\"Embedded WordPress Post\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div>\n<p>Now you can embed your posts on other WordPress sites. Simply drop a post URL into the editor and see an instant embed preview, complete with the title, excerpt, and featured image if you’ve set one. We’ll even include your site icon and links for comments and sharing.</p>\n<p>In addition to post embeds, WordPress 4.4 also adds support for five new oEmbed providers: Cloudup, Reddit Comments, ReverbNation, Speaker Deck, and VideoPress.</p>\n<hr />\n<h2 style=\"text-align: center\">Under the Hood</h2>\n<p><img class=\"aligncenter size-full wp-image-4003\" src=\"https://wordpress.org/news/files/2015/12/banner-1544x500.jpg\" alt=\"The WordPress REST API logo\" width=\"1544\" height=\"500\" srcset=\"https://wordpress.org/news/files/2015/12/banner-1544x500-300x97.jpg 300w, https://wordpress.org/news/files/2015/12/banner-1544x500-768x249.jpg 768w, https://wordpress.org/news/files/2015/12/banner-1544x500-1024x332.jpg 1024w, https://wordpress.org/news/files/2015/12/banner-1544x500.jpg 1544w\" sizes=\"(max-width: 1544px) 100vw, 1544px\" /></p>\n<h3>REST API infrastructure</h3>\n<p>Infrastructure for the REST API has been integrated into core, marking a new era in developing with WordPress. The REST API gives developers an easy way to build and extend RESTful APIs on top of WordPress.</p>\n<p>Infrastructure is the first part of a multi-stage rollout for the REST API. Inclusion of core endpoints is targeted for an upcoming release. To get a sneak peek of the core endpoints, and for more information on extending the REST API, check out the official <a href=\"https://wordpress.org/plugins/rest-api/\">WordPress REST API</a> plugin.</p>\n<h3>Term meta</h3>\n<p>Terms now support metadata, just like posts. See <a href=\"https://developer.wordpress.org/reference/functions/add_term_meta\"><code>add_term_meta()</code></a>, <a href=\"https://developer.wordpress.org/reference/functions/get_term_meta\"><code>get_term_meta()</code></a>, and <a href=\"https://developer.wordpress.org/reference/functions/update_term_meta\"><code>update_term_meta()</code></a> for more information.</p>\n<h3>Comment query improvements</h3>\n<p>Comment queries now have cache handling to improve performance. New arguments in <code>WP_Comment_Query</code> make crafting robust comment queries simpler.</p>\n<div class=\"feature-section under-the-hood three-col\">\n<div class=\"col\">\n<h3>Term, comment, and network objects</h3>\n<p>New <code>WP_Term</code>, <code>WP_Comment</code>, and <code>WP_Network</code> objects make interacting with terms, comments, and networks more predictable and intuitive in code.</p>\n</div>\n</div>\n<hr />\n<h2>The Team</h2>\n<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/wonderboymusic\"><img src=\"https://www.gravatar.com/avatar/ed0f881acb9dc96bee53e4dc61b5558f?d=mm&amp;s=180&amp;r=G\" alt=\"Scott Taylor\" width=\"80\" height=\"80\" /></a>This release was led by <a href=\"http://scotty-t.com/\">Scott Taylor</a>, with the help of these fine individuals. There are 471 contributors with props in this release (by far the most ever!). Pull up some Clifford Brown on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/mercime\">@mercime</a>, <a href=\"https://profiles.wordpress.org/_smartik_\">_smartik_</a>, <a href=\"https://profiles.wordpress.org/a5hleyrich\">A5hleyRich</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrutley\">Aaron Rutley</a>, <a href=\"https://profiles.wordpress.org/kawauso\">Adam Harley (Kawauso)</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adamholisky\">adamholisky</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/albertoct\">AlbertoCT</a>, <a href=\"https://profiles.wordpress.org/akirk\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/gounder\">Alexander Gounder</a>, <a href=\"https://profiles.wordpress.org/alireza1375\">alireza1375</a>, <a href=\"https://profiles.wordpress.org/shedonist\">Amanda Giles</a>, <a href=\"https://profiles.wordpress.org/amereservant\">amereservant</a>, <a href=\"https://profiles.wordpress.org/sabreuse\">Amy Hendrix (sabreuse)</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/aduth\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/norcross\">Andrew Norcross</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/amandato\">Angelo Mandato</a>, <a href=\"https://profiles.wordpress.org/ankitgadertcampcom\">Ankit Gade</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/antpb\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/apkoponen\">ap.koponen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/atomicjack\">atomicjack</a>, <a href=\"https://profiles.wordpress.org/austinginder\">Austin Ginder</a>, <a href=\"https://profiles.wordpress.org/filosofo\">Austin Matzko</a>, <a href=\"https://profiles.wordpress.org/barryceelen\">Barry Ceelen</a>, <a href=\"https://profiles.wordpress.org/barrykooij\">Barry Kooij</a>, <a href=\"https://profiles.wordpress.org/bcworkz\">bcworkz</a>, <a href=\"https://profiles.wordpress.org/bdn3504\">BdN3504</a>, <a href=\"https://profiles.wordpress.org/pixolin\">Bego Mario Garde</a>, <a href=\"https://profiles.wordpress.org/benjmay\">Ben May</a>, <a href=\"https://profiles.wordpress.org/benjaminpick\">Benjamin Pick</a>, <a href=\"https://profiles.wordpress.org/berengerzyla\">berengerzyla</a>, <a href=\"https://profiles.wordpress.org/neoxx\">Bernhard Riedl</a>, <a href=\"https://profiles.wordpress.org/bigdawggi\">bigdawggi</a>, <a href=\"https://profiles.wordpress.org/bilalcoder\">bilalcoder</a>, <a href=\"https://profiles.wordpress.org/binarykitten\">BinaryKitten</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornjohansen\">Bj&#248;rn Johansen</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradt\">Brad Touesnard</a>, <a href=\"https://profiles.wordpress.org/bradparbs\">bradparbs</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/bravokeyl\">bravokeyl</a>, <a href=\"https://profiles.wordpress.org/brentvr\">brentvr</a>, <a href=\"https://profiles.wordpress.org/brettz95\">brettz95</a>, <a href=\"https://profiles.wordpress.org/mckilem\">Bruno Kos</a>, <a href=\"https://profiles.wordpress.org/crazycoolcam\">Cam</a>, <a href=\"https://profiles.wordpress.org/camikaos\">Cami Kaos</a>, <a href=\"https://profiles.wordpress.org/carolinegeven\">carolinegeven</a>, <a href=\"https://profiles.wordpress.org/misterbisson\">Casey Bisson</a>, <a href=\"https://profiles.wordpress.org/ch1902\">ch1902</a>, <a href=\"https://profiles.wordpress.org/nhuja\">Chandra M</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chasewiseman\">Chase Wiseman</a>, <a href=\"https://profiles.wordpress.org/chiara_09\">Chiara Dossena</a>, <a href=\"https://profiles.wordpress.org/chipbennett\">Chip Bennett</a>, <a href=\"https://profiles.wordpress.org/chiragswadia\">Chirag Swadia</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/chrismkindred\">Chris Kindred</a>, <a href=\"https://profiles.wordpress.org/cklosows\">Chris Klosowski</a>, <a href=\"https://profiles.wordpress.org/chriscoyier\">chriscoyier</a>, <a href=\"https://profiles.wordpress.org/chrisdc1\">Chrisdc1</a>, <a href=\"https://profiles.wordpress.org/lovememore\">christianoliff</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom\">cjhaas</a>, <a href=\"https://profiles.wordpress.org/codeelite\">codeelite</a>, <a href=\"https://profiles.wordpress.org/coenjacobs\">Coen Jacobs</a>, <a href=\"https://profiles.wordpress.org/compute\">Compute</a>, <a href=\"https://profiles.wordpress.org/couturefreak\">Courtney Ivey</a>, <a href=\"https://profiles.wordpress.org/craig-ralston\">Craig Ralston</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/dboulet\">Dan Boulet</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/daniel-koskinen\">Daniel Koskinen</a>, <a href=\"https://profiles.wordpress.org/dmenard\">Daniel M&#233;nard</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/daniellandau\">daniellandau</a>, <a href=\"https://profiles.wordpress.org/daniloercoli\">daniloercoli</a>, <a href=\"https://profiles.wordpress.org/dannydehaan\">Danny de Haan</a>, <a href=\"https://profiles.wordpress.org/dvankooten\">Danny van Kooten</a>, <a href=\"https://profiles.wordpress.org/nerrad\">Darren Ethier (nerrad)</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/dattaparad\">Datta Parad</a>, <a href=\"https://profiles.wordpress.org/dmchale\">Dave McHale</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/davidanderson\">David Anderson</a>, <a href=\"https://profiles.wordpress.org/davidbinda\">David Binovec</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/debaat\">DeBAAT</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/downstairsdev\">Devin Price</a>, <a href=\"https://profiles.wordpress.org/dezzy\">Dezzy</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipalidhole27gmailcom\">Dipali Dhole</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipesh.kakadiya</a>, <a href=\"https://profiles.wordpress.org/dbru\">Dominik Bruderer</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dossy\">Dossy Shiobara</a>, <a href=\"https://profiles.wordpress.org/drebbitsweb\">Dreb Bits</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustinbolton\">dustinbolton</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/edirect24\">edirect24</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/eduardozulian\">Eduardo Zulian</a>, <a href=\"https://profiles.wordpress.org/cais\">Edward Caissie</a>, <a href=\"https://profiles.wordpress.org/egill\">Egill R. Erlendsson</a>, <a href=\"https://profiles.wordpress.org/egower\">egower</a>, <a href=\"https://profiles.wordpress.org/iehsanir\">Ehsaan</a>, <a href=\"https://profiles.wordpress.org/ehtis\">ehtis</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ellieroepken\">Ellie Strejlau</a>, <a href=\"https://profiles.wordpress.org/elliott-stocks\">Elliott Stocks</a>, <a href=\"https://profiles.wordpress.org/elusiveunit\">elusiveunit</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericdaams\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"https://profiles.wordpress.org/ericjuden\">ericjuden</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/f4rkie\">F4rkie</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fsylum\">Firdaus Zahari</a>, <a href=\"https://profiles.wordpress.org/firebird75\">firebird75</a>, <a href=\"https://profiles.wordpress.org/fonglh\">fonglh</a>, <a href=\"https://profiles.wordpress.org/francoisb\">francoisb</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/gaelan\">Gaelan Lloyd</a>, <a href=\"https://profiles.wordpress.org/gagan0123\">Gagan Deep Singh</a>, <a href=\"https://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/garza\">garza</a>, <a href=\"https://profiles.wordpress.org/grvrulz\">Gaurav Pareek</a>, <a href=\"https://profiles.wordpress.org/gautamgupta\">Gautam Gupta</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/geminorum\">geminorum</a>, <a href=\"https://profiles.wordpress.org/kloon\">Gerhard Potgieter</a>, <a href=\"https://profiles.wordpress.org/gezamiklo\">geza.miklo</a>, <a href=\"https://profiles.wordpress.org/gizburdt\">Gijs Jorissen</a>, <a href=\"https://profiles.wordpress.org/garusky\">Giuseppe Mamone</a>, <a href=\"https://profiles.wordpress.org/jubstuff\">Giustino Borzacchiello</a>, <a href=\"https://profiles.wordpress.org/gnaka08\">gnaka08</a>, <a href=\"https://profiles.wordpress.org/gradyetc\">gradyetc</a>, <a href=\"https://profiles.wordpress.org/gregrickaby\">Greg Rickaby</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/webord\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/gwinhlopez\">gwinh.lopez</a>, <a href=\"https://profiles.wordpress.org/hakre\">hakre</a>, <a href=\"https://profiles.wordpress.org/hauvong\">hauvong</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hrishiv90\">Hrishikesh Vaipurkar</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/iandstewart\">Ian Stewart</a>, <a href=\"https://profiles.wordpress.org/icetee\">icetee</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/headonfire\">Ihor Vorotnov</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ippetkov\">ippetkov</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/athsear\">J.Sugiyama</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jakubtyrcha\">jakub.tyrcha</a>, <a href=\"https://profiles.wordpress.org/macmanx\">James Huff</a>, <a href=\"https://profiles.wordpress.org/janhenckens\">Jan Henckens</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaspermdegroot\">Jasper de Groot</a>, <a href=\"https://profiles.wordpress.org/jazbek\">jazbek</a>, <a href=\"https://profiles.wordpress.org/jcroucher\">jcroucher</a>, <a href=\"https://profiles.wordpress.org/jfarthing84\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jeffstieler\">Jeff Stieler</a>, <a href=\"https://profiles.wordpress.org/jeffmatson\">JeffMatson</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeffpyebrookcom\">Jeffrey Schutzman</a>, <a href=\"https://profiles.wordpress.org/jeichorn\">jeichorn</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/slimndap\">Jeroen Schmit</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/engelen\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jim912\">jim912</a>, <a href=\"https://profiles.wordpress.org/jliman\">jliman</a>, <a href=\"https://profiles.wordpress.org/jmayhak\">jmayhak</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">jnylen0</a>, <a href=\"https://profiles.wordpress.org/jobst\">Jobst Schmalenbach</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joehills\">joehills</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/mindctrl\">John Parris</a>, <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/koke\">Jorge Bernal</a>, <a href=\"https://profiles.wordpress.org/betzster\">Josh Betz</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/jpr\">jpr</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/justdaiv\">justdaiv</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/greenshady\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/karinedo\">karinedo</a>, <a href=\"https://profiles.wordpress.org/karpstrucking\">karpstrucking</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevinb\">Kevin Behrens</a>, <a href=\"https://profiles.wordpress.org/kevinlangleyjr\">Kevin Langley</a>, <a href=\"https://profiles.wordpress.org/kevinatelement\">kevinatelement</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/krissiev\">KrissieV</a>, <a href=\"https://profiles.wordpress.org/drozdz\">Krzysiek Dr&#243;żdż</a>, <a href=\"https://profiles.wordpress.org/kurtpayne\">Kurt Payne</a>, <a href=\"https://profiles.wordpress.org/laceous\">laceous</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/offereins\">Laurens Offereins</a>, <a href=\"https://profiles.wordpress.org/lcherpit\">lcherpit</a>, <a href=\"https://profiles.wordpress.org/ldinclaux\">ldinclaux</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leemon\">leemon</a>, <a href=\"https://profiles.wordpress.org/lessbloat\">lessbloat</a>, <a href=\"https://profiles.wordpress.org/linuxologos\">linuxologos</a>, <a href=\"https://profiles.wordpress.org/spmlucas\">Lucas Karpiuk</a>, <a href=\"https://profiles.wordpress.org/lucatume\">lucatume</a>, <a href=\"https://profiles.wordpress.org/luciole135\">luciole135</a>, <a href=\"https://profiles.wordpress.org/lucymtc\">Lucy Tomas</a>, <a href=\"https://profiles.wordpress.org/lukecarbis\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/madalinungureanu\">madalin.ungureanu</a>, <a href=\"https://profiles.wordpress.org/mako09\">Mako</a>, <a href=\"https://profiles.wordpress.org/manolis09\">manolis09</a>, <a href=\"https://profiles.wordpress.org/iworks\">Marcin Pietrzak</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/mechter\">Markus</a>, <a href=\"https://profiles.wordpress.org/wilto\">Mat Marquis</a>, <a href=\"https://profiles.wordpress.org/matheusfd\">Matheus Martins</a>, <a href=\"https://profiles.wordpress.org/mattbagwell\">Matt Bagwell</a>, <a href=\"https://profiles.wordpress.org/mgibbs189\">Matt Gibbs</a>, <a href=\"https://profiles.wordpress.org/sivel\">Matt Martz</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/wp-architect\">Matthew Ell</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mazurstas\">mazurstas</a>, <a href=\"https://profiles.wordpress.org/mbrandys\">mbrandys</a>, <a href=\"https://profiles.wordpress.org/mdmcginn\">mdmcginn</a>, <a href=\"https://profiles.wordpress.org/mehulkaklotar\">Mehul Kaklotar</a>, <a href=\"https://profiles.wordpress.org/meitar\">Meitar</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/meloniq\">meloniq</a>, <a href=\"https://profiles.wordpress.org/micahmills\">micahmills</a>, <a href=\"https://profiles.wordpress.org/micahwave\">micahwave</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/cainm\">Michael Cain</a>, <a href=\"https://profiles.wordpress.org/michielhab\">Michiel Habraken</a>, <a href=\"https://profiles.wordpress.org/mcguive7\">Mickey Kay</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/thaicloud\">Mike Jordan</a>, <a href=\"https://profiles.wordpress.org/mikeschinkel\">Mike Schinkel</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/mismith227\">mismith227</a>, <a href=\"https://profiles.wordpress.org/misterunknown\">misterunknown</a>, <a href=\"https://profiles.wordpress.org/mitchoyoshitaka\">mitcho (Michael Yoshitaka Erlewine)</a>, <a href=\"https://profiles.wordpress.org/monika\">Monika</a>, <a href=\"https://profiles.wordpress.org/morganestes\">morganestes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/usermrpapa\">Mr Papa</a>, <a href=\"https://profiles.wordpress.org/mrmist\">mrmist</a>, <a href=\"https://profiles.wordpress.org/mulvane\">mulvane</a>, <a href=\"https://profiles.wordpress.org/neoscrib\">neoscrib</a>, <a href=\"https://profiles.wordpress.org/next-season\">NExT-Season</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/nicholas_io\">nicholas_io</a>, <a href=\"https://profiles.wordpress.org/nickciske\">Nick Ciske</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nickduncan\">NickDuncan</a>, <a href=\"https://profiles.wordpress.org/rahe\">Nicolas Juen</a>, <a href=\"https://profiles.wordpress.org/nikeo\">nikeo</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/niklasbr\">Niklas</a>, <a href=\"https://profiles.wordpress.org/nikolovtmw\">Nikola Nikolov</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/originalexe\">OriginalEXE</a>, <a href=\"https://profiles.wordpress.org/pareshradadiya-1\">Paresh Radadiya</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/obrienlabs\">Pat O\'Brien</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pauldewouters\">Paul de Wouters</a>, <a href=\"https://profiles.wordpress.org/figureone\">Paul Ryan</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/walbo\">Petter Walb&#248; Johnsg&#229;rd</a>, <a href=\"https://profiles.wordpress.org/petya\">Petya Raykovska</a>, <a href=\"https://profiles.wordpress.org/pfefferle\">pfefferle</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/philiplakin\">PhilipLakin</a>, <a href=\"https://profiles.wordpress.org/corphi\">Philipp Cordes</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/psoluch\">Piotr Soluch</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/prasad-nevase\">Prasad Nevase</a>, <a href=\"https://profiles.wordpress.org/nprasath002\">Prasath Nadarajah</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rajnikmit\">rajnikmit</a>, <a href=\"https://profiles.wordpress.org/racase\">Rakesh Lawaju (Racase Lawaju)</a>, <a href=\"https://profiles.wordpress.org/ramay\">ramay</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/raulillana\">Raul Illana</a>, <a href=\"https://profiles.wordpress.org/renoirb\">renoirb</a>, <a href=\"https://profiles.wordpress.org/rhubbardreverb\">rhubbardreverb</a>, <a href=\"https://profiles.wordpress.org/rhyswynne\">Rhys Wynne</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rogerhub\">Roger Chen</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/wpmuguru\">Ron Rennick</a>, <a href=\"https://profiles.wordpress.org/ronalfy\">Ronald Huereca</a>, <a href=\"https://profiles.wordpress.org/kingkool68\">Russell Heimlich</a>, <a href=\"https://profiles.wordpress.org/ruudjoyo\">Ruud Laan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/markel\">Ryan Markel</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/zeo\">Safirul Alredha</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/salvoaranzulla\">salvoaranzulla</a>, <a href=\"https://profiles.wordpress.org/sammybeats\">Sam Brodie</a>, <a href=\"https://profiles.wordpress.org/sam2kb\">sam2kb</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/rosso99\">Sara Rosso</a>, <a href=\"https://profiles.wordpress.org/sarciszewski\">sarciszewski</a>, <a href=\"https://profiles.wordpress.org/sgrant\">Scott Grant</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/scottbrownconsulting\">scottbrownconsulting</a>, <a href=\"https://profiles.wordpress.org/greglone\">ScreenfeedFr</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/sdavis2702\">sdavis2702</a>, <a href=\"https://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/serpent7776\">serpent7776</a>, <a href=\"https://profiles.wordpress.org/several27\">several27</a>, <a href=\"https://profiles.wordpress.org/shimakyohsuke\">shimakyohsuke</a>, <a href=\"https://profiles.wordpress.org/shinichin\">Shinichi Nishikawa</a>, <a href=\"https://profiles.wordpress.org/side777\">side777</a>, <a href=\"https://profiles.wordpress.org/pross\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/sirzooro\">sirzooro</a>, <a href=\"https://profiles.wordpress.org/sjmur\">sjmur</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Spacedmonkey</a>, <a href=\"https://profiles.wordpress.org/sboisvert\">St&#233;phane Boisvert</a>, <a href=\"https://profiles.wordpress.org/khromov\">Stanislav Khromov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/stebbiv\">stebbiv</a>, <a href=\"https://profiles.wordpress.org/miglosh\">Stefan Froehlich</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevehenty\">stevehenty</a>, <a href=\"https://profiles.wordpress.org/stevehoneynz\">SteveHoneyNZ</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/charlestonsw\">Store Locator Plus</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Sujay</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/summerblue\">summerblue</a>, <a href=\"https://profiles.wordpress.org/sunnyratilal\">Sunny Ratilal</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tanner-m\">Tanner Moushey</a>, <a href=\"https://profiles.wordpress.org/tbcorr\">tbcorr</a>, <a href=\"https://profiles.wordpress.org/tychay\">Terry Chay</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/themiked\">theMikeD</a>, <a href=\"https://profiles.wordpress.org/kraftner\">Thomas Kr&#228;ftner</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tott\">Thorsten Ott</a>, <a href=\"https://profiles.wordpress.org/tigertech\">tigertech</a>, <a href=\"https://profiles.wordpress.org/tillkruess\">Till</a>, <a href=\"https://profiles.wordpress.org/tevko\">Tim Evko</a>, <a href=\"https://profiles.wordpress.org/tmatsuur\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tmeister\">tmeister</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/willmot\">Tom Willmot</a>, <a href=\"https://profiles.wordpress.org/tomharrigan\">TomHarrigan</a>, <a href=\"https://profiles.wordpress.org/tommarshall\">tommarshall</a>, <a href=\"https://profiles.wordpress.org/tomsommer\">tomsommer</a>, <a href=\"https://profiles.wordpress.org/skithund\">Toni Viemer&#246;</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/rilwis\">Tran Ngoc Tuan Anh</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/trenzterra\">trenzterra</a>, <a href=\"https://profiles.wordpress.org/tryon\">Tryon Eggleston</a>, <a href=\"https://profiles.wordpress.org/tszming\">tszming</a>, <a href=\"https://profiles.wordpress.org/junsuijin\">ty</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/chacha102\">Tyler Carter</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/sorich87\">Ulrich Sossou</a>, <a href=\"https://profiles.wordpress.org/umeshsingla\">Umesh Kumar</a>, <a href=\"https://profiles.wordpress.org/umeshnevase\">Umesh Nevase</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/vilkatis\">vilkatis</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/walterebert\">Walter Ebert</a>, <a href=\"https://profiles.wordpress.org/walterbarcelos\">walterbarcelos</a>, <a href=\"https://profiles.wordpress.org/webaware\">webaware</a>, <a href=\"https://profiles.wordpress.org/webdevmattcrom\">webdevmattcrom</a>, <a href=\"https://profiles.wordpress.org/wen-solutions\">WEN Solutions</a>, <a href=\"https://profiles.wordpress.org/wenthemes\">WEN Themes</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wmertens\">wmertens</a>, <a href=\"https://profiles.wordpress.org/wojtekszkutnik\">Wojtek Szkutnik</a>, <a href=\"https://profiles.wordpress.org/theode\">WP Plugin Dev dot com</a>, <a href=\"https://profiles.wordpress.org/wpdev101\">wpdev101</a>, <a href=\"https://profiles.wordpress.org/alphawolf\">wpseek</a>, <a href=\"https://profiles.wordpress.org/wturrell\">wturrell</a>, <a href=\"https://profiles.wordpress.org/yamchhetri\">Yam Chhetri</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/zrothauser\">Zack Rothauser</a>, and <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>.\n<p>&nbsp;</p>\n<p>Special thanks go to <a href=\"http://siobhanmckeown.com/\">Siobhan McKeown</a> for producing the release video with <a href=\"http://www.sararosso.com/newsletter/\">Sara Rosso</a>, and <a href=\"http://camikaos.com\">Cami Kaos</a> for the voice-over.</p>\n<p>Finally, thanks to all of the contributors who provided subtitles for the release video, which at last count had been translated into 23 languages!</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.5!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 18 Mar 2016 18:59:02 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 17 Mar 2016 04:30:25 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20150326220540\";}", "no");
INSERT INTO `wp_options` VALUES("33378", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1458370742", "no");
INSERT INTO `wp_options` VALUES("33379", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1458327542", "no");
INSERT INTO `wp_options` VALUES("33380", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1458370743", "no");
INSERT INTO `wp_options` VALUES("33381", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: Is W3C Replicating the WordPress Pingback System?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wptavern.com/is-w3c-replicating-the-wordpress-pingback-system\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6137:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/JamesRichmanProfile.png\" rel=\"attachment wp-att-52632\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/JamesRichmanProfile.png?resize=150%2C150\" alt=\"JamesRichmanProfile\" class=\"alignright size-thumbnail wp-image-52632\" /></a>This post was contributed by guest author <a href=\"http://1stwebdesigner.com/\" target=\"_blank\">James Richman</a>. James writes about marketing, digital design, entrepreneurship, and technology. He has gained most of his experience from running a variety of his own businesses for more than a decade.<br />\n&nbsp;</p>\n<hr />\n<p>On January 12, 2016, the W3C (the World Wide Web Consortium) released its first public working draft of <a href=\"https://www.w3.org/TR/2016/WD-webmention-20160112/\" target=\"_blank\">Webmentions</a>, but the announcement didn’t feel new. In fact, Webmentions have been around since IndieWebCamp created them in 2013, and <a href=\"https://www.toptal.com/wordpress\" target=\"_blank\">top WordPress developers</a> are already using a Webmentions plugin to utilize the tool.</p>\n<p>Yet, for those who use WordPress, Webmentions seemed like a retread of WordPress’ Pingback system from the early 2000s, which featured a similar concept.</p>\n<p>The Pingback system was invented in 2002 by Stuart Langridge, and in essence, it allowed pieces that were published on different WordPress sites to talk to each other. This is perhaps best explained by walking through an example scenario:</p>\n<ol>\n<li>Website A posts a new entry on its blog.</li>\n<li>Website B responds to that blog post with its own post and links to the post on Website A.</li>\n<li>The Pingback system then notifies Website A that Website B wrote about and linked to its blog post.</li>\n<li>Website A then verifies the content and link on Website B. If it is not spam, Website A will post a comment on the original blog post linking to Website B’s post.</li>\n</ol>\n<p>It’s important to note a few things about the Pingback system. First, it is exclusively for WordPress sites, and both sites have to enable Pingback for it to work. Second, the whole Pingback system is automated, streamlining the process of trackbacks, which is the manual equivalent of the automated Pingback.</p>\n<p>Yet despite its perks, <a href=\"http://wptavern.com/its-time-for-xml-rpc-in-wordpress-to-hit-the-road\" target=\"_blank\">Pingback system usage</a> declined after the automatic system was taken advantage of by spammers.</p>\n<p>The issue of spamming and abuse of such a communication channel has long been the problem with this type of communication channel. Prior to Pingbacks, WordPress used a Trackback system that provided the same type of communication.</p>\n<p>The only difference between the Trackback system and Pingbacks is that Trackbacks had to be inputted manually. Spamming problems were just as prevalent with trackbacks. In fact the WPTavern site <a href=\"http://wptavern.com/wptavern-was-trackbacked-to-death\" target=\"_blank\">shut down in 2010</a> because of trackback spam.</p>\n<p>So what makes Webmentions different than the Pingbacks and Trackbacks that came before? Well, not all that much. Turns out, Webmentions do the exact same thing as the Pingback system; they just do it better.</p>\n<p>The biggest difference between the two is the code they’re composed of. Pingback uses XMLRPC, an outdated approach that encodes data with XML and then transports that data with HTTP. The Pingback system is bulky and slow. Webmentions, on the other hand, uses HTTP and x-www-form-urlencoded content, a much more widely accepted format in today’s world. The result is that Webmentions is much faster and much easier to integrate.</p>\n<p>As Pingback’s creator Langridge <a href=\"http://www.kryogenix.org/days/2014/11/29/enabling-webmentions/\" target=\"_blank\">points out on his blog</a>, “XMLRPC is considerably less popular than it was, and is really heavyweight for this sort of thing. We’ve learned since then that HTTP can actually do all this stuff for us way more simply.” If you haven’t guessed, the Pingback founder has converted to Webmentions too.</p>\n<p>Webmention’s growing popularity is due to the tool’s ease of use and the fact that it blocks spam effectively with the <a href=\"http://indiewebcamp.com/Vouch\" target=\"_blank\">Vouch protocol</a>. But Webmentions also look better aesthetically in the comments section. Pingback comments look robotic and aren’t exactly readable; a Pingback comment contains the title of the post that sent the Pingback and an ellipsed summary that doesn’t make much sense.</p>\n<p>Webmentions look and feel like human comments with the help of the <a href=\"https://github.com/pfefferle/wordpress-semantic-linkbacks\" target=\"_blank\">Semantic Linkbacks plugin</a>. This plugin parses the Webmention linkback and translates it into a full sentence (e.g. ‘Sarah mentioned this post in her article x on site y’) and can even include the author’s profile picture.</p>\n<p>Webmentions are quickly replacing the Pingback system because of the tool’s convenience and better implementation to reach a similar goal, and this has been happening prior to W3C’s public endorsement. So what does W3C’s support of <a href=\"http://indiewebcamp.com/webmention\" target=\"_blank\">IndieWebCamp’s creation</a> mean?</p>\n<p>Ultimately, W3C’s announcement will likely help cement Webmention’s place on the internet. And so W3C’s recent push can be and should be considered as an effort to standardize the wild web.</p>\n<p>The internet was created to communicate and share information, yet individual pieces of content are unable to communicate with each other as easily as users can. The Pingback system was a worthy, but flawed, attempt to change that, and now Pingback’s legacy survives through the broader support and growing distribution of Webmention’s network. If Webmentions become more popular, maybe one day in the future, they will connect the strands of the web together, so that the web will have earned its namesake in truth.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 17:40:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: Cory Miller and Pippin Williamson Discuss the Importance of Mental Health on Office Hours Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52599\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"http://wptavern.com/cory-miller-and-pippin-williamson-discuss-the-importance-of-mental-health-on-office-hours-podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2006:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/heart.jpg\" rel=\"attachment wp-att-52604\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/heart.jpg?resize=1024%2C587\" alt=\"photo credit: rubryan\" class=\"size-full wp-image-52604\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/rubyran2626/2263837091/in/faves-57854010@N05/\">rubryan</a>\n<p>In the latest episode of <a href=\"http://officehours.fm/\" target=\"_blank\">Office Hours</a>, a WordPress business podcast, host Carrie Dils interviewed <a href=\"https://ithemes.com/\" target=\"_blank\">Cory Miller</a> and <a href=\"https://pippinsplugins.com/\" target=\"_blank\">Pippin Williamson</a> to discuss the importance of personal wellness. The episode is titled &#8220;<a href=\"http://officehours.fm/podcast/95-2/\" target=\"_blank\">Taking Care of Your Business Means Taking Care of Yourself</a>&#8221; and the video is now available on OfficeHours.fm.</p>\n<p>Both Miller and Williamson are successful WordPress entrepreneurs who have recently shared their experiences on maintaining mental health. In this interview Dils chats with the guests about stress and depression and how they can impact your business. They each share tips for how to recharge or &#8220;Go find your soul food,&#8221; as Williamson put it. The episode covers a broad range of topics that aren&#8217;t often discussed in the world of business:</p>\n<ul>\n<li>Extracting yourself from toxic relationships</li>\n<li>Fear of failure/ fear of not working</li>\n<li>Setting healthy boundaries</li>\n<li>Taking breaks</li>\n<li>Establishing a support team</li>\n<li>Transparency with peers</li>\n<li>Combatting negative thoughts</li>\n<li>Finding a mentor</li>\n</ul>\n<p>If you are experiencing the unique pressures of entrepreneurship or struggling with maintaining your mental health, check out the <a href=\"http://officehours.fm/podcast/95-2/\" target=\"_blank\">latest episode of Office Hours</a> for some practical tips.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 05:25:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPForms Aims to be the Most Beginner Friendly Forms Plugin for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52516\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/wpforms-aims-to-be-the-most-beginner-friendly-forms-plugin-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9192:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsFeaturedImage.png\" rel=\"attachment wp-att-52594\"><img class=\"aligncenter size-full wp-image-52594\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsFeaturedImage.png?resize=817%2C261\" alt=\"WPForms Featured Image\" /></a></p>\n<p><a href=\"https://wordpress.org/plugins/wpforms-lite/\">WPForms Lite</a> is a new plugin developed by <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> and <a href=\"https://profiles.wordpress.org/jaredatch/\">Jared Atchison</a> that aims to be the most beginner friendly form creation plugin in the market, &#8220;We made simple tasks EASY rather than letting the complex tasks define how hard simple will be,&#8221; Balkhi told the Tavern. I took the plugin for a test drive to see how easy it is to use.</p>\n<h2>A Great Introduction</h2>\n<p>Upon activation, a WPForms introduction screen is displayed. This screen provides information on how to create your first form and includes an embedded video explaining how. I had to watch the video a few times to follow along but overall it serves its purpose.</p>\n<p>If video is not your thing, consider walking through the <a href=\"https://wpforms.com/docs/creating-first-form/\">step by step guide</a> on the WPForms website. Those who want to jump right in can do so by clicking the <strong>WPForms &gt; Add New</strong> link.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsIntroductionScreen.png\" rel=\"attachment wp-att-52581\"><img class=\"size-full wp-image-52581\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsIntroductionScreen.png?resize=1025%2C675\" alt=\"WP Forms Introduction Screen\" /></a>WPForms Introduction Screen\n<h2>WPForm User Interface Forces You to Focus</h2>\n<p>One of the first things I noticed is the user interface and how it appears over WordPress. It was shocking at first to see WordPress disappear but the team chose to use this interface to avoid being constrained with WordPress&#8217; user interface. After working with WPForms for more than an hour, I found myself enjoying the fact that the interface forced me to focus on creating my form.</p>\n<p>WPForms ships with six different templates to handle the most common use cases. All templates except the Blank Form and the Simple Contact form require you to upgrade to the commercial version. I chose the simple contact form template.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormTemplates.png\" rel=\"attachment wp-att-52582\"><img class=\"size-full wp-image-52582\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormTemplates.png?resize=1025%2C559\" alt=\"WPForm Templates\" /></a>WPForm Templates\n<p>The simple contact form template automatically adds a name, email, paragraph, and submit fields to the form. An important time saver that sets WPForms apart from other plugins is that, the fields are automatically flagged as required.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSimpleContactFormTemplate.png\" rel=\"attachment wp-att-52583\"><img class=\"size-full wp-image-52583\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSimpleContactFormTemplate.png?resize=1025%2C605\" alt=\"WPForm Simple Contact Form Template\" /></a>WPForm Simple Contact Form Template\n<p>You can rearrange the fields by clicking and dragging them up or down. Rearranging fields is a breeze, doesn&#8217;t require a page refresh, and doesn&#8217;t bog down the browser. When clicking on a field, its properties are displayed on the left where you can configure its label, format, description, and whether or not its required.</p>\n<p>Advanced options enable you to determine a field&#8217;s size, placeholder text, default values, and whether to hide the label or sub-labels. Switching between screens and configuring fields is a fast, straightforward process.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormFieldOptions.png\" rel=\"attachment wp-att-52584\"><img class=\"size-full wp-image-52584\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormFieldOptions.png?resize=1025%2C671\" alt=\"WPForm Field Options\" /></a>WPForm Field Options\n<p>Once the fields are configured, you&#8217;ll want to click the Settings screen. This is where you can configure what happens when a visitor clicks the submit button. You can enable or disable email notifications and use smart tags to configure the form&#8217;s output. This version of WPForms Lite doesn&#8217;t have email templates but Balkhi says it&#8217;s something the team is working on.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSmartTags.png\" rel=\"attachment wp-att-52585\"><img class=\"size-full wp-image-52585\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSmartTags.png?resize=1025%2C489\" alt=\"WPForm Smart Tags\" /></a>WPForm Smart Tags\n<p>Here is what the form&#8217;s output looks like in Thunderbird. Personally, I like Jetpack&#8217;s formatting style more but this could change once WPForms supports email templates.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormOutput.png\" rel=\"attachment wp-att-52586\"><img class=\"size-full wp-image-52586\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormOutput.png?resize=836%2C367\" alt=\"WPForm Output\" /></a>WPForms Output\n<p>As a comparison, this is what Jetpack&#8217;s Contact Form module output looks like in Thunderbird. The text looks better and I appreciate the bold field names.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/JetpacksFormOutput.png\" rel=\"attachment wp-att-52588\"><img class=\"size-full wp-image-52588\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/JetpacksFormOutput.png?resize=809%2C310\" alt=\"Jetpack Contact Form Output\" /></a>Jetpack Contact Form Module Output\n<p>WPForms battles spam using two different methods, honeypot and <a href=\"https://wpforms.com/docs/setup-captcha-wpforms/\">reCAPTCHA.</a> reCAPTCHA is a free,  <a href=\"https://www.google.com/recaptcha/intro/index.html\">anti-spam service</a> provided by Google. In order to use it with WPForms, you&#8217;ll need to sign up for an account and add your site key and secret key to WPForm&#8217;s settings page.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsSettingsPage.png\" rel=\"attachment wp-att-52590\"><img class=\"size-full wp-image-52590\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsSettingsPage.png?resize=1025%2C420\" alt=\"WPForms Settings Page\" /></a>WPForms Settings Page\n<p>Once a form is configured and saved, adding it to a page is easy. Simply create a new page in WordPress and in the editor, click the Add Form button. A modal will pop up giving you the option to choose which form to add to the page. You can also choose whether to show the form&#8217;s title and description from this box. When a form is added to the page, WPForms puts a shortcode like [ wpforms id=&#8221;50582&#8243; ] into the content area.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormInsertUI.png\" rel=\"attachment wp-att-52592\"><img class=\"size-full wp-image-52592\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormInsertUI.png?resize=498%2C219\" alt=\"UI For Inserting a WPForm into a Page\" /></a>UI For Inserting a WPForm into a Page\n<p>I configured WPForms to not apply styling to my form. However, you can choose whether WPForms applies base and form theme styling or base styling only. You&#8217;ll want to experiment with these options to see if your form looks any better with styles applied.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsTavernContactForm.png\" rel=\"attachment wp-att-52593\"><img class=\"size-full wp-image-52593\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsTavernContactForm.png?resize=696%2C881\" alt=\"WPForms Contact Form on The Tavern Frontend\" /></a>WPForms Contact Form on The Tavern Frontend\n<h2>My Verdict?</h2>\n<p>You should know that outside of creating simple contact forms and what&#8217;s available via the standard fields, almost everything else requires you to upgrade to the commercial version, including the ability to store and view form entries in WordPress. However, the plugin doesn&#8217;t nag or annoy you with popups that a commercial version is available. Upgrade prompts are only triggered when trying to access a commercial feature.</p>\n<p>After putting WPForms Lite through its paces, it&#8217;s definitely one of the easiest and fastest ways to set up a contact form. It&#8217;s clear by using the supplied templates that Balkhi and his team have considered common pitfalls and have done a great job eliminating them.</p>\n<p>I haven&#8217;t looked into the contact form space in WordPress for a few years but after testing WPForms, I&#8217;m motivated to compare some of the most popular plugins in the space to see how each one tackles the user experience. Expect a detailed roundup in the next few weeks.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 02:05:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"WPTavern: Stack Overflow Survey Results Show WordPress is Trending Up, Despite Being Ranked Among Most Dreaded Technologies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52540\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"http://wptavern.com/stack-overflow-survey-results-show-wordpress-is-trending-up-despite-being-ranked-among-most-dreaded-technologies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7217:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/stack-overflow-developer-survey-2016.png\" rel=\"attachment wp-att-52554\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/stack-overflow-developer-survey-2016.png?resize=1025%2C462\" alt=\"stack-overflow-developer-survey-2016\" class=\"aligncenter size-full wp-image-52554\" /></a></p>\n<p>Stack Overflow published the results of its <a href=\"https://stackoverflow.com/research/developer-survey-2016\" target=\"_blank\">2016 Developer Survey</a>, summarizing responses from 56,033 developers in 173 countries. The 45-question survey collected answers from more than twice as many developers as the previous year.</p>\n<p>The results were published along with a disclaimer recognizing that the survey is &#8220;biased against devs who don&#8217;t speak English, or who don&#8217;t like taking English-language surveys.&#8221; Nevertheless, since the survey captured responses from such a large number of developers on a site that receives 40 million visitors per month, the results are definitely worth a read.</p>\n<p>The average age of developers surveyed was 29.6 years old and 92.8% of the respondents were male. Most of them are at least partially self-taught (69%) with 45% of them having acquired degrees in computer science or a related field.</p>\n<p>A quick developer profile of those surveyed shows that the largest section (28%) is made up of those who identify as a full-stack web developer.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/developer-profile.png\" rel=\"attachment wp-att-52557\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/developer-profile.png?resize=1025%2C490\" alt=\"developer-profile\" class=\"aligncenter size-full wp-image-52557\" /></a></p>\n<h3>Developers Value Diversity</h3>\n<p>Despite the fact that the vast majority of the respondents were male, the results indicate that developers value diversity. In summarizing 42,156 responses, Stack Overflow found the following:</p>\n<blockquote><p>Overall, about 73% of developers tell us they think diversity is at least somewhat important in the workplace. 41% of developers say diversity is very important. And developers who most often influence hiring decisions are more likely to believe in the value of diversity than other developer types.</p></blockquote>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/diversity.png\" rel=\"attachment wp-att-52544\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/diversity.png?resize=1025%2C481\" alt=\"diversity\" class=\"aligncenter size-full wp-image-52544\" /></a></p>\n<h3>Visual Basic and WordPress Top the List for Most Dreaded Technologies</h3>\n<p>WordPress moved up one spot from last year in the ranking of <a href=\"https://stackoverflow.com/research/developer-survey-2016#technology-most-loved-dreaded-and-wanted\" target=\"_blank\">most dreaded technologies</a> that respondents would prefer not to use. This is not surprising given that the most popular tags for posts on Stack Overflow are JavaScript, Java, Android, and Python.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/most-dreaded.png\" rel=\"attachment wp-att-52546\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/most-dreaded.png?resize=1025%2C634\" alt=\"most-dreaded\" class=\"aligncenter size-full wp-image-52546\" /></a></p>\n<p>On the other hand, when surveying the <a href=\"https://stackoverflow.com/research/developer-survey-2016#most-popular-technologies-per-occupation\" target=\"_blank\">most popular technologies per developer type</a>, WordPress is currently used by 24.1% of front-end developers. As a side note, this also corresponds roughly to its current <a href=\"http://w3techs.com/technologies/history_overview/content_management/all\" target=\"_blank\">market share</a> (26%).</p>\n<h3>WordPress and JavaScript Technologies Are Trending Up</h3>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/trending-technologies.png\" rel=\"attachment wp-att-52548\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/trending-technologies.png?resize=1025%2C842\" alt=\"trending-technologies\" class=\"aligncenter size-full wp-image-52548\" /></a></p>\n<p>Newer technologies like React, Node.js, and AngularJS are trending, with the above percentages representing the change in share of Stack Overflow votes between January 2015 and January 2016. All three are also among the <a href=\"https://stackoverflow.com/research/developer-survey-2016#technology-top-paying-tech\" target=\"_blank\">top-paying technologies</a> per occupation for both full stack and front-end developers.</p>\n<p>It&#8217;s worth noting that all of these trending technologies are also becoming more readily integrated with WordPress, and will be more widely used when the REST API is finally merged with core.</p>\n<p>Despite the fact that WordPress ranks second in the most dreaded technology category, it is also trending up 18.5% from 2015. According to these results, WordPress&#8217; popularity is increasing at a rate similar to that of many JavaScript-based technologies.</p>\n<h3>Job Title and Remote Work Are Important Priorities for Experienced Developers</h3>\n<p>The 2016 results found that 91% of developers surveyed worldwide are “gainfully employed” (full-time, self-employed, or freelance). Developers are in high demand, with just 15% of respondents actively looking for a job. It&#8217;s also interesting to note that 78% of developers surveyed are interested in exploring new employment opportunities.</p>\n<p>If you&#8217;re trying to hire a developer, one of the most important things to consider is that they highly prioritize being able to work remotely. Responses from 49,521 developers indicate that as they gain more years of experience, both job title and remote work options are increasing priorities.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/priorities.png\" rel=\"attachment wp-att-52549\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/priorities.png?resize=1025%2C675\" alt=\"priorities\" class=\"aligncenter size-full wp-image-52549\" /></a></p>\n<p>Only 30% of developers currently work remotely part-time or full-time, but Stack Overflow found that remote developers are more likely to love their jobs than other developers. If you own a company that hires developers, chances are that you will attract a larger, more experienced pool of applicants if employees are allowed to work remotely.</p>\n<p>Developers who want to get a better understanding of the broader industry&#8217;s work challenges, salary expectations, and most popular technologies will want to review the full <a href=\"https://stackoverflow.com/research/developer-survey-2016\" target=\"_blank\">results of the survey</a>.</p>\n<p>The document includes some important feedback for the WordPress community to consider. Although WordPress is among the technologies that are trending up, the broader development community still does not seem to enjoy working with it. How can we make the software more developer-friendly without compromising user friendliness?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 21:57:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WPTavern: WPWeekly Episode 226 – Burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=52552&preview_id=52552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wptavern.com/wpweekly-episode-226-burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2888:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I discuss the symptoms of burnout and share tips on how to prevent it. We provide a status update on WordPress 4.5 and discuss my experience hooking up a site to Apple News Publisher. To round out the show, Marcus shares his experience using Shopify&#8217;s new WordPress plugin.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/when-contributing-to-wordpress-full-time-leads-to-burnout\">When Contributing to WordPress Full-Time Leads to Burnout</a><br />\n<a href=\"http://wptavern.com/wordpress-global-translation-day-set-for-april-24-2016\">WordPress Global Translation Day Set for April 24, 2016</a><br />\n<a href=\"http://wptavern.com/tickets-for-wordcamp-jacksonville-2016-now-on-sale\">Tickets for WordCamp Jacksonville 2016 Now on Sale</a><br />\n<a href=\"http://wptavern.com/how-to-connect-your-wordpress-powered-site-to-apple-news-publisher\">How to Connect Your WordPress Powered Site to Apple News Publisher</a><br />\n<a href=\"http://wptavern.com/shopify-launches-official-plugin-for-wordpress\">Shopify Launches Official Plugin for WordPress</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/shopify-ecommerce-shopping-cart/\">Shopify</a> is an eCommerce plugin for WordPress that makes selling products on your site simple. In just a few clicks, you can create a Buy Button that lets visitors securely checkout from any page on your site.</p>\n<p><a href=\"https://wordpress.org/plugins/woomaxmin/\">WooMaxMin for WooCommerce </a>gives you the ability to set up minimum and maximum purchase limits for your customers.</p>\n<p><a href=\"https://wordpress.org/plugins/lifterlms-wpmktgengine-extension/\">LifterLMS &#8211; WPMKTGENGINE Extension </a>allows you to automatically track all of the participation within a LifterLMS installation from your WPMktgEngine customer database. You can use this information to incorporate their participation with courses and memberships along with other activity information to target messages, create new products that will hit the mark, and build tighter and trusting relationships with customers.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, March 23rd 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #226:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 21:05:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Saving the Open Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46383\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://ma.tt/2016/03/saving-the-open-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"<p><a href=\"http://buytaert.net/can-we-save-the-open-web\">Dries Buytaert asks &#8220;Can we save the open web?&#8221;</a> and makes an amazing case for why we should. I agree with and endorse basically everything in that post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 14:39:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: Fight for the Future Launches “Save Security” Campaign in Support of Apple\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52486\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/fight-for-the-future-launches-save-security-campaign-in-support-of-apple\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3063:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/save-security.png\" rel=\"attachment wp-att-52525\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/save-security.png?resize=1025%2C456\" alt=\"save-security\" class=\"aligncenter size-full wp-image-52525\" /></a></p>\n<p><a href=\"https://www.fightforthefuture.org/\" target=\"_blank\">Fight for the Future</a>, a non-profit organization that works to preserve freedom of expression on the web, launched its new &#8220;<a href=\"https://savesecurity.org/\" target=\"_blank\">Save Security</a>&#8221; campaign today in support of Apple. The FBI has requested that the company hack into an iPhone recovered from one of the terrorists involved in the <a href=\"https://en.wikipedia.org/wiki/2015_San_Bernardino_attack\" target=\"_blank\">San Bernardino mass shooting</a> to assist in the criminal investigation.</p>\n<p>Apple has refused numerous court orders to create a new tool that would allow the government to circumvent the iPhone&#8217;s security measures that protect the encrypted communications of private individuals. The company will go to court on March 22nd for hearing in Riverside, CA. Fight for the Future plans to display thousands of statements in support of Apple from Internet users outside the courthouse.</p>\n<p>The Save Security campaign website summarized what is at stake with the government forcing Apple to weaken its encryption:</p>\n<blockquote><p>In its attacks on Apple, the FBI is seeking a legal precedent that would let them force any company to weaken the security of its products. Engineers use consumer products like the iPhone to maintain the most sensitive systems on the planet. Hospitals. Air traffic control. Nuclear power. What the FBI is asking for puts lives at risk, by undermining security everywhere.</p></blockquote>\n<p>Two weeks ago, Automattic <a href=\"https://transparency.automattic.com/2016/03/03/automattic-and-wordpress-com-stand-with-apple-to-support-digital-security/\" target=\"_blank\">announced</a> that it stands with Apple to support digital security. The company <a href=\"https://cloudup.com/iZG9vzAV3U3\" target=\"_blank\">filed an amicus brief</a> in support of Apple alongside Cloudflare, Ebay, Kickstarter, Twitter, GitHub, Reddit, Square, and other leading technology companies.</p>\n<p>&#8220;The fact is that if a security flaw exists, there is no way to ensure that only trusted governments, investigating a crime, can exploit that vulnerability,&#8221; Automattic&#8217;s attorney Paul Sieminski said in the announcement. &#8220;Improving security for everyone means aggressively finding and closing holes, not creating new ones.&#8221;</p>\n<p>If you want to join in Fight for the Future&#8217;s campaign to support Apple, the <a href=\"https://savesecurity.org/\" target=\"_blank\">SaveSecurity.org</a> website offers a profile picture you can use as well as a website banner (see <a href=\"https://savesecurity.org/?ALWAYS_SHOW_SC_BANNER=true\" target=\"_blank\">live demo</a>) to raise awareness.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Mar 2016 22:56:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: How to Connect Your WordPress Powered Site to Apple News Publisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52502\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/how-to-connect-your-wordpress-powered-site-to-apple-news-publisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5623:\"<p>When Apple News Publisher <a href=\"http://www.apple.com/pr/library/2015/06/08Apple-Announces-News-App-for-iPhone-iPad.html\">launched in September, 2015</a>, it partnered with 20 publishers including, ESPN, The New York Times, and CNN. Today, publishers large and small are able to <a href=\"https://icloud.com/newspublisher\">sign up</a> to Apple&#8217;s <a href=\"https://developer.apple.com/news-publisher/\">News Publisher program</a> which delivers content from sites to devices running iOS 9 or above. Since its launch, the service has garnered more than <a href=\"http://9to5mac.com/2015/10/27/apple-news-40-million/\">40 million users</a>.</p>\n<p>Aside from its user base, one of the main benefits to syndicating through News Publisher is that content is optimized across all of Apple&#8217;s iOS 9 devices, providing a better user experience as opposed to RSS readers that can render content unpredictably.</p>\n<h2>Configuring Sites for News Publisher</h2>\n<p>There are three options for publishers to push content to the service. You can use the content creation screen inside of News Publisher, connect an existing site using a plugin, or submit the URL to your site&#8217;s RSS feed.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/NewsPublisherContentAuthoring.png\" rel=\"attachment wp-att-52504\"><img class=\"size-full wp-image-52504\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/NewsPublisherContentAuthoring.png?resize=1025%2C544\" alt=\"News Publisher Content Creation Screen\" /></a>News Publisher Content Creation Screen\n<p>I submitted the Tavern to News Publisher a few weeks ago and received a notification today that the site is approved. When submitting your site, you&#8217;ll need to give Apple your contact phone number and physical address. You&#8217;ll also need to upload a PNG logo that&#8217;s transparent, less than 2MB in size, and meets <a href=\"https://help.apple.com/newspublisher/icloud/#/apd7c9ae979c\">Apple&#8217;s logo guidelines</a>.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/PublisherSubmissionProcess2.png\" rel=\"attachment wp-att-52506\"><img class=\"size-full wp-image-52506\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/PublisherSubmissionProcess2.png?resize=837%2C652\" alt=\"News Publisher Submission Process\" /></a>News Publisher Submission Process\n<p>If you use WordPress and your site is approved, consider using the <a href=\"https://wordpress.org/plugins/publish-to-apple-news/\">Publish to Apple News</a> plugin developed by <a href=\"http://www.alleyinteractive.com/\">Alley Interactive</a> and other contributing developers. Once installed, visit your channel&#8217;s administration page in News Publisher and click on the API Key link. This will give you the three things needed to connect your site.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/ChannelAPIInfo.png\" rel=\"attachment wp-att-52507\"><img class=\"size-full wp-image-52507\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/ChannelAPIInfo.png?resize=693%2C536\" alt=\"Channel API Information\" /></a>Channel API Information\n<p>Login to your WordPress site and visit <strong>Settings &gt; Apple News</strong> and insert the following information into the corresponding fields. Since the field names and order don&#8217;t match, I created this short list.</p>\n<ul>\n<li>Channel ID &gt; API Channel</li>\n<li>Key ID &gt; API Key</li>\n<li>Secret &gt; API Secret</li>\n</ul>\n<p>From the settings screen, you can configure if the plugin should publish and update articles to Apple News automatically and whether to do it at the same time as WordPress in one action. You can also choose which Post Types are available. At the bottom of the screen, there are a host of design options that enable you to alter the display of how your articles look in Apple News.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/NewsPublisherOptionsPage.png\" rel=\"attachment wp-att-52508\"><img class=\"size-full wp-image-52508\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/NewsPublisherOptionsPage.png?resize=757%2C835\" alt=\"News Publisher Plugin Options Page\" /></a>News Publisher Plugin Options Page\n<p>I don&#8217;t know what the Tavern&#8217;s content looks like on News Publisher as I wait for the initial series of posts to be approved. For the time being, the content is styled with the default settings.</p>\n<h3>Monetizing Your Feed</h3>\n<p>To monetize your News Publisher feed, enable iTunes connect with your developer ID. If you don&#8217;t have one, you&#8217;ll need to enroll in <a href=\"https://developer.apple.com/programs/enroll/\">Apple&#8217;s Developer Program </a>Once that&#8217;s complete, sign the Apple News Content Agreement and provide your tax and banking information on iTunes Connect. Note, that in order to <a href=\"https://help.apple.com/newspublisher/icloud/#/apdd44eeeeeb\">place ads</a> in your content, you need to publish articles from a CMS like WordPress.</p>\n<h2>Is News Publisher Worth the Hassle?</h2>\n<p>As a new publisher to Apple&#8217;s syndication system, it&#8217;s too early to tell if signing up was a waste of time or a benefit to readers. In the next week or two, I&#8217;ll report my findings, including feedback from Tavern readers on what they think of the format. Until then, you can subscribe to our channel by <a href=\"https://apple.news/TQYQeeBHDRce_JL3U0PCWGw\">opening this link</a> on a device that uses iOS 9 or later. If you subscribe to the Tavern, tell us about your experience in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Mar 2016 20:46:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Matt: Kat Hagan Works Differently\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46347\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://ma.tt/2016/03/kat-hagan-works-differently/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"<p><span class=\"embed-youtube\"></span></p>\n<p>&nbsp;</p>\n<p><a href=\"http://workdifferent.com/wdstories-kat-hagan-automatic/\">Kat Hagan is an engineer and a team lead at Automattic, and you can read all about her story that led her there</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Mar 2016 18:51:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Dyad: A Beautiful Free WordPress Theme for Photographers and Foodies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52207\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/dyad-a-beautiful-free-wordpress-theme-for-photographers-and-foodies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2976:\"<p><a href=\"https://wordpress.org/themes/dyad/\" target=\"_blank\">Dyad</a> is the latest free theme release from the folks at Automattic. It was designed to suit creative websites, with written content and photographs receiving equal treatment.</p>\n<p>The theme is actually a fork of <a href=\"https://wordpress.org/themes/receptar/\" target=\"_blank\">Receptar</a>, a theme by <a href=\"http://www.webmandesign.eu/\" target=\"_blank\">WebMan Design</a>. The original split-screen, book-like design for single posts was created to look like a modern cook book.</p>\n<p>Automattic designers added a featured content slider to the homepage along with a sticky top navigation menu, among other changes. The featured tag can be set in the customizer. If you don&#8217;t want to use the slider, the theme will default to displaying the custom header image (which is set by adding a featured image to the page assigned as the static homepage).</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/dyad-screenshot.png\" rel=\"attachment wp-att-52479\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/dyad-screenshot.png?resize=660%2C683\" alt=\"dyad-screenshot\" class=\"aligncenter size-full wp-image-52479\" /></a></p>\n<p>The homepage sports a grid layout for posts with featured images and excerpts side-by-side. Single posts display the featured image and title at 50% of of the screen with the content on the other half. The layout responds nicely for mobile devices.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/dyad-single-post-responsive.png\" rel=\"attachment wp-att-52495\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/dyad-single-post-responsive.png?resize=660%2C391\" alt=\"dyad-single-post-responsive\" class=\"aligncenter size-full wp-image-52495\" /></a></p>\n<p>Dyad includes one expandable widget area in the footer. Any widgets dropped into this area will expand to fit one, two, three, or four columns. The footer also includes space for a social links menu with icons available for 26 different social accounts.</p>\n<p>Check out a <a href=\"https://dyaddemo.wordpress.com/\" target=\"_blank\">live demo</a> of Dyad on WordPress.com to see the theme in action.</p>\n<p>One consideration for using the theme is that you will always need to have large-sized feature images readily available to maintain the design. The optimal size is 1800px x 1280px. This shouldn&#8217;t be a problem for photography, cooking, portfolio, or other image-heavy sites. However, if your content is more text-oriented with a few scattered images, you may want to select a different theme.</p>\n<p><a href=\"https://wordpress.org/themes/dyad/\" target=\"_blank\">Dyad</a> is Automattic&#8217;s 87th free theme release on WordPress.org. Full documentation for setting it up is available on the theme&#8217;s WordPress.com <a href=\"https://wordpress.com/themes/dyad/\" target=\"_blank\">homepage</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Mar 2016 17:47:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: White House Seeks Feedback on GitHub for Government-Wide Open Source Software Policy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52437\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/white-house-seeks-feedback-on-github-for-government-wide-open-source-software-policy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3710:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/white-house.jpg\" rel=\"attachment wp-att-52474\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/white-house.jpg?resize=1024%2C520\" alt=\"photo credit: The White House Washington DC - (license)\" class=\"size-full wp-image-52474\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/71380981@N06/19902559769\">The White House Washington DC</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-nd/2.0/\">(license)</a>\n<p>The White House is <a href=\"https://sourcecode.cio.gov/\" target=\"_blank\">calling for developers to comment</a> on its proposed draft for a Government-wide Open Source Software policy. In the request for public comment, the <a href=\"https://www.whitehouse.gov/omb/\" target=\"_blank\">White House Office of Management and Budget (OMB)</a> outlined two major goals for the new policy:</p>\n<blockquote><p>This policy requires that, among other things: (1) new custom code whose development is paid for by the Federal Government be made available for reuse across Federal agencies; and (2) a portion of that new custom code be released to the public as Open Source Software (OSS).</p></blockquote>\n<p>The pilot program proposed in the draft policy would require &#8220;covered agencies to release at least 20 percent of their newly-developed custom code, in addition to the release of all custom code developed by Federal employees at covered agencies as part of their official duties.&#8221;</p>\n<p>Specifically, the government is asking for feedback on a list of considerations regarding releasing custom code as open source. A few examples include the following:</p>\n<ul>\n<li>To what extent is the proposed pilot an effective means to fuel innovation, lower costs, benefit the public, and meet the operational and mission needs of covered agencies?</li>\n<li>Would a different minimum percentage be more or less effective in achieving the goals above?</li>\n<li>To what extent could this policy have an effect on the software development market? For example, could such a policy increase or decrease competition among vendors, dollar amounts bid on Federal contracts, or total life-cycle cost to the Federal Government?</li>\n<li>What opportunities and challenges exist in Government-wide adoption of an open source policy?</li>\n</ul>\n<p>Encouraging developers to produce reusable code to be shared across federal agencies could significantly lower development costs and improve government efficiency. It could also promote transparency of the code quality produced by vendors and employees.</p>\n<p>After the embarrassing <a href=\"http://nymag.com/daily/intelligencer/2013/10/silicon-valley-reacts-to-healthcaregov.html\" target=\"_blank\">debacle of Healthcare.gov</a>, which cost taxpayers hundreds of millions of dollars, it&#8217;s good to see government embracing open source in an expanded capacity.</p>\n<h3>How to Contribute</h3>\n<p>You can join the conversation by participating in discussions on the <a href=\"https://github.com/whitehouse/source-code-policy/issues\" target=\"_blank\">source code policy GitHub issues</a> or by logging a new issue. The White House even welcomes changes and line edits to the policy content via <a href=\"https://github.com/whitehouse/source-code-policy/edit/gh-pages/pages/index.md\" target=\"_blank\">pull requests</a>.</p>\n<p>Anyone can <a href=\"https://github.com/WhiteHouse/source-code-policy\" target=\"_blank\">contribute on GitHub</a> to help shape the federal source code policy until April 11, 2016. At that time public contributions will be closed and the White House will analyze feedback while creating the final policy.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Mar 2016 22:54:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Shopify Launches Official Plugin for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52450\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wptavern.com/shopify-launches-official-plugin-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2620:\"<p>Shopify <a href=\"https://www.shopify.com/blog/113145925-introducing-shopify-for-wordpress\" target=\"_blank\">announced</a> today that the company is jumping into the WordPress market with a new official plugin and three WordPress themes. The Canadian company captures just <a href=\"https://wappalyzer.com/categories/ecommerce\" target=\"_blank\">8% of the e-commerce technology market share</a>, trailing WooCommerce (31%), Magento (19%), OpenCart (11%), Prestashop (10%), and others (13%).</p>\n<p>The new <a href=\"https://github.com/Shopify/buy-button-wordpress\" target=\"_blank\">Shopify Buy Button</a> plugin is intended for users who already have a business set up on WordPress and are only looking to sell a few products with a buy button, as opposed to a full-fledged store. It allows users to sell products that have already been added to their Shopify stores and requires a $9/month Shopify Lite subscription.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/shopify-wp.gif\" rel=\"attachment wp-att-52463\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/shopify-wp.gif?resize=975%2C549\" alt=\"shopify-wp\" class=\"aligncenter size-full wp-image-52463\" /></a></p>\n<p>Shopify partnered with Themezilla, Themify, and Ultralinx to build Shopify-powered WordPress themes. The themes are only free to download for a limited time, which leaves users without updates unless they purchase the theme from the commercial provider.</p>\n<p>The corresponding plugin is currently hosted on GitHub but is in the process of being reviewed for WordPress.org, according to product representative Daniel Patricio.</p>\n<p>&#8220;Many users have already been using it through the themes for a couple weeks now so we just wanted to get it out there to the rest of our users,&#8221; Patricio said. &#8220;We are in the review cycle to get it listed and should be up shortly where people will be able to get updates as we add features.&#8221;</p>\n<p>It is not advisable to use or install the plugin until it is hosted on WordPress.org, as Shopify currently has no way to deliver security updates to users. It is unclear why the company chose to officially launch its new WordPress integration without updates in mind, but this is a major concern. If a vulnerability were discovered, the company has no straightforward way to alert people who have downloaded the plugin from GitHub.</p>\n<p>When asked for an ETA for the plugin&#8217;s arrival on WordPress.org, Patricio said, &#8220;We don&#8217;t have a timeline yet but will be getting it up there soon.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Mar 2016 19:23:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Matt: What’s in My Bag, 2016 edition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46172\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://ma.tt/2016/03/whats-in-my-bag-2016-edition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12982:\"<p>Many people have been requesting an update to <a href=\"https://ma.tt/2015/01/whats-in-my-bag-2014/\">my what&#8217;s in my bag post from last year</a>. Almost every single item in the bag has changed, this year has had particularly high turnover. We&#8217;re <a href=\"https://ma.tt/2015/05/macbook-usb-c-review/\">still in a weird teenage period of USB-C adoption</a>, and I hope by next year to have many fewer non-USB-C or Lightning cables. Things with a asterisk * are the same from last year. Without further ado:</p>\n<p><a href=\"http://i0.wp.com/ma.tt/files/2016/02/DSC_1387.jpg?ssl=1\"><img class=\"aligncenter size-full wp-image-46178\" src=\"http://i0.wp.com/ma.tt/files/2016/02/DSC_1387.jpg?w=604&ssl=1\" alt=\"\" /></a></p>\n<ol>\n<li><a href=\"http://shop.lululemon.com/products/clothes-accessories/men-bags/Mens-Cruiser-Backpack\">This is my favorite item of the new year, a Lululemon Cruiser backpack</a> that has a million pockets both inside and outside, and allows me to carry more stuff, more comfortably, and access it faster. Lululemon updates their products and designs every few months, but if you ever spot something like this online or in the store check it out. Hat tip on this one to <a href=\"http://roseinmidair.com/\">Rose</a>.</li>\n<li><a href=\"http://www.amazon.com/gp/product/B00TX5YUCM\">A short Lightning + micro USB cable</a>, which is great for pairing with a battery pack. I sometimes carry a few of these around and give them away all the time, as &#8220;do you have a light?&#8221; has evolved to &#8220;do you have a charge?&#8221; in the new millenium.</li>\n<li><a href=\"http://www.amazon.com/gp/product/B012V56D2A\">Short regular USB to USB-C cable</a>.</li>\n<li><a href=\"http://www.amazon.com/gp/product/B000BX47X2\">Belkin Retractable Ethernet</a>. *</li>\n<li>Anker <a href=\"http://www.amazon.com/gp/product/B0119OI9XU\">USB-C to USB-C cable</a>. Make sure to read the reviews when you buy these to get the ones that do the proper voltage. I can charge a Macbook with this, and the new Nexus 5x, directly from the battery pack or the #43 wall charger.</li>\n<li><a href=\"http://www.amazon.com/gp/product/B000CDFYNS\">Mini-USB cable</a>, which I use for the odd older device (like a Nikon camera) that still does mini-USB (that older big one). Would love to get rid of this one.</li>\n<li>A charge cable for #45, the Fitbit Charge HR. <a href=\"http://www.amazon.com/gp/product/B0142A96G2\">You can buy these cheap on Amazon</a>, and if you lose it you&#8217;re out of luck, so I usually keep a few at home and one in my bag.</li>\n<li><a href=\"http://www.apple.com/shop/product/ME291AM/A/lightning-to-usb-cable\">This is my goldilocks regular lightning cable, not too long and not too short</a>, 0.5m.</li>\n<li>A retractable micro-USB.</li>\n<li><a href=\"http://www.apple.com/shop/product/MLA02LL/A/magic-mouse-2\">Apple Magic Mouse 2</a>, the new one that charges via Lightning, natch.</li>\n<li>Way over to the right, <a href=\"http://www.muji.us/store/stationery/notebooks.html\">a small Muji notebook</a>.</li>\n<li>This is a weird but cool cable, <a href=\"http://www.amazon.com/gp/product/B00T7BK9PY\">basically bridges USB to Norelco shavers</a>. I use a Norelco beard trimmer and for some reason all of these companies think we want to carry around proprietary chargers, this is a slightly unwieldy cable but better than carrying around the big Norelco power brick.</li>\n<li>Lockpick set. *</li>\n<li><a href=\"https://www.honest.com/bath-and-body/honest-organic-lip-balm-trio\">Lavender mint organic lip balm from Honest Co</a>, which I think I got for free somewhere.</li>\n<li><a href=\"http://www.aesop.com/usa/skin-care/lip/rosehip-seed-lip-cream.html\">Aesop rosehip seed lip cream</a>, which I bought mostly for the smell, when it&#8217;s done I&#8217;ll probably switch to <a href=\"http://www.aesop.com/usa/skin-care/lip/avail-lip-balm.html\">their lip balm</a>. (I should do a cosmetics version of this for my dopp kit, it&#8217;s had lots of trial and error as well.) I love Aesop, especially t<a href=\"http://www.aesop.com/usa/body-care/cleanse/resurrection-aromatique-hand-wash-4.html\">heir Resurrection line</a>.</li>\n<li><a href=\"http://www.amazon.com/Aveda-Blue-Oil-0-24-oz/dp/B0031KN9UE\">Aveda Blue Oil</a> that I find relaxing. *</li>\n<li><a href=\"http://www.amazon.com/Apple-Thunderbolt-Cable-0-5-Meter-MD862LL/dp/B00WVDGZM6/\">Short thunderbolt to thunderbolt cable</a>, which is great for transferring between computers. *</li>\n<li>Muji international power adapter, much simpler, lighter, and cooler than what I used before.</li>\n<li>Way on the top right, this is probably the least-travel-friendly thing I travel with, but the utility is so great I put up with it. It&#8217;s the <a href=\"http://www.amazon.com/gp/product/B00D4LBOV6\">Sennheiser Culture Series Wideband Headset</a>, which I use for podcasts, Skype, Facetime, Zoom, and Google Hangout calls with external folks and teams inside of Automattic. Light, comfortable, great sound quality, and great at blocking out background noise so you don&#8217;t annoy other people on the call. Worth the hassle.</li>\n<li>A customized Macbook Pro 15&#8243;, in space grey, with the WordPress logo that shines through.</li>\n<li><a href=\"http://www.amazon.com/Belkin-Car-Vent-Mount-Smartphones/dp/B00O5JARCI/\">Belkin car mount</a>, which is great for rentals. *</li>\n<li>A <a href=\"http://www.amazon.com/gp/product/B00X8Z47XA\">USB 3.0 SD / CompactFlash / etc reader</a>.</li>\n<li>microSD to SD adapter, with a 64gb micro SD in it. Good for cameras, phones, and occasionally transferring files. Can be paired with the card reader if the computer has a USB port but not a SD reader. <a href=\"http://www.amazon.com/dp/B010Q588D4/\">When you get a microSD card it usually comes with this</a>.</li>\n<li>One of my new favorite things: <a href=\"http://www.dxo.com/us/dxo-one\">DxO One camera</a>. It&#8217;s a SLR-quality camera that plugs in directly to the lightning port on your iPhone, and can store the photos directly on your phone. Photo quality is surprisingly good, the only problem I&#8217;ve had with it is the lightning port pop-up will no longer close. The other similar device I tried but wasn&#8217;t as good was the <a href=\"http://www.getolympus.com/us/en/air-a01.html\">Olympus Air A01</a>, so I just carry around the DxO now.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B007PTCFFW/\">TP-LINK TL-WR702N Wireless N150 Travel Router</a>, which works so-so. Not sure why I still carry this, haven&#8217;t used it in a while. *</li>\n<li><a href=\"http://www.amazon.com/gp/product/B018TGGH4E\">Aukey car 49.5W 3-port USB adapter</a>, which has two high-powered USB ports and a Quick Charge 3.0 USB-C port.</li>\n<li>My favorite external battery right now, the <a href=\"http://www.amazon.com/gp/product/B019IFIJW8\">RAVPower 20100mAh Portable Charger</a>, also with Quick Charge 3.0 and a USB-C port. This thing is a beast, can charge a USB-C Macbook too.</li>\n<li><a href=\"http://www.amazon.com/High-Resolution-Display-Adaptive-PagePress-Sensors/dp/B00IOY8XWQ\">Kindle Voyage</a> with the <a href=\"http://www.amazon.com/Limited-Edition-Premium-Leather-Origami/dp/B00NO84J0W\">brown leather cover</a>. *</li>\n<li>Macbook power adapter.</li>\n<li>Very cool <a href=\"http://en-us.sennheiser.com/momentum-wireless-headphones-with-mic\">Sennheiser Momentum Wireless</a> headphones in ivory,customized with the WordPress logo. I&#8217;m testing this out as a possible gift for <a href=\"https://automattic.com/\">Automatticians</a> when they reach a certain number of years at the company. For a fuller review, <a href=\"https://ma.tt/2015/04/best-headphones-spring-2015-edition/\">see this post</a>.</li>\n<li><a href=\"https://www.cotopaxi.com/products/waterbottle-white?variant=8128462529\">Cotopaxi water bottle</a> that I got for free at the <a href=\"https://sas.summit.co/\">Summit at Sea conference</a>. The backpack has a handy area to carry a water bottle, and I&#8217;ve become a guy who refills water bottles at the airport instead of always buying disposable ones.</li>\n<li>Special cord for the #30 Momentum headphones.</li>\n<li><a href=\"http://www.amazon.com/dp/B004C51HRY/\">Retractable 1/8th inch audio cable</a>. *</li>\n<li><a href=\"http://www.amazon.com/dp/B00IYA2ZJW/\">Powerbeats 2 Wireless headphones</a> that I use for running, working out, or just going around the city.</li>\n<li><a href=\"http://www.amazon.com/gp/product/B00E9W11QM\">Belkin headphone splitter</a>, for sharing audio when watching a movie on a plane. *</li>\n<li><a href=\"https://www.google.com/chromecast/speakers/\">Chromecast audio</a>, which I&#8217;ve never used but it&#8217;s so small and light I carry it around just in case.</li>\n<li><a href=\"https://www.google.com/chromecast/tv/\">Chromecast TV</a>, which I&#8217;ve also never used but also small and light and I&#8217;m sure it&#8217;ll come in handy one of these days.</li>\n<li>Verizon iPhone 6s+, which is normal, but the new thing here is I&#8217;ve stopped carrying a wallet, and a separate phone case, and now carry this big &#8216;ol <a href=\"http://www.amazon.com/gp/product/B00VGDQRAW\">Sena Heritage Wallet Book</a>. At first I felt utterly ridiculous doing this as it feels GINORMOUS at first, but after it wore in a little bit, and I got used to it, it&#8217;s so freeing to only have one thing to keep track of, and it&#8217;s also forced me to carry a lot less than I used to in my wallet.</li>\n<li>Maison Bonnet sunglasses. Hat tip to <a href=\"https://about.me/tonyconrad\">Tony</a>.</li>\n<li>Stickers! <a href=\"http://wapuu.jp/\">Wapuu</a> and <a href=\"https://slack.com/\">Slack</a>.</li>\n<li><a href=\"http://www.amazon.com/Blinks-Ultralight-Comfortable-Contoured-Blindfold/dp/B000WNX21Y/\">Bucky eye shades</a>, like an eye mask but has a curve so it doesn’t touch your eyes. I don’t use this often but when I do it’s a life-saver. *</li>\n<li>My favorite USB wall plug, after trying dozens, is this <a href=\"https://www.amazon.com/gp/product/B00UWMCXD8/\">Aukey 30W / 6A travel wall charger</a>. I love the foldable plug, and it&#8217;s really fast.</li>\n<li>I generally only have one wall charger, but temporarily carrying around this <a href=\"http://www.amazon.com/gp/product/B019C23ZGW\">Tronsmart 33W USB-C + USB charger with Quick Charge 3.0</a>, which can very quickly charge the battery or the Nexus, and a Macbook in a pinch. Hopefully will combine this and #42 sometime this year. One thing I really dislike about this item is the bright light on it, which I need to cover with tape.</li>\n<li>The only pill / vitamin / anything I take every day: <a href=\"http://www.elysiumhealth.com/\">Elysium Health Basis</a>. I&#8217;m not an expert or a doctor, but read up on them and the research around it, pretty interesting stuff.</li>\n<li><a href=\"https://www.fitbit.com/chargehr\">Fitbit Charge HR</a>. I gave up on my Apple Watch. I&#8217;ll probably try the Fitbit watch when it comes out. My favorite feature is the sleep tracking. Least favorite is the retro screen, and that it doesn&#8217;t always show the time.</li>\n<li><a href=\"http://www.amazon.com/Sharpie-Permanent-Markers-Marker-32101PP/dp/B000XANH9S\">Double-sided sharpie (thick and thin point)</a> and a <a href=\"http://www.muji.us/store/pen-pencils.html\">Muji pen</a>.</li>\n<li><a href=\"http://www.westoneaudio.com/index.php/products/hearing-protection/es49-custom-hearing-protection.html\">Westone ES49 custom earplugs</a>, for if I go to concerts or anyplace overly loud. *</li>\n<li>Some index cards, good for brainstorming.</li>\n<li>Passport. * As Mia Farrow said about Frank Sinatra, &#8220;I learned to bring my passport to dinner.&#8221;</li>\n<li>Jetpack notebook, I like to have a paper notebook to take notes, especially in group or product meetings, because there isn&#8217;t the distraction of a screen.</li>\n<li><a href=\"https://www.google.com/nexus/5x/\">Nexus 5x</a>, which is definitely one of the better Android devices I&#8217;ve had, paired with <a href=\"https://fi.google.com/\">Google Project Fi</a> phone / data service, which has saved me thousands of dollars with its $10/gb overseas data pricing. Since my iPhone is so huge, I tried to go for a smaller Android device. I always travel with both in case something happens to one phone, for network diversity, and as I said this has better international data pricing than Verizon.</li>\n<li>Business card holder. *</li>\n<li>Post-it notes.</li>\n</ol>\n<p>All in all 13 items stayed the same, the other 40 are new to this edition.</p>\n<p><a href=\"http://i0.wp.com/ma.tt/files/2016/02/DSC_1387.jpg?ssl=1\"><img class=\"aligncenter size-full wp-image-46178\" src=\"http://i0.wp.com/ma.tt/files/2016/02/DSC_1387.jpg?w=604&ssl=1\" alt=\"\" /></a></p>\n<p>That&#8217;s a wrap, folks! If you have any questions or suggestions please drop them in the comments. Once my <a href=\"https://ma.tt/2016/02/lent-this-year-buying-things/\">no-buying-things moratorium for Lent</a> is over I can start trying new things out again.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Mar 2016 17:24:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: Tickets for WordCamp Jacksonville 2016 Now on Sale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52421\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://wptavern.com/tickets-for-wordcamp-jacksonville-2016-now-on-sale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2514:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/wordcamp-jacksonville.png\" rel=\"attachment wp-att-52424\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/wordcamp-jacksonville.png?resize=1025%2C502\" alt=\"wordcamp-jacksonville\" class=\"aligncenter size-full wp-image-52424\" /></a></p>\n<p>Florida hosts some of the most successful and longest-running WordCamps in the US with events in Miami, Orlando, and Tampa Bay. Jacksonville, the largest city in Florida with a population of more than 800,000, will be hosting its very first WordCamp. The event will be held April 16-17 downtown at the <a href=\"https://2016.jacksonville.wordcamp.org/location/\" target=\"_blank\">Florida State College</a> campus.</p>\n<p>According to <a href=\"http://frankcorso.me/\" target=\"_blank\">Frank Corso</a>, lead organizer for the WordCamp and an organizer of the Gainesville WordPress Meetup, the team is planning for 250 attendees. The WordPress community in northern Florida is working together to make the event happen.</p>\n<p>&#8220;One of the co-organizers is the organizer of the local WPjax meet-up group and another organizer is the organizer of another city&#8217;s WP meetup group,&#8221; Corso said. &#8220;A few of us started talking at WordCamp Miami 2015 and realized that we really wanted to have a local WordCamp in our area. So, we reached out some others in the Jacksonville area to see if there was enough demand for it. We received a large amount of support for it and decided to proceed.&#8221;</p>\n<p>Last week the event&#8217;s organizers introduced the <a href=\"https://2016.jacksonville.wordcamp.org/2016/03/11/introducing-the-first-round-of-speakers/\" target=\"_blank\">first round of speakers</a>, which includes local tech entrepreneurs and WordPress community leaders from around Florida. The deadline for speaker applications has passed, but organizers are still looking for <a href=\"https://2016.jacksonville.wordcamp.org/2016/03/03/call-for-volunteers/\" target=\"_blank\">volunteers</a> and <a href=\"https://2016.jacksonville.wordcamp.org/2016/01/04/call-for-sponsors/\" target=\"_blank\">sponsors</a>.</p>\n<p>WordCamp Jacksonville <a href=\"https://2016.jacksonville.wordcamp.org/tickets/\" target=\"_blank\">tickets</a> went on sale today, but there are only 250 available due to venue capacity. Follow <a href=\"https://twitter.com/WordCampJax\" target=\"_blank\">@WordCampJax</a> and the #wcjax hashtag on Twitter for all the latest news.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Mar 2016 22:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: When Contributing to WordPress Full-Time Leads to Burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52409\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/when-contributing-to-wordpress-full-time-leads-to-burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4014:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/BurnoutFeaturedImage.png\" rel=\"attachment wp-att-52418\"><img class=\"size-full wp-image-52418\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/BurnoutFeaturedImage.png?resize=657%2C333\" alt=\"Burnout Featured Image\" /></a><a href=\"http://www.flickr.com/photos/12480780@N05/24053903526\">Fireplace 4</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-nd/2.0/\">(license)</a>\n<p>As a distributed worker, one of the toughest obstacles I face is burnout. It&#8217;s one of the reasons I took a month off from all things WordPress. According to <a href=\"http://www.merriam-webster.com/dictionary/burnout\">Merriam-Webster</a>, burnout is, &#8220;the condition of someone who has become very physically and emotionally tired after doing a difficult job for a long time.&#8221; Once burnout sets in, it&#8217;s tough to recover without avoiding the job completely.</p>\n<p>Drew Jaynes, WordPress core developer, describes how contributing to the WordPress project full-time <a href=\"http://werdswords.com/contributing-full-time-isnt-everyone/\">led to burnout</a>.</p>\n<p>&#8220;Here’s the thing: burnout is a real struggle. And when you’re working on something full-bore, 100 percent of the time, and you burnout, there aren’t a lot of good options to help combat that except to keep pressing on and try to get your groove back,&#8221; Jaynes said.</p>\n<p>Recognizing the signs that burnout is imminent is an important step towards avoiding it, &#8220;I typically realize I’m burned out when I basically lose interest in whatever thing I’d been previously passionate about. Burnout is the result of going at something too hard for too long. And then when you stop, getting started again is a struggle,&#8221; he said.</p>\n<p>Jaynes realized it was time to move on from full-time contributing to something new after experiencing burnout three times in seven months. Although he will continue to contribute back to WordPress, it will be in a more limited role as he focuses on products.</p>\n<h2>How Matt Mullenweg Avoids Burnout</h2>\n<p>People combat burnout differently based on their individual circumstances. When asked <a href=\"https://www.producthunt.com/live/matt-mullenweg#comment-151645\">how he combats burnout</a> in an <a href=\"http://wptavern.com/highlights-from-matt-mullenwegs-qa-session-on-product-hunt\">Ask Me Anything segment</a> in September 2015, Matt Mullenweg, CEO of Automattic, responded:</p>\n<blockquote><p>Everything is connected, so if one of ( health | diet | relationships | family | work | soul | creative outlet ) is running on empty for too long, it will impact the others and you might end up treating the symptom rather than the cause. Recovery always comes from the people around you who give you unconditional love and support, which I&#8217;ve been lucky to have since I was an infant.</p>\n<p>To avoid it now I try to take small mini-breaks frequently, be that a ten minute meditation every day, jogging a few times a week, or taking a few days to recharge once a month. I find that&#8217;s better (and less stressful) than trying to do a big blow-out reset or vacation once a year. Conversely, a lot of times when people think I&#8217;m on vacation I&#8217;m actually working as much or more than when I&#8217;m at home, just from a more interesting location (often with fewer distractions). Funnily enough I&#8217;m more likely to actually take time off and unplug at home, and more likely to be working when in an exotic location.</p></blockquote>\n<p>I work for a company that has an unlimited vacation policy. I took advantage of it by taking a month off to clear my mind to help me refocus and it worked wonders for my mental well-being. If you feel it&#8217;s necessary and your employer has a similar policy, don&#8217;t be afraid to ask for some time off to regroup. What do you do to combat burnout? Please share your advice in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Mar 2016 22:05:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: Addicted to Distraction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46355\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://ma.tt/2016/03/addicted-to-distraction/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:665:\"<blockquote><p>Addiction is the relentless pull to a substance or an activity that becomes so compulsive it ultimately interferes with everyday life. By that definition, nearly everyone I know is addicted in some measure to the Internet. It has arguably replaced work itself as our most socially sanctioned addiction. [&#8230;]</p>\n<p>Denial is any addict’s first defense. No obstacle to recovery is greater than the infinite capacity to rationalize our compulsive behaviors.</p></blockquote>\n<p>Oldie but goodie <a href=\"http://www.nytimes.com/2015/11/29/opinion/sunday/addicted-to-distraction.html?_r=2\">from the New York Times, Addicted to Distraction</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Mar 2016 18:57:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WordPress Global Translation Day Set for April 24, 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/wordpress-global-translation-day-set-for-april-24-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4941:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/08/globe.jpg\" rel=\"attachment wp-att-29134\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/08/globe.jpg?resize=1024%2C499\" alt=\"photo credit: . Entrer dans le rêve - cc\" class=\"size-full wp-image-29134\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/tranbina/4765484383/\">. Entrer dans le rêve</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>The WordPress Polyglots team is planning its first ever <a href=\"https://make.wordpress.org/polyglots/2016/03/02/wordpress-global-translation-day-april-24th-2016/\" target=\"_blank\">Global Translation Day</a> to be held April 24, 2016, in every timezone around the globe. The 24-hour translation sprint will start at dawn in the East and end in the West. In addition to translating strings, organizers are also looking to grow the translation teams and educate new translators. They have identified the following three goals for the event:</p>\n<ul>\n<li>Show people who are interested in translating WordPress in their language how to get involved</li>\n<li>Translate and validate the waiting strings for current projects under the supervision of the current General translation editors</li>\n<li>Add more general translation editors to different translation teams</li>\n</ul>\n<p>The Global Translation Day is an ambitious undertaking that involves coordinating a 24-hour live stream of tutorials about translating WordPress in different languages, as well as local, on-site contributor teams.</p>\n<p>&#8220;Not very many people know how big the translation efforts around WordPress are, how dedicated our volunteer Translation Editors are to making sure we have quality, consistent software translations,&#8221; Polyglots contributor Petya Raykovska said. &#8220;We wanted the Global Translation Day to shed a bit of light on that and especially on the local teams.</p>\n<h3>Growing the WordPress Platform by Making it More Internationally Accessible</h3>\n<p>The Polyglots team is slowly chipping away at the world&#8217;s most widely spoken languages to provide core, theme, and plugin translations for users in their own languages.</p>\n<p>&#8220;We have many languages that need a lot of help,&#8221; Raykovska said. &#8220;Our Japanese, German, French, Dutch, Spanish, Portuguese teams are amazing, these are active 100% translated locales,&#8221; she said. &#8220;But when it comes to plugin and theme translations, that’s where the demand is greatest.</p>\n<p>&#8220;On the other hand, we have languages that need help for WordPress core. All the Indian languages can use a huge push, our African and Asian languages need help.&#8221;</p>\n<p>The progress of each locale is tracked on the <a href=\"https://make.wordpress.org/polyglots/teams/\" target=\"_blank\">Translation Teams</a> page, displaying the percentage of strings translated for each.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/translations.png\" rel=\"attachment wp-att-52391\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/translations.png?resize=1025%2C395\" alt=\"translations\" class=\"aligncenter size-full wp-image-52391\" /></a></p>\n<p>&#8220;Some of the biggest languages in the world are represented in this chart and if we got them to 100% that could have a huge impact on WordPress itself,&#8221; Raykovska said.</p>\n<p>&#8220;If you remember the big jump WordPress did in 2011 and then in 2014, when international downloads surpassed English downloads, half of those international downloads were for Japanese,&#8221; she said.</p>\n<p>&#8220;Now imagine what impact languages like Chinese, Hindi (and other Indian languages) and other languages in countries where English is not a default language, can have. The Global WordPress Translation day is about making WordPress accessible to more people and also about helping the platform’s growth,&#8221; Raykovska said.</p>\n<p>The Polyglots are calling all multilingual contributors to join in the event. Raykovska reports that so far they have more than 60 teams committing to take part, with 10 mini-contributor days held locally and more incoming. The Polyglots are also planning to host remote events where local teams use their own Slack channels to onboard contributors and work on translations.</p>\n<p>Contributors can choose from a number of ways to get involved. You can record a video in your language for the promotion clip, volunteer to do a live stream talk about translating WordPress into your language, organize a local contributor day, or get involved with the main organization.</p>\n<p>If you have the language skills to participate in the translation sprint, it&#8217;s one of the easiest ways to start contributing to WordPress and help prepare the platform for its next major international leap. Join #polyglots on Slack to connect with the team.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Mar 2016 18:11:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Changelog Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46350\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2016/03/changelog-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:575:\"<p>I know a lot of people are on their way to SxSW right now, <a href=\"https://changelog.com/197/\">here&#8217;s a podcast I joined called The Changelog you can download and check out on the way there</a> (or back). It&#8217;s a bit more technical than the interviews I normally do, we talk about Javascript, Calypso, the philosophy of open source and WordPress, some of the thinking behind Automattic&#8217;s acquisitions, and my favorite programming books. I hope <a href=\"https://changelog.com/197/\">you can check it out</a>, Adam and Jerod did a great job on this one.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 12 Mar 2016 02:17:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: In Case You Missed It – Issue 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=52368&preview_id=52368\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wptavern.com/in-case-you-missed-it-issue-4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6892:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png\" rel=\"attachment wp-att-50955\"><img class=\"size-full wp-image-50955\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?resize=676%2C292\" alt=\"In Case You Missed It Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There&#8217;s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn&#8217;t make it into a full post.</p>\n<h2>Justin Tadlock Announces Simpler Pricing</h2>\n<p>Justin Tadlock <a href=\"http://themehybrid.com/weblog/simpler-pricing-for-theme-designer-and-plugin-developer\">revamped his pricing</a> model for his <a href=\"http://themehybrid.com/plugins/plugin-developer\">Plugin Developer</a> and <a href=\"http://themehybrid.com/plugins/theme-designer\">Theme Designer</a> plugins. Based on two months of feedback, Tadlock removed the pricing tiers in favor of a single price. Both plugins are $90 and come with source files, one year of support, and access to the Theme Hybrid Slack channel.</p>\n<p>Existing customers have already been upgraded and can take advantage of the new perks. What&#8217;s nice is that Tadlock is giving those who purchased the plugins for $125 a partial refund of $35 to make up the difference.</p>\n<h2>Using WordPress to Break The Silence</h2>\n<p>Mahangu Weerasinghe, who works at Automattic as a Happiness Engineer, <a href=\"http://heropress.com/essays/breaking-the-silence/\">published a fantastic essay</a> on HeroPress this week that describes how WordPress helped him break his silence. Weerasinghe suffers from stuttering and as a result, remained silent even if he had something to say. It&#8217;s an inspirational story and the best content I&#8217;ve read all week. There are many quotable spots in the post, but this is my favorite.</p>\n<blockquote><p>There are a lot of things we cannot control in this world, many forces at work that we cannot even see. But, as members of this community, I think we can content ourselves with this thought:</p>\n<p>Because of the GPL, and the way it works, WordPress will be available as a publishing platform for decades to come, and long after the next social network comes and goes, for as long as the Internet remains free and accessible, anyone with WordPress will be able to have their say.</p>\n<p>What WordPress did for me, it can do for others. And that’s why we need to keep going.</p>\n<p>Because every silence can be overcome.</p></blockquote>\n<p>Congrats Weerasinghe on defeating the silence and helping others to do the same.</p>\n<h2>Automattic Acquires Pressable</h2>\n<p>Automattic has purchased the rest of Vid Luther&#8217;s common stock shares in Pressable and has effectively <a href=\"https://poststatus.com/automattic-pressable/\">acquired the company</a>. Chris Lauzon, a Happiness Engineer at Automattic, is the company&#8217;s interim CEO. Be sure to read Matt Mulleweng&#8217;s statement which clearly indicates to me that the company is not part of Automattic&#8217;s long-term interests.</p>\n<h2>Matt Mullenweg in The Irish Times</h2>\n<p>Ciara O&#8217;Brien <a href=\"http://www.irishtimes.com/business/technology/matt-mullenweg-how-wordpress-got-the-whole-world-blogging-1.2558828\">interviewed Matt Mullenweg</a> when he visited Dublin, Ireland to speak at an Irish Software Association event. It&#8217;s one of the better interviews I&#8217;ve read in recent memory and if you know Matt well enough, you can tell which parts of the interview he showed his sense of humor.</p>\n<p>For example, when asked how he relaxes and switches off work mode, he responds &#8220;Well, this is lovely. We have tea and little cookies.” I can almost guarantee you that he chuckled while making that remark.</p>\n<h2>Introvert Reviews Pressnomics</h2>\n<p>Jeff Matson, who leads the documentation efforts for Rocketgenius, <a href=\"http://jeffmatson.net/realization-of-progress-and-success/\">documented</a> (pun intended) his experience at Pressnomics 4. Thanks to his involvement in the community the past few years, people recognized him and started conversations with him instead of the other way around.</p>\n<blockquote><p>I’m the nerd with the thick glasses, overgrown beard, and a hoodie; the guy who lives in a rather small apartment, drives a Kia, and shops at outlet malls. To put it simply, I’m your typical every-day middle-class 20-something guy. Certainly not the typically targeted clientele for such a high level business-centric conference.</p></blockquote>\n<p>Yet, he had a great time and strengthened relationships and created new ones with members of the community. As a friend, it&#8217;s great to see Jeff make large strides both in his professional and personal life.</p>\n<h2>Co-Organizing WordCamp Miami</h2>\n<p>David Bisset <a href=\"http://davidbisset.com/wordcamp-miami-2016-the-mega-review/\">shares his experience</a> co-organizing one of the largest WordCamps in the US. According to a recent tweet, the team is already making plans for WordCamp Miami, FL 2017.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">One of the reasons <a href=\"https://twitter.com/hashtag/wcmia?src=hash\">#wcmia</a> organization team is so great: post-conference planning meetups. 2017 planning has begun. <a href=\"https://t.co/NZF31TRNOj\">pic.twitter.com/NZF31TRNOj</a></p>\n<p>&mdash; David Bisset (@dimensionmedia) <a href=\"https://twitter.com/dimensionmedia/status/708282526477979650\">March 11, 2016</a></p></blockquote>\n<p></p>\n<h2>Wapuu of the North!</h2>\n<p>As a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project. St. Patrick&#8217;s day is right around the corner, so what better way to celebrate than with a Wapuu with Irish roots. Meet, The Wapuu of the North.</p>\n<p>The Wapuu of the North was created by Peter of <a href=\"http://1440design.com/wordpress/branding-wordcamp-belfast/\" target=\"_blank\">1440 Design</a> for WordCamp Belfast, Ireland. This particular Wapuu has quite the head of hair!</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/belfast_wapuu.jpg\" rel=\"attachment wp-att-52005\"><img class=\"aligncenter size-full wp-image-52005\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/belfast_wapuu.jpg?resize=1000%2C1000\" alt=\"belfast_wapuu\" /></a></p>\n<p>That&#8217;s it for issue four. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 12 Mar 2016 01:24:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: OnePress: A Free Single-Page WordPress Theme Built with Bootstrap 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51305\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/onepress-a-free-single-page-wordpress-theme-built-with-bootstrap-4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3001:\"<p>If you&#8217;re a fan of the scrolling single-page parallax style themes, <a href=\"https://wordpress.org/themes/onepress/\" target=\"_blank\">OnePress</a> is a new one on WordPress.org that may pique your interest. After less than a month in the official directory, it has already been installed on more than 3,000 websites. OnePress was developed by the folks at <a href=\"https://www.famethemes.com/themes/onepress/\" target=\"_blank\">FameThemes</a> using <a href=\"http://v4-alpha.getbootstrap.com/\" target=\"_blank\">Bootstrap version 4</a>. It is suitable for business, portfolio, and agency websites.</p>\n<p>The theme features a full-screen background image with action buttons in the first major section. Scrolling further down reveals an about section, services, a video lightbox, an animated counter, team section, latest news, and contact form (powered by Contact Form 7).</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/onepress.png\" rel=\"attachment wp-att-52246\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/onepress.png?resize=1025%2C769\" alt=\"onepress\" class=\"aligncenter size-full wp-image-52246\" /></a></p>\n<p>All of the sections can be easily configured in the customizer and each has design options such as overlay color and opacity, section titles and subtitles, number of columns, and more. You can elect to hide any of the sections that you don&#8217;t want to use.</p>\n<p>Also, if you&#8217;re not a fan of the parallax animations, there are options to disable them per element or globally for all the animations in the theme. You can also disable the sticky header when scrolling.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/onepress-customizer.png\" rel=\"attachment wp-att-52356\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/onepress-customizer.png?resize=1025%2C374\" alt=\"onepress-customizer\" class=\"aligncenter size-full wp-image-52356\" /></a></p>\n<p>OnePress includes controls in the customizer for setting social profiles in the footer. It also includes a setting for pasting in a MailChimp Action URL for a newsletter signup form.</p>\n<p>Check out a <a href=\"http://www.famethemes.com/preview/?theme=OnePress\" target=\"_blank\">live demo</a> of OnePress and click the menu items or scroll to view all of the sections. You can also toggle through desktop, tablet, and mobile views. Its smooth responsiveness and mobile-friendly menu are powered by Bootstrap.</p>\n<p>OnePress is an excellent example of how a single-page WordPress theme can be easily configurable via WordPress&#8217; native customizer. It is available for <a href=\"https://wordpress.org/themes/onepress/\" target=\"_blank\">download from WordPress.org</a> or via your admin theme browser. The OnePress homepage on FameThemes has thorough <a href=\"http://docs.famethemes.com/article/43-onepress-documentation\" target=\"_blank\">documentation</a> for setting up each of the sections.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Mar 2016 22:10:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: WordPress 4.5 Improves Comment Moderation Screens\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52295\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/wordpress-4-5-improves-comment-moderation-screens\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6151:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/08/comments.png\" rel=\"attachment wp-att-28128\"><img class=\"aligncenter size-full wp-image-28128\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/08/comments.png?resize=984%2C455\" alt=\"comments\" /></a>Building on the momentum generated from the <a href=\"https://make.wordpress.org/core/2015/10/28/comment-object-and-query-features-in-4-4/\">WordPress 4.4 development cycle</a>, WordPress 4.5 includes a number of enhancements to comments. In a <a href=\"https://make.wordpress.org/core/2016/03/09/comment-changes-in-wordpress-4-5/\">post on the Make Core blog</a>, Rachel Baker explains the changes and what to expect.</p>\n<p>&#8220;WordPress 4.5 includes several ancient bug fixes and a few enhancements in the Comments component. We have <a href=\"https://core.trac.wordpress.org/query?status=closed&component=Comments&milestone=4.5&group=resolution&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">closed 25 tickets</a>,&#8221; Baker said.</p>\n<p>The biggest change users will notice are the design improvements to the comment moderation screen when clicking one of the available links in a comment moderation email. Instead of appearing as a large block of plain-text, comments are formatted as long as they contain the following HTML elements.</p>\n<ul>\n<li>A &#8211; Links</li>\n<li>Abbr &#8211; Abbreviations</li>\n<li>Acronym &#8211; Defines an acronym</li>\n<li>B &#8211; Bold</li>\n<li>Blockquote &#8211; Specifies a section that is quoted from another source</li>\n<li>Cite &#8211; Defines the title of a work</li>\n<li>Code &#8211; Defines a piece of computer code</li>\n<li>Del &#8211; Defines text that has been deleted from a document</li>\n<li>Em &#8211; Emphasizes text</li>\n<li>I &#8211; Italicize</li>\n<li>Q &#8211; Defines a short quotation</li>\n<li>S &#8211; Specifies text that is no longer correct</li>\n<li>Strike &#8211; Defines strikethrough text</li>\n<li>Strong &#8211; Defines important text</li>\n</ul>\n<p>During testing, I noticed that in some cases, the text still appears in a large block as if the paragraph tag is ignored. I&#8217;ve already reported this issue to Baker who is looking into it. As you can see, the text that is bold, blockquoted, linked, and italicized, maintains its formatting on the moderation screen.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/CommentFormattingOnModerationScreen.png\" rel=\"attachment wp-att-52346\"><img class=\"size-full wp-image-52346\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/CommentFormattingOnModerationScreen.png?resize=1025%2C571\" alt=\"Formatted Text On The Comment Moderation Screen\" /></a>Formatted Text On The Comment Moderation Screen\n<p>In addition to visual enhancements, an Edit Comment link was added to the bottom of the comment. In the future, it would be nice to edit a comment in place during the moderation flow, similar to how Quick Edit works, instead of navigating to a different screen. Other notable changes include:</p>\n<ul>\n<li>Updated message styles that match other screens.</li>\n<li>The comment date is only wrapped in a link if the comment permalink exists.</li>\n<li><code>#wpbody-content</code> is appended to comment moderation email links for accessibility.</li>\n<li>The <code>rel=nofollow</code> attribute and value pair will no longer be added to relative or same domain links within <code>comment_content</code>.</li>\n<li><code>WP_Comment_Query</code> now supports the <code>author_url</code> parameter.</li>\n<li>The new <code>pre_wp_update_comment_count_now</code> filter allows you to bail out of updating the comment count for a given Post.</li>\n</ul>\n<h2>Maximum Comment Field Length</h2>\n<p>Those who publish lengthy comments will be happy to know that in WordPress 4.5, &#8220;the comment fields will enforce the maximum length of each field’s respective database column with hardcoded attributes. The hardcoded limits can be adjusted to accommodate custom database schemas using the <code>comment_form_default_fields</code> filter,&#8221; Baker said. By default, the limits are as follows:</p>\n<ul>\n<li>Comment: 65525 characters</li>\n<li>Name : 245 characters</li>\n<li>Email: 100 characters</li>\n<li>Url: 200 characters</li>\n</ul>\n<p>When comments are submitted in 4.5, they&#8217;ll be checked by the new <code>wp_get_comment_fields_max_lengths()</code> function and the <code>wp_get_comment_fields_max_lengths</code> filter. If a value is more than the limit, a <code>WP_Error</code> is displayed. If a user publishes a comment and sees an error page, they&#8217;ll be able to navigate back to their comment via a link rather than having to use their browser&#8217;s back button.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/CommentErrorNavigation.png\" rel=\"attachment wp-att-52347\"><img class=\"size-full wp-image-52347\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/CommentErrorNavigation.png?resize=724%2C354\" alt=\"Comment Error Page Navigation\" /></a>Comment Error Page Navigation\n<p>It&#8217;s great that comments continue to receive attention, even if there&#8217;s a long way to go. Unfortunately, the ability to <a href=\"https://core.trac.wordpress.org/ticket/33717\">send a notification email when a comment is approved from moderation</a> was punted to a future release. I&#8217;m looking forward to reviewing plugins that allow users to easily configure the comment length limits as seen above. It would be nice to configure the limits so spammers see an error message because of their comment&#8217;s length rather than being placed into the moderation queue.</p>\n<p>To see and test these improvements yourself, download and install <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">WordPress beta 3</a> on a test site. If you think you’ve discovered a bug, please create a new post on the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> of the support forums. What do you think of these changes to comments in WordPress 4.5?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Mar 2016 20:07:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: GitHub Now Supports Emoji Reactions for Pull Requests, Issues, and Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52304\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/github-now-supports-emoji-reactions-for-pull-requests-issues-and-comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3903:\"<p>Last month GitHub finally <a href=\"http://wptavern.com/github-responds-to-letter-from-open-source-project-maintainers\" target=\"_blank\">responded</a> to the <a href=\"http://wptavern.com/open-source-project-maintainers-confront-github-with-open-letter-on-issue-management\" target=\"_blank\">open letter on issue management</a> that has now been <a href=\"https://docs.google.com/spreadsheets/d/1oGsg02jS-PnlIMJ3OlWIOEmhtG-udTwuDz_vsQPBHKs/htmlview?usp=sharing&sle=true\" target=\"_blank\">signed</a> by nearly 2,000 open source project maintainers. GitHub officially apologized for the lack of communication and promised to add new features and iterate on the core experience.</p>\n<p>Shortly after acknowledging the letter, GitHub <a href=\"http://wptavern.com/github-introduces-issue-and-pull-request-templates\" target=\"_blank\">introduced templates for issues and pull requests</a>, which allow project maintainers to guide contributors towards submitting more meaningful contributions.</p>\n<p>One of the other major requests included in the open letter was a voting system to declutter +1&#8217;s from issues. While the +1&#8217;s constitute valuable feedback, maintainers need a better UI to help make these conversations easier to read.</p>\n<p>GitHub has now answered this request by <a href=\"https://github.com/blog/2119-pull-request-and-issue-reactions\" target=\"_blank\">adding emoji reactions to pull requests, issues, and comments</a>. Emoji support is nothing new but organizing it into reactions helps keep comments more manageable:</p>\n<blockquote><p>In many cases, especially on popular projects, the result is a long thread full of emoji and not much content, which makes it difficult to have a discussion. With reactions, you can now reduce the noise in these threads.</p></blockquote>\n<p>Reactions are currently limited to six emoji that are commonly used in GitHub conversations:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/github-reactions.gif\" rel=\"attachment wp-att-52312\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/github-reactions.gif?resize=917%2C359\" alt=\"github-reactions\" class=\"aligncenter size-full wp-image-52312\" /></a></p>\n<p>Going forward, emoji reactions should make life easier for project maintainers, as they provide a quick way to assess consensus. If contributors embrace emoji reactions, the new feature can help maintainers gauge how widespread a bug is. They also serve to highlight the most helpful comments in a conversation.</p>\n<p>Emoji reactions, which were also recently adopted by Slack and Facebook, are making their way into more applications as an alternative way of offering feedback. Path was one of the first social apps to offer reactions in 2012. Buzzfeed has taken the feature to a new level with the addition of gif reaction options at the end of articles:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/buzzfeed-reactions.png\" rel=\"attachment wp-att-52327\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/buzzfeed-reactions.png?resize=1025%2C601\" alt=\"buzzfeed-reactions\" class=\"aligncenter size-full wp-image-52327\" /></a></p>\n<p>A feature that was once limited to social networks is now changing communication in the workplace by facilitating conversations for large groups of people. While emoji reactions offer people more ways of expressing themselves, they can also serve as a metric, a gauge, and a voting system.</p>\n<p>The new <a href=\"http://wptavern.com/new-feature-plugin-for-wordpress-adds-emoji-reactions-to-posts\" target=\"_blank\">Reactions feature plugin</a> for WordPress received no small amount of criticism when it was introduced earlier this week. Even if the plugin never reaches the proposal stage, the conversation about the value of emoji reactions in modern communication is worth having.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Mar 2016 16:10:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: From Silence to Publishing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46343\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://ma.tt/2016/03/from-silence-to-publishing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:722:\"<blockquote><p>My parents first noticed my stutter when I was three years old. For the longest time, I thought I would one day be rid of it. I went for speech therapy, I did fluency exercises, I prayed. But now, at age thirty, I’m fairly confident that it’s here to stay. [&#8230;]</p>\n<p>Somehow, as I progressed through high school, the expectant pauses of those listening to me were more difficult to bear that the nicknames and name calling. Often, I would not speak up, even when I had something I wanted to say.</p>\n<p>My default setting was silence.</p></blockquote>\n<p><a href=\"http://heropress.com/essays/breaking-the-silence/\">Read the rest of Mahangu Weerasinghe&#8217;s story, Breaking the Silence</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 22:48:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Post Status: Automattic has purchased a majority stake in Pressable\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=22262\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://poststatus.com/automattic-pressable/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5218:\"<p><a href=\"https://automattic.com\">Automattic</a> has purchased a majority stake in <a href=\"https://pressable.com/\">Pressable</a>, one of the earliest managed WordPress hosting companies, founded in 2010. They were first known as ZippyKid, and <a href=\"https://poststatus.com/zippykid-pressable/\">rebranded in 2013</a>.</p>\n<p>Automattic was already a shareholder in Pressable, most recently as the primary investor of <a href=\"https://www.crunchbase.com/organization/pressable#/entity\">a $1.5 million round</a> in April of 2015.</p>\n<p>Technically, Automattic purchased  common stock shares from Vid Luther, the CEO of Pressable. The monetary value of that common stock was, &#8220;enough to be debt free,&#8221; according to Vid. He owned about 37% of the company, or 4.5 million shares of 7 million shares of common stock (versus preferred shares). The company has also been in debt, reportedly close to $1 million worth.</p>\n<p>Automattic is now the majority owner of Pressable, and since Vid sold his shares, this is effectively an acquisition, and Automattic will be able to set the direction of the company from now on. Chris Lauzon, a Happiness Engineer at Automattic, is the interim CEO. There are other smaller investors in Pressable whom maintain their shares in the company, and it&#8217;s unknown what those investors will do.</p>\n<p>When I confirmed the exit with Vid, he said, &#8220;This is the best thing that I could have done for my family, or myself.&#8221; He was burning the candle at both ends, working twice as much as he wanted to be working, and wasn&#8217;t seeing the growth and success that he dreamed of for so many years. Pressable has always done okay in the managed WordPress market, but never outpaced quick-growth and heavily funded WP Engine, or the first entry to the market, Pagely. But Pressable has not been in a position of strength for a really long time.</p>\n<p>Pagely, WP Engine, and Pressable were really the first three into the market of managed hosting &#8212; a market that now includes nearly every big name host. It&#8217;s fascinating to see the different directions they&#8217;ve gone since. WP Engine <a href=\"https://www.crunchbase.com/organization/wp-engine#/entity\">has raised</a> nearly $40 million over the years and gone for scale (Automattic also invested in their Series A), while Pagely has bootstrapped the whole way and really hit their stride in the last couple of years with a move to the higher end of the market. Dozens of managed hosting companies exist today.</p>\n<p>The work these three companies put into the early managed market got the attention of the biggest players in the market, like GoDaddy and EIG (owner of BlueHost, HostGator, and many more). Pressable fought hard, and Vid&#8217;s exit from the company comes after a long road with many challenges.</p>\n<p>Pressable has long been on Rackspace infrastructure, as Vid had relationships with them going back a long time; that infrastructure suffered <a href=\"http://wptavern.com/recent-pressable-outages-the-result-of-a-slow-loris-attack\">a few catastrophic outages</a> from attacks that cost Pressable quite a few customers in January 2015, stunting progress.</p>\n<p>They nearly sold Pressable to WP Engine about two years ago, and decided against it at the 11th hour. The financing round last year was a period of rejuvenation for them, after a troubled period between the malicious attacks on their infrastructure and some internal issues, and the team was looking forward to new opportunities moving forward, including a potential focus on hosting catered for eCommerce with WordPress.</p>\n<p>Speaking to an agency owner with clients at Pressable, they told me they believe they, &#8220;always struggled to find their voice and audience in a space that quickly filled up.&#8221; I agree with the observation.</p>\n<p>Pressable&#8217;s revenues were under $2 million per year, and they have a team of about 10 people. Vid is no longer at the company; his last day was March 7th. It remains to be seen exactly what direction Automattic will take the company, though I presume it will continue business as usual for now, like they did <a href=\"https://poststatus.com/automattic-acquired-woocommerce-woothemes/\">after the WooThemes acquisition</a>. While Automattic now owns the company, Matt Mullenweg made it clear to me that it&#8217;s not in their long term interest to be significantly involved in the traditional hosting business.</p>\n<p>Matt Mullenweg gave the following statement about the purchase:</p>\n<blockquote><p>Automattic is happy to be an investor in a number of WordPress-related companies and web hosts, and will continue to invest in the future. With Pressable we&#8217;ve unfortunately been forced to take a more active role to protect Pressable&#8217;s customers, employees, and our investment. Chris Lauzon, a Happiness Engineer at Automattic, has been temporarily working with the Pressable team to get everything in order, especially on the support side. Automattic continues to enjoy working with and supporting many great WordPress hosts, and we expect that Pressable will be able to operate fully independently in the future.</p></blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 21:59:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Do the Woo: A New Podcast for WooCommerce Store Owners\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52197\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/do-the-woo-a-new-podcast-for-woocommerce-store-owners\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3266:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/podcast.jpg\" rel=\"attachment wp-att-52297\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/podcast.jpg?resize=960%2C472\" alt=\"photo credit: Maciej Korsan\" class=\"size-full wp-image-52297\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/IQVHQYS3GL\">Maciej Korsan</a>\n<p>Bob Dunn, a WordPress educator better known on the web as <a href=\"https://bobwp.com/\" target=\"_blank\">BobWP</a>, is <a href=\"http://dothewoopodcast.com/welcome-to-do-the-woo-the-podcast-for-woocommerce-shop-owners/\" target=\"_blank\">launching a podcast for WooCommerce store owners</a>. &#8220;Do the Woo&#8221; will air weekly on Wednesdays with tips and tricks to help store owners attract more customers. Dunn plans to host guests involved in WooCommerce development, as well as store owners who will be invited to share their challenges and successes.</p>\n<p>After using WooCommerce for five years with client projects, as well as his own products, Dunn is prepared to share his store management experience with listeners. He&#8217;s used the plugin and many of its extensions for selling services, bookings, downloads, and currently for his membership site sales. He has also taught WooCommerce workshops and is preparing new courses for his students.</p>\n<p>Store owners are the targeted audience for Dunn&#8217;s new podcast with a focus on the business aspects of store management.</p>\n<p>&#8220;It will be a mix of topics, rather than a straight interviews format, which is what many of the other podcasts are,&#8221; Dunn said. &#8220;I’ll be sharing eCommerce news and tips from a WooCommerce perspective. I’ll Interview Woo experts, designers, developers and shop owners. I’ll also share ideas for using Woo in ways that the average user might not have considered. There will be some tech, but also marketing, sales and social, all around WC.&#8221;</p>\n<p>Dunn is aiming to reach both tech savvy users and those who would rather focus solely on the business of running a store.</p>\n<p>&#8220;Having built sites for shop owners and in my role as co-organizer for the Seattle WooCommerce meetup, I would have to say that it’s a mix of technical skill,&#8221; he said. &#8220;As with anything WordPress, it spans the spectrum. Some are very hands-on and comfortable with the technology, while others want to focus more on their products and sales and tend to avoid the tech end of things.&#8221;</p>\n<p>With an estimated 30% of e-commerce sites running on WooCommerce, a podcast focused on navigating the WooCommerce ecosystem as a store owner has a good chance of finding a decent audience with the right content strategy.</p>\n<p>&#8220;My goal is to help these shop owners by giving them marketing ideas and providing a forum for stories from some of their colleagues who have insights and experiences to share,&#8221; Dunn said.</p>\n<p>Interested listeners can subscribe at <a href=\"http://dothewoopodcast.com/\" target=\"_blank\">DoTheWooPodcast.com</a> where the first official episode will be published next week. Dunn will also be running WooCommerce-related posts on <a href=\"http://BobWP.com\" target=\"_blank\">BobWP.com</a> every Wednesday.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 21:27:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WPWeekly Episode 225 – Interview With Scott Kingsley Clark Lead Developer of Pods\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=52290&preview_id=52290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/wpweekly-episode-225-interview-with-scott-kingsley-clark-lead-developer-of-pods\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2883:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I interview <a href=\"https://scottkclark.com/\">Scott Kingsley Clark</a>, lead developer of the <a href=\"http://pods.io/\">Pods framework</a> plugin. Clark explains the financial and organizational structure of the <a href=\"https://pods.io/friends-of-pods/\">Friends of Pods program</a> and how it benefits the plugin&#8217;s development.</p>\n<p>He also explains what the <a href=\"https://github.com/sc0ttkclark/wordpress-fields-api\">Fields API project</a> is and its significance to WordPress. To make a long story short, it&#8217;s on par with the REST API&#8217;s inclusion in core. Last but not least, in a first for WordPress Weekly, Clark sings a song while strumming his Baritone Ukulele.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/custom-content-type-manager-plugin-update-creates-a-security-nightmare\">Custom Content Type Manager Plugin Update Creates a Security Nightmare</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/video-conferencing-with-zoom-api/\">Video Conferencing with Zoom API,</a> by <a href=\"https://profiles.wordpress.org/j_3rk/\">Deepen Bajracharya</a> from Nepal, gives you the power to manage Zoom Meetings from your WordPress dashboard. You can manage meetings, users, and display meetings in posts or pages using shortcodes.</p>\n<p><a href=\"https://wordpress.org/plugins/timeline-diagram/\">Time Line Diagram</a>, by <a href=\"https://profiles.wordpress.org/md-shiddikur-rahman/\">Shiddikur Rahman, </a>is a responsive WordPress Plugin that allows you to create a beautiful vertical storyline. You simply create posts, assign images, a date, and then Time Line Diagram will automatically populate the posts in chronological order, based on the year and date.</p>\n<p><a href=\"https://wordpress.org/plugins/easier-excerpts/\">Easier Excerpts,</a> by <a href=\"https://profiles.wordpress.org/tommcfarlin/\">Tom McFarlin </a>and <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> from PressWare, automatically expands and contracts the post&#8217;s excerpt to eliminate unnecessary white space.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, March 16th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #225:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 20:37:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Jetpack 3.9.3 Maintenance Release Adds Compatibility for WordPress 4.5 Custom Logos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52250\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://wptavern.com/jetpack-3-9-3-maintenance-release-adds-compatibility-for-wordpress-4-5-custom-logos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2731:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif\" rel=\"attachment wp-att-27470\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/07/jetpack-logo.gif?resize=700%2C276\" alt=\"jetpack-logo\" class=\"aligncenter size-full wp-image-27470\" /></a></p>\n<p><a href=\"http://jetpack.com/2016/03/10/jetpack-3-9-3-maintenance-and-compatibility-release/\" target=\"_blank\">Jetpack 3.9.3 and 3.9.4</a> are now available. Although 3.9.3 is billed as a &#8220;maintenance and compatibility release,&#8221; there are a number of significant changes and improvements that make this an important release.</p>\n<p>WordPress 4.5 will introduce native <a href=\"http://wptavern.com/wordpress-4-5-to-introduce-native-support-for-a-theme-logo\" target=\"_blank\">support for a theme logo</a>. This will render Jetpack&#8217;s site logo feature obsolete. The 3.9.3 release of the plugin adds compatibility with WordPress 4.5 by ensuring that sites use core&#8217;s implementation for custom logos instead.</p>\n<p>According to Konstantin Obenland in a recent <a href=\"https://make.wordpress.org/core/2016/03/10/custom-logo/\" target=\"_blank\">post</a> on make/core, &#8220;Jetpack will do a migration behind the scenes to work with it out of the box.&#8221; He also said that WordPress core&#8217;s new custom logo feature will use <a href=\"http://wptavern.com/customizer-responsive-preview-and-selective-refresh-to-be-merged-into-wordpress-4-5\" target=\"_blank\">Selective Refresh</a>, which means that the preview will load instantly after the image has been uploaded.</p>\n<p>Notable enhancements in this release include:</p>\n<ul>\n<li>When using Carousel and Photon together, Jetpack will now link to the Photon version of full-sized images</li>\n<li>Performance improvements to Comments, Infinite Scroll, Markdown, Publicize, Sitemaps, and the Subscription widget</li>\n<li>Infinite Scroll: Introduced a later filter for settings</li>\n<li>New filters in the Top Posts Widget code</li>\n<li>oEmbed for Houzz.com</li>\n</ul>\n<p>The release also fixes an annoying bug in the Comments module that would reload the page when clicking &#8216;Reply.&#8217;</p>\n<p>Jetpack 3.9.4 was released right on the heels of 3.9.3 to fix an issue where some comments were being displayed incorrectly. The problem was significant enough to push out an additional release right away.</p>\n<p>Updating to the latest version of Jetpack will help your site work seamlessly with WordPress 4.5 when it is released the week of April 12. Check out the full <a href=\"https://wordpress.org/plugins/jetpack/changelog/\" target=\"_blank\">changelog</a> for both releases to see all of the enhancements and bug fixes.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 18:29:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: WordCamp Europe 2016 Expands Attendee Capacity to 2200, Largest WordCamp to Date\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52248\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/wordcamp-europe-2016-expands-attendee-capacity-to-2200-largest-wordcamp-to-date\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2919:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/MuseumsQuartier.jpg\" rel=\"attachment wp-att-52255\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/MuseumsQuartier.jpg?resize=800%2C448\" alt=\"photo credit: rank.at\" class=\"size-full wp-image-52255\" /></a>photo credit: <a href=\"https://www.rank.at/en/blog-article/old-meets-new-in-the-heart-of-vienna-the-museumsquartier-vienna.html\">rank.at</a>\n<p><a href=\"https://2016.europe.wordcamp.org/\" target=\"_blank\">WordCamp Europe 2016</a> is now on track to be the largest WordPress conference to date. The event, which will be held in Vienna June 24-26, has expanded its capacity to 2200 attendees (including micro-sponsors.) 400 additional tickets will be made available this week.</p>\n<p><a href=\"http://wptavern.com/wordcamp-europe-2016-sold-out-organizers-working-to-get-more-venue-space\" target=\"_blank\">The first 1700 seats sold out</a> six months in advance, causing organizers to scramble to expand the venue capacity to meet the overwhelming demand for more tickets. They were able to secure three additional halls in the Leopold Museum and the Baroque suites of the MuseumsQuartier, all located within a minute&#8217;s walking distance of each other.</p>\n<p>“With the camp happening in the city center, we wanted to make it easy for people to visit all the exquisite museums and sights in the area,&#8221; lead organizer Petya Raykovska said. As a bonus, conference goers will receive free access to the Leopold&#8217;s museum&#8217;s permanent exhibitions as part of their tickets.</p>\n<p>WordCamp Europe will also be hosting the largest WordPress contributor day on record. Organizers are planning for 500 attendees and are considering using one of Vienna&#8217;s universities as the venue.</p>\n<p>&#8220;We would have liked it to be in Leopold’s but unfortunately securing stable wifi for so many people in a museum is above our budget, so we’re looking for a venue that already has the infrastructure,&#8221; Raykovska said.</p>\n<p>Current attendees represent 68 different countries, and the organizing team now includes members from 10 countries spanning both Eastern and Western Europe. The team would like to host a WordPress community summit for Europe but have not received confirmation for this year.</p>\n<p>The host city for WordCamp Europe 2017 will be selected by the end of March. This will expand the organizing team for the current event, as future hosts will come on board to learn the ropes.</p>\n<p>The next batch of <a href=\"https://2016.europe.wordcamp.org/tickets/\" target=\"_blank\">tickets</a> for the event will go on sale Friday, March 11th at 10 AM CET. In the meantime, the 250 people who signed up for the <a href=\"http://eepurl.com/bNsAUr\" target=\"_blank\">waiting list</a> will receive an email to claim their tickets first via a special reservation link.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 10:35:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Write CSS in the Customizer with the Advanced CSS Editor Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52194\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/write-css-in-the-customizer-with-the-advanced-css-editor-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3247:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/paint-brush.jpg\" rel=\"attachment wp-att-52240\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/paint-brush.jpg?resize=1024%2C538\" alt=\"photo credit: cutting in - (license)\" class=\"size-full wp-image-52240\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/10687935@N04/6021868900\">cutting in</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>Last year WordPress developer <a href=\"http://www.hardeepasrani.com/\" target=\"_blank\">Hardeep Asrani</a> and the folks at <a href=\"http://themeisle.com/\" target=\"_blank\">ThemeIsle</a> released <a href=\"http://wptavern.com/customize-your-login-page-using-the-wordpress-customizer\" target=\"_blank\">Custom Login Customizer</a>, a plugin that allows users to design their own login pages in the customizer. Since that time core developers have made more progress on the customizer roadmap, allowing for more varied uses outside of a theme-related context.</p>\n<p>Last week the ThemeIsle team debuted <a href=\"https://wordpress.org/plugins/advanced-css-editor/\" target=\"_blank\">Advanced CSS Editor</a>, a new plugin in its arsenal that demonstrates another exciting use for the customizer. It makes use of <a href=\"http://wptavern.com/customizer-responsive-preview-and-selective-refresh-to-be-merged-into-wordpress-4-5\" target=\"_blank\">postMessage transport</a> to offer live previews of CSS changes while a user is writing them in the customizer. The plugin also allows users to write CSS for different device screen sizes, including desktop, tablet, and mobile phones. The demo below shows a screen capture of the plugin in action on my test site:</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/edit-css.gif\" rel=\"attachment wp-att-52205\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/edit-css.gif?resize=924%2C558\" alt=\"edit-css\" class=\"aligncenter size-full wp-image-52205\" /></a></p>\n<p>Seeing CSS edits updating in real time, instead of switching back and forth between a file editor and the frontend, was a refreshing experience. Having the ability to quickly write and preview media queries is also a convenient feature.</p>\n<p>Although many core contributors are not fond of having a file editor in WordPress, the feature has yet to be removed. Using the Advanced CSS Editor plugin makes you wonder what the core file editor might look like in the customizer, at least for CSS files.</p>\n<p>In the past, the customizer&#8217;s paint brush admin icon seemed like an ambitious stretch for a feature that, up until recently, felt clunky and slow to render previews. But recent advancements like <a href=\"https://make.wordpress.org/core/2016/02/16/selective-refresh-in-the-customizer/\" target=\"_blank\">selective refresh</a> will help to make the customizer provide a true live preview experience.</p>\n<p>The <a href=\"https://wordpress.org/plugins/advanced-css-editor/\" target=\"_blank\">Advanced CSS Editor</a> plugin is a good example of how fast previews can be in the customizer and how much of a better experience it offers over similar plugins that require multiple clicks to refresh.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Mar 2016 23:13:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: Jetpack Turns 5 and Celebrates With a New Domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52190\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wptavern.com/jetpack-turns-5-and-celebrates-with-a-new-domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9574:\"<p>On this day in 2011, <a href=\"https://wordpress.org/plugins/jetpack/\">Jetpack</a>, the project formerly known as &#8220;.org connect&#8221; inside Automattic, was released to the public. At the time, the team consisted of five people. Today, there are more than 50 people on various teams within the project, including, support, user experience, growth, and development. It&#8217;s also active on more than 1 million sites.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/Jetpack11Interface.png\" rel=\"attachment wp-att-52213\"><img class=\"size-full wp-image-52213\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/Jetpack11Interface.png?resize=989%2C855\" alt=\"Jetpack 1.1 User Interface\" /></a>Jetpack 1.1 User Interface\n<p>To celebrate the occasion, <a href=\"https://profiles.wordpress.org/professor44/\">Jesse Friedman</a>, Experience Advocate at Automattic, <a href=\"http://jetpack.com/2016/03/09/5-years-in-jetpack-is-soaring-higher-than-ever/\">shares four unique stories</a> from people who rely on Jetpack for their sites. The stories include a food blogger who uses 20 different modules, a developer who manages a number of sites, a new user who discovers the benefits of <a href=\"http://jetpack.com/support/photon/\">Photon</a>, and a convert who prefers Jetpack over clunky alternatives.</p>\n<p>Jetpack&#8217;s support team is also celebrating its fifth birthday. According to Carolyn Sonnek, Happiness Rocketeer for Jetpack, the support team responded to over 93,000 support messages between email and the forums last year.</p>\n<p>In addition to Jetpack&#8217;s birthday, the site&#8217;s domain has moved from Jetpack.me to Jetpack.com. Automattic <a href=\"http://www.thedomains.com/2015/12/09/automattic-com-owner-of-wordpress-acquires-jetpack-com/\">purchased the domain</a> in December 2015, from Jetpack Design of Santa Monica, CA. According to domain appraisal service <a href=\"http://www.estibot.com\">Estibot.com</a>, its <a href=\"http://www.estibot.com/appraise.php?a=appraisal&k=f818b525ed659fb84fdca10f05e64f47&domain=jetpack.com\">estimated value</a> is $51K.</p>\n<h2>Interview With Jesse Friedman</h2>\n<p>Friedman describes his journey working on Jetpack and shares what he&#8217;s learned since joining the team.</p>\n<p><strong>How long have you been on the Jetpack journey and what&#8217;s it been like?</strong></p>\n<p>I started using Jetpack in the Spring of 2012. I was working as the Director of Web Development at a web development and marketing company. I needed several different tools to round out the WordPress environment I was building to house a 2,000 site multisite that was growing by 50 sites a month.</p>\n<p>All of us on the team agreed that Jetpack solved a lot of different needs for us in one convenient plugin. As developers, we loved the out of the box features like Sharing, Publicize, and Monitor, and our clients loved Stats.</p>\n<p>In 2014, I left that company and joined up with the BruteProtect team. We worked hard to build a great security plugin that has been implemented on millions of websites. Later in 2014, we were excited to receive the news that we were joining the Jetpack team to continue BruteProtect as a Jetpack feature. Released last year, Jetpack Protect guards our users from malicious and brute force login attempts. It was truly something special to go from being a big fan of Jetpack to being on the team at Automattic.</p>\n<p><strong>What are some things you have learned through Jetpack development that have benefited you in other areas?</strong></p>\n<p>In the last 18 months, I’ve been doing a lot of work around the experience users have with Jetpack. Everything from individual features, to the connection process, to our website and how we communicate with our users. I’ve learned a lot about Jetpack and our community. The main thing being that, while Jetpack provides a lot of value to professionals and veterans, it is just<span class=\"copyonly\"> as</span><i></i>, if not more important for new users.</p>\n<p><strong>Do you think Jetpack is a key component to WordPress reaching 50% market share?</strong></p>\n<p>The WordPress community as a whole is growing so quickly. Hosts provide really simple tools to build a WordPress website with a single click or even no clicks at all. That means that WordPress and Jetpack have to be just as intuitive and work to improve the new user experience.<i class=\"copy_only\"></i></p>\n<p>This is especially important when we consider growing WordPress&#8217; market share. I think everyone who builds something for WordPress, or publishes on WordPress, or organizes WordPress community events, are critical to growing to 50% or beyond.</p>\n<p>Any WordPress tool or plugin that can help a user build their website faster while providing maintenance tools like Manage or security tools like Protect is going to play an important role in the growth of market share.</p>\n<p>Jetpack specifically, is in a unique position because we can leverage the<span class=\"Apple-converted-space\"> </span><a href=\"http://wordpress.com/\" target=\"_blank\" rel=\"noreferrer\">WordPress.com</a><span class=\"Apple-converted-space\"> </span>infrastructure and network to build extremely powerful tools (like a global CDN) in an otherwise simple interface. Not to mention Jetpack’s popularity, it’s one of the most popular plugins across all of WordPress. Which is reinforced for me as I spend more and more time with our users, who are quite happy.</p>\n<h2>Paid Services in Jetpack Remain at a Minimum</h2>\n<p>Jetpack has come a long way since its inception but it&#8217;s interesting to look back at 2011 and review what some in the WordPress media world had to say about it. Ryan Imel, of WPCandy.com, <a href=\"http://wpcandy.com/thinks/jetpack-means-more-than-features-for-dot-org-users/\">looked into new opportunities for Automattic</a> as Jetpack provided a direct line into millions of self hosted sites.</p>\n<blockquote><p>Jetpack is now a direct line in to WordPress.org Dashboards for Automattic. When (not <em>if</em>) Automattic releases a new software as a service, a simple update to Jetpack will bring that news in front of a serious number of WordPress.org users. This is a big step for Automattic, since up to now their reach has been mostly within the walls of WordPress.com. Now Jetpack is not only available for anyone to use, but it will come preinstalled with one-click installs of WordPress with a number of hosting providers.</p></blockquote>\n<p><a href=\"http://jetpack.com/2011/03/09/blast-off/\">Jetpack&#8217;s goal</a> was to provide many of the useful features on WordPress.com to self-hosted users and while it does that, the business portion of the plugin can&#8217;t be ignored. Automattic owned services VideoPress and VaultPress are presented to millions of users who may otherwise not have known about them.</p>\n<p>Today, Jetpack contains only two modules that require a paid subscription, VideoPress and VaultPress. So while it would be easy to increase Jetpack&#8217;s revenue generating capabilities by cramming it with commercial services and paid add-ons, Automattic has not done so.</p>\n<p>At the end of the post, Imel asks a question that couldn&#8217;t be answered at the time, &#8220;In a large sense, what does Jetpack mean to the world of WordPress?&#8221; Fast forward five years later, we know that it&#8217;s a key component that&#8217;s helping <a href=\"http://wptavern.com/how-important-is-jetpack-on-wordpress-road-to-50-market-share\">WordPress move towards 50% market share</a>.</p>\n<h2>Jetpack Pride</h2>\n<p>The five year mark is a great milestone for any plugin and a great time to reflect. In Jetpack&#8217;s five year existence, Matt Mullenweg, WordPress co-founder, says what he&#8217;s most proud of, &#8220;I’m most proud of the fact that people who start using WordPress and Jetpack at the same time are more likely to be using WordPress a month later. It brings us closer to WordPress’ over-arching goal of democratizing publishing, giving users the ability to have the best of both worlds: open source and cloud.&#8221; Mullenweg said.</p>\n<h2>Share Your Jetpack Story</h2>\n<p>The Jetpack team is looking for feedback on how it&#8217;s saved you time, help you build websites faster, helped optimize your sites, etc. You can share your story by publishing it in the comments of this post or by using the <a href=\"https://twitter.com/search?q=%23JetpackTurns5&src=typd\"><strong>#JetpackTurns5</strong></a> hashtag on Twitter. One of my favorite stories so far is from Cécile Rainon who discovered WordPress through Jetpack and now works for Automattic.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Discovered WordPress through this plugin and I\'m now a proud Automattician! <a href=\"https://t.co/r0yCKYzqmI\">https://t.co/r0yCKYzqmI</a> via <a href=\"https://twitter.com/jetpack\">@jetpack</a> <a href=\"https://twitter.com/hashtag/jetpackturns5?src=hash\">#jetpackturns5</a></p>\n<p>&mdash; Cécile (@cecile_rainon) <a href=\"https://twitter.com/cecile_rainon/status/707594514433753088\">March 9, 2016</a></p></blockquote>\n<p></p>\n<p>We use a number of modules to provide basic functionality such as contact forms, custom CSS, Likes, Protect, and more. In fact, every module except for five are activated on the Tavern. Using one plugin that handles a lot of the functionality we use on a daily basis is easier to maintain than using a number of separate plugins.</p>\n<p>Happy birthday, Jetpack and here&#8217;s to five more!</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Mar 2016 22:02:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Jetpack Turns 5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46331\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2016/03/jetpack-turns-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:761:\"<p>Today the <a href=\"http://jetpack.com/2016/03/09/5-years-in-jetpack-is-soaring-higher-than-ever/\">Jetpack plugin turns five years old</a>. Who woulda thunk it? It&#8217;s one of the most popular plugins in WP history, and sites that include it as part of their WordPress install are more likely to to have engaged and active users &#8212; we&#8217;ve even seen it reduce churn on major web hosts. While there&#8217;s been a lot that&#8217;s happened in the Jetpack plugin so far, what&#8217;s around the corner has me even more excited. <img src=\"https://s.w.org/images/core/emoji/72x72/1f600.png\" alt=\"😀\" class=\"wp-smiley\" /> <img src=\"https://s.w.org/images/core/emoji/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" /> P.S. Check out that new domain.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Mar 2016 14:27:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.5 Adds Inline Editing to the Links Modal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52174\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-5-adds-inline-editing-to-the-links-modal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1777:\"<p>Today Andrew Ozz, one of the maintainers on <a href=\"https://make.wordpress.org/core/components/\" target=\"_blank\">WordPress&#8217; core Editor component</a>, announced some <a href=\"https://make.wordpress.org/core/2016/03/08/link-modal-wplink-changes-in-wordpress-4-5/\" target=\"_blank\">major improvements coming to the links modal</a> in the 4.5 release. Currently, when adding a link to text in the visual editor, a modal launches where you can paste in the URL, add link text, and set the target to open in a new window. The modal also expands to let you search for and link to existing content.</p>\n<p>The TinyMCE link modal in WordPress 4.5 will allow for inline editing. It can actually detect when a user is entering a URL or attempting to search for one. The search uses jQuery UI Autocomplete, making it fast and easy to search through existing content. The gears icon launches the full modal with advanced options to set the target and title attribute.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/links-modal.gif\" rel=\"attachment wp-att-52178\"><img class=\"aligncenter size-full wp-image-52178\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/links-modal.gif?resize=838%2C496\" alt=\"links-modal\" /></a></p>\n<p>The links modal improvements are the result of WordPress core contributor Ella Iseulde Van Dorpe&#8217;s work on a <a href=\"https://core.trac.wordpress.org/ticket/33301\" target=\"_blank\">ticket</a> opened to make this UI similar to the way Google Docs handles links. The experience of linking in the visual editor is now tighter and much more elegant and intuitive. This is one of the many small, yet impactful ways that WordPress is improving with each incremental release.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Mar 2016 00:34:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: New Feature Plugin for WordPress Adds Emoji Reactions to Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52097\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/new-feature-plugin-for-wordpress-adds-emoji-reactions-to-posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5822:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/emoji.jpg\" rel=\"attachment wp-att-52168\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/emoji.jpg?resize=1024%2C576\" alt=\"photo credit: Emoji - (license)\" class=\"size-full wp-image-52168\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/59525227@N08/25617662995\">Emoji</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p><a href=\"http://pento.net/\" target=\"_blank\">Gary Pendergast</a> is looking to bring WordPress users a new way of giving feedback on posts that goes beyond simple text-based comments. A core committer and emoji aficionado, Pendergast spearheaded the effort to add <a href=\"https://make.wordpress.org/core/tag/emoji/\" target=\"_blank\">emoji support</a> to WordPress and is now working on an <a href=\"https://make.wordpress.org/core/2016/03/07/reactions/\" target=\"_blank\">emoji reactions feature plugin</a>.</p>\n<p>The plugin is being developed to offer reactions that are similar to those available in Slack and Facebook.</p>\n<p>&#8220;It works much the same way as a Like button, but provides a wider range of reactions so readers can give more nuanced feedback without needing to go to the effort of leaving a comment,&#8221; Pendergast said. &#8220;This also allows readers to provide the same level of interaction in situations where a &#8216;Like&#8217; is an inappropriate message to send, as Eric Meyer describes in his post about <a href=\"http://meyerweb.com/eric/thoughts/2014/12/24/inadvertent-algorithmic-cruelty/\" target=\"_blank\">Inadvertent Algorithmic Cruelty</a>.&#8221;</p>\n<p>The <a href=\"https://wordpress.org/plugins/react/\" target=\"_blank\">Reactions plugin</a> is available on WordPress.org as a proof-of-concept with basic features:</p>\n<ul>\n<li>Allows for reactions to posts</li>\n<li>REST API endpoints for storing and retrieving reactions</li>\n<li>An exceedingly ugly emoji selector</li>\n</ul>\n<p>The plugin is under active development but those who want to get involved testing it early can log bugs on the project&#8217;s <a href=\"https://github.com/pento/react/issues\" target=\"_blank\">GitHub issues queue</a>. Reactions requires the <a href=\"https://wordpress.org/plugins/rest-api/\" target=\"_blank\">WP REST API</a> plugin. Once both are installed, you&#8217;ll see an emoji reactions button beneath the post content.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/reactions.png\" rel=\"attachment wp-att-52147\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/reactions.png?resize=1025%2C642\" alt=\"reactions\" class=\"aligncenter size-full wp-image-52147\" /></a></p>\n<p>Clicking on the button will expand a panel of emoji reactions. The emoji picker UI is very basic but Pendergast is still investigating different options for display.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/reactions-expanded.png\" rel=\"attachment wp-att-52161\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/reactions-expanded.png?resize=1025%2C639\" alt=\"reactions-expanded\" class=\"aligncenter size-full wp-image-52161\" /></a></p>\n<p>The post on the make/core blog immediately drew heated criticism and opposition. One of the more restrained reactions from <a href=\"https://make.wordpress.org/core/2016/03/07/reactions/#comment-29449\" target=\"_blank\">@chatmandesign</a> praises the idea for personal blogs but discourages its development beyond a plugin:</p>\n<blockquote><p>I have to agree with what rapidly seems to be becoming the general consensus: Great idea for a plugin – if I ever setup my own personal blog, I might even use it – but I can’t imagine why this would be considered for Core. I would end up having to disable it on nearly every website I build, which are primarily business websites where this sort of goofy element would simply be inappropriate.</p></blockquote>\n<p>Others commented that while it may not be a good candidate for core, having a canonical plugin for handling emoji reactions could be beneficial for the community.</p>\n<p>Pendergast responded to critics by reiterating the casual exploratory nature of the project.</p>\n<p>&#8220;Right now, it isn’t being considered for Core – it’s being explored as a possible feature in the future,&#8221; he said. &#8220;The idea still has to prove itself in terms of usefulness, usability, and general appeal. In terms of how close this is to landing in Core, it’s about the same as a new ticket being opened on Trac.&#8221;</p>\n<p>Thanks in large part to mobile devices, emoji are now inescapable staples of modern communication for digitally connected people. Even so, the question of bringing emoji reactions into WordPress core may prove to be a deeply polarizing issue.</p>\n<p>In one camp you have emoji fanatics who would go so far as to create a 25,000+ character <a href=\"http://www.huffingtonpost.com/2015/04/16/alice-in-wonderland-emoji_n_7066576.html\" target=\"_blank\">emoji translation of Alice in Wonderland</a>. On the other side are equally impassioned emoji haters who think the characters are unimaginative and that using emoji <a href=\"http://www.theguardian.com/commentisfree/2014/jun/18/adults-emoji-grow-up-emoticons-teenagers\" target=\"_blank\">perpetuates &#8220;linguistic incompetence&#8221;</a>.</p>\n<p>If the Reactions feature plugin makes it to the core proposal stage, the WordPress community will be in for some interesting debates. If you want to get in on the fun of emoji reactions and lend a hand to the project, you can join the #feature-reactions channel in Slack. Development of the plugin will continue on <a href=\"https://github.com/pento/react\" target=\"_blank\">GitHub</a> and will be periodically pushed to WordPress.org.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Mar 2016 21:56:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Automattic Releases WordPress Plugin for Facebook’s Instant Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52069\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/automattic-releases-wordpress-plugin-for-facebooks-instant-articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5930:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/facebook-instant-articles-wordpress.jpg\" rel=\"attachment wp-att-52114\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/facebook-instant-articles-wordpress.jpg?resize=1025%2C577\" alt=\"facebook-instant-articles-wordpress\" class=\"aligncenter size-full wp-image-52114\" /></a></p>\n<p>Today the WordPress.com VIP team <a href=\"https://vip.wordpress.com/2016/03/07/new-wordpress-plugin-for-facebook-instant-articles/\" target=\"_blank\">released</a> a plugin for Facebook&#8217;s <a href=\"https://instantarticles.fb.com/\" target=\"_blank\">Instant Articles</a>, which will be <a href=\"http://media.fb.com/2016/02/17/opening-up-instant-articles/\" target=\"_blank\">open to any publisher</a> starting April 12, 2016. Automattic partnered with Facebook and VIP-Featured-Partner agency <a href=\"https://en.dekode.no/?noredirect=en_US\" target=\"_blank\">Dekode</a> to produce a plugin that outputs a compliant feed of posts wrapped in the required markup for Facebook.</p>\n<p>Instant Articles for WordPress is now <a href=\"https://vip.wordpress.com/2016/03/07/new-wordpress-plugin-for-facebook-instant-articles/\" target=\"_blank\">available on GitHub</a> and is also coming soon to the WordPress plugin directory.</p>\n<p>Publishers must go through a review process to ensure that their posts are properly formatted and compliant before being allowed to push content via Instant Articles. Once approved, articles will load nearly instantly on mobile devices. According to Facebook, the speed is as much as 10 times faster than the standard mobile web.</p>\n<p>&#8220;We had heard from a lot of WordPress publishers that they were eager to try out the Instant Articles program — based on the speed and user experience optimized for Facebook&#8217;s audience,&#8221; VP of Platform Services at Automattic Paul Maiorana said. &#8220;It&#8217;s still quite early, but we wanted to move quickly to ensure that WordPress and WordPress.com VIP publishers can take advantage of Instant Articles as soon as it opens up to everyone. And we were excited to work with Facebook to help make that happen.&#8221;</p>\n<p>Facebook is working to create the best news feed on the web. More content delivered instantly means more advertising revenue for the social network. Publishers that make their content available via Instant Articles also have the opportunity to earn advertising revenue. If publishers sell their own ads, they get to keep 100% of the revenue. If they opt to use the Facebook Audience Network, they keep 70%.</p>\n<p>Automattic&#8217;s open source Instant Articles plugin does not have built-in options for serving ads. According to Maiorana, further customization will be left up to the publishers.</p>\n<p>&#8220;The new plugin is meant to be a starting point for publishers, from which they can customize design, advertising options, and which articles they choose to syndicate,&#8221; Maiorana said.</p>\n<p>Instant Articles is not yet available to WordPress.com users, but Maiorana said that it&#8217;s something they will explore in the future.</p>\n<h3>Instant Articles Is Geared Towards News Publishers</h3>\n<p>You may be wondering if your brand or business should use the new plugin and start pursuing the approval process with Facebook. The current implementation of Instant Articles is not for everyone. A Facebook spokesperson told <a href=\"https://contently.com/strategist/2016/02/17/facebook-will-likely-open-instant-articles-to-brands-publishers-grandma/#footnote-1\" target=\"_blank\">Contently</a>:</p>\n<blockquote><p>In April, Instant Articles will be open to any publishers that wish to join, but it is primarily designed for news publishers. While other types of publishers will have the option to create Instant Articles, in many cases there are other formats on Facebook that will better serve their needs.</p></blockquote>\n<p>Facebook&#8217;s algorithm is likely to prioritize Instant Articles, as faster-loading articles are shared more often.</p>\n<p>However, publishing to Instant Articles requires no small amount of technical skill, especially if you&#8217;re not already on a platform like WordPress that offers support via a plugin. Even with the help of Automattic&#8217;s plugin you still need to make a number of customizations to add branding and advertising while the underlying APIs are still in flux.</p>\n<p>Publishers will need to decide how much control of their content they are willing to give up to Facebook in exchange for articles that load instantly. Funneling readers to Instant Articles hosted on Facebook has the potential to undermine direct mobile traffic. Facebook is also <a href=\"http://money.cnn.com/2016/02/04/technology/online-censorship-facebook-twitter/\" target=\"_blank\">notorious for its censorship</a>. What will Automattic&#8217;s response be to its partner if Facebook decides to censor WordPress publishers on its network? Maiorana wouldn&#8217;t directly answer this question.</p>\n<p>&#8220;Our goal at WordPress.com VIP is to help publishers have the tools and the freedom to make their own decisions — and to move quickly in experimenting across platforms,&#8221; Maiorana said. &#8220;This is another new way for them to do that.&#8221;</p>\n<p>New mobile publishing channels like Instant Articles and <a href=\"http://wptavern.com/automattic-adds-amp-support-to-wordpress-com-releases-plugin-for-self-hosted-sites\" target=\"_blank\">Google&#8217;s AMP project</a> require developer resources for publishers to get on board. Both of these tech giants are clawing for content distribution. They each have their own unique requirements that publishers will have to meet to in order to have their content found and prioritized. Each publisher will have to decide whether the improved speed, exposure, and/or ad revenue will be enough to make these efforts worthwhile.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Mar 2016 21:30:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: The Inaugural WPCampus Set For July 15-16, 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52130\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wptavern.com/the-inaugural-wpcampus-set-for-july-15-16-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1550:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/09/WPCampusFeaturedImage.png\" rel=\"attachment wp-att-48353\"><img class=\"aligncenter size-full wp-image-48353\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/09/WPCampusFeaturedImage.png?resize=811%2C161\" alt=\"WPCampus Featured Image\" /></a><a href=\"https://2016.wpcampus.org/\">WPCampus</a>, a WordPress event geared towards non-profits and higher education, will take place on July 15-16, 2016 in Sarasota, FL at the <a href=\"https://2016.wpcampus.org/location/\">University of South Florida Sarasota-Manatee</a> campus. The team is looking for <a href=\"https://2016.wpcampus.org/speakers/\">speakers</a> and <a href=\"https://2016.wpcampus.org/sponsors/\">sponsors</a>. Speakers who are accepted will receive free admission and swag.</p>\n<p>Organizers are open to stories as they relate to WordPress and education. According to the site, the intended audience will include faculty, students, developers, site designers, devops/sysadmins, content developers, instructional designers, marketing and admissions people, and institutional leaders. The team is most interested in case studies, conceptual discussions, best practices, and works-in-progress.</p>\n<p>If you&#8217;re interested in speaking at the first WPCampus, <a href=\"https://2016.wpcampus.org/speakers/\">speaker submissions</a> close at midnight EST on March 21, 2016. WPCampus is not affiliated or endorsed by the WordPress Foundation and is its own community run entity.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Mar 2016 20:44:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Custom Content Type Manager Plugin Update Creates a Security Nightmare\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/custom-content-type-manager-plugin-update-creates-a-security-nightmare\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4563:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/CustomContentTypeManagerPluginHeader.png\" rel=\"attachment wp-att-52125\"><img class=\"aligncenter size-full wp-image-52125\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/CustomContentTypeManagerPluginHeader.png?resize=758%2C237\" alt=\"Custom Content Type Manager Plugin Header\" /></a>Over the years, we&#8217;ve told users that the <a href=\"https://wordpress.org/plugins/\">WordPress plugin directory</a> is the safest place to download and install plugins from. This is due in large part to <a href=\"http://wptavern.com/behind-the-scenes-in-the-wordpress-plugin-directory-with-mika-epstein\">the dedication of volunteers</a> who act as gatekeepers and review plugins before they&#8217;re added to the directory. Plugin updates, however don&#8217;t receive the same scrutiny as there&#8217;s too many of them.</p>\n<p>Sucuri Security representative Denis Sinegubko, <a href=\"https://blog.sucuri.net/2016/03/when-wordpress-plugin-goes-bad.html\">published an in-depth post</a> that explains how an update to the <a href=\"https://wordpress.org/plugins/custom-content-type-manager/\">Custom Content Type Manager</a> plugin, which is active on more than 10k sites, turned into a security nightmare for some users. Custom Content Type Manager enables users to create custom fields for dropdowns, images, and more.</p>\n<p>According to Sinegubko, a user by the name of Wooranker was added as a maintainer on February 5th. Wooranker is also listed as a contributor to the <a href=\"https://wordpress.org/plugins/postie/\">Postie plugin</a> but <a href=\"https://blog.sucuri.net/2016/03/when-wordpress-plugin-goes-bad.html#comment-2552555345\">according to its author</a>, Wooranker does not and will not have access to change the source code. On February 19th, Wooranker <a href=\"https://plugins.trac.wordpress.org/changeset/1354314/custom-content-type-manager\">pushed out an update</a> that included the CCTM_Communicator.php file and inserted new code into the plugin’s index.php file.</p>\n<p>On March 1st, MartinCDS <a href=\"https://wordpress.org/support/topic/vulnerability-on-auto-updatephp\">created a thread</a> in the plugin&#8217;s support forums and reported the following:</p>\n<blockquote><p>I recently updated a few of my sites and since then my site was hacked. According to my log files the code was injected via custom-content-type-manager/auto-update.php. I navigated there and there is a form input. Please fix this in the next update. I don&#8217;t see a reason for an automatic update anyways- this is a known vulnerability by hackers.</p></blockquote>\n<p>Other users also reported that their sites had been hacked due to the auto-update.php file. This file allowed the attacker to upload a c.php file into the plugin directory. The c.php file was used to create a more sophisticated attack shell named wp-options.php in the site&#8217;s root directory. The c.php file was deleted once wp-options.php was created, making it harder to detect.</p>\n<h2>Custom Content Type Manager is Fixed</h2>\n<p>Samuel &#8216;Otto&#8217; Wood, who helps maintain WordPress.org, <a href=\"https://blog.sucuri.net/2016/03/when-wordpress-plugin-goes-bad.html#comment-2553534185\">left a comment on the article</a> acknowledging that the plugin has been fixed on the directory:</p>\n<blockquote><p>The plugin has been updated to 0.9.8.9, which is a copy of 0.9.8.6 (the last good version). This will remove the malicious code from the plugin, but not any code that was added to sites in the meantime. Please follow through with the Mitigation steps given by Denis in the post.</p></blockquote>\n<p>To learn how the attack works, insight into who Wooranker may be, and to see a list of mitigation steps, I encourage you to <a href=\"https://blog.sucuri.net/2016/03/when-wordpress-plugin-goes-bad.html\">read the post</a>.</p>\n<h2>A Concerning Reminder</h2>\n<p>I feel bad for those who updated their plugins from a trusted source only to make their sites vulnerable to attack. Unfortunately, there is no way to prevent situations like these from occurring unless every line of code for each update is scrutinized by a security professional, but that doesn&#8217;t scale.</p>\n<p>This doesn&#8217;t detract the trust I have for the WordPress plugin directory but users need to realize that what happened with Custom Content Type Manager can happen to other plugins as well. Your best defense is to use security scanning software of your choice that keeps track of file changes and to make routine backups.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Mar 2016 19:49:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Irish Times Interview\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46328\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://ma.tt/2016/03/irish-times-interview/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"<p>An interview <a href=\"http://www.irishtimes.com/business/technology/matt-mullenweg-how-wordpress-got-the-whole-world-blogging-1.2558828\">I did with the Irish Times when I was in Dublin is now live</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Mar 2016 19:32:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Magnus: A Bold New Photoblogging Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52061\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wptavern.com/magnus-a-bold-new-photoblogging-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3831:\"<p><a href=\"https://wordpress.org/themes/magnus/\" target=\"_blank\">Magnus</a> is a beautiful new photoblogging theme that landed in the WordPress Theme Directory last week. It was created by <a href=\"http://hugobaeta.com/\" target=\"_blank\">Hugo Baeta</a>, whose work you may have seen in the <a href=\"https://wordpress.com/design-handbook/\" target=\"_blank\">WordPress.com design handbook</a> and last year&#8217;s <a href=\"http://wptavern.com/wordpress-4-2-introduces-subtle-refinements-to-the-default-admin-color-scheme\" target=\"_blank\">subtle refinements to the default admin color scheme</a>. Magnus is Baeta&#8217;s first theme to be approved for the official directory.</p>\n<p>The theme puts the spotlight on your photographs with full-width featured images for posts. If the homepage is set to display posts, the most recent post&#8217;s title and featured image will show at the top of the page.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/magnus-home-menu.png\" rel=\"attachment wp-att-52076\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/magnus-home-menu.png?resize=1025%2C573\" alt=\"magnus-home-menu\" class=\"aligncenter size-full wp-image-52076\" /></a></p>\n<p>Baeta applied a unique pulse effect to the full-width images using CSS3 keyframes animation with the scale property. The resulting effect almost makes it appear as though you are traveling through the image. The theme also includes several other subtle, tasteful CSS animations for menus, toggling, and page transitions.</p>\n<p>If the homepage is set to display posts, they will tile uniformly under the most recent one with titles and featured images.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/magnus.png\" rel=\"attachment wp-att-52073\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/magnus.png?resize=1025%2C1408\" alt=\"magnus\" class=\"aligncenter size-full wp-image-52073\" /></a></p>\n<p>Baeta&#8217;s careful attention to typography is evident in the highly readable single post design.  Magnus uses a combination of Google fonts &#8211; Karla for paragraph text and Montserrat for headers.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/single-post.png\" rel=\"attachment wp-att-52074\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/single-post.png?resize=1025%2C666\" alt=\"single-post\" class=\"aligncenter size-full wp-image-52074\" /></a></p>\n<p>The theme includes one widgetized area, a sidebar that can be toggled into view from the right side of the screen. The sidebar slides smoothly into view and is semi-transparent, which makes for a less jarring experience than other similar sidebar implementations.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/magnus-sidebar.png\" rel=\"attachment wp-att-52072\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/magnus-sidebar.png?resize=1025%2C510\" alt=\"magnus-sidebar\" class=\"aligncenter size-full wp-image-52072\" /></a></p>\n<p>Left, right, and centered overhanging pull quotes can be easily created by aligning blockquotes to either side or the center.</p>\n<p>One thing I appreciate about this theme is that it makes almost all of the design decisions and allows very few design-related customizer options. You can change the header image and the header text color, but that&#8217;s it. The design is all about showcasing your images.</p>\n<p>If you need your content to make a big impact, <a href=\"https://wordpress.org/themes/magnus/\" target=\"_blank\">Magnus</a> is solid option that doesn&#8217;t require configuring a long list of options. You can <a href=\"https://wordpress.org/themes/magnus/\" target=\"_blank\">download it for free from WordPress.org</a> or via your admin themes browser.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Mar 2016 16:16:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: WPWeekly Episode 224 – Preview of WordPress 4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=52049&preview_id=52049\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/wpweekly-episode-224-preview-of-wordpress-4-5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2586:\"<p>In our first episode in more than a month, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I discuss the latest WordPress news, including a preview of WordPress 4.5. I share my experience taking a month off away from WordPress and the lessons learned in doing so. This show is a little rough around the edges but we&#8217;ll be back to our normal selves starting next week.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">WordPress 4.5 Beta 1 Released</a><br />\n<a href=\"http://wptavern.com/wordpress-4-5-to-introduce-native-support-for-a-theme-logo\">WordPress 4.5 to Introduce Native Support for a Theme Logo</a><br />\n<a href=\"http://wptavern.com/poetica-acquired-by-conde-nast-open-source-wordpress-plugin-will-be-discontinued\">Poetica Acquired by Condé Nast, Open Source WordPress Plugin Will Be Discontinued</a><br />\n<a href=\"http://wptavern.com/stripe-payment-gateway-for-woocommerce-is-now-available-for-free\">Stripe Payment Gateway for WooCommerce Is Now Available for Free</a><br />\n<a href=\"http://wptavern.com/automattic-adds-amp-support-to-wordpress-com-releases-plugin-for-self-hosted-sites\">Automattic Adds AMP Support to WordPress.com, Releases Plugin for Self-Hosted Sites</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/migrate-ninja-forms-to-gravity-forms/\">Migrate Ninja Forms to Gravity Forms</a> is a plugin that does exactly what it&#8217;s name implies. It migrates content from Ninja Forms to Gravity Forms.</p>\n<p><a href=\"https://wordpress.org/plugins/amp-analytics/\">AMP Analytics</a> extends Google&#8217;s AMP to allow you to add analytics to your Accelerated Mobile Pages.</p>\n<p><a href=\"https://wordpress.org/plugins/pl-platform/\">PageLines Platform 5</a> is a complete drag-and-drop editing system. It works with any standard WordPress theme.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, March 9th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #224:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Mar 2016 20:29:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: In Case You Missed It – Issue 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51929\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wptavern.com/in-case-you-missed-it-issue-3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7794:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png\" rel=\"attachment wp-att-50955\"><img class=\"size-full wp-image-50955\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?resize=676%2C292\" alt=\"In Case You Missed It Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There&#8217;s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is part of a new series where I share an assortment of items related to WordPress that caught my eye but didn&#8217;t make it into a full post.</p>\n<h2>Automattic Stands with Apple</h2>\n<p>In light of the recent court order issued against Apple in the <a href=\"http://www.nytimes.com/2016/02/18/technology/apple-timothy-cook-fbi-san-bernardino.html?_r=0\">San Bernardino case</a>, Automattic has <a href=\"https://transparency.automattic.com/2016/03/03/automattic-and-wordpress-com-stand-with-apple-to-support-digital-security/\">taken a stand</a> with Apple by joining other influential technology companies in filing an amicus brief in support of Apple’s legal challenge.</p>\n<p>The court order requires Apple to write code that acts as a backdoor and weakens security on iPhones. Automattic&#8217;s transparency blog explains why they&#8217;re siding with Apple:</p>\n<blockquote><p>Like Apple, we respect the rule of law, and honor the valid government orders we receive to furnish data in connection with criminal investigations. But deliberately weakening information security, as Apple has been asked to do here, is a step too far that makes everyone less safe.</p>\n<p>Undermining security measures – even in situations where there appear to be good intentions – will inevitably have unintended consequences for regular people.</p>\n<p>We stand with Apple in both condemning terrorism and defending the privacy and security of our users. If Automattic was faced with a government order like the one issued in San Bernadino, we, like Apple, would do everything within the law to challenge it. That’s why we’re joining with a sizable group of leading tech companies today to support Apple in this case.</p></blockquote>\n<p>If you&#8217;d like to learn more about why the court order is a terrible idea, check out the <a href=\"https://cloudup.com/iZG9vzAV3U3\">full legal brief</a> submitted by Automattic to the United States District Court.</p>\n<h2>The Ethics of Sharing GPL Code</h2>\n<p>Tom McFarlin shares his thoughts on working with clients, educating people, and <a href=\"https://tommcfarlin.com/sharing-gpl-code/\">sharing GPL code</a> from client projects. If you&#8217;re a consultant, how do you convince clients to give you permission to release code they pay for and you write to the public under the GPL?</p>\n<p>After reading the post, <a href=\"https://tommcfarlin.com/sharing-gpl-code/#comment-881900\">check out this comment</a> left by Darrinb.</p>\n<h2>Gravity Forms Becomes 2nd Gold Partner</h2>\n<p>Around this time last year, Scott Kingsley Clark <a href=\"http://wptavern.com/pods-lead-developer-scott-kingsley-clark-launches-friends-of-pods-funding-campaign\">launched a new sponsorship program</a> called Friends of Pods. The funding is used to decrease private development of Pods and focus more on Pods core, related plugins, and integrations. Gravity Forms, the popular form creation plugin created by Rocketgenius is the <a href=\"http://pods.io/2016/03/04/announcing-our-2nd-gold-partner-gravity-forms/\">second gold partner</a> in the program.</p>\n<p>In addition to the partnership news, the <a href=\"https://wordpress.org/plugins/pods-gravity-forms/\">Pods Gravity Forms add-on</a> is now available on the WordPress plugin directory.</p>\n<h2>ActiveDen is No More</h2>\n<p><a href=\"http://activeden.net/\">ActiveDen</a>, a site where people could sell Flash assets and was the first site in the Envato Marketplace has officially closed its doors. The company <a href=\"http://inside.envato.com/farewell-activeden/\">shut it down</a> in order to focus on things that have more impact.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/ActiveDenShutsDown.png\" rel=\"attachment wp-att-52052\"><img class=\"size-full wp-image-52052\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/ActiveDenShutsDown.png?resize=812%2C303\" alt=\"ActiveDen Shuts Down\" /></a>ActiveDen Shuts Down\n<p>To learn more about the history of ActiveDen, I encourage you to watch this 45 minute video featuring Collis Ta&#8217;eed where he talks about the first six months of Envato.</p>\n<div class=\"embed-wrap\"></div>\n<h2>SIDEKICK Partners With ThemeForest</h2>\n<p><a href=\"https://www.sidekick.pro/updates/sidekick-teams-themeforest/\">SIDEKICK announced</a> it is in a trial partnership with 19 ThemeForest authors. The partnership enables customers to view interactive tutorials from within the WordPress dashboard. According to the announcement, the test aims to alleviate some support pain for authors.</p>\n<h2>Calypso&#8217;s Contributor Code of Conduct</h2>\n<p>Codes of Conduct are not limited to events. Many open source projects have implemented them as a way to provide a base line of expectations from those who participate in the project. WordPress core contributor, Ryan Boren, shared a link to <a href=\"https://github.com/Automattic/wp-calypso/blob/master/CODE-OF-CONDUCT.md\">Calypso&#8217;s Code of Conduct</a> on Github which explains the expectations project maintainers have of contributors.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Open source contribution is onboarding flow 4 the future of work in a software eaten world. It has codes of conduct. <a href=\"https://t.co/isXa7S1WTh\">https://t.co/isXa7S1WTh</a></p>\n<p>&mdash; Ryan Boren (@rboren) <a href=\"https://twitter.com/rboren/status/705228769192079360\">March 3, 2016</a></p></blockquote>\n<p></p>\n<h2>Coen Jacobs on Bundling Libraries in WordPress</h2>\n<p>Coen Jacobs <a href=\"http://coenjacobs.me/2016/03/02/bundling-libraries-is-not-overhead-its-a-best-practice/\">explains why</a> bundling libraries is not overhead but a best practice. It&#8217;s another post in a series from Jacobs on the issue of handling dependencies in WordPress.</p>\n<h2>WordImpress and Media Temple Partnership</h2>\n<p>The WordImpress team <a href=\"https://wordimpress.com/announcing-wordimpres-media-temple-community-consultants/\">announced on its site</a> that it has partnered with Media Temple as WordPress Community Consultants. In exchange for information about customer needs, Media Temple is enabling the team to sponsor, attend, and speak at more WordCamps this year.</p>\n<h2>Happy Birthday Wapuu!</h2>\n<p>In what is a traditional part of this series, I end each issue featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project.</p>\n<p>In honor of <a href=\"http://wapuu.jp/2016/02/18/happy-birthday-wapuu/\">Wapuu&#8217;s recent birthday</a> which is February 19th, I present Birthday Wapuu. I hope you&#8217;ll join me in wishing Wapuu a happy birthday!</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/BirthdayWapuu.png\" rel=\"attachment wp-att-52054\"><img class=\"size-full wp-image-52054\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/BirthdayWapuu.png?resize=900%2C1000\" alt=\"Happy Birthday Wapuu\" /></a>Happy Birthday Wapuu\n<p>That&#8217;s it for issue three. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Mar 2016 20:12:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Akismet: Akismet WordPress Plugin 3.1.8 Now Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://blog.akismet.com/2016/03/04/akismet-wordpress-plugin-3-1-8-now-available/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1089:\"<p>Version 3.1.8 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is now available.</p>\n<p>This update improves compatibility with plugins that rewrite admin URLs. It also reduces the amount of space Akismet uses in the database and reduces the size of the Akismet API requests. A fix is also included for a bug that could have caused comment moderation emails to be sent for some comments that were caught as spam.</p>\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins directory</a>.</p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1905/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1905/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1905&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Mar 2016 17:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: Joshua Strebel Interviews Alex King 10 Days Before His Death\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52027\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://wptavern.com/joshua-strebel-interviews-alex-king-10-days-before-his-death\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1577:\"<p>In September of 2015, Joshua Strebel, founder of Pagely, <a href=\"http://pressnomics.com/2015/09/four-speakers-added-to-pn4/\">announced that Alex King</a> would be one of the speakers at Pressnomics 4, an annual conference devoted to the business aspects of WordPress. Unfortunately, days after the announcement, <a href=\"http://wptavern.com/alex-king-founder-of-crowd-favorite-passes-away\">King passed away</a> from colon cancer.</p>\n<p>Due to health reasons, King would not have been able to attend the event in person. Instead, Strebel flew to King&#8217;s house and <a href=\"http://pressnomics.com/2016/03/our-interview-with-alex-king/\">recorded a 40 minute bedside interview</a>. In the interview, which is edited beautifully, the duo discuss King&#8217;s career, lessons learned managing Crowd Favorite, and if Automattic is the empire, who fills the role of Darth Vader.</p>\n<div class=\"embed-wrap\"></div>\n<p>Jeff Matson who writes and maintains documentation for <a href=\"http://www.rocketgenius.com/\">Rocketgenius</a> and who&#8217;s attending the event, describes the crowd&#8217;s reaction after watching the interview, &#8220;Insightful and full of emotion, where a standing ovation was not only warranted, but mandatory. The crowd&#8217;s reaction truly showed how loved and respected Alex King was.&#8221;</p>\n<p>As I watched the interview, it was difficult not to cry. King passed away 10 days after it was recorded and even then, he had a sense of humor. King is survived by his wife Heather and his daughter Caitlin.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 22:21:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Roots Team Releases wp-password-bcrypt Plugin to Improve WordPress Password Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51913\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/roots-team-releases-wp-password-bcrypt-plugin-to-improve-wordpress-password-security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5264:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/passwords.jpg\" rel=\"attachment wp-att-52033\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/passwords.jpg?resize=1024%2C436\" alt=\"photo credit: Linux password file - (license)\" class=\"size-full wp-image-52033\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/132889348@N07/20538585283\">Linux password file</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>This week the <a href=\"https://roots.io/\" target=\"_blank\">Roots</a> development team released <a href=\"https://github.com/roots/wp-password-bcrypt\" target=\"_blank\">wp-password-bcrypt</a>, a plugin that uses <a href=\"https://en.wikipedia.org/wiki/Bcrypt\" target=\"_blank\">bcrypt</a> instead of <a href=\"https://en.wikipedia.org/wiki/MD5\" target=\"_blank\">MD5</a> password hashing. MD5&#8217;s known and exploited weaknesses have rendered it &#8220;cryptographically broken and unsuitable for further use,&#8221; according to the CMU Software Engineering Institute.</p>\n<p>In a <a href=\"https://roots.io/improving-wordpress-password-security/\" target=\"_blank\">post</a> announcing the plugin, Scott Walkinshaw explained why WordPress&#8217; default MD5 hashing function + salting is insecure:</p>\n<blockquote><p>MD5 is considered &#8220;broken&#8221; due to its collision vulnerability, but it’s broken more fundamentally for passwords: it’s too cheap and fast to calculate a hash.</p></blockquote>\n<p><a href=\"https://en.wikipedia.org/wiki/Bcrypt\" target=\"_blank\">bcrypt</a>, on the other hand, is much slower than MD5, making it more expensive to calculate. This stronger method of password hashing is built into PHP 5.5, but WordPress maintains 5.2.4 as its minimum required version. This precludes WordPress from using the newer password_hash function.</p>\n<p>Walkinshaw cites a four year old <a href=\"https://core.trac.wordpress.org/ticket/21022\" target=\"_blank\">ticket</a> which proposes a way for WordPress to allow plugin developers to more easily change from the salted MD5 method of hashing to the more secure bcrypt. James McKay left a sobering <a href=\"https://core.trac.wordpress.org/ticket/21022#comment:8\" target=\"_blank\">comment</a> on that ticket, advocating that WordPress core move to make bcrypt the default for environments that support it:</p>\n<blockquote><p>bcrypt needs to be made the default, out of the box option on all systems that support it. The idea that WordPress admins should have to go hunting for a plugin or tweak configuration options to do this scares me, simply because most of them won&#8217;t unless (a) they are well versed in web security, (b) they know that WordPress uses a weak alternative by default, and (c) they consider it to be an issue worth worrying about.</p>\n<p>People often underestimate the seriousness of MD5 and the SHA-* algorithms being &#8220;less secure.&#8221; They aren&#8217;t just less secure: thanks to developments in password cracking in the past few years using GPU- and FPGA- based software, they are <a href=\"https://codahale.com/how-to-safely-store-a-password/\" target=\"_blank\">totally useless</a>. Programs such as oclHashCat even have an option specifically to crack passwords in WordPress databases &#8212; and the rate at which they can do so is terrifying. If you&#8217;re not making a strong password hashing algorithm the default, out of the box option, you&#8217;re exposing your users to unacceptable and unnecessary risk.</p></blockquote>\n<p>Unfortunately, action on the ticket has been held up due to a UX issue. Discussion on the ticket continues, but contributors have not yet settled on a path for improvement.</p>\n<p>&#8220;So what is holding up the switch?&#8221; Walkinshaw said. &#8220;Bureaucracy and the unwillingness to make it happen. The consensus of the ticket is that it’s actually a UX problem. At this point, there is no technical reason why this can’t be done.&#8221;</p>\n<p>In the meantime, if you want to implement secure bcrypt hashed passwords, you can use the <a href=\"https://github.com/roots/wp-password-bcrypt\" target=\"_blank\">wp-password-bcrypt</a> plugin from the Roots team. It will protect against database compromises. If your WP database fell into the wrong hands, attackers would have a much more difficult time attempting to brute force a bcrypted password versus a MD5-based password.</p>\n<p>The plugin re-hashes user passwords with bcrypt when users log in. If a user never logs in, the password remains hashed with MD5. It can also be uninstalled without negative consequences. There are no settings &#8211; it simply works in the background.</p>\n<p>&#8220;We&#8217;ve purposely tried to keep the plugin as simple as possible so there are no surprises,&#8221; Walkinshaw said. &#8220;Obviously we recommend people test out the plugin first, and hopefully put it on a staging site first.&#8221;</p>\n<p>The plugin can be installed by automatically autoloading it with Composer or by manually copying wp-password-bcrypt.php into your mu-plugins folder. It will also soon be added to Roots&#8217; <a href=\"https://roots.io/bedrock/\" target=\"_blank\">Bedrock</a> project boilerplate to provide a more secure default.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 21:37:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WordPress Meetup Groups in Belfast and Dublin are Planning WordCamps for 2016 and 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51824\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://wptavern.com/wordpress-meetup-groups-in-belfast-and-dublin-are-planning-wordcamps-for-2016-and-2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4919:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/wordcamp-belfast.jpg\" rel=\"attachment wp-att-52003\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/wordcamp-belfast.jpg?resize=712%2C291\" alt=\"wordcamp-belfast\" class=\"aligncenter size-full wp-image-52003\" /></a></p>\n<p>The inaugural <a href=\"https://twitter.com/WCBelfast\" target=\"_blank\">WordCamp Belfast</a> and <a href=\"https://twitter.com/WordCampDublin\" target=\"_blank\">WordCamp Dublin</a> are now in the early stages of planning. Members of the WordPress Northern Ireland meetup group are collaborating with the Dublin meetup to organize an event in Belfast in September 2016 and one in Dublin in April 2017. The dates have not yet been set in stone but organizers are looking at venues and are gathering all the details and costs to begin work on a budget.</p>\n<p>&#8220;Ever since first setting up the WordPress Meetup group in January 2014, a WordCamp was always something that we wanted to see – when the time was right,&#8221; organizer Mark Smallman said. &#8220;Having had the meetup group running successfully for two years, and having been in communication with the Dublin group, we decided the time was right to explore the possibility of running a WordCamp.&#8221;</p>\n<p>John Walsh, co-organizer of the Dublin WordPress Meetup Group, has applied to be the lead organizer of WordCamp Dublin 2017.</p>\n<p>&#8220;The goal is to combine our resources and work together to achieve the common goal of bringing WordCamp to Dublin and to Belfast on an annual basis,&#8221; Walsh said. &#8220;Separately, we have a certain capability but by working together we can accomplish a lot more.&#8221;</p>\n<p>Since neither of the two groups has previously hosted or planned a WordCamp, Smallman said that it&#8217;s a steep learning curve for all of them.</p>\n<p>&#8220;It helps to have as many and as varied a range of skills as possible on-board to help us get to the summit,&#8221; Smallman said. &#8220;We hope that once we have #WCBelfast in full swing, some of the same organizing team members can either offer assistance to WordCamp Dublin or take on roles directly within their organizing team. This should help both WordCamps in terms of planning for the future.&#8221;</p>\n<p>Smallman said that if both WordCamps are a success, the teams will look at the possibility of alternating between Belfast and Dublin in future years.</p>\n<p>&#8220;Having a team that is spread over the two areas will also help to widen the net of possible speakers, sponsors and attendees for both WordCamps, hopefully helping to make both a success,&#8221; he said. &#8220;And who knows, possibly both will become regular events on the WordCamp calendar.&#8221;</p>\n<h3>The Wapuu of the North: Growing the Community Spirit in Belfast</h3>\n<p>Smallman and the organizing team hope the two WordCamps will help to validate and grow the unique WordPress communities on both sides of the border.</p>\n<p>&#8220;Belfast and Northern Ireland have a wide range of very skilled people in the I.T. sector,&#8221; he said. &#8220;But up until recently it was lacking when it comes to community spirit within the sector. Slowly, we have seen groups within the area grow and now we have thriving Blogging and PHP groups as well as many others.&#8221;</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/belfast_wapuu.jpg\" rel=\"attachment wp-att-52005\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/belfast_wapuu.jpg?resize=300%2C300\" alt=\"belfast_wapuu\" class=\"alignright size-medium wp-image-52005\" /></a>As an expression of community spirit, the Belfast organizing team has already created a wapuu mascot for the event.</p>\n<p>&#8220;The Wapuu of the North was generously created by Peter of <a href=\"http://1440design.com/wordpress/branding-wordcamp-belfast/\" target=\"_blank\">1440 Design</a> in Belfast,&#8221; Smallman said. &#8220;Peter works along side <a href=\"https://twitter.com/se_nelson\" target=\"_blank\">Sam Nelson</a> who is on our organizing team. Sam also created our #WCBelfast badge.</p>\n<p>&#8220;We chatted and bounced a few ideas around for a theme for the WordCamp,&#8221; he said. &#8220;Game of Thrones was a very obvious choice, and one that none of us could think of a better fit. Northern Ireland has no fewer than a dozen filming locations for the show. We all thought that we could not choose anyone better than the Wapuu of the North to deliver the message that the White Walkers (developers) were on their way!&#8221;</p>\n<p>Smallman said the team is excited about the venue they&#8217;ve selected for hosting Northern Ireland&#8217;s very first WordCamp.</p>\n<p>&#8220;With all being well, we really are planning something very special for our first WordCamp,&#8221; he said. &#8220;We cannot wait to get moving onto the next stage.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 10:00:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: BuddyPress 2.5.0 Released, Features Customizable Emails and Support for Emoji\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51957\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/buddypress-2-5-0-released-features-customizable-emails-and-support-for-emoji\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2990:\"<p>BuddyPress 2.5.0 &#8220;Medici&#8221; was <a href=\"https://buddypress.org/2016/03/buddypress-2-5-0/\" target=\"_blank\">released</a> today, named for <a href=\"http://www.medici57.com/\" target=\"_blank\">Medici on 57th</a>, a Chicago restaurant famous among BP contributors for its &#8220;Garbage Pizza.&#8221; The new <a href=\"https://codex.buddypress.org/emails/\" target=\"_blank\">BP Email API</a> is the highlight of the release. It allows users to edit BuddyPress emails in the admin and change their appearance in the customizer.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/bp-emails-feature.png\" rel=\"attachment wp-att-51979\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/bp-emails-feature.png?resize=1016%2C528\" alt=\"bp-emails-feature\" class=\"aligncenter size-full wp-image-51979\" /></a></p>\n<p>The placeholder text in curly braces, which is replaced with data in the emails, is called a &#8220;token.&#8221; All <a href=\"https://codex.buddypress.org/emails/email-tokens/\" target=\"_blank\">available email tokens</a> are listed in the codex. Since BP emails are simply a custom post type, plugin developers can easily hook into BuddyPress&#8217; email system and <a href=\"https://codex.buddypress.org/emails/custom-emails/\" target=\"_blank\">create new emails</a> that will be triggered by a specified action.</p>\n<p>This release also introduces long-awaited support for emoji, which can now be used in activity updates, messages, and group descriptions.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/bp-emoji.png\" rel=\"attachment wp-att-51988\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/bp-emoji.png?resize=844%2C387\" alt=\"bp-emoji\" class=\"aligncenter size-full wp-image-51988\" /></a></p>\n<p>Other highlights of BuddyPress 2.5 include:</p>\n<ul>\n<li><strong>Post Type Comments Tracking</strong> &#8211; Custom post types show in the activity stream and now, with the BuddyPress &#8220;Site Tracking&#8221; component enabled, replies to CPT-generated activity items will be synchronized with comments on the corresponding post.</li>\n<li><strong>Twenty Twelve Companion Stylesheet</strong> &#8211; BuddyPress now has basic styles that will make it fit in seamlessly when activated with the Twenty Twelve theme.</li>\n<li><strong>Autolink Settings for Profile Fields</strong> &#8211; BuddyPress profile fields can be autolinked to a search of the members directory using the field value as a search term. This release offers as new setting to enable or disable the autolinking on a per-field basis.</li>\n</ul>\n<p>34 volunteer contributors worked together to close 95 tickets for the <a href=\"https://buddypress.trac.wordpress.org/milestone/2.5\" target=\"_blank\">2.5 milestone</a>. For a full list of all the improvements and fixes, check out the <a href=\"https://buddypress.trac.wordpress.org/milestone/2.5\" target=\"_blank\">official 2.5.0 changelog</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 00:12:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: TGM Plugin Activation Library Contributors Work Toward Feature Plugin Proposal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51715\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/tgm-plugin-activation-library-contributors-work-toward-feature-plugin-proposal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6907:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/paper.jpg\" rel=\"attachment wp-att-51974\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/paper.jpg?resize=960%2C516\" alt=\"photo credit: Startup Stock Photos\" class=\"size-full wp-image-51974\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/AL0V4Q84GP\">Startup Stock Photos</a>\n<p>The team behind the <a href=\"http://tgmpluginactivation.com/\" target=\"_blank\">TGM Plugin Activation Library</a> (TGMPA) is working to propose it as a feature plugin for WordPress. Last July contributors on the project <a href=\"https://make.wordpress.org/core/2015/07/10/feature-plugin-chat-on-july-14/#comment-26310\" target=\"_blank\">opened the discussion</a> on a post calling for feature plugins, and the upcoming 3.0 version is being developed with this path in mind.</p>\n<p>Developers use TGMPA to manage dependencies between plugins and themes, as an alternative to bundling a heap of plugin-type functionality into one extension. It walks users through the process of installing plugin dependencies that are required or recommended by the developer. The library is used by 6% of WordPress.org themes as well as a large number of commercial products hosted on CodeCanyon and Themeforest.</p>\n<p>TGMPA will require a substantial rewrite in order to make it ready for consideration as a feature plugin. It also needs to be multisite compatible, address a number of usability issues, and be trimmed of extra features to become leaner and more core friendly.</p>\n<p>The team behind the project has a <a href=\"https://docs.google.com/forms/d/1dGb8s2poPWbCGPBPLn5sDDxSulNRYit7vF_-rsk5V6M/viewform?c=0&w=1\" target=\"_blank\">survey</a> open to solicit opinions from the community regarding the implementation of these changes. A few sample considerations from the survey include:</p>\n<ul>\n<li>What method should the plugin use to supply dependency information to multisite independently of whether a theme or plugin is active?</li>\n<li>How should the plugin deal with themes and plugins which haven&#8217;t yet upgraded to the newer version of TGMPA?</li>\n<li>Should the plugin support plugin download sources other than wordpress.org?</li>\n</ul>\n<p>&#8220;To me it feels like we need more core team support for it to be properly considered for feature plugin status, so some lobbying behind the scenes is in order,&#8221; TGMPA lead developer <a href=\"https://twitter.com/jrf_nl\" target=\"_blank\">Juliette Reinders Folmer</a> told the Tavern. &#8220;The survey is also part of this as that will give us hard data to use in the discussions.&#8221;</p>\n<h3>The Future of TGMPA Is a More Modular Architecture</h3>\n<p>Folmer said that regardless of whether TGMPA is approved to become a feature plugin, future development will continue with core in mind.</p>\n<p>&#8220;Development for v3 will be a lot more modular,&#8221; Folmer said. &#8220;TGMPA currently is effectively one file with four classes. That makes it easy to include it in themes and plugins (one file), but not as easy to maintain. As v3 will contain some big changes, this seems like a good point in time to change the structure of TGMPA as well.&#8221;</p>\n<p>With a more modular approach in place, Folmer said that the team plans to split the package into a number of different repositories for development purposes. She has tentatively identified features that would be offered in the core module, and everything else would be supported via add-on modules, i.e.:</p>\n<ul>\n<li>support for bundled plugins</li>\n<li>support for non-wp.org download urls</li>\n<li>support for recommended plugins</li>\n</ul>\n<p>TGMPA would also introduce two wrappers &#8211; each would function as a layer that will load all the available modules:</p>\n<ul>\n<li>one for continued support for including TGMPA in plugins and themes</li>\n<li>one for TGMPA as a feature plugin</li>\n</ul>\n<p>&#8220;So no matter what will be decided concerning whether TGMPA will be allowed to become a feature plugin, support for the features of TGMPA as is (but better) will be continued,&#8221; Folmer said.</p>\n<p>&#8220;With the modular development, it won&#8217;t be as easy anymore to download &#8216;TGMPA&#8217; from GitHub, as you&#8217;d need to download all the different modules (or use composer / use git submodules),&#8221; she said. &#8220;I envision the <a href=\"http://wptavern.com/tgm-plugin-activation-team-releases-custom-generator\" target=\"_blank\">Custom TGMPA Generator</a> to be the way forward for downloading TGMPA as a complete package in that respect.&#8221;</p>\n<h3>Can TGMPA Gain Enough Support from Core Developers to Become a Feature Plugin?</h3>\n<p>Folmer said that the WordPress core developers she has spoken with are divided on whether on whether its current approach makes it a good candidate for a feature plugin.</p>\n<p>During <a href=\"https://github.com/TGMPA/TGM-Plugin-Activation/issues/447\" target=\"_blank\">preliminary discussions on GitHub</a>, WordPress core committer <a href=\"http://pento.net/\" target=\"_blank\">Gary Pendergast</a> expressed reservations about requiring too much user interaction during the process.</p>\n<p>&#8220;The primary goal of plugin dependencies should be that it&#8217;s invisible to the user,&#8221; Pendergast said. &#8220;If there&#8217;s ever a point where the user is asked to make a decision, then it&#8217;s not ready for core.</p>\n<p>&#8220;I&#8217;ve had a quick read through the TGMPA code,&#8221; he said. &#8220;I think it&#8217;s solving the problem it needed to solve (providing a drop-in library for themes and plugins), but I think we&#8217;d need to tie it much more tightly into core for it to be a feature plugin.&#8221;</p>\n<p>Folmer hopes to address user experience concerns with refinements to the plugin based on feedback from the survey, which will be open until the end of March.</p>\n<p>&#8220;So far, most responses have been from developers using TGMPA,&#8221; she said. &#8220;Even though the survey is quite technical, we would very much also like to hear from more end-users.&#8221;</p>\n<p>With the recent confusion over WordPress.org&#8217;s previously unwritten rule <a href=\"http://wptavern.com/the-wordpress-plugin-directory-will-no-longer-accept-frameworks\" target=\"_blank\">banning framework plugins from the official directory</a>, the challenge of managing inter-plugin dependencies is under the spotlight again. The TGM Plugin Activation library isn&#8217;t the only possible solution to this problem, but it does have a motivated contributor base that is willing to take up the challenge of solving this problem via a feature plugin. If you want to be part of shaping the roadmap for version 3, make sure to <a href=\"https://docs.google.com/forms/d/1dGb8s2poPWbCGPBPLn5sDDxSulNRYit7vF_-rsk5V6M/viewform?c=0&w=1\" target=\"_blank\">fill out the survey</a> before April 1.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Mar 2016 20:16:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: The WordPress Plugin Directory Will No Longer Accept Frameworks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51927\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/the-wordpress-plugin-directory-will-no-longer-accept-frameworks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5925:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/sockets.jpg\" rel=\"attachment wp-att-51946\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/sockets.jpg?resize=960%2C476\" alt=\"photo credit: Jaroslaw Puszczyński\" class=\"size-full wp-image-51946\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/M07SV6AMBD\">Jaroslaw Puszczyński</a>\n<p>Today the WordPress plugin review team issued a reminder for what they said is a long-standing, unwritten rule: frameworks are not allowed in the official directory. In a post tiled &#8220;<a href=\"https://make.wordpress.org/plugins/2016/03/01/please-do-not-submit-frameworks/\" target=\"_blank\">Please do not submit frameworks</a>,&#8221; Mika Epstein outlined the reason behind the rule:</p>\n<blockquote><p>At this time, we are not accepting frameworks as we don’t feel frameworks, boilerplates, and libraries are appropriate for the Plugins Directory. We require that plugins be useful in and of themselves (even if only being a portal to an external service). And while there are many benefits to frameworks and libraries, without plugin dependency support in core or the directory, it becomes another level of hassle for users.</p></blockquote>\n<p>Until WordPress core adopts a way to support plugin dependencies, the plugin review team recommends that frameworks and libraries be packaged with each plugin in a way that doesn&#8217;t conflict with other plugins/frameworks/libraries.</p>\n<p>The issue was most recently addressed with the <a href=\"https://wordpress.org/plugins/cmb2/\" target=\"_blank\">CMB2</a> plugin, which Epstein said was <a href=\"https://make.wordpress.org/plugins/2016/02/25/re-thinking-tags-in-the-plugin-directory/#comment-42655\" target=\"_blank\">mistakenly approved months ago.</a> CMB2 is essentially a library that makes it easy for developers to build metaboxes, custom fields, and forms. It is exactly the kind of plugin that the previously unwritten rule is meant to block from being available in the official directory. Epstein further clarified the reasons why:</p>\n<blockquote><p>The issue is as follows: Having a framework as a plugin is a poor experience for the user. Not the developer. The user. The user understands “I have an add-on for WooCommerce, I probably need Woo.” They do not always understand “I have plugin Slider Joe. Why do I need Advanced Custom Fields?” In addition, by having a library as a plugin, the onus of version compatibility is now on the person least likely to understand it: the user.</p>\n<p>The plugin repository is not, currently, a library or framework repository. It’s not meant like the NPM package manager, or even Composer as a way to define what a plugin ‘needs’ in the same ways for a developer to build a project. The plugin repository is, plain and simple, meant for plugins that users will find useful. Plugins that add functionality to WordPress in a directly inter-actable way.\n</p></blockquote>\n<p>The confusion lies in the fact that this particular rule has been applied inconsistently for years and has many notable exceptions, including <a href=\"https://wordpress.org/plugins/redux-framework/\" target=\"_blank\">Redux Framework</a>, <a href=\"https://wordpress.org/plugins/cmb2/\" target=\"_blank\">CMB2</a>, and arguably plugins like <a href=\"https://wordpress.org/plugins/piklist/\" target=\"_blank\">Piklist</a>, <a href=\"https://wordpress.org/plugins/titan-framework/\" target=\"_blank\">Titan Framework</a>, <a href=\"https://wordpress.org/plugins/kirki/\" target=\"_blank\">Kirki</a>, <a href=\"https://wordpress.org/plugins/options-framework/\" target=\"_blank\">Options Framework</a>, and many more. These are the types of plugins that don&#8217;t really do anything out of the box but are meant for developers to use for building things.</p>\n<p>According to Epstein, a few of these plugins have been &#8220;grandfathered in&#8221; due to oversights in the plugin review process, but the rule stands for new submissions.</p>\n<p>&#8220;CMB2 and Redux Framework are grandfathered in,&#8221; she <a href=\"https://make.wordpress.org/plugins/2016/02/25/re-thinking-tags-in-the-plugin-directory/#comment-42655\" target=\"_blank\">said</a>. &#8220;We don’t let any more in, since a lot of plugins include them inside AS plugins. It’s a mess. Also CMB2 shouldn’t have been approved, which is a different mess altogether. Frameworks are not supposed to be in the repo at this time. Period.&#8221;</p>\n<p>Another commenter on the most recent post, who recently had his <a href=\"https://wordpress.org/plugins/advanced-term-fields/\" target=\"_blank\">Advanced Term Fields</a> plugin approved, asked, <strong>&#8220;Are you saying the best way to handle this scenario is to include the parent framework in each child plugin, as opposed to alerting the user that &#8216;This plugin requires XXX plugin in order to function properly?\'&#8221;</strong></p>\n<p>Epstein confirmed that this is in fact what the team is suggesting:</p>\n<blockquote><p>Currently, yes. That would have been the best way. Since your plugin is approved, though, it’s unfair of us to yank the rug out from under you. While you don’t have a great many users, we recognize when the gaff is us.</p></blockquote>\n<p>The plugin review team has a difficult job and is working with limited volunteer resources. However, the inconsistent application of unwritten rules has led to what appears to be an arbitrary set of guidelines. One thing that would make life easier for both reviewers and plugin developers is if WordPress core adopted a way to manage inter-plugin dependencies. <a href=\"http://tgmpluginactivation.com/\" target=\"_blank\">The TGM Plugin Activation</a> team is <a href=\"https://github.com/TGMPA/TGM-Plugin-Activation/issues/447\" target=\"_blank\">working on a proposal for a feature plugin</a>, which we&#8217;ll examine in depth in an upcoming post.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Mar 2016 00:49:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Poetica Acquired by Condé Nast, Open Source WordPress Plugin Will Be Discontinued\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"http://wptavern.com/poetica-acquired-by-conde-nast-open-source-wordpress-plugin-will-be-discontinued\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3293:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/poetica.png\" rel=\"attachment wp-att-51905\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/poetica.png?resize=1025%2C520\" alt=\"poetica\" class=\"aligncenter size-full wp-image-51905\" /></a></p>\n<p>Poetica <a href=\"https://blog.poetica.com/2016/03/01/our-next-chapter/\" target=\"_blank\">announced</a> today that its team and technology have been acquired by Condé Nast. The technology provided realtime &#8220;Google-docs style collaboration&#8221; in the WordPress post editor as well as a non-WordPress editor available via the public <a href=\"https://poetica.com/\" target=\"_blank\">Poetica.com</a> service. As of June 1, 2016, the service will be shut down.</p>\n<p>The Poetica team will continue to develop the technology as part of <a href=\"http://learn.copilot.conde.io/\" target=\"_blank\">Copilot</a>, Condé Nast’s proprietary publishing platform.</p>\n<p>According to CTO and co-founder Blaine Cook, <a href=\"https://twitter.com/blaine/status/704738953321013253\" target=\"_blank\">development on the open source plugin will be discontinued</a>, as the plugin is dependent on the Poetica service. Those who have been using the plugin will have no choice but to find an alternative.</p>\n<p>WordPress isn&#8217;t well-equipped for content collaboration. In fact, thanks to its fancy <a href=\"https://codex.wordpress.org/Post_Locking\" target=\"_blank\">post locking</a> feature, WordPress is streamlined to enable the opposite of a collaborative editorial workflow. It&#8217;s designed for one user to work on a post while locking all other users out.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2013/09/post-locking.png\" rel=\"attachment wp-att-9350\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2013/09/post-locking.png?resize=715%2C231\" alt=\"post-locking\" class=\"aligncenter size-full wp-image-9350\" /></a></p>\n<p>Additionally, after a post is published, no further collaboration can be made, as the only way to make edits is to push changes immediately to the live copy.</p>\n<p>Poetica was one of the few tools that provided a way for editorial teams to write together, allowing multiple WordPress users to view and edit content at the same time. The plugin tracked changes and allowed users to make suggested edits that could be accepted or rejected.</p>\n<p>Although Poetica provided a much-needed collaboration tool for WordPress, its founders said they were unable to create a profitable business model around the software:</p>\n<blockquote><p>Up until now, though, we’ve been a small five-person team. We’ve tackled the dual problems of creating a humane, intuitive, and collaborative way to interact with text, on any device and any content platform; and the parallel challenge of creating a viable business model. Unfortunately, these goals were often at odds with each-other, competing for our limited time and attention.</p></blockquote>\n<p>After Poetica.com is shut down, it will destroy any drafts and user data from the site, as Condé Nast has only acquired the software and not the user data. Users will soon be notified via email about how to download a full archive of their drafts ahead of the June 1st shutdown.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Mar 2016 19:38:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: aXe: An Open Source JavaScript Library for Automating Accessibility Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51876\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/axe-an-open-source-javascript-library-for-automating-accessibility-testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4883:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/02/axe-logo.jpg\" rel=\"attachment wp-att-51880\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/02/axe-logo.jpg?resize=780%2C366\" alt=\"axe-logo\" class=\"aligncenter size-full wp-image-51880\" /></a></p>\n<p>In June 2015 <a href=\"http://www.deque.com/\" target=\"_blank\">Deque</a>, an accessibility consultancy, open sourced <a href=\"https://github.com/dequelabs/axe-core\" target=\"_blank\">aXe</a>, its accessibility rules engine for automated web UI testing. aXe is a compact JavaScript library (~100 KB) that executes automated accessibility tests inside your testing framework or browser. Deque outlined a number of advantages that the aXe library has over previous approaches to automated testing of HTML-based user interfaces:</p>\n<ul>\n<li>It works on all modern browsers</li>\n<li>It supports in-memory fixtures, static fixtures, integration tests and iframes of infinite depth</li>\n<li>It has zero false positives (bugs notwithstanding)</li>\n<li>It is open source</li>\n<li>It is actively supported by a major accessibility vendor</li>\n<li>It is designed to work with whatever tools, frameworks, libraries and environments you have today</li>\n<li>It is designed to be integrated into your existing functional/acceptance automated tests</li>\n<li>It automatically determines which rules to run based on the evaluation context</li>\n<li>It is highly configurable</li>\n</ul>\n<p>aXe integrates with Karma, QUnit, Jasmine, Mocha, PhantomJS, and many others &#8211; basically any testing framework that supports JavaScript execution.</p>\n<h3>aXe Extension Adds Accessibility Testing to Chrome Developer Tools</h3>\n<p>If you&#8217;re not using automated testing tools in your projects, the Chrome developer tools extension is the easiest gateway to performing accessibility tests directly in the browser as you&#8217;re viewing or building a website or application.</p>\n<p>aXe is available as a <a href=\"https://chrome.google.com/webstore/detail/axe/lhdoppojpmngadmnindnejefpokejbdd\" target=\"_blank\">free extension from the Chrome web store</a>. (Alternatively, it&#8217;s also available as an <a href=\"https://addons.mozilla.org/en-us/firefox/addon/axe-devtools/?src=search&utm_campaign=aXe%20The%20Accessibility%20Engine&utm_content=aXe%20for%20Firefox&utm_medium=Hyperlink&utm_source=Website\" target=\"_blank\">add-on for Firefox</a>.) Once you click &#8220;Add to Chrome,&#8221; aXe will be available under its own tab in Chrome DevTools panel. It automatically ferrets out accessibility defects and offers details for each violation.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/02/axe-on-wordpressorg.png\" rel=\"attachment wp-att-51879\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/02/axe-on-wordpressorg.png?resize=1025%2C583\" alt=\"axe-on-wordpressorg\" class=\"aligncenter size-full wp-image-51879\" /></a></p>\n<p>The creators of aXe were invited to contribute the open source library to the <a href=\"http://www.w3.org/WAI/ER/2015/draft-charter-3\" target=\"_blank\">W3C WAI Evaluation and Repair Tools Working Group</a>, as the group works to develop a normative set of rules for evaluating <a href=\"https://www.w3.org/TR/WCAG20/\" target=\"_blank\">WCAG 2.0</a> conformance.</p>\n<p>If you&#8217;re working on improving WordPress&#8217; accessibility, the aXe extension can even help perform some of the <a href=\"https://make.wordpress.org/accessibility/handbook/testing/how-to-test-for-accessibility/\" target=\"_blank\">tests recommended by the Accessibility team</a>. You can log issues by <a href=\"https://make.wordpress.org/core/handbook/reporting-bugs/\" target=\"_blank\">creating a ticket on WordPress Trac</a> or testing patches for existing tickets.</p>\n<p>In 2014 the Accessibility team <a href=\"https://make.wordpress.org/accessibility/2014/05/02/automated-accessibility-testing/\" target=\"_blank\">discussed adding automated accessibility testing to WordPress</a>, with Quail.js as one of the frontrunners. The team is just now <a href=\"http://wptavern.com/your-chance-to-give-feedback-on-wordpress-accessibility-coding-standards\" target=\"_blank\">adding accessibility code standards to the WordPress core handbook</a>. The next step would be firming up a list of requirements for an automated testing tool. aXe might be a new possibility to consider, as it is open source and focused on helping websites meet WCAG 2.0 requirements.</p>\n<p>Deque&#8217;s mission with aXe is to bring equality to the digital world. They are working to make automated accessibility testing more mainstream with professional web developers. If accessibility is a priority for your work, <a href=\"https://github.com/dequelabs/axe-core\" target=\"_blank\">aXe</a> is a lightweight library you may want to consider for automated testing on own projects.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Mar 2016 01:11:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Stripe Payment Gateway for WooCommerce Is Now Available for Free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=51757\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/stripe-payment-gateway-for-woocommerce-is-now-available-for-free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2694:\"<p>Last week WooCommerce announced on Twitter that its <a href=\"https://www.woothemes.com/products/stripe/\" target=\"_blank\">Stripe payment gateway</a> is now a free product. Prior to this decision, it was priced at $79 for a single license, $99 for up to five sites, and $199 for up to 25 sites.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Exciting product announcement from <a href=\"https://twitter.com/stripe\">@stripe</a> (which is also now free for WooCommerce, woo!) <a href=\"https://t.co/kQet52WMbn\">https://t.co/kQet52WMbn</a> <a href=\"https://t.co/PzCRoyrgWG\">pic.twitter.com/PzCRoyrgWG</a></p>\n<p>&mdash; WooCommerce (@WooCommerce) <a href=\"https://twitter.com/WooCommerce/status/702809439271821312\">February 25, 2016</a></p></blockquote>\n<p></p>\n<p>The news coincides with the debut of Stripe&#8217;s new <a href=\"https://stripe.com/atlas\" target=\"_blank\">Atlas</a> product, which allows foreign companies to incorporate as a U.S. company in Delaware, set up a U.S. bank account, and accept payments with Stripe. Atlas was created to help entrepreneurs start global businesses no matter where they are located in the world.</p>\n<p>Automattic had a similar aim of lowering the barrier to entry for WooCommerce when it made the Stripe payment gateway available for free.</p>\n<p>&#8220;Receiving payments is integral to running an online store,&#8221; WooCommerce Product Team Lead Matty Cohen said. &#8220;Publishing the WooCommerce Stripe integration for free is one way we are helping merchants to get their stores set up quicker, and to easily receive credit card payments through their stores.</p>\n<p>&#8220;One of our focuses is to lower the barrier to entry and to assist WooCommerce stores in becoming successful,&#8221; Cohen said. &#8220;We are excited to be partners in making payment processing globally available for WooCommerce merchants.&#8221;</p>\n<p>Over the past two years, Stripe has been working to expand its services beyond the handful of countries it initially supported in the US and Europe. Although Stripe is increasingly popular, it cannot yet be considered a global option for accepting payments. It&#8217;s currently in <a href=\"https://support.stripe.com/questions/what-countries-does-stripe-support\" target=\"_blank\">private beta</a> for businesses in Brazil, Mexico, Portugal, Singapore, and Switzerland.</p>\n<p>Products like Atlas, in combination with the free gateway available from WooCommerce, should serve to bring Stripe availability to more locations around the world. WooCommerce representatives would not comment on whether Automattic is planning on offering more payment gateweys for free.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Feb 2016 19:27:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 18 Mar 2016 18:59:03 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"243007\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Fri, 18 Mar 2016 18:30:14 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20150326220540\";}", "no");
INSERT INTO `wp_options` VALUES("33382", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1458370743", "no");
INSERT INTO `wp_options` VALUES("33383", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1458327543", "no");
INSERT INTO `wp_options` VALUES("33384", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1458370744", "no");
INSERT INTO `wp_options` VALUES("33385", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 18:39:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"The most downloaded plugin for WordPress (almost 30 million downloads). Use All in One SEO Pack to automatically optimize your site for Search Engines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 14 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Protect your WordPress site by hiding vital areas of your site, protecting access to important files, preventing brute-force login attempts, detecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical user experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 18 Mar 2016 18:59:04 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Fri, 18 Mar 2016 19:14:51 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Fri, 18 Mar 2016 18:39:51 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20150326220540\";}", "no");
INSERT INTO `wp_options` VALUES("33386", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1458370744", "no");
INSERT INTO `wp_options` VALUES("33387", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1458327544", "no");
INSERT INTO `wp_options` VALUES("33388", "_transient_timeout_plugin_slugs", "1458418433", "no");
INSERT INTO `wp_options` VALUES("33389", "_transient_plugin_slugs", "a:20:{i:0;s:17:\"booked/booked.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:33:\"duplicate-post/duplicate-post.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:39:\"easy-theme-and-plugin-upgrades/init.php\";i:5;s:34:\"envato-wordpress-toolkit/index.php\";i:6;s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";i:7;s:9:\"hello.php\";i:8;s:35:\"insert-headers-and-footers/ihaf.php\";i:9;s:19:\"jetpack/jetpack.php\";i:10;s:27:\"LayerSlider/layerslider.php\";i:11;s:29:\"mailchimp-wp/mailchimp-wp.php\";i:12;s:40:\"mojo-marketplace-hg/mojo-marketplace.php\";i:13;s:38:\"recent-tweets-widget/recent-tweets.php\";i:14;s:23:\"revslider/revslider.php\";i:15;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:16;s:41:\"wordpress-importer/wordpress-importer.php\";i:17;s:27:\"js_composer/js_composer.php\";i:18;s:27:\"wp-super-cache/wp-cache.php\";i:19;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO `wp_options` VALUES("33390", "_transient_timeout_dash_88ae138922fe95674369b1cb3d215a2b", "1458370744", "no");
INSERT INTO `wp_options` VALUES("33391", "_transient_dash_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\'>WordPress 4.5 Beta 4</a> <span class=\"rss-date\">March 17, 2016</span><div class=\"rssSummary\">WordPress 4.5 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wptavern.com/is-w3c-replicating-the-wordpress-pingback-system\'>WPTavern: Is W3C Replicating the WordPress Pingback System?</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/cory-miller-and-pippin-williamson-discuss-the-importance-of-mental-health-on-office-hours-podcast\'>WPTavern: Cory Miller and Pippin Williamson Discuss the Importance of Mental Health on Office Hours Podcast</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/wpforms-aims-to-be-the-most-beginner-friendly-forms-plugin-for-wordpress\'>WPTavern: WPForms Aims to be the Most Beginner Friendly Forms Plugin for WordPress</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/siteorigin-panels/\' class=\'dashboard-news-plugin-link\'>Page Builder by SiteOrigin</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=siteorigin-panels&amp;_wpnonce=afc8554417&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Page Builder by SiteOrigin\'>Install</a>)</span></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("33410", "_site_transient_timeout_security_report_performed_recently", "1458332593", "yes");
INSERT INTO `wp_options` VALUES("33411", "_site_transient_security_report_performed_recently", "1", "yes");
INSERT INTO `wp_options` VALUES("33414", "_transient_timeout_wpseo-dashboard-totals", "1458418096", "no");
INSERT INTO `wp_options` VALUES("33415", "_transient_wpseo-dashboard-totals", "a:1:{i:0;a:1:{i:3;a:5:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"title\";s:27:\"Posts without focus keyword\";s:5:\"class\";s:15:\"wpseo-glance-na\";s:10:\"icon_class\";s:2:\"na\";s:5:\"count\";s:1:\"4\";}}}", "no");
INSERT INTO `wp_options` VALUES("33416", "_site_transient_timeout_ghu-1eda13567dd0e7ce35b07e674764d1ef", "1458335374", "yes");
INSERT INTO `wp_options` VALUES("33417", "_site_transient_ghu-1eda13567dd0e7ce35b07e674764d1ef", "O:8:\"stdClass\":12:{s:4:\"name\";s:20:\"mojo-marketplace.php\";s:4:\"path\";s:20:\"mojo-marketplace.php\";s:3:\"sha\";s:40:\"31cc1212225e89c3653552d60226942ce32f2488\";s:4:\"size\";i:1956;s:3:\"url\";s:112:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contents/mojo-marketplace.php?ref=hg-production\";s:8:\"html_url\";s:94:\"https://github.com/mojoness/mojo-marketplace-wp-plugin/blob/hg-production/mojo-marketplace.php\";s:7:\"git_url\";s:115:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/blobs/31cc1212225e89c3653552d60226942ce32f2488\";s:12:\"download_url\";s:104:\"https://raw.githubusercontent.com/mojoness/mojo-marketplace-wp-plugin/hg-production/mojo-marketplace.php\";s:4:\"type\";s:4:\"file\";s:7:\"content\";s:2652:\"PD9waHAKLyoKUGx1Z2luIE5hbWU6IE1PSk8gTWFya2V0cGxhY2UKRGVzY3Jp\ncHRpb246IFRoaXMgcGx1Z2luIGFkZHMgc2hvcnRjb2Rlcywgd2lkZ2V0cywg\nYW5kIHRoZW1lcyB0byB5b3VyIFdvcmRQcmVzcyBzaXRlLgpWZXJzaW9uOiAw\nLjcuNApBdXRob3I6IE1pa2UgSGFuc2VuCkF1dGhvciBVUkk6IGh0dHA6Ly9t\naWtlaGFuc2VuLm1lP3V0bV9jYW1wYWlnbj1wbHVnaW4mdXRtX3NvdXJjZT1t\nb2pvX3dwX3BsdWdpbgpMaWNlbnNlOiBHUEx2MiBvciBsYXRlcgpMaWNlbnNl\nIFVSSTogaHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzL2dwbC0yLjAuaHRt\nbApHaXRIdWIgUGx1Z2luIFVSSTogbW9qb25lc3MvbW9qby1tYXJrZXRwbGFj\nZS13cC1wbHVnaW4KR2l0SHViIEJyYW5jaDogcHJvZHVjdGlvbgoqLwoKLy8g\nRG8gbm90IGFjY2VzcyBmaWxlIGRpcmVjdGx5IQppZiAoICEgZGVmaW5lZCgg\nJ1dQSU5DJyApICkgeyBkaWU7IH0KCmRlZmluZSggJ01NX0JBU0VfRElSJywg\ncGx1Z2luX2Rpcl9wYXRoKCBfX0ZJTEVfXyApICk7CmRlZmluZSggJ01NX0JB\nU0VfVVJMJywgcGx1Z2luX2Rpcl91cmwoIF9fRklMRV9fICkgKTsKZGVmaW5l\nKCAnTU1fQVNTRVRTX1VSTCcsICdodHRwczovL3d3dy5tb2pvbWFya2V0cGxh\nY2UuY29tL21vam8tcGx1Z2luLWFzc2V0cy8nICk7CgppZiAoIGZpbGVfZXhp\nc3RzKCBNTV9CQVNFX0RJUiAuICdpbmMvYnJhbmQucGhwJyApICkgewoJcmVx\ndWlyZV9vbmNlKCBNTV9CQVNFX0RJUiAuICdpbmMvYnJhbmQucGhwJyApOwp9\nCnJlcXVpcmVfb25jZSggTU1fQkFTRV9ESVIgLiAnaW5jL2Jhc2UucGhwJyAp\nOwpyZXF1aXJlX29uY2UoIE1NX0JBU0VfRElSIC4gJ2luYy9jaHVybi5waHAn\nICk7CnJlcXVpcmVfb25jZSggTU1fQkFTRV9ESVIgLiAnaW5jL21lbnUucGhw\nJyApOwpyZXF1aXJlX29uY2UoIE1NX0JBU0VfRElSIC4gJ2luYy9zaG9ydGNv\nZGUtZ2VuZXJhdG9yLnBocCcgKTsKcmVxdWlyZV9vbmNlKCBNTV9CQVNFX0RJ\nUiAuICdpbmMvbW9qby10aGVtZXMucGhwJyApOwpyZXF1aXJlX29uY2UoIE1N\nX0JBU0VfRElSIC4gJ2luYy9zdHlsZXMucGhwJyApOwpyZXF1aXJlX29uY2Uo\nIE1NX0JBU0VfRElSIC4gJ2luYy9wbHVnaW4tc2VhcmNoLnBocCcgKTsKcmVx\ndWlyZV9vbmNlKCBNTV9CQVNFX0RJUiAuICdpbmMvamV0cGFjay5waHAnICk7\nCnJlcXVpcmVfb25jZSggTU1fQkFTRV9ESVIgLiAnaW5jL3VzZXItZXhwZXJp\nZW5jZS10cmFja2luZy5waHAnICk7CnJlcXVpcmVfb25jZSggTU1fQkFTRV9E\nSVIgLiAnaW5jL25vdGlmaWNhdGlvbnMucGhwJyApOwpyZXF1aXJlX29uY2Uo\nIE1NX0JBU0VfRElSIC4gJ2luYy9zcGFtLXByZXZlbnRpb24ucGhwJyApOwpy\nZXF1aXJlX29uY2UoIE1NX0JBU0VfRElSIC4gJ2luYy91cGRhdGVzLnBocCcg\nKTsKcmVxdWlyZV9vbmNlKCBNTV9CQVNFX0RJUiAuICdpbmMvY29taW5nLXNv\nb24ucGhwJyApOwpyZXF1aXJlX29uY2UoIE1NX0JBU0VfRElSIC4gJ2luYy90\nZXN0cy5waHAnICk7CnJlcXVpcmVfb25jZSggTU1fQkFTRV9ESVIgLiAnaW5j\nL2VkaXRvci1wcm9tcHQucGhwJyApOwptbV9yZXF1aXJlKCBNTV9CQVNFX0RJ\nUiAuICdpbmMvc3NvLnBocCcgKTsKCmlmICggJ3F1aWNraW5zdGFsbCcgPT0g\nZ2V0X29wdGlvbiggJ21tX2JyYW5kJyApIHx8IG1tX2pldHBhY2tfYmx1ZWhv\nc3Rfb25seSgpICkgewoJbW1fcmVxdWlyZSggTU1fQkFTRV9ESVIgLiAndmVu\nZG9yL2pldHBhY2svamV0cGFjay1vbmJvYXJkaW5nL2pldHBhY2stb25ib2Fy\nZGluZy5waHAnICk7Cn0KCmlmICggbW1famV0cGFja19ibHVlaG9zdF9vbmx5\nKCkgKSB7CgltbV9yZXF1aXJlKCBNTV9CQVNFX0RJUiAuICd2ZW5kb3IvamV0\ncGFjay9qZXRwYWNrLW9uYm9hcmRpbmctdHJhY2tzL2pldHBhY2stb25ib2Fy\nZGluZy10cmFja3MucGhwJyApOwp9CgptbV9yZXF1aXJlKCBNTV9CQVNFX0RJ\nUiAuICd1cGRhdGVyLnBocCcgKTsK\n\";s:8:\"encoding\";s:6:\"base64\";s:6:\"_links\";O:8:\"stdClass\":3:{s:4:\"self\";s:112:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contents/mojo-marketplace.php?ref=hg-production\";s:3:\"git\";s:115:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/blobs/31cc1212225e89c3653552d60226942ce32f2488\";s:4:\"html\";s:94:\"https://github.com/mojoness/mojo-marketplace-wp-plugin/blob/hg-production/mojo-marketplace.php\";}}", "yes");
INSERT INTO `wp_options` VALUES("33418", "_site_transient_timeout_ghu-aca1a99da826e8036f3bd23a2dafb4ea", "1458335375", "yes");
INSERT INTO `wp_options` VALUES("33419", "_site_transient_ghu-aca1a99da826e8036f3bd23a2dafb4ea", "O:8:\"stdClass\":3:{s:11:\"total_count\";i:1;s:18:\"incomplete_results\";b:0;s:5:\"items\";a:1:{i:0;O:8:\"stdClass\":69:{s:2:\"id\";i:16290496;s:4:\"name\";s:26:\"mojo-marketplace-wp-plugin\";s:9:\"full_name\";s:35:\"mojoness/mojo-marketplace-wp-plugin\";s:5:\"owner\";O:8:\"stdClass\":17:{s:5:\"login\";s:8:\"mojoness\";s:2:\"id\";i:1278255;s:10:\"avatar_url\";s:51:\"https://avatars.githubusercontent.com/u/1278255?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:37:\"https://api.github.com/users/mojoness\";s:8:\"html_url\";s:27:\"https://github.com/mojoness\";s:13:\"followers_url\";s:47:\"https://api.github.com/users/mojoness/followers\";s:13:\"following_url\";s:60:\"https://api.github.com/users/mojoness/following{/other_user}\";s:9:\"gists_url\";s:53:\"https://api.github.com/users/mojoness/gists{/gist_id}\";s:11:\"starred_url\";s:60:\"https://api.github.com/users/mojoness/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:51:\"https://api.github.com/users/mojoness/subscriptions\";s:17:\"organizations_url\";s:42:\"https://api.github.com/users/mojoness/orgs\";s:9:\"repos_url\";s:43:\"https://api.github.com/users/mojoness/repos\";s:10:\"events_url\";s:54:\"https://api.github.com/users/mojoness/events{/privacy}\";s:19:\"received_events_url\";s:53:\"https://api.github.com/users/mojoness/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:7:\"private\";b:0;s:8:\"html_url\";s:54:\"https://github.com/mojoness/mojo-marketplace-wp-plugin\";s:11:\"description\";s:58:\"WordPress plugin that has shortcodes, widgets and themes. \";s:4:\"fork\";b:0;s:3:\"url\";s:64:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin\";s:9:\"forks_url\";s:70:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/forks\";s:8:\"keys_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/keys{/key_id}\";s:17:\"collaborators_url\";s:93:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/collaborators{/collaborator}\";s:9:\"teams_url\";s:70:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/teams\";s:9:\"hooks_url\";s:70:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/hooks\";s:16:\"issue_events_url\";s:87:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/issues/events{/number}\";s:10:\"events_url\";s:71:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/events\";s:13:\"assignees_url\";s:81:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/assignees{/user}\";s:12:\"branches_url\";s:82:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/branches{/branch}\";s:8:\"tags_url\";s:69:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/tags\";s:9:\"blobs_url\";s:80:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/blobs{/sha}\";s:12:\"git_tags_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/tags{/sha}\";s:12:\"git_refs_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/refs{/sha}\";s:9:\"trees_url\";s:80:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/trees{/sha}\";s:12:\"statuses_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/statuses/{sha}\";s:13:\"languages_url\";s:74:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/languages\";s:14:\"stargazers_url\";s:75:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/stargazers\";s:16:\"contributors_url\";s:77:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contributors\";s:15:\"subscribers_url\";s:76:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/subscribers\";s:16:\"subscription_url\";s:77:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/subscription\";s:11:\"commits_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/commits{/sha}\";s:15:\"git_commits_url\";s:82:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/git/commits{/sha}\";s:12:\"comments_url\";s:82:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/comments{/number}\";s:17:\"issue_comment_url\";s:89:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/issues/comments{/number}\";s:12:\"contents_url\";s:81:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/contents/{+path}\";s:11:\"compare_url\";s:88:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/compare/{base}...{head}\";s:10:\"merges_url\";s:71:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/merges\";s:11:\"archive_url\";s:87:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/{archive_format}{/ref}\";s:13:\"downloads_url\";s:74:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/downloads\";s:10:\"issues_url\";s:80:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/issues{/number}\";s:9:\"pulls_url\";s:79:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/pulls{/number}\";s:14:\"milestones_url\";s:84:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/milestones{/number}\";s:17:\"notifications_url\";s:104:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/notifications{?since,all,participating}\";s:10:\"labels_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/labels{/name}\";s:12:\"releases_url\";s:78:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/releases{/id}\";s:15:\"deployments_url\";s:76:\"https://api.github.com/repos/mojoness/mojo-marketplace-wp-plugin/deployments\";s:10:\"created_at\";s:20:\"2014-01-27T19:47:10Z\";s:10:\"updated_at\";s:20:\"2016-03-09T23:06:54Z\";s:9:\"pushed_at\";s:20:\"2016-03-16T20:36:24Z\";s:7:\"git_url\";s:56:\"git://github.com/mojoness/mojo-marketplace-wp-plugin.git\";s:7:\"ssh_url\";s:54:\"git@github.com:mojoness/mojo-marketplace-wp-plugin.git\";s:9:\"clone_url\";s:58:\"https://github.com/mojoness/mojo-marketplace-wp-plugin.git\";s:7:\"svn_url\";s:54:\"https://github.com/mojoness/mojo-marketplace-wp-plugin\";s:8:\"homepage\";N;s:4:\"size\";i:2521;s:16:\"stargazers_count\";i:2;s:14:\"watchers_count\";i:2;s:8:\"language\";s:10:\"JavaScript\";s:10:\"has_issues\";b:1;s:13:\"has_downloads\";b:1;s:8:\"has_wiki\";b:1;s:9:\"has_pages\";b:0;s:11:\"forks_count\";i:3;s:10:\"mirror_url\";N;s:17:\"open_issues_count\";i:1;s:5:\"forks\";i:3;s:11:\"open_issues\";i:1;s:8:\"watchers\";i:2;s:14:\"default_branch\";s:6:\"master\";s:5:\"score\";d:30.16366599999999920100890449248254299163818359375;}}}", "yes");
INSERT INTO `wp_options` VALUES("33420", "_site_transient_timeout_ghu-cd60ad3e4bd0d8706fc4a4f35f398ee5", "1458335375", "yes");
INSERT INTO `wp_options` VALUES("33421", "_site_transient_ghu-cd60ad3e4bd0d8706fc4a4f35f398ee5", "no tags here", "yes");
INSERT INTO `wp_options` VALUES("33422", "_site_transient_timeout_ghu-9bb54241f94b24d969f7f1e4865eb9ed", "1458335375", "yes");
INSERT INTO `wp_options` VALUES("33423", "_site_transient_ghu-9bb54241f94b24d969f7f1e4865eb9ed", "O:8:\"stdClass\":2:{s:7:\"message\";s:9:\"Not Found\";s:17:\"documentation_url\";s:31:\"https://developer.github.com/v3\";}", "yes");
INSERT INTO `wp_options` VALUES("33424", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1458342590", "yes");
INSERT INTO `wp_options` VALUES("33425", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5762\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3580\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3548\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3046\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2757\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2281\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2190\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2045\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1999\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1968\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1959\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1915\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1828\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1641\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1539\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"1532\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1509\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1338\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1281\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1276\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1178\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1080\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1055\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"996\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"950\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"922\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"907\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"892\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"889\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"878\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"878\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"822\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"784\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"778\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"759\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"743\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"737\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"736\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"735\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"732\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"727\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"726\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"687\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"681\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"671\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"671\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"670\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"661\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"648\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"630\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"629\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"626\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"609\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"602\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"591\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"585\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"585\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"585\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"584\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"570\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"562\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"558\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"548\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"540\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"537\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"526\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"517\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"507\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"502\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"501\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"491\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"489\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"486\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"484\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"466\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"452\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"438\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"436\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"436\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"435\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"434\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"428\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"422\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"419\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"414\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"404\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"404\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"402\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"402\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"398\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"397\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"394\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"390\";}s:4:\"text\";a:3:{s:4:\"name\";s:4:\"text\";s:4:\"slug\";s:4:\"text\";s:5:\"count\";s:3:\"388\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"386\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"384\";}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";s:3:\"384\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"384\";}s:9:\"automatic\";a:3:{s:4:\"name\";s:9:\"automatic\";s:4:\"slug\";s:9:\"automatic\";s:5:\"count\";s:3:\"381\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"381\";}}", "yes");
INSERT INTO `wp_options` VALUES("33426", "_site_transient_timeout_theme_roots", "1458333601", "yes");
INSERT INTO `wp_options` VALUES("33427", "_site_transient_theme_roots", "a:6:{s:7:\"betheme\";s:7:\"/themes\";s:7:\"salient\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_options` VALUES("33429", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1458331901;s:7:\"checked\";a:20:{s:17:\"booked/booked.php\";s:6:\"1.6.10\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:3:\"4.4\";s:33:\"duplicate-post/duplicate-post.php\";s:3:\"2.6\";s:25:\"duplicator/duplicator.php\";s:5:\"1.1.4\";s:39:\"easy-theme-and-plugin-upgrades/init.php\";s:5:\"1.0.4\";s:34:\"envato-wordpress-toolkit/index.php\";s:5:\"1.6.3\";s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";s:5:\"2.0.5\";s:9:\"hello.php\";s:3:\"1.6\";s:35:\"insert-headers-and-footers/ihaf.php\";s:5:\"1.3.3\";s:19:\"jetpack/jetpack.php\";s:5:\"3.9.4\";s:27:\"LayerSlider/layerslider.php\";s:5:\"5.2.0\";s:29:\"mailchimp-wp/mailchimp-wp.php\";s:5:\"1.5.4\";s:40:\"mojo-marketplace-hg/mojo-marketplace.php\";s:5:\"0.5.9\";s:38:\"recent-tweets-widget/recent-tweets.php\";s:5:\"1.6.5\";s:23:\"revslider/revslider.php\";s:5:\"4.6.5\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:5:\"3.7.0\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.6.1\";s:27:\"js_composer/js_composer.php\";s:5:\"4.3.5\";s:27:\"wp-super-cache/wp-cache.php\";s:5:\"1.4.8\";s:24:\"wordpress-seo/wp-seo.php\";s:5:\"3.1.1\";}s:8:\"response\";a:2:{s:27:\"js_composer/js_composer.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:11:\"js_composer\";s:11:\"new_version\";s:6:\"4.11.1\";s:3:\"url\";s:0:\"\";s:7:\"package\";s:0:\"\";s:4:\"name\";s:24:\"WPBakery Visual Composer\";}s:34:\"envato-wordpress-toolkit/index.php\";O:8:\"stdClass\":4:{s:11:\"new_version\";s:5:\"1.7.2\";s:4:\"slug\";s:24:\"envato-wordpress-toolkit\";s:3:\"url\";s:63:\"https://github.com/envato/envato-wordpress-toolkit?access_token\";s:7:\"package\";s:69:\"https://github.com/envato/envato-wordpress-toolkit/archive/master.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:13:{s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:3:\"4.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.zip\";}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1295\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:3:\"2.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicate-post.2.6.zip\";s:14:\"upgrade_notice\";s:90:\"PHP 5.4 (Strict Standards) compatible + Fixed possible XSS and SQL injections + other bugs\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.1.4\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.1.4.zip\";}s:39:\"easy-theme-and-plugin-upgrades/init.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"12348\";s:4:\"slug\";s:30:\"easy-theme-and-plugin-upgrades\";s:6:\"plugin\";s:39:\"easy-theme-and-plugin-upgrades/init.php\";s:11:\"new_version\";s:5:\"1.0.4\";s:3:\"url\";s:61:\"https://wordpress.org/plugins/easy-theme-and-plugin-upgrades/\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/plugin/easy-theme-and-plugin-upgrades.1.0.4.zip\";}s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33928\";s:4:\"slug\";s:27:\"force-regenerate-thumbnails\";s:6:\"plugin\";s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";s:11:\"new_version\";s:5:\"2.0.5\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/force-regenerate-thumbnails/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/force-regenerate-thumbnails.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:35:\"insert-headers-and-footers/ihaf.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33017\";s:4:\"slug\";s:26:\"insert-headers-and-footers\";s:6:\"plugin\";s:35:\"insert-headers-and-footers/ihaf.php\";s:11:\"new_version\";s:5:\"1.3.3\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/insert-headers-and-footers/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/insert-headers-and-footers.zip\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.9.4\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.4.zip\";}s:29:\"mailchimp-wp/mailchimp-wp.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"52961\";s:4:\"slug\";s:12:\"mailchimp-wp\";s:6:\"plugin\";s:29:\"mailchimp-wp/mailchimp-wp.php\";s:11:\"new_version\";s:5:\"1.5.4\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/mailchimp-wp/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/mailchimp-wp.1.5.4.zip\";}s:38:\"recent-tweets-widget/recent-tweets.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"39142\";s:4:\"slug\";s:20:\"recent-tweets-widget\";s:6:\"plugin\";s:38:\"recent-tweets-widget/recent-tweets.php\";s:11:\"new_version\";s:5:\"1.6.5\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/recent-tweets-widget/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/recent-tweets-widget.1.6.5.zip\";}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"14975\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.1\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.1.zip\";}s:27:\"wp-super-cache/wp-cache.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1221\";s:4:\"slug\";s:14:\"wp-super-cache\";s:6:\"plugin\";s:27:\"wp-super-cache/wp-cache.php\";s:11:\"new_version\";s:5:\"1.4.8\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-super-cache/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-super-cache.1.4.8.zip\";s:14:\"upgrade_notice\";s:38:\"Removed malware URL in a code comment.\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.3.1.1.zip\";}}}", "yes");
INSERT INTO `wp_options` VALUES("33430", "duplicator_settings", "a:10:{s:7:\"version\";s:5:\"1.1.4\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("33431", "duplicator_version_plugin", "1.1.4", "yes");
INSERT INTO `wp_options` VALUES("33434", "duplicator_package_active", "O:11:\"DUP_Package\":21:{s:2:\"ID\";N;s:4:\"Name\";s:33:\"20160318_notarypublicsanfrancisco\";s:4:\"Hash\";s:29:\"56ec619b847bd8882160318201419\";s:8:\"NameHash\";s:63:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419\";s:7:\"Version\";s:5:\"1.1.4\";s:9:\"VersionWP\";s:5:\"4.4.2\";s:9:\"VersionDB\";s:11:\"5.5.42-37.1\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:73:\"/home3/johnny/public_html/notarypublicsanfranciscoca.com/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://notarypublicsanfranciscoca.com/wp-snapshots/\";s:8:\"ScanFile\";s:73:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:56:\"/home3/johnny/public_html/notarypublicsanfranciscoca.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":21:{s:2:\"ID\";N;s:4:\"Name\";s:33:\"20160318_notarypublicsanfrancisco\";s:4:\"Hash\";s:29:\"56ec619b847bd8882160318201419\";s:8:\"NameHash\";s:63:\"20160318_notarypublicsanfrancisco_56ec619b847bd8882160318201419\";s:7:\"Version\";s:5:\"1.1.4\";s:9:\"VersionWP\";s:5:\"4.4.2\";s:9:\"VersionDB\";s:11:\"5.5.42-37.1\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:73:\"/home3/johnny/public_html/notarypublicsanfranciscoca.com/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://notarypublicsanfranciscoca.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:20;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:50;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:50;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:70;s:8:\"Database\";r:83;}", "yes");
INSERT INTO `wp_options` VALUES("33435", "_transient_timeout_booked_addons_json", "1458332301", "no");
INSERT INTO `wp_options` VALUES("33436", "_transient_booked_addons_json", "[{\"title\":\"Calendar Feeds\",\"description\":\"Use the <strong>Calendar Feeds<\\/strong> add-on with the <strong>Booked<\\/strong> plugin to add calendar feed support. It will provide you with URLs you can use to sync your Booked appointments (as read-only events) with your Google and\\/or iCloud Calendar(s).\",\"fa_code\":\"fa-rss\",\"envato_market_url\":\"http:\\/\\/codecanyon.net\\/item\\/booked-calendar-feeds-addon\\/11877979\\/?ref=boxystudio\",\"product_price\":\"$13\",\"image_icon\":\"https:\\/\\/boxystudio.com\\/wp-content\\/uploads\\/2015\\/04\\/booked-calendar-feeds1.png\",\"plugin_slug\":\"booked-calendar-feeds\"},{\"title\":\"Payments with WooCommerce\",\"description\":\"Use the <strong>Payments with WooCommerce<\\/strong> add-on with <strong>Booked<\\/strong> and <strong>WooCommerce<\\/strong> to add payment integration to Booked. Create \\\"products\\\" (both simple and variable) from which your customers can choose when booking an appointment.\",\"fa_code\":\"fa-shopping-cart\",\"envato_market_url\":\"http:\\/\\/codecanyon.net\\/item\\/booked-payments-with-woocommerce-addon\\/12824257\\/?ref=boxystudio\",\"product_price\":\"$14\",\"image_icon\":\"https:\\/\\/boxystudio.com\\/wp-content\\/uploads\\/2015\\/04\\/booked-wc-payments.png\",\"plugin_slug\":\"booked-woocommerce-payments\"},{\"title\":\"Front-end Agents\",\"description\":\"Use the <strong>Front-end Agents<\\/strong> add-on to transform the profiles of Booking Agents into front-end appointment moderation screens. View upcoming appointments, moderate pending appointments, and review your appointment history all from the front-end.\",\"fa_code\":\"\",\"envato_market_url\":\"http:\\/\\/codecanyon.net\\/item\\/booked-frontend-agents-addon\\/13556645\\/?ref=boxystudio\",\"product_price\":\"$14\",\"image_icon\":\"https:\\/\\/boxystudio.com\\/wp-content\\/uploads\\/2015\\/06\\/booked-frontend-agents.png\",\"plugin_slug\":\"booked-frontend-agents\"}]", "no");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("7", "8", "_form", "<p>Your Name (required)<br />\n    [text* your-name] </p>\n\n<p>Your Email (required)<br />\n    [email* your-email] </p>\n\n<p>Subject<br />\n    [text your-subject] </p>\n\n<p>Your Message<br />\n    [textarea your-message] </p>\n\n<p>[submit \"Send\"]</p>");
INSERT INTO `wp_postmeta` VALUES("8", "8", "_mail", "a:8:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:54:\"[your-name] <wordpress@notarypublicsanfranciscoca.com>\";s:4:\"body\";s:201:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Canine Companion Concierge (http://notarypublicsanfranciscoca.com)\";s:9:\"recipient\";s:35:\"john@notarypublicsanfranciscoca.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("9", "8", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:70:\"Canine Companion Concierge <wordpress@caninecompanionandconcierge.com>\";s:4:\"body\";s:143:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Canine Companion Concierge (http://notarypublicsanfranciscoca.com)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:32:\"Reply-To: john_eastbay@yahoo.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("10", "8", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:31:\"Please fill the required field.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";}");
INSERT INTO `wp_postmeta` VALUES("11", "8", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("12", "8", "_locale", "en_US");
INSERT INTO `wp_postmeta` VALUES("15", "11", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("16", "11", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("17", "11", "_nectar_slider_caption", "Welcome to Salient, a Beautiful & Robust WordPress Theme.");
INSERT INTO `wp_postmeta` VALUES("18", "11", "_nectar_slider_link", "http://themenectar.com/demo/salient/blog/");
INSERT INTO `wp_postmeta` VALUES("19", "11", "_nectar_slider_button", "Check out the blog");
INSERT INTO `wp_postmeta` VALUES("20", "11", "_nectar_slider_button_url", "http://themenectar.com/");
INSERT INTO `wp_postmeta` VALUES("21", "11", "_nectar_slide_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("22", "11", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("23", "11", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("24", "11", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("25", "11", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("26", "11", "_nectar_media_upload", "");
INSERT INTO `wp_postmeta` VALUES("27", "11", "_nectar_media_upload_poster", "");
INSERT INTO `wp_postmeta` VALUES("28", "11", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("29", "11", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("30", "11", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("31", "11", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("32", "11", "_nectar_slider_caption", "Welcome to Salient, a Beautiful & Robust WordPress Theme.");
INSERT INTO `wp_postmeta` VALUES("33", "11", "_nectar_slider_link", "http://themenectar.com/demo/salient/blog/");
INSERT INTO `wp_postmeta` VALUES("34", "11", "_nectar_slider_button", "Check out the blog");
INSERT INTO `wp_postmeta` VALUES("35", "11", "_nectar_slider_button_url", "http://themenectar.com/");
INSERT INTO `wp_postmeta` VALUES("36", "11", "_nectar_slide_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("37", "11", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("38", "11", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("39", "11", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("40", "11", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("41", "11", "_nectar_media_upload", "");
INSERT INTO `wp_postmeta` VALUES("42", "11", "_nectar_media_upload_poster", "");
INSERT INTO `wp_postmeta` VALUES("43", "11", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("44", "11", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("45", "12", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("46", "12", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("47", "12", "_nectar_slider_caption", "Take your website with you. Salient is ultra responsive and displays amazing on-the-go!");
INSERT INTO `wp_postmeta` VALUES("48", "12", "_nectar_slider_link", "");
INSERT INTO `wp_postmeta` VALUES("49", "12", "_nectar_slider_button", "Explore more Features");
INSERT INTO `wp_postmeta` VALUES("50", "12", "_nectar_slider_button_url", "http://themenectar.com/demo/salient/features/elements/");
INSERT INTO `wp_postmeta` VALUES("51", "12", "_nectar_slide_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("52", "12", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("53", "12", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("54", "12", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("55", "12", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("56", "12", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("57", "12", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("58", "12", "_nectar_slider_caption", "Take your website with you. Salient is ultra responsive and displays amazing on-the-go!");
INSERT INTO `wp_postmeta` VALUES("59", "12", "_nectar_slider_link", "");
INSERT INTO `wp_postmeta` VALUES("60", "12", "_nectar_slider_button", "Explore more Features");
INSERT INTO `wp_postmeta` VALUES("61", "12", "_nectar_slider_button_url", "http://themenectar.com/demo/salient/features/elements/");
INSERT INTO `wp_postmeta` VALUES("62", "12", "_nectar_slide_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("63", "12", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("64", "12", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("65", "12", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("66", "12", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("67", "13", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("68", "13", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("69", "13", "_nectar_slider_caption", "We have been told we do work actually worth sharing");
INSERT INTO `wp_postmeta` VALUES("70", "13", "_nectar_slider_link", "");
INSERT INTO `wp_postmeta` VALUES("71", "13", "_nectar_slider_button", "View our portfolio");
INSERT INTO `wp_postmeta` VALUES("72", "13", "_nectar_slider_button_url", "http://themenectar.com/demo/salient/portfolio/");
INSERT INTO `wp_postmeta` VALUES("73", "13", "_nectar_slide_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("74", "13", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("75", "13", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("76", "13", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("77", "13", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("78", "13", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("79", "13", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("80", "13", "_nectar_slider_caption", "We have been told we do work actually worth sharing");
INSERT INTO `wp_postmeta` VALUES("81", "13", "_nectar_slider_link", "");
INSERT INTO `wp_postmeta` VALUES("82", "13", "_nectar_slider_button", "View our portfolio");
INSERT INTO `wp_postmeta` VALUES("83", "13", "_nectar_slider_button_url", "http://themenectar.com/demo/salient/portfolio/");
INSERT INTO `wp_postmeta` VALUES("84", "13", "_nectar_slide_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("85", "13", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("86", "13", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("87", "13", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("88", "13", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("89", "526", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("90", "526", "_nectar_slider_image", "http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/castro-valley-dog-walking1.jpg");
INSERT INTO `wp_postmeta` VALUES("91", "526", "_nectar_slider_caption", "The need for quality, professional pet care has never been more essential<br/>as we increasingly juggle career, family, school, and social obligations.");
INSERT INTO `wp_postmeta` VALUES("92", "526", "_nectar_slider_button", "More Information");
INSERT INTO `wp_postmeta` VALUES("93", "526", "_nectar_slider_button_url", "http://notarypublicsanfranciscoca.com");
INSERT INTO `wp_postmeta` VALUES("94", "526", "_nectar_slide_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("95", "526", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("96", "526", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("97", "526", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("98", "526", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("99", "526", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("100", "526", "_nectar_slider_image", "http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/castro-valley-dog-walking1.jpg");
INSERT INTO `wp_postmeta` VALUES("101", "526", "_nectar_slider_caption", "The need for quality, professional pet care has never been more essential<br/>as we increasingly juggle career, family, school, and social obligations.");
INSERT INTO `wp_postmeta` VALUES("102", "526", "_nectar_slider_button", "More Information");
INSERT INTO `wp_postmeta` VALUES("103", "526", "_nectar_slider_button_url", "http://notarypublicsanfranciscoca.com");
INSERT INTO `wp_postmeta` VALUES("104", "526", "_nectar_slide_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("105", "526", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("106", "526", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("107", "526", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("108", "526", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("157", "615", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("158", "615", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("159", "615", "_nectar_slider_image", "http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/700.jpg");
INSERT INTO `wp_postmeta` VALUES("160", "615", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("161", "615", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("162", "615", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("163", "615", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("164", "615", "_nectar_slider_video_texture", "on");
INSERT INTO `wp_postmeta` VALUES("165", "615", "_nectar_slider_slide_bg_alignment", "bottom");
INSERT INTO `wp_postmeta` VALUES("166", "615", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("167", "615", "_nectar_slider_heading", "Exercise ~ Stimulation ~ Affection");
INSERT INTO `wp_postmeta` VALUES("168", "615", "_nectar_slider_caption", "We help your pets live happier, healthier lives.");
INSERT INTO `wp_postmeta` VALUES("169", "615", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("170", "615", "_nectar_slider_button", "Our Services");
INSERT INTO `wp_postmeta` VALUES("171", "615", "_nectar_slider_button_url", "#");
INSERT INTO `wp_postmeta` VALUES("172", "615", "_nectar_slider_button_style", "transparent_2");
INSERT INTO `wp_postmeta` VALUES("173", "615", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("174", "615", "_nectar_slider_button_2", "About Us");
INSERT INTO `wp_postmeta` VALUES("175", "615", "_nectar_slider_button_url_2", "#");
INSERT INTO `wp_postmeta` VALUES("176", "615", "_nectar_slider_button_style_2", "transparent_2");
INSERT INTO `wp_postmeta` VALUES("177", "615", "_nectar_slider_button_color_2", "extra-color-3");
INSERT INTO `wp_postmeta` VALUES("178", "615", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("179", "615", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("180", "615", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("181", "615", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("182", "615", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("183", "615", "_nectar_slider_caption_background", "on");
INSERT INTO `wp_postmeta` VALUES("184", "615", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("185", "615", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("186", "615", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("187", "615", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("188", "615", "_nectar_slider_image", "http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/01/700.jpg");
INSERT INTO `wp_postmeta` VALUES("189", "615", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("190", "615", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("191", "615", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("192", "615", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("193", "615", "_nectar_slider_video_texture", "on");
INSERT INTO `wp_postmeta` VALUES("194", "615", "_nectar_slider_slide_bg_alignment", "bottom");
INSERT INTO `wp_postmeta` VALUES("195", "615", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("196", "615", "_nectar_slider_heading", "Exercise ~ Stimulation ~ Affection");
INSERT INTO `wp_postmeta` VALUES("197", "615", "_nectar_slider_caption", "We help your pets live happier, healthier lives.");
INSERT INTO `wp_postmeta` VALUES("198", "615", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("199", "615", "_nectar_slider_button", "Our Services");
INSERT INTO `wp_postmeta` VALUES("200", "615", "_nectar_slider_button_url", "#");
INSERT INTO `wp_postmeta` VALUES("201", "615", "_nectar_slider_button_style", "transparent_2");
INSERT INTO `wp_postmeta` VALUES("202", "615", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("203", "615", "_nectar_slider_button_2", "About Us");
INSERT INTO `wp_postmeta` VALUES("204", "615", "_nectar_slider_button_url_2", "#");
INSERT INTO `wp_postmeta` VALUES("205", "615", "_nectar_slider_button_style_2", "transparent_2");
INSERT INTO `wp_postmeta` VALUES("206", "615", "_nectar_slider_button_color_2", "extra-color-3");
INSERT INTO `wp_postmeta` VALUES("207", "615", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("208", "615", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("209", "615", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("210", "615", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("211", "615", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("212", "615", "_nectar_slider_caption_background", "on");
INSERT INTO `wp_postmeta` VALUES("213", "615", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("214", "615", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("215", "617", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("216", "617", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("217", "617", "_nectar_slider_image", "http://themenectar.com/demo/salient-ascend/wp-content/uploads/2014/07/white.jpg");
INSERT INTO `wp_postmeta` VALUES("218", "617", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("219", "617", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("220", "617", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("221", "617", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("222", "617", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("223", "617", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("224", "617", "_nectar_slider_slide_font_color", "dark");
INSERT INTO `wp_postmeta` VALUES("225", "617", "_nectar_slider_heading", "Experience");
INSERT INTO `wp_postmeta` VALUES("226", "617", "_nectar_slider_caption", "What real creative freedom feels like in a theme\n ");
INSERT INTO `wp_postmeta` VALUES("227", "617", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("228", "617", "_nectar_slider_button", "Learn More Now");
INSERT INTO `wp_postmeta` VALUES("229", "617", "_nectar_slider_button_url", "#");
INSERT INTO `wp_postmeta` VALUES("230", "617", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("231", "617", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("232", "617", "_nectar_slider_button_2", "View Work Instead");
INSERT INTO `wp_postmeta` VALUES("233", "617", "_nectar_slider_button_url_2", "#");
INSERT INTO `wp_postmeta` VALUES("234", "617", "_nectar_slider_button_style_2", "transparent_2");
INSERT INTO `wp_postmeta` VALUES("235", "617", "_nectar_slider_button_color_2", "extra-color-3");
INSERT INTO `wp_postmeta` VALUES("236", "617", "_nectar_slider_entire_link", "http://google.com");
INSERT INTO `wp_postmeta` VALUES("237", "617", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("238", "617", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("239", "617", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("240", "617", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("241", "617", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("242", "617", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("243", "617", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("244", "617", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("245", "617", "_nectar_slider_image", "http://themenectar.com/demo/salient-ascend/wp-content/uploads/2014/07/white.jpg");
INSERT INTO `wp_postmeta` VALUES("246", "617", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("247", "617", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("248", "617", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("249", "617", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("250", "617", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("251", "617", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("252", "617", "_nectar_slider_slide_font_color", "dark");
INSERT INTO `wp_postmeta` VALUES("253", "617", "_nectar_slider_heading", "Experience");
INSERT INTO `wp_postmeta` VALUES("254", "617", "_nectar_slider_caption", "What real creative freedom feels like in a theme\n ");
INSERT INTO `wp_postmeta` VALUES("255", "617", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("256", "617", "_nectar_slider_button", "Learn More Now");
INSERT INTO `wp_postmeta` VALUES("257", "617", "_nectar_slider_button_url", "#");
INSERT INTO `wp_postmeta` VALUES("258", "617", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("259", "617", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("260", "617", "_nectar_slider_button_2", "View Work Instead");
INSERT INTO `wp_postmeta` VALUES("261", "617", "_nectar_slider_button_url_2", "#");
INSERT INTO `wp_postmeta` VALUES("262", "617", "_nectar_slider_button_style_2", "transparent_2");
INSERT INTO `wp_postmeta` VALUES("263", "617", "_nectar_slider_button_color_2", "extra-color-3");
INSERT INTO `wp_postmeta` VALUES("264", "617", "_nectar_slider_entire_link", "http://google.com");
INSERT INTO `wp_postmeta` VALUES("265", "617", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("266", "617", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("267", "617", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("268", "617", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("269", "617", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("270", "617", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("271", "630", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("272", "630", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("273", "630", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("274", "630", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("275", "630", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("276", "630", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("277", "630", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("278", "630", "_nectar_slider_video_texture", "on");
INSERT INTO `wp_postmeta` VALUES("279", "630", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("280", "630", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("281", "630", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("282", "630", "_nectar_slider_caption", "<img src=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/geo-bird.png\" alt=\"gro bird\" />");
INSERT INTO `wp_postmeta` VALUES("283", "630", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("284", "630", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("285", "630", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("286", "630", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("287", "630", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("288", "630", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("289", "630", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("290", "630", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("291", "630", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("292", "630", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("293", "630", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("294", "630", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("295", "630", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("296", "630", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("297", "630", "_nectar_slider_caption_background", "on");
INSERT INTO `wp_postmeta` VALUES("298", "630", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("299", "630", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("300", "630", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("301", "630", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("302", "630", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("303", "630", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("304", "630", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("305", "630", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("306", "630", "_nectar_slider_video_texture", "on");
INSERT INTO `wp_postmeta` VALUES("307", "630", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("308", "630", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("309", "630", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("310", "630", "_nectar_slider_caption", "<img src=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/geo-bird.png\" alt=\"gro bird\" />");
INSERT INTO `wp_postmeta` VALUES("311", "630", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("312", "630", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("313", "630", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("314", "630", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("315", "630", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("316", "630", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("317", "630", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("318", "630", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("319", "630", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("320", "630", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("321", "630", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("322", "630", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("323", "630", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("324", "630", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("325", "630", "_nectar_slider_caption_background", "on");
INSERT INTO `wp_postmeta` VALUES("326", "630", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("327", "646", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("328", "646", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("329", "646", "_nectar_slider_image", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2014/03/mobile-app-1.jpg");
INSERT INTO `wp_postmeta` VALUES("330", "646", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("331", "646", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("332", "646", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("333", "646", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("334", "646", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("335", "646", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("336", "646", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("337", "646", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("338", "646", "_nectar_slider_caption", "");
INSERT INTO `wp_postmeta` VALUES("339", "646", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("340", "646", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("341", "646", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("342", "646", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("343", "646", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("344", "646", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("345", "646", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("346", "646", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("347", "646", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("348", "646", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("349", "646", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("350", "646", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("351", "646", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("352", "646", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("353", "646", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("354", "646", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("355", "646", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("356", "646", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("357", "646", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("358", "646", "_nectar_slider_image", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2014/03/mobile-app-1.jpg");
INSERT INTO `wp_postmeta` VALUES("359", "646", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("360", "646", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("361", "646", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("362", "646", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("363", "646", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("364", "646", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("365", "646", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("366", "646", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("367", "646", "_nectar_slider_caption", "");
INSERT INTO `wp_postmeta` VALUES("368", "646", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("369", "646", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("370", "646", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("371", "646", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("372", "646", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("373", "646", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("374", "646", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("375", "646", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("376", "646", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("377", "646", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("378", "646", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("379", "646", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("380", "646", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("381", "646", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("382", "646", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("383", "646", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("384", "646", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("385", "649", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("386", "649", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("387", "649", "_nectar_slider_image", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2014/03/mobile-app-2.jpg");
INSERT INTO `wp_postmeta` VALUES("388", "649", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("389", "649", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("390", "649", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("391", "649", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("392", "649", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("393", "649", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("394", "649", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("395", "649", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("396", "649", "_nectar_slider_caption", "");
INSERT INTO `wp_postmeta` VALUES("397", "649", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("398", "649", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("399", "649", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("400", "649", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("401", "649", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("402", "649", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("403", "649", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("404", "649", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("405", "649", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("406", "649", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("407", "649", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("408", "649", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("409", "649", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("410", "649", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("411", "649", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("412", "649", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("413", "649", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("414", "649", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("415", "649", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("416", "649", "_nectar_slider_image", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2014/03/mobile-app-2.jpg");
INSERT INTO `wp_postmeta` VALUES("417", "649", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("418", "649", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("419", "649", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("420", "649", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("421", "649", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("422", "649", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("423", "649", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("424", "649", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("425", "649", "_nectar_slider_caption", "");
INSERT INTO `wp_postmeta` VALUES("426", "649", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("427", "649", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("428", "649", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("429", "649", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("430", "649", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("431", "649", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("432", "649", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("433", "649", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("434", "649", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("435", "649", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("436", "649", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("437", "649", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("438", "649", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("439", "649", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("440", "649", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("441", "649", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("442", "649", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("443", "652", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("444", "652", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("445", "652", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("446", "652", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("447", "652", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("448", "652", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("449", "652", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("450", "652", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("451", "652", "_nectar_slider_slide_bg_alignment", "bottom");
INSERT INTO `wp_postmeta` VALUES("452", "652", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("453", "652", "_nectar_slider_heading", "We Are Salient");
INSERT INTO `wp_postmeta` VALUES("454", "652", "_nectar_slider_caption", "A creative agency that builds awesome stuff all day, every day");
INSERT INTO `wp_postmeta` VALUES("455", "652", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("456", "652", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("457", "652", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("458", "652", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("459", "652", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("460", "652", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("461", "652", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("462", "652", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("463", "652", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("464", "652", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("465", "652", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("466", "652", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("467", "652", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("468", "652", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("469", "652", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("470", "652", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("471", "652", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("472", "652", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("473", "652", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("474", "652", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("475", "652", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("476", "652", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("477", "652", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("478", "652", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("479", "652", "_nectar_slider_slide_bg_alignment", "bottom");
INSERT INTO `wp_postmeta` VALUES("480", "652", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("481", "652", "_nectar_slider_heading", "We Are Salient");
INSERT INTO `wp_postmeta` VALUES("482", "652", "_nectar_slider_caption", "A creative agency that builds awesome stuff all day, every day");
INSERT INTO `wp_postmeta` VALUES("483", "652", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("484", "652", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("485", "652", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("486", "652", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("487", "652", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("488", "652", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("489", "652", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("490", "652", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("491", "652", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("492", "652", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("493", "652", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("494", "652", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("495", "652", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("496", "652", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("497", "652", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("498", "652", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("853", "672", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("854", "672", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("855", "672", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("856", "672", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("857", "672", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("858", "672", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("859", "672", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("860", "672", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("861", "672", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("862", "672", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("863", "672", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("864", "672", "_nectar_slider_caption", "<img src=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/11/salient-ink-text.png\" alt=\"salient ink text\" />");
INSERT INTO `wp_postmeta` VALUES("865", "672", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("866", "672", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("867", "672", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("868", "672", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("869", "672", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("870", "672", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("871", "672", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("872", "672", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("873", "672", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("874", "672", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("875", "672", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("876", "672", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("877", "672", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("878", "672", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("879", "672", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("880", "672", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("881", "672", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("882", "672", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("883", "672", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("884", "672", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("885", "672", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("886", "672", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("887", "672", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("888", "672", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("889", "672", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("890", "672", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("891", "672", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("892", "672", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("893", "672", "_nectar_slider_caption", "<img src=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/11/salient-ink-text.png\" alt=\"salient ink text\" />");
INSERT INTO `wp_postmeta` VALUES("894", "672", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("895", "672", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("896", "672", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("897", "672", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("898", "672", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("899", "672", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("900", "672", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("901", "672", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("902", "672", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("903", "672", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("904", "672", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("905", "672", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("906", "672", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("907", "672", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("908", "672", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("909", "672", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("910", "672", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("911", "701", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("912", "701", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("913", "701", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("914", "701", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("915", "701", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("916", "701", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("917", "701", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("918", "701", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("919", "701", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("920", "701", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("921", "701", "_nectar_slider_heading", "Pixel Perfection");
INSERT INTO `wp_postmeta` VALUES("922", "701", "_nectar_slider_caption", "Salient was built with a high attention to details both in design & code");
INSERT INTO `wp_postmeta` VALUES("923", "701", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("924", "701", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("925", "701", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("926", "701", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("927", "701", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("928", "701", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("929", "701", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("930", "701", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("931", "701", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("932", "701", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("933", "701", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("934", "701", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("935", "701", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("936", "701", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("937", "701", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("938", "701", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("939", "701", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("940", "701", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("941", "701", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("942", "701", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("943", "701", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("944", "701", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("945", "701", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("946", "701", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("947", "701", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("948", "701", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("949", "701", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("950", "701", "_nectar_slider_heading", "Pixel Perfection");
INSERT INTO `wp_postmeta` VALUES("951", "701", "_nectar_slider_caption", "Salient was built with a high attention to details both in design & code");
INSERT INTO `wp_postmeta` VALUES("952", "701", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("953", "701", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("954", "701", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("955", "701", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("956", "701", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("957", "701", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("958", "701", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("959", "701", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("960", "701", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("961", "701", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("962", "701", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("963", "701", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("964", "701", "_nectar_slide_xpos_alignment", "centered");
INSERT INTO `wp_postmeta` VALUES("965", "701", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("966", "701", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("967", "701", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("968", "701", "_nectar_slider_down_arrow", "on");
INSERT INTO `wp_postmeta` VALUES("1035", "1752", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1036", "1752", "_nectar_slider_bg_type", "video_bg");
INSERT INTO `wp_postmeta` VALUES("1037", "1752", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("1038", "1752", "_nectar_media_upload_webm", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains-no-ground.webm");
INSERT INTO `wp_postmeta` VALUES("1039", "1752", "_nectar_media_upload_mp4", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains-no-ground.mp4");
INSERT INTO `wp_postmeta` VALUES("1040", "1752", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1041", "1752", "_nectar_slider_preview_image", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains-preview1.jpg");
INSERT INTO `wp_postmeta` VALUES("1042", "1752", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("1043", "1752", "_nectar_slider_slide_bg_alignment", "top");
INSERT INTO `wp_postmeta` VALUES("1044", "1752", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("1045", "1752", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("1046", "1752", "_nectar_slider_caption", "");
INSERT INTO `wp_postmeta` VALUES("1047", "1752", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("1048", "1752", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("1049", "1752", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("1050", "1752", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("1051", "1752", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("1052", "1752", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("1053", "1752", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1054", "1752", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("1055", "1752", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("1056", "1752", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("1057", "1752", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1058", "1752", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("1059", "1752", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("1060", "1752", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("1061", "1752", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("1062", "1752", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("1063", "1752", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1064", "1752", "_nectar_slider_bg_type", "video_bg");
INSERT INTO `wp_postmeta` VALUES("1065", "1752", "_nectar_slider_image", "");
INSERT INTO `wp_postmeta` VALUES("1066", "1752", "_nectar_media_upload_webm", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains-no-ground.webm");
INSERT INTO `wp_postmeta` VALUES("1067", "1752", "_nectar_media_upload_mp4", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains-no-ground.mp4");
INSERT INTO `wp_postmeta` VALUES("1068", "1752", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1069", "1752", "_nectar_slider_preview_image", "http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains-preview1.jpg");
INSERT INTO `wp_postmeta` VALUES("1070", "1752", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("1071", "1752", "_nectar_slider_slide_bg_alignment", "top");
INSERT INTO `wp_postmeta` VALUES("1072", "1752", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("1073", "1752", "_nectar_slider_heading", "");
INSERT INTO `wp_postmeta` VALUES("1074", "1752", "_nectar_slider_caption", "");
INSERT INTO `wp_postmeta` VALUES("1075", "1752", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("1076", "1752", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("1077", "1752", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("1078", "1752", "_nectar_slider_button", "");
INSERT INTO `wp_postmeta` VALUES("1079", "1752", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("1080", "1752", "_nectar_slider_button_style", "solid_color");
INSERT INTO `wp_postmeta` VALUES("1081", "1752", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1082", "1752", "_nectar_slider_button_2", "");
INSERT INTO `wp_postmeta` VALUES("1083", "1752", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("1084", "1752", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("1085", "1752", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1086", "1752", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("1087", "1752", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("1088", "1752", "_nectar_slide_xpos_alignment", "left");
INSERT INTO `wp_postmeta` VALUES("1089", "1752", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("1090", "1752", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("1091", "2057", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1092", "2057", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("1093", "2057", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("1094", "2057", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("1095", "2057", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("1096", "2057", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1097", "2057", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("1098", "2057", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("1099", "2057", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("1100", "2057", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("1101", "2057", "_nectar_slider_heading", "It\'s Here");
INSERT INTO `wp_postmeta` VALUES("1102", "2057", "_nectar_slider_caption", "Download the latest copy today & never<br/>\nbe unprepared for the weather again.");
INSERT INTO `wp_postmeta` VALUES("1103", "2057", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("1104", "2057", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("1105", "2057", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("1106", "2057", "_nectar_slider_button", "Download");
INSERT INTO `wp_postmeta` VALUES("1107", "2057", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("1108", "2057", "_nectar_slider_button_style", "transparent");
INSERT INTO `wp_postmeta` VALUES("1109", "2057", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1110", "2057", "_nectar_slider_button_2", "User Guide");
INSERT INTO `wp_postmeta` VALUES("1111", "2057", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("1112", "2057", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("1113", "2057", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1114", "2057", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("1115", "2057", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("1116", "2057", "_nectar_slide_xpos_alignment", "right");
INSERT INTO `wp_postmeta` VALUES("1117", "2057", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("1118", "2057", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("1119", "2057", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1120", "2057", "_nectar_slider_bg_type", "image_bg");
INSERT INTO `wp_postmeta` VALUES("1121", "2057", "_nectar_slider_image", "http://themenectar.com/demo/salient/wp-content/uploads/2013/09/black-bg1.png");
INSERT INTO `wp_postmeta` VALUES("1122", "2057", "_nectar_media_upload_webm", "");
INSERT INTO `wp_postmeta` VALUES("1123", "2057", "_nectar_media_upload_mp4", "");
INSERT INTO `wp_postmeta` VALUES("1124", "2057", "_nectar_media_upload_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1125", "2057", "_nectar_slider_preview_image", "");
INSERT INTO `wp_postmeta` VALUES("1126", "2057", "_nectar_slider_video_texture", "off");
INSERT INTO `wp_postmeta` VALUES("1127", "2057", "_nectar_slider_slide_bg_alignment", "center");
INSERT INTO `wp_postmeta` VALUES("1128", "2057", "_nectar_slider_slide_font_color", "light");
INSERT INTO `wp_postmeta` VALUES("1129", "2057", "_nectar_slider_heading", "It\'s Here");
INSERT INTO `wp_postmeta` VALUES("1130", "2057", "_nectar_slider_caption", "Download the latest copy today & never<br/>\nbe unprepared for the weather again.");
INSERT INTO `wp_postmeta` VALUES("1131", "2057", "_nectar_slider_caption_background", "off");
INSERT INTO `wp_postmeta` VALUES("1132", "2057", "_nectar_slider_down_arrow", "off");
INSERT INTO `wp_postmeta` VALUES("1133", "2057", "_nectar_slider_link_type", "button_links");
INSERT INTO `wp_postmeta` VALUES("1134", "2057", "_nectar_slider_button", "Download");
INSERT INTO `wp_postmeta` VALUES("1135", "2057", "_nectar_slider_button_url", "");
INSERT INTO `wp_postmeta` VALUES("1136", "2057", "_nectar_slider_button_style", "transparent");
INSERT INTO `wp_postmeta` VALUES("1137", "2057", "_nectar_slider_button_color", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1138", "2057", "_nectar_slider_button_2", "User Guide");
INSERT INTO `wp_postmeta` VALUES("1139", "2057", "_nectar_slider_button_url_2", "");
INSERT INTO `wp_postmeta` VALUES("1140", "2057", "_nectar_slider_button_style_2", "solid_color");
INSERT INTO `wp_postmeta` VALUES("1141", "2057", "_nectar_slider_button_color_2", "primary-color");
INSERT INTO `wp_postmeta` VALUES("1142", "2057", "_nectar_slider_entire_link", "");
INSERT INTO `wp_postmeta` VALUES("1143", "2057", "_nectar_slider_video_popup", "");
INSERT INTO `wp_postmeta` VALUES("1144", "2057", "_nectar_slide_xpos_alignment", "right");
INSERT INTO `wp_postmeta` VALUES("1145", "2057", "_nectar_slide_ypos_alignment", "middle");
INSERT INTO `wp_postmeta` VALUES("1146", "2057", "_nectar_slider_slide_custom_class", "");
INSERT INTO `wp_postmeta` VALUES("1738", "65", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1739", "65", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("1740", "65", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("1741", "65", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1742", "65", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("1743", "65", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("1744", "65", "_nectar_love", "70");
INSERT INTO `wp_postmeta` VALUES("1745", "65", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("1746", "65", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("1747", "65", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("1748", "65", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("1749", "65", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("1750", "65", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("1751", "65", "_portfolio_item_masonry_sizing", "wide");
INSERT INTO `wp_postmeta` VALUES("1752", "65", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("1753", "65", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("1754", "65", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("1755", "65", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("1756", "65", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("1757", "65", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("1758", "65", "_nectar_header_bg_height", "450");
INSERT INTO `wp_postmeta` VALUES("1759", "65", "_nectar_header_bg_color", "#333333");
INSERT INTO `wp_postmeta` VALUES("1760", "65", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("1761", "65", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("1762", "65", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1763", "65", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("1764", "65", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("1765", "65", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1766", "65", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("1767", "65", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("1768", "65", "_nectar_love", "70");
INSERT INTO `wp_postmeta` VALUES("1769", "65", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("1770", "65", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("1771", "65", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("1772", "65", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("1773", "65", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("1774", "65", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("1775", "65", "_portfolio_item_masonry_sizing", "wide");
INSERT INTO `wp_postmeta` VALUES("1776", "65", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("1777", "65", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("1778", "65", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("1779", "65", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("1780", "65", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("1781", "65", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("1782", "65", "_nectar_header_bg_height", "450");
INSERT INTO `wp_postmeta` VALUES("1783", "65", "_nectar_header_bg_color", "#333333");
INSERT INTO `wp_postmeta` VALUES("1784", "65", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("1785", "65", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("1786", "70", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1787", "70", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("1788", "70", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1789", "70", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("1790", "70", "_nectar_video_embed", "<iframe src=\"http://player.vimeo.com/video/63987795\" width=\"720\" height=\"405\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> ");
INSERT INTO `wp_postmeta` VALUES("1791", "70", "_nectar_love", "103");
INSERT INTO `wp_postmeta` VALUES("1792", "70", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("1793", "70", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("1794", "70", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"25\" vertically_center_columns=\"true\"][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]<img class=\"alignnone size-full wp-image-932\" alt=\"black-box\" src=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" width=\"800\" height=\"480\" />[/vc_column_text][/vc_column][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]<img class=\"alignnone size-full wp-image-934\" alt=\"black-box3\" src=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" width=\"800\" height=\"463\" />[/vc_column_text][/vc_column][/vc_row][vc_row type=\"in_container\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" bottom_padding=\"20\" top_padding=\"40\"][vc_column width=\"1/1\"][vc_column_text]\n<h4>The Key Aspects We Covered</h4>\n[/vc_column_text][divider line_type=\"No Line\" custom_height=\"5\"][tabbed_section][tab title=\"Discovery\" id=\"t1\"][vc_column_text] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam rhoncus adipiscing malesuada. Ut ligula dui, condimentum pellentesque auctor at, eleifend eu eros. Cras viverra gravida erat egestas imperdiet. Pellentesque commodo, ante eget feugiat feugiat, lectus nunc mollis nisl, ac lobortis nisl enim vel tortor. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam rhoncus adipiscing malesuada. Ut ligula dui, condimentum pellentesque auctor at, eleifend eu eros. Cras viverra gravida erat egestas imperdiet. Pellentesque commodo, ante eget feugiat feugiat, lectus nunc mollis nisl, ac lobortis nisl enim vel tortor. [/vc_column_text][/tab][tab title=\"Content Creation\" id=\"t2\"][vc_column_text] Nam aliquet tincidunt rutrum. Maecenas accumsan libero ac sem molestie elementum. Vivamus sodales, tortor eu luctus tempor, turpis enim commodo tortor, condimentum ultricies nibh risus id ipsum. Nam nec sem ante, quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu eros Nam aliquet tincidunt rutrum. Maecenas accumsan libero ac sem molestie elementum. Vivamus sodales, tortor eu luctus tempor, turpis enim commodo tortor, condimentum ultricies nibh risus id ipsum. Nam nec sem ante, quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu eros[/vc_column_text][/tab][tab title=\"Branding\" id=\"t3\"][vc_column_text]Ut ipsum ligula, adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. Vestibulum erat risus, mollis non sagittis ac, scelerisque ac lectus. Praesent ornare augue sit amet lectus porttitor auctor. Adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu ero[/vc_column_text][/tab][tab title=\"Social Reach\" id=\"t4\"][vc_column_text]Ut ipsum ligula, adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. Vestibulum erat risus, mollis non sagittis ac, scelerisque ac lectus. Praesent ornare augue sit amet lectus porttitor auctor. Adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu ero[/vc_column_text][/tab][/tabbed_section][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("1795", "70", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("1796", "70", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("1797", "70", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("1798", "70", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("1799", "70", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("1800", "70", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("1801", "70", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("1802", "70", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("1803", "70", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1804", "70", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("1805", "70", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("1806", "70", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("1807", "70", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("1808", "70", "_nectar_header_bg_height", "400");
INSERT INTO `wp_postmeta` VALUES("1809", "70", "_nectar_header_bg_color", "#020202");
INSERT INTO `wp_postmeta` VALUES("1810", "70", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("1811", "70", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("1812", "70", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1813", "70", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("1814", "70", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1815", "70", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("1816", "70", "_nectar_video_embed", "<iframe src=\"http://player.vimeo.com/video/63987795\" width=\"720\" height=\"405\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> ");
INSERT INTO `wp_postmeta` VALUES("1817", "70", "_nectar_love", "103");
INSERT INTO `wp_postmeta` VALUES("1818", "70", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("1819", "70", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("1820", "70", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"25\" vertically_center_columns=\"true\"][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]<img class=\"alignnone size-full wp-image-932\" alt=\"black-box\" src=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" width=\"800\" height=\"480\" />[/vc_column_text][/vc_column][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]<img class=\"alignnone size-full wp-image-934\" alt=\"black-box3\" src=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" width=\"800\" height=\"463\" />[/vc_column_text][/vc_column][/vc_row][vc_row type=\"in_container\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" bottom_padding=\"20\" top_padding=\"40\"][vc_column width=\"1/1\"][vc_column_text]\n<h4>The Key Aspects We Covered</h4>\n[/vc_column_text][divider line_type=\"No Line\" custom_height=\"5\"][tabbed_section][tab title=\"Discovery\" id=\"t1\"][vc_column_text] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam rhoncus adipiscing malesuada. Ut ligula dui, condimentum pellentesque auctor at, eleifend eu eros. Cras viverra gravida erat egestas imperdiet. Pellentesque commodo, ante eget feugiat feugiat, lectus nunc mollis nisl, ac lobortis nisl enim vel tortor. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam rhoncus adipiscing malesuada. Ut ligula dui, condimentum pellentesque auctor at, eleifend eu eros. Cras viverra gravida erat egestas imperdiet. Pellentesque commodo, ante eget feugiat feugiat, lectus nunc mollis nisl, ac lobortis nisl enim vel tortor. [/vc_column_text][/tab][tab title=\"Content Creation\" id=\"t2\"][vc_column_text] Nam aliquet tincidunt rutrum. Maecenas accumsan libero ac sem molestie elementum. Vivamus sodales, tortor eu luctus tempor, turpis enim commodo tortor, condimentum ultricies nibh risus id ipsum. Nam nec sem ante, quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu eros Nam aliquet tincidunt rutrum. Maecenas accumsan libero ac sem molestie elementum. Vivamus sodales, tortor eu luctus tempor, turpis enim commodo tortor, condimentum ultricies nibh risus id ipsum. Nam nec sem ante, quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu eros[/vc_column_text][/tab][tab title=\"Branding\" id=\"t3\"][vc_column_text]Ut ipsum ligula, adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. Vestibulum erat risus, mollis non sagittis ac, scelerisque ac lectus. Praesent ornare augue sit amet lectus porttitor auctor. Adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu ero[/vc_column_text][/tab][tab title=\"Social Reach\" id=\"t4\"][vc_column_text]Ut ipsum ligula, adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. Vestibulum erat risus, mollis non sagittis ac, scelerisque ac lectus. Praesent ornare augue sit amet lectus porttitor auctor. Adipiscing et rutrum eget, vehicula nec ligula. In in ligula nec ligula adipiscing cursus. Duis condimentum elit eu mi sodales facilisis. quis cursus enim. Morbi lacinia mollis augue vitae dapibus. eleifend eu ero[/vc_column_text][/tab][/tabbed_section][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("1821", "70", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("1822", "70", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("1823", "70", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("1824", "70", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("1825", "70", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("1826", "70", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("1827", "70", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("1828", "70", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("1829", "70", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1830", "70", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("1831", "70", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("1832", "70", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("1833", "70", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("1834", "70", "_nectar_header_bg_height", "400");
INSERT INTO `wp_postmeta` VALUES("1835", "70", "_nectar_header_bg_color", "#020202");
INSERT INTO `wp_postmeta` VALUES("1836", "70", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("1837", "70", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("1838", "72", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1839", "72", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("1840", "72", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("1841", "72", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1842", "72", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("1843", "72", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("1844", "72", "_nectar_love", "90");
INSERT INTO `wp_postmeta` VALUES("1845", "72", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("1846", "72", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("1847", "72", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("1848", "72", "_nectar_media_upload", "http://localhost/wordpress-3-6/wp-content/uploads/2013/05/spacebound.ogv");
INSERT INTO `wp_postmeta` VALUES("1849", "72", "_nectar_media_upload_poster", "");
INSERT INTO `wp_postmeta` VALUES("1850", "72", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("1851", "72", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("1852", "72", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("1853", "72", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("1854", "72", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("1855", "72", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("1856", "72", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("1857", "72", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("1858", "72", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("1859", "72", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("1860", "72", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("1861", "72", "_nectar_header_bg_height", "300");
INSERT INTO `wp_postmeta` VALUES("1862", "72", "_nectar_header_bg_color", "#616b6d");
INSERT INTO `wp_postmeta` VALUES("1863", "72", "_nectar_header_font_color", "#ffffff");
INSERT INTO `wp_postmeta` VALUES("1864", "72", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("1865", "72", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1866", "72", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("1867", "72", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("1868", "72", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("1869", "72", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("1870", "72", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("1871", "72", "_nectar_love", "90");
INSERT INTO `wp_postmeta` VALUES("1872", "72", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("1873", "72", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("1874", "72", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("1875", "72", "_nectar_media_upload", "http://localhost/wordpress-3-6/wp-content/uploads/2013/05/spacebound.ogv");
INSERT INTO `wp_postmeta` VALUES("1876", "72", "_nectar_media_upload_poster", "");
INSERT INTO `wp_postmeta` VALUES("1877", "72", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("1878", "72", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("1879", "72", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("1880", "72", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("1881", "72", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("1882", "72", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("1883", "72", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("1884", "72", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("1885", "72", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("1886", "72", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("1887", "72", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("1888", "72", "_nectar_header_bg_height", "300");
INSERT INTO `wp_postmeta` VALUES("1889", "72", "_nectar_header_bg_color", "#616b6d");
INSERT INTO `wp_postmeta` VALUES("1890", "72", "_nectar_header_font_color", "#ffffff");
INSERT INTO `wp_postmeta` VALUES("1891", "72", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2248", "76", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2249", "76", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2250", "76", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2251", "76", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2252", "76", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2253", "76", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2254", "76", "_nectar_love", "74");
INSERT INTO `wp_postmeta` VALUES("2255", "76", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2256", "76", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2257", "76", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("2258", "76", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("2259", "76", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2260", "76", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("2261", "76", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2262", "76", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2263", "76", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2264", "76", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2265", "76", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2266", "76", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2267", "76", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2268", "76", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2269", "76", "_nectar_header_bg_color", "#020202");
INSERT INTO `wp_postmeta` VALUES("2270", "76", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2271", "76", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2272", "76", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2273", "76", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2274", "76", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2275", "76", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2276", "76", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2277", "76", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2278", "76", "_nectar_love", "74");
INSERT INTO `wp_postmeta` VALUES("2279", "76", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2280", "76", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2281", "76", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("2282", "76", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("2283", "76", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2284", "76", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("2285", "76", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2286", "76", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2287", "76", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2288", "76", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2289", "76", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2290", "76", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2291", "76", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2292", "76", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2293", "76", "_nectar_header_bg_color", "#020202");
INSERT INTO `wp_postmeta` VALUES("2294", "76", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2295", "76", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2490", "629", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2491", "629", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("2492", "629", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2493", "629", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2494", "629", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("2495", "629", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"0\" bottom_padding=\"0\"][vc_column width=\"1/1\"][nectar_slider full_width=\"true\" desktop_swipe=\"true\" location=\"Lowpoly\" slider_height=\"550\" bullet_navigation=\"true\" min_slider_height=\"300\" slider_transition=\"slide\" fullscreen=\"true\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"90\" bottom_padding=\"90\"][vc_column width=\"1/2\"][image_with_animation animation=\"Fade In From Left\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/geowofl-device-1.png\" img_link_target=\"_self\"] [/image_with_animation][/vc_column][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h2>Built With iOS In Mind</h2>\nSalient was built from the ground up with responsive design in mind rather than it being an after thought. Your users will appreciate the difference of its carefully planned layouts and browse your site with ease! In addition, Retina support will guarantee your site displays as crisp as possible on the latest devices.\n\n[button color=\"accent-color\" size=\"large\" url=\"#\" text=\"Continue The Tour\"][/vc_column_text][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" bg_color=\"#ffffff\" text_color=\"dark\" text_align=\"left\" top_padding=\"90\" bottom_padding=\"0\"][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h2>Perfect On All Devices</h2>\nSalient gives you an arsenal of beautifully crafted elements and pre-defined structures that will bring life to your prject. Now with more power than ever, you have control over advanced options such as unlimited full-width &amp; parallax sections + multiple accent colors.\n\nAll of the elements in this theme were carefully crafted with a high attention to detail to ensure a consistent &amp; high-end design. Unlock your contents full potential and start getting noticed today!\n\n[button color=\"Accent-Color\" url=\"#\" size=\"large\" text=\"Show Me The Goods\"][/vc_column_text][/vc_column][vc_column width=\"1/2\"][image_with_animation animation=\"Fade In From Right\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/geowolf-device-2.png\"] [/image_with_animation][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"light\" text_align=\"center\" top_padding=\"120\" bottom_padding=\"120\" video_overlay_color=\"#00d8b2\" scene_position=\"center\" bg_color=\"#00d8b2\"][vc_column width=\"1/1\"][vc_column_text]\n<h1>Ready To Stand Out?</h1>\n[divider line_type=\"No Line\" custom_height=\"30\"]\n\n[button color=\"See-Through\" size=\"large\" url=\"http://themeforest.net/item/salient-responsive-multipurpose-theme/4363266\" text=\"Buy Salient Now\" image=\"default-arrow\"]  [button color=\"See-Through\" size=\"large\" url=\"http://themenectar.com/demo/salient-frostwave/contact-alternative/\" text=\"Reach Out To Us\" image=\"default-arrow\"]\n\n[/vc_column_text][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("2496", "629", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2497", "629", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2498", "629", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2499", "629", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2500", "629", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2501", "629", "_nectar_love", "25");
INSERT INTO `wp_postmeta` VALUES("2502", "629", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2503", "629", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2504", "629", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2505", "629", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2506", "629", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2507", "629", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2508", "629", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2509", "629", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2510", "629", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2511", "629", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2512", "629", "_nectar_header_bg_height", "275");
INSERT INTO `wp_postmeta` VALUES("2513", "629", "_nectar_header_bg_color", "#2b2b2b");
INSERT INTO `wp_postmeta` VALUES("2514", "629", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2515", "629", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2516", "629", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2517", "629", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("2518", "629", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2519", "629", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2520", "629", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("2521", "629", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"0\" bottom_padding=\"0\"][vc_column width=\"1/1\"][nectar_slider full_width=\"true\" desktop_swipe=\"true\" location=\"Lowpoly\" slider_height=\"550\" bullet_navigation=\"true\" min_slider_height=\"300\" slider_transition=\"slide\" fullscreen=\"true\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"90\" bottom_padding=\"90\"][vc_column width=\"1/2\"][image_with_animation animation=\"Fade In From Left\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/geowofl-device-1.png\" img_link_target=\"_self\"] [/image_with_animation][/vc_column][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h2>Built With iOS In Mind</h2>\nSalient was built from the ground up with responsive design in mind rather than it being an after thought. Your users will appreciate the difference of its carefully planned layouts and browse your site with ease! In addition, Retina support will guarantee your site displays as crisp as possible on the latest devices.\n\n[button color=\"accent-color\" size=\"large\" url=\"#\" text=\"Continue The Tour\"][/vc_column_text][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" bg_color=\"#ffffff\" text_color=\"dark\" text_align=\"left\" top_padding=\"90\" bottom_padding=\"0\"][vc_column width=\"1/2\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h2>Perfect On All Devices</h2>\nSalient gives you an arsenal of beautifully crafted elements and pre-defined structures that will bring life to your prject. Now with more power than ever, you have control over advanced options such as unlimited full-width &amp; parallax sections + multiple accent colors.\n\nAll of the elements in this theme were carefully crafted with a high attention to detail to ensure a consistent &amp; high-end design. Unlock your contents full potential and start getting noticed today!\n\n[button color=\"Accent-Color\" url=\"#\" size=\"large\" text=\"Show Me The Goods\"][/vc_column_text][/vc_column][vc_column width=\"1/2\"][image_with_animation animation=\"Fade In From Right\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/geowolf-device-2.png\"] [/image_with_animation][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"light\" text_align=\"center\" top_padding=\"120\" bottom_padding=\"120\" video_overlay_color=\"#00d8b2\" scene_position=\"center\" bg_color=\"#00d8b2\"][vc_column width=\"1/1\"][vc_column_text]\n<h1>Ready To Stand Out?</h1>\n[divider line_type=\"No Line\" custom_height=\"30\"]\n\n[button color=\"See-Through\" size=\"large\" url=\"http://themeforest.net/item/salient-responsive-multipurpose-theme/4363266\" text=\"Buy Salient Now\" image=\"default-arrow\"]  [button color=\"See-Through\" size=\"large\" url=\"http://themenectar.com/demo/salient-frostwave/contact-alternative/\" text=\"Reach Out To Us\" image=\"default-arrow\"]\n\n[/vc_column_text][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("2522", "629", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2523", "629", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2524", "629", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2525", "629", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2526", "629", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2527", "629", "_nectar_love", "25");
INSERT INTO `wp_postmeta` VALUES("2528", "629", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2529", "629", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2530", "629", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2531", "629", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2532", "629", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2533", "629", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2534", "629", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2535", "629", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2536", "629", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2537", "629", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2538", "629", "_nectar_header_bg_height", "275");
INSERT INTO `wp_postmeta` VALUES("2539", "629", "_nectar_header_bg_color", "#2b2b2b");
INSERT INTO `wp_postmeta` VALUES("2540", "629", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2541", "629", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2542", "654", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2543", "654", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("2544", "654", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2545", "654", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2546", "654", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("2547", "654", "_nectar_portfolio_extra_content", "[full_width_section bg_pos=\"Center Center\" bg_repeat=\"No-Repeat\" text_color=\"Dark\" top_padding=\"90\" bottom_padding=\"90\" background_color=\"#fafafa\"][one_half][vc_column_text]\n<h2>A Mobile Project</h2>\nIn et massa a massa egestas suscipit tincidunt ut est. Curabitur rutrum faucibus elit, at convallis diam mattis eget. Aliquam scelerisque erat a felis dignissim, a consequat tortor rhoncus. Nullam vulputate nibh at nisi consectetur, nec rutrum nunc iaculis. Donec at aliquam felis. Fusce quis pellentesque odio. Nulla porttitor neque vitae ligula luctus imperdiet molestie at dui. Mauris.[/vc_column_text][/one_half][one_half_last][vc_column_text]\n<h2>Our Approach</h2>\nIn et massa a massa egestas suscipit tincidunt ut est. Curabitur rutrum faucibus elit, at convallis diam mattis eget. Aliquam scelerisque erat a felis dignissim, a consequat tortor rhoncus. Nullam vulputate nibh at nisi consectetur, nec rutrum nunc iaculis. Donec at aliquam felis. Fusce quis pellentesque odio. Nulla porttitor neque vitae ligula luctus imperdiet molestie at dui. Mauris.[/vc_column_text][/one_half_last][/full_width_section][vc_row type=\"full_width_background\" bg_image=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/09/weather-app13.png\" bg_position=\"center center\" bg_repeat=\"no-repeat\" bg_color=\"#212121\" text_color=\"light\" text_align=\"left\" top_padding=\"130\" bottom_padding=\"130\"][vc_column width=\"1/2\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-11.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>Custom Icon Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type=\"No Line\" custom_height=\"20\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-21.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>User Interface Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type=\"No Line\" custom_height=\"20\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-31.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>User Experience Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type=\"No Line\" custom_height=\"20\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-41.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>Responsive Web Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width=\"1/2\"][/vc_column][/vc_row][full_width_section bg_pos=\"Center Center\" bg_repeat=\"No-Repeat\" text_color=\"light\" top_padding=\"5\" bottom_padding=\"5\" background_color=\"#161616\" type=\"full_width_content\" text_align=\"left\" image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/09/line1.jpg\"][vc_column width=\"1/1\" animation=\"none\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][/vc_column][/full_width_section][full_width_section bg_pos=\"Center Center\" bg_repeat=\"No-Repeat\" text_color=\"light\" top_padding=\"90\" bottom_padding=\"90\" background_color=\"#111111\" type=\"full_width_background\" text_align=\"left\"][one_fourth][milestone color=\"Extra-color-1\" number=\"12\" subject=\"Team Members\"][/one_fourth][one_fourth][milestone color=\"Extra-color-1\" number=\"145\" subject=\"Days to make\"][/one_fourth][one_fourth][milestone color=\"Accent-Color\" number=\"36\" subject=\"Git Branches\" symbol_position=\"after\"][/one_fourth][one_fourth_last][milestone color=\"Accent-Color\" number=\"759\" subject=\"Current Downloads\" symbol_position=\"after\"][/one_fourth_last][/full_width_section][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\"][vc_column width=\"1/1\"][nectar_slider full_width=\"true\" bullet_navigation=\"true\" desktop_swipe=\"true\" location=\"Weather App\" slider_height=\"650\" loop=\"true\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"center\" bottom_padding=\"60\" top_padding=\"60\"][vc_column enable_animation=\"true\" animation=\"fade-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][social_buttons nectar_love=\"true\" facebook=\"true\" twitter=\"true\" pinterest=\"true\"][vc_column_text]\n<p style=\"text-align: center;\">If you like this project, please take a second\nto share with the world so weather app can grow!\n\n[/vc_column_text][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("2548", "654", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2549", "654", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2550", "654", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2551", "654", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2552", "654", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2553", "654", "_nectar_love", "115");
INSERT INTO `wp_postmeta` VALUES("2554", "654", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2555", "654", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2556", "654", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2557", "654", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("2558", "654", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2559", "654", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2560", "654", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2561", "654", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2562", "654", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2563", "654", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2564", "654", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2565", "654", "_nectar_header_bg_color", "#1e1e1e");
INSERT INTO `wp_postmeta` VALUES("2566", "654", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2567", "654", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2568", "654", "_wp_old_slug", "branding-concept");
INSERT INTO `wp_postmeta` VALUES("2569", "654", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2570", "654", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("2571", "654", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2572", "654", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2573", "654", "_nectar_gallery_slider", "off");
INSERT INTO `wp_postmeta` VALUES("2574", "654", "_nectar_portfolio_extra_content", "[full_width_section bg_pos=\"Center Center\" bg_repeat=\"No-Repeat\" text_color=\"Dark\" top_padding=\"90\" bottom_padding=\"90\" background_color=\"#fafafa\"][one_half][vc_column_text]\n<h2>A Mobile Project</h2>\nIn et massa a massa egestas suscipit tincidunt ut est. Curabitur rutrum faucibus elit, at convallis diam mattis eget. Aliquam scelerisque erat a felis dignissim, a consequat tortor rhoncus. Nullam vulputate nibh at nisi consectetur, nec rutrum nunc iaculis. Donec at aliquam felis. Fusce quis pellentesque odio. Nulla porttitor neque vitae ligula luctus imperdiet molestie at dui. Mauris.[/vc_column_text][/one_half][one_half_last][vc_column_text]\n<h2>Our Approach</h2>\nIn et massa a massa egestas suscipit tincidunt ut est. Curabitur rutrum faucibus elit, at convallis diam mattis eget. Aliquam scelerisque erat a felis dignissim, a consequat tortor rhoncus. Nullam vulputate nibh at nisi consectetur, nec rutrum nunc iaculis. Donec at aliquam felis. Fusce quis pellentesque odio. Nulla porttitor neque vitae ligula luctus imperdiet molestie at dui. Mauris.[/vc_column_text][/one_half_last][/full_width_section][vc_row type=\"full_width_background\" bg_image=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/09/weather-app13.png\" bg_position=\"center center\" bg_repeat=\"no-repeat\" bg_color=\"#212121\" text_color=\"light\" text_align=\"left\" top_padding=\"130\" bottom_padding=\"130\"][vc_column width=\"1/2\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-11.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>Custom Icon Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type=\"No Line\" custom_height=\"20\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-21.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>User Interface Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type=\"No Line\" custom_height=\"20\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-31.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>User Experience Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type=\"No Line\" custom_height=\"20\"][vc_row_inner][vc_column_inner width=\"1/4\"][image_with_animation animation=\"Grow In\" image_url=\"http://themenectar.com/demo/salient/wp-content/uploads/2013/09/weather-icon-41.png\"] [/image_with_animation][/vc_column_inner][vc_column_inner width=\"3/4\"][vc_column_text]\n<h2>Responsive Web Design</h2>\nPhasellus enim libero, blandit vel sapien vitae, condim entum ultricies magna et. Quisque euismod orci ut et ipsum primis lobortis aliquam. Aliquam in tortor enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width=\"1/2\"][/vc_column][/vc_row][full_width_section bg_pos=\"Center Center\" bg_repeat=\"No-Repeat\" text_color=\"light\" top_padding=\"5\" bottom_padding=\"5\" background_color=\"#161616\" type=\"full_width_content\" text_align=\"left\" image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/09/line1.jpg\"][vc_column width=\"1/1\" animation=\"none\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][/vc_column][/full_width_section][full_width_section bg_pos=\"Center Center\" bg_repeat=\"No-Repeat\" text_color=\"light\" top_padding=\"90\" bottom_padding=\"90\" background_color=\"#111111\" type=\"full_width_background\" text_align=\"left\"][one_fourth][milestone color=\"Extra-color-1\" number=\"12\" subject=\"Team Members\"][/one_fourth][one_fourth][milestone color=\"Extra-color-1\" number=\"145\" subject=\"Days to make\"][/one_fourth][one_fourth][milestone color=\"Accent-Color\" number=\"36\" subject=\"Git Branches\" symbol_position=\"after\"][/one_fourth][one_fourth_last][milestone color=\"Accent-Color\" number=\"759\" subject=\"Current Downloads\" symbol_position=\"after\"][/one_fourth_last][/full_width_section][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\"][vc_column width=\"1/1\"][nectar_slider full_width=\"true\" bullet_navigation=\"true\" desktop_swipe=\"true\" location=\"Weather App\" slider_height=\"650\" loop=\"true\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"center\" bottom_padding=\"60\" top_padding=\"60\"][vc_column enable_animation=\"true\" animation=\"fade-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][social_buttons nectar_love=\"true\" facebook=\"true\" twitter=\"true\" pinterest=\"true\"][vc_column_text]\n<p style=\"text-align: center;\">If you like this project, please take a second\nto share with the world so weather app can grow!\n\n[/vc_column_text][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("2575", "654", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2576", "654", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2577", "654", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2578", "654", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2579", "654", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2580", "654", "_nectar_love", "115");
INSERT INTO `wp_postmeta` VALUES("2581", "654", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2582", "654", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2583", "654", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2584", "654", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("2585", "654", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2586", "654", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2587", "654", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2588", "654", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2589", "654", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2590", "654", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2591", "654", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2592", "654", "_nectar_header_bg_color", "#1e1e1e");
INSERT INTO `wp_postmeta` VALUES("2593", "654", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2594", "654", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2595", "654", "_wp_old_slug", "branding-concept");
INSERT INTO `wp_postmeta` VALUES("2801", "1829", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2802", "1829", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2803", "1829", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2804", "1829", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_content\" vertically_center_columns=\"true\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"light\" text_align=\"left\"][vc_column width=\"1/2\" animation=\"none\" column_padding=\"no-extra-padding\" background_color=\"#151611\" background_color_opacity=\"1\"][vc_column_text]<iframe src=\"http://player.vimeo.com/video/23711782?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1\" width=\"549\" height=\"309\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe>[/vc_column_text][/vc_column][vc_column width=\"1/2\" animation=\"none\" column_padding=\"padding-4-percent\" background_color_opacity=\"1\" background_color=\"#fe4641\"][vc_row_inner][vc_column_inner width=\"1/1\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\"][vc_column_text]\n<h3>A Project By Pedro Conti</h3>\n[divider line_type=\"No Line\" custom_height=\"15\"]\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lorem quam, adipiscing condimentum tristique vel, eleifend sed turpis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lorem quam, adipiscing condimentum tristique vel, eleifend sed turpis.\n\n[button open_new_tab=\"true\" color=\"see-through\" image=\"default-arrow\" size=\"large\" url=\"www.pedroconti.com/\" text=\"Check out Pedro\'s Work\" color_override=\"\"][/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"5\" bottom_padding=\"5\" vertically_center_columns=\"true\" bg_color=\"#303030\"][vc_column width=\"1/1\" animation=\"none\" column_padding=\"no-extra-padding\" background_color=\"#303030\" background_color_opacity=\"1\" centered_text=\"true\"][image_with_animation image_url=\"2293\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("2805", "1829", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("2806", "1829", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2807", "1829", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2808", "1829", "_portfolio_item_masonry_sizing", "wide_tall");
INSERT INTO `wp_postmeta` VALUES("2809", "1829", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2810", "1829", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2811", "1829", "_nectar_project_excerpt", "A Short Film By Pedro Conti");
INSERT INTO `wp_postmeta` VALUES("2812", "1829", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2813", "1829", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2814", "1829", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2815", "1829", "_nectar_header_bg_height", "570");
INSERT INTO `wp_postmeta` VALUES("2816", "1829", "_nectar_header_bg_color", "#020202");
INSERT INTO `wp_postmeta` VALUES("2817", "1829", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2818", "1829", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2819", "1829", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2820", "1829", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2821", "1829", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2822", "1829", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2823", "1829", "_nectar_love", "28");
INSERT INTO `wp_postmeta` VALUES("2824", "1829", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2825", "1829", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2826", "1829", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2827", "1829", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2828", "1829", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_content\" vertically_center_columns=\"true\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"light\" text_align=\"left\"][vc_column width=\"1/2\" animation=\"none\" column_padding=\"no-extra-padding\" background_color=\"#151611\" background_color_opacity=\"1\"][vc_column_text]<iframe src=\"http://player.vimeo.com/video/23711782?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1\" width=\"549\" height=\"309\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe>[/vc_column_text][/vc_column][vc_column width=\"1/2\" animation=\"none\" column_padding=\"padding-4-percent\" background_color_opacity=\"1\" background_color=\"#fe4641\"][vc_row_inner][vc_column_inner width=\"1/1\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\"][vc_column_text]\n<h3>A Project By Pedro Conti</h3>\n[divider line_type=\"No Line\" custom_height=\"15\"]\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lorem quam, adipiscing condimentum tristique vel, eleifend sed turpis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lorem quam, adipiscing condimentum tristique vel, eleifend sed turpis.\n\n[button open_new_tab=\"true\" color=\"see-through\" image=\"default-arrow\" size=\"large\" url=\"www.pedroconti.com/\" text=\"Check out Pedro\'s Work\" color_override=\"\"][/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"5\" bottom_padding=\"5\" vertically_center_columns=\"true\" bg_color=\"#303030\"][vc_column width=\"1/1\" animation=\"none\" column_padding=\"no-extra-padding\" background_color=\"#303030\" background_color_opacity=\"1\" centered_text=\"true\"][image_with_animation image_url=\"2293\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("2829", "1829", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("2830", "1829", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2831", "1829", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2832", "1829", "_portfolio_item_masonry_sizing", "wide_tall");
INSERT INTO `wp_postmeta` VALUES("2833", "1829", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2834", "1829", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2835", "1829", "_nectar_project_excerpt", "A Short Film By Pedro Conti");
INSERT INTO `wp_postmeta` VALUES("2836", "1829", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2837", "1829", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2838", "1829", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2839", "1829", "_nectar_header_bg_height", "570");
INSERT INTO `wp_postmeta` VALUES("2840", "1829", "_nectar_header_bg_color", "#020202");
INSERT INTO `wp_postmeta` VALUES("2841", "1829", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2842", "1829", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2843", "1829", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2844", "1829", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2845", "1829", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2846", "1829", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2847", "1829", "_nectar_love", "28");
INSERT INTO `wp_postmeta` VALUES("2848", "1829", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2849", "1832", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2850", "1832", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2851", "1832", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2852", "1832", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2853", "1832", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2854", "1832", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2855", "1832", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("2856", "1832", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2857", "1832", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2858", "1832", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2859", "1832", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2860", "1832", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2861", "1832", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2862", "1832", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2863", "1832", "_nectar_header_bg_height", "350");
INSERT INTO `wp_postmeta` VALUES("2864", "1832", "_nectar_header_bg_color", "#0c0c0c");
INSERT INTO `wp_postmeta` VALUES("2865", "1832", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2866", "1832", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2867", "1832", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2868", "1832", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2869", "1832", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2870", "1832", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2871", "1832", "_nectar_love", "65");
INSERT INTO `wp_postmeta` VALUES("2872", "1832", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2873", "1832", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2874", "1832", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2875", "1832", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2876", "1832", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2877", "1832", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2878", "1832", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2879", "1832", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("2880", "1832", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2881", "1832", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2882", "1832", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2883", "1832", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2884", "1832", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2885", "1832", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2886", "1832", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2887", "1832", "_nectar_header_bg_height", "350");
INSERT INTO `wp_postmeta` VALUES("2888", "1832", "_nectar_header_bg_color", "#0c0c0c");
INSERT INTO `wp_postmeta` VALUES("2889", "1832", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2890", "1832", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2891", "1832", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2892", "1832", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2893", "1832", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2894", "1832", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2895", "1832", "_nectar_love", "65");
INSERT INTO `wp_postmeta` VALUES("2896", "1832", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2897", "1835", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2898", "1835", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2899", "1835", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2900", "1835", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2901", "1835", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2902", "1835", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2903", "1835", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("2904", "1835", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2905", "1835", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2906", "1835", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2907", "1835", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2908", "1835", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2909", "1835", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2910", "1835", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2911", "1835", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2912", "1835", "_nectar_header_bg_color", "#1c1c1c");
INSERT INTO `wp_postmeta` VALUES("2913", "1835", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2914", "1835", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2915", "1835", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2916", "1835", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2917", "1835", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2918", "1835", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2919", "1835", "_nectar_love", "154");
INSERT INTO `wp_postmeta` VALUES("2920", "1835", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2921", "1835", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2922", "1835", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("2923", "1835", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2924", "1835", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2925", "1835", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2926", "1835", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2927", "1835", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("2928", "1835", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2929", "1835", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("2930", "1835", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2931", "1835", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2932", "1835", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2933", "1835", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2934", "1835", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("2935", "1835", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2936", "1835", "_nectar_header_bg_color", "#1c1c1c");
INSERT INTO `wp_postmeta` VALUES("2937", "1835", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("2938", "1835", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2939", "1835", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2940", "1835", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2941", "1835", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2942", "1835", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2943", "1835", "_nectar_love", "154");
INSERT INTO `wp_postmeta` VALUES("2944", "1835", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2945", "1838", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2946", "1838", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("2947", "1838", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2948", "1838", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2949", "1838", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2950", "1838", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2951", "1838", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2952", "1838", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2953", "1838", "_nectar_external_project_url", "http://themenectar.com/demo/salient-ascend/ownage-in-the-mountains/");
INSERT INTO `wp_postmeta` VALUES("2954", "1838", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2955", "1838", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2956", "1838", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2957", "1838", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2958", "1838", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("2959", "1838", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2960", "1838", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("2961", "1838", "_nectar_header_font_color", "#ffffff");
INSERT INTO `wp_postmeta` VALUES("2962", "1838", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2963", "1838", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2964", "1838", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2965", "1838", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2966", "1838", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2967", "1838", "_nectar_love", "194");
INSERT INTO `wp_postmeta` VALUES("2968", "1838", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2969", "1838", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2970", "1838", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("2971", "1838", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2972", "1838", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2973", "1838", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2974", "1838", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2975", "1838", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("2976", "1838", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("2977", "1838", "_nectar_external_project_url", "http://themenectar.com/demo/salient-ascend/ownage-in-the-mountains/");
INSERT INTO `wp_postmeta` VALUES("2978", "1838", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("2979", "1838", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("2980", "1838", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("2981", "1838", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("2982", "1838", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("2983", "1838", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("2984", "1838", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("2985", "1838", "_nectar_header_font_color", "#ffffff");
INSERT INTO `wp_postmeta` VALUES("2986", "1838", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("2987", "1838", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("2988", "1838", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("2989", "1838", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("2990", "1838", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("2991", "1838", "_nectar_love", "194");
INSERT INTO `wp_postmeta` VALUES("2992", "1838", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("2993", "1841", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2994", "1841", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("2995", "1841", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("2996", "1841", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("2997", "1841", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("2998", "1841", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("2999", "1841", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3000", "1841", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("3001", "1841", "_nectar_external_project_url", "http://themenectar.com/demo/salient-ascend/be-my-guest/");
INSERT INTO `wp_postmeta` VALUES("3002", "1841", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3003", "1841", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3004", "1841", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3005", "1841", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3006", "1841", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3007", "1841", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("3008", "1841", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("3009", "1841", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3010", "1841", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3011", "1841", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3012", "1841", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3013", "1841", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3014", "1841", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3015", "1841", "_nectar_love", "66");
INSERT INTO `wp_postmeta` VALUES("3016", "1841", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3017", "1841", "_wp_old_slug", "the-island");
INSERT INTO `wp_postmeta` VALUES("3018", "1841", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3019", "1841", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("3020", "1841", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3021", "1841", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("3022", "1841", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("3023", "1841", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3024", "1841", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3025", "1841", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("3026", "1841", "_nectar_external_project_url", "http://themenectar.com/demo/salient-ascend/be-my-guest/");
INSERT INTO `wp_postmeta` VALUES("3027", "1841", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3028", "1841", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3029", "1841", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3030", "1841", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3031", "1841", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3032", "1841", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("3033", "1841", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("3034", "1841", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3035", "1841", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3036", "1841", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3037", "1841", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3038", "1841", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3039", "1841", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3040", "1841", "_nectar_love", "66");
INSERT INTO `wp_postmeta` VALUES("3041", "1841", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3042", "1841", "_wp_old_slug", "the-island");
INSERT INTO `wp_postmeta` VALUES("3043", "1851", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3044", "1851", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("3045", "1851", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3046", "1851", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("3047", "1851", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("3048", "1851", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3049", "1851", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3050", "1851", "_portfolio_item_masonry_sizing", "wide");
INSERT INTO `wp_postmeta` VALUES("3051", "1851", "_nectar_external_project_url", " http://themenectar.com/demo/salient-ascend/the-field/");
INSERT INTO `wp_postmeta` VALUES("3052", "1851", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3053", "1851", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3054", "1851", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3055", "1851", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3056", "1851", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3057", "1851", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("3058", "1851", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("3059", "1851", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3060", "1851", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3061", "1851", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3062", "1851", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3063", "1851", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3064", "1851", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3065", "1851", "_nectar_love", "77");
INSERT INTO `wp_postmeta` VALUES("3066", "1851", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3067", "1851", "_wp_old_slug", "spacebound-2");
INSERT INTO `wp_postmeta` VALUES("3068", "1851", "_wp_old_slug", "the-ledge");
INSERT INTO `wp_postmeta` VALUES("3069", "1851", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3070", "1851", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("3071", "1851", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3072", "1851", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("3073", "1851", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("3074", "1851", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3075", "1851", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3076", "1851", "_portfolio_item_masonry_sizing", "wide");
INSERT INTO `wp_postmeta` VALUES("3077", "1851", "_nectar_external_project_url", " http://themenectar.com/demo/salient-ascend/the-field/");
INSERT INTO `wp_postmeta` VALUES("3078", "1851", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3079", "1851", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3080", "1851", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3081", "1851", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3082", "1851", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3083", "1851", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("3084", "1851", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("3085", "1851", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3086", "1851", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3087", "1851", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3088", "1851", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3089", "1851", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3090", "1851", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3091", "1851", "_nectar_love", "77");
INSERT INTO `wp_postmeta` VALUES("3092", "1851", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3093", "1851", "_wp_old_slug", "spacebound-2");
INSERT INTO `wp_postmeta` VALUES("3094", "1851", "_wp_old_slug", "the-ledge");
INSERT INTO `wp_postmeta` VALUES("3157", "2946", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3158", "2946", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("3159", "2946", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3160", "2946", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"120\" bottom_padding=\"80\" scene_position=\"center\"][vc_column width=\"1/3\" animation=\"none\" delay=\"0\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-bucket\" color=\"Accent-Color\"]\n<h4>Design To Brag About</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"200\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-lab\" color=\"Accent-Color\"]\n<h4>Completely Customizable</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"400\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-atom\" color=\"Accent-Color\"]\n<h4>Loaded With Power</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"0\" bottom_padding=\"120\" scene_position=\"center\"][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"200\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"linecon-icon-display\" color=\"Accent-Color\"]\n<h4>In-Depth Tutorial Videos</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"400\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-cube\" color=\"Accent-Color\"]\n<h4>Effortless Page Builder</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"600\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"linecon-icon-settings\" color=\"Accent-Color\"]\n<h4>Free Updates &amp; Support</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"left\"][vc_column width=\"1/1\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"center\" top_padding=\"100\" bottom_padding=\"100\"][vc_column width=\"1/6\"][/vc_column][vc_column width=\"2/3\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h1 style=\"text-align: center;\">Lorem ipsum dolor</h1>\n[/vc_column_text][divider line_type=\"Small Line\" custom_height=\"50\"][vc_column_text]\n<h4 style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sollicitudin estnec felis luctus porttitor. Donec ac accumsan neque. Curabitur dignissim blandit mi aliquet bibendum. Ipsum dolor sit amet, consectetur adipiscing elit. Nulla hendrerit sed nulla.</h4>\n[/vc_column_text][/vc_column][vc_column width=\"1/6\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/2\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][vc_column width=\"1/2\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][vc_column width=\"1/3\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][vc_column width=\"1/3\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"center\" top_padding=\"100\" bottom_padding=\"100\"][vc_column width=\"1/6\"][/vc_column][vc_column width=\"2/3\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h4 style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sollicitudin estnec felis luctus porttitor. Donec ac accumsan neque. Curabitur dignissim blandit mi aliquet bibendum. Ipsum dolor sit amet, consectetur adipiscing elit. Nulla hendrerit sed nulla.</h4>\n[/vc_column_text][/vc_column][vc_column width=\"1/6\"][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"left\"][vc_column width=\"1/1\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"light\" text_align=\"center\" parallax_bg=\"true\" scene_position=\"center\" vertically_center_columns=\"true\" top_padding=\"70\" bottom_padding=\"70\" bg_color=\"#282828\" bg_image=\"2995\"][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"200\" symbol=\"+\" subject=\"Projects Completed\"][/vc_column][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\" delay=\"200\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"246\" symbol=\"k\" subject=\"Pixels Pushed\"][/vc_column][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\" delay=\"400\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"1538\" subject=\"Cups Of Coffee\"][/vc_column][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\" delay=\"600\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"582\" subject=\"Features Added\"][/vc_column][vc_column width=\"1/6\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"248\" subject=\"PS Layers\"][/vc_column][vc_column width=\"1/6\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"127\" subject=\"GB File Size\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"center\" top_padding=\"100\" bottom_padding=\"100\"][vc_column width=\"1/6\"][/vc_column][vc_column width=\"2/3\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h4 style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sollicitudin estnec felis luctus porttitor. Donec ac accumsan neque. Curabitur dignissim blandit mi aliquet bibendum. Ipsum dolor sit amet, consectetur adipiscing elit. Nulla hendrerit sed nulla.</h4>\n[/vc_column_text][divider line_type=\"No Line\" custom_height=\"30\"][vc_column_text][button open_new_tab=\"true\" color=\"extra-color-1\" size=\"large\" url=\"#\" text=\"Facebook\" color_override=\"\" image=\"icon-facebook\" ]  [button open_new_tab=\"true\" color=\"extra-color-1\" size=\"large\" url=\"#\" text=\"Twitter\" color_override=\"\" image=\"icon-twitter\" ]  [button open_new_tab=\"true\" color=\"extra-color-1\" size=\"large\" url=\"#\" text=\"Google+\" color_override=\"\" image=\"icon-google-plus\" ][/vc_column_text][/vc_column][vc_column width=\"1/6\"][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("3161", "2946", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("3162", "2946", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3163", "2946", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("3164", "2946", "_portfolio_item_masonry_sizing", "wide_tall");
INSERT INTO `wp_postmeta` VALUES("3165", "2946", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("3166", "2946", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3167", "2946", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3168", "2946", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3169", "2946", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3170", "2946", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("3171", "2946", "_nectar_header_bg_height", "500");
INSERT INTO `wp_postmeta` VALUES("3172", "2946", "_nectar_header_bg_color", "#2f2f2f");
INSERT INTO `wp_postmeta` VALUES("3173", "2946", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3174", "2946", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3175", "2946", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3176", "2946", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3177", "2946", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3178", "2946", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3179", "2946", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3180", "2946", "_wpb_post_custom_css", "#portfolio-extra .col img {\n  max-width: none!important;\n  width: 100%!important;\n}");
INSERT INTO `wp_postmeta` VALUES("3181", "2946", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("3182", "2946", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3183", "2946", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("3184", "2946", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3185", "2946", "_nectar_portfolio_extra_content", "[vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"120\" bottom_padding=\"80\" scene_position=\"center\"][vc_column width=\"1/3\" animation=\"none\" delay=\"0\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-bucket\" color=\"Accent-Color\"]\n<h4>Design To Brag About</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"200\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-lab\" color=\"Accent-Color\"]\n<h4>Completely Customizable</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"400\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-atom\" color=\"Accent-Color\"]\n<h4>Loaded With Power</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"dark\" text_align=\"left\" top_padding=\"0\" bottom_padding=\"120\" scene_position=\"center\"][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"200\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"linecon-icon-display\" color=\"Accent-Color\"]\n<h4>In-Depth Tutorial Videos</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"400\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"steadysets-icon-cube\" color=\"Accent-Color\"]\n<h4>Effortless Page Builder</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][vc_column width=\"1/3\" animation=\"fade-in\" delay=\"600\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][text-with-icon icon_type=\"font_icon\" icon=\"linecon-icon-settings\" color=\"Accent-Color\"]\n<h4>Free Updates &amp; Support</h4>\nPhasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam. Aliquam in tortor enim.[/text-with-icon][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"left\"][vc_column width=\"1/1\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"center\" top_padding=\"100\" bottom_padding=\"100\"][vc_column width=\"1/6\"][/vc_column][vc_column width=\"2/3\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h1 style=\"text-align: center;\">Lorem ipsum dolor</h1>\n[/vc_column_text][divider line_type=\"Small Line\" custom_height=\"50\"][vc_column_text]\n<h4 style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sollicitudin estnec felis luctus porttitor. Donec ac accumsan neque. Curabitur dignissim blandit mi aliquet bibendum. Ipsum dolor sit amet, consectetur adipiscing elit. Nulla hendrerit sed nulla.</h4>\n[/vc_column_text][/vc_column][vc_column width=\"1/6\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/2\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][vc_column width=\"1/2\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][vc_column width=\"1/3\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][vc_column width=\"1/3\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"center\" top_padding=\"100\" bottom_padding=\"100\"][vc_column width=\"1/6\"][/vc_column][vc_column width=\"2/3\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h4 style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sollicitudin estnec felis luctus porttitor. Donec ac accumsan neque. Curabitur dignissim blandit mi aliquet bibendum. Ipsum dolor sit amet, consectetur adipiscing elit. Nulla hendrerit sed nulla.</h4>\n[/vc_column_text][/vc_column][vc_column width=\"1/6\"][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"left\"][vc_column width=\"1/1\"][image_with_animation image_url=\"http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/no-portfolio-item.jpg\" animation=\"Fade In\" img_link_target=\"_self\"][/vc_column][/vc_row][vc_row type=\"full_width_content\" bg_position=\"left top\" bg_repeat=\"no-repeat\" text_color=\"light\" text_align=\"center\" parallax_bg=\"true\" scene_position=\"center\" vertically_center_columns=\"true\" top_padding=\"70\" bottom_padding=\"70\" bg_color=\"#282828\" bg_image=\"2995\"][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"200\" symbol=\"+\" subject=\"Projects Completed\"][/vc_column][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\" delay=\"200\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"246\" symbol=\"k\" subject=\"Pixels Pushed\"][/vc_column][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\" delay=\"400\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"1538\" subject=\"Cups Of Coffee\"][/vc_column][vc_column width=\"1/6\" animation=\"none\" column_padding=\"padding-2-percent\" background_color_opacity=\"1\" delay=\"600\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"582\" subject=\"Features Added\"][/vc_column][vc_column width=\"1/6\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"248\" subject=\"PS Layers\"][/vc_column][vc_column width=\"1/6\"][milestone symbol_position=\"after\" color=\"Accent-Color\" number=\"127\" subject=\"GB File Size\"][/vc_column][/vc_row][vc_row type=\"full_width_background\" bg_position=\"left top\" bg_repeat=\"no-repeat\" scene_position=\"center\" text_color=\"dark\" text_align=\"center\" top_padding=\"100\" bottom_padding=\"100\"][vc_column width=\"1/6\"][/vc_column][vc_column width=\"2/3\" enable_animation=\"true\" animation=\"flip-in\" column_padding=\"no-extra-padding\" background_color_opacity=\"1\"][vc_column_text]\n<h4 style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sollicitudin estnec felis luctus porttitor. Donec ac accumsan neque. Curabitur dignissim blandit mi aliquet bibendum. Ipsum dolor sit amet, consectetur adipiscing elit. Nulla hendrerit sed nulla.</h4>\n[/vc_column_text][divider line_type=\"No Line\" custom_height=\"30\"][vc_column_text][button open_new_tab=\"true\" color=\"extra-color-1\" size=\"large\" url=\"#\" text=\"Facebook\" color_override=\"\" image=\"icon-facebook\" ]  [button open_new_tab=\"true\" color=\"extra-color-1\" size=\"large\" url=\"#\" text=\"Twitter\" color_override=\"\" image=\"icon-twitter\" ]  [button open_new_tab=\"true\" color=\"extra-color-1\" size=\"large\" url=\"#\" text=\"Google+\" color_override=\"\" image=\"icon-google-plus\" ][/vc_column_text][/vc_column][vc_column width=\"1/6\"][/vc_column][/vc_row]");
INSERT INTO `wp_postmeta` VALUES("3186", "2946", "_nectar_portfolio_item_layout", "enabled");
INSERT INTO `wp_postmeta` VALUES("3187", "2946", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3188", "2946", "_nectar_hide_featured", "on");
INSERT INTO `wp_postmeta` VALUES("3189", "2946", "_portfolio_item_masonry_sizing", "wide_tall");
INSERT INTO `wp_postmeta` VALUES("3190", "2946", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("3191", "2946", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3192", "2946", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3193", "2946", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3194", "2946", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3195", "2946", "_nectar_header_parallax", "on");
INSERT INTO `wp_postmeta` VALUES("3196", "2946", "_nectar_header_bg_height", "500");
INSERT INTO `wp_postmeta` VALUES("3197", "2946", "_nectar_header_bg_color", "#2f2f2f");
INSERT INTO `wp_postmeta` VALUES("3198", "2946", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3199", "2946", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3200", "2946", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3201", "2946", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3202", "2946", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3203", "2946", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3204", "2946", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3205", "2946", "_wpb_post_custom_css", "#portfolio-extra .col img {\n  max-width: none!important;\n  width: 100%!important;\n}");
INSERT INTO `wp_postmeta` VALUES("3206", "2946", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("3207", "2964", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3208", "2964", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("3209", "2964", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3210", "2964", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("3211", "2964", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("3212", "2964", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3213", "2964", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3214", "2964", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("3215", "2964", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("3216", "2964", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3217", "2964", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3218", "2964", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3219", "2964", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3220", "2964", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3221", "2964", "_nectar_header_bg_height", "400");
INSERT INTO `wp_postmeta` VALUES("3222", "2964", "_nectar_header_bg_color", "#282828");
INSERT INTO `wp_postmeta` VALUES("3223", "2964", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3224", "2964", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3225", "2964", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3226", "2964", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3227", "2964", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3228", "2964", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3229", "2964", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3230", "2964", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("3231", "2964", "_wp_old_slug", "vinyl-record");
INSERT INTO `wp_postmeta` VALUES("3232", "2964", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3233", "2964", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("3234", "2964", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3235", "2964", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("3236", "2964", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("3237", "2964", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3238", "2964", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3239", "2964", "_portfolio_item_masonry_sizing", "regular");
INSERT INTO `wp_postmeta` VALUES("3240", "2964", "_nectar_external_project_url", "");
INSERT INTO `wp_postmeta` VALUES("3241", "2964", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3242", "2964", "_nectar_project_excerpt", "");
INSERT INTO `wp_postmeta` VALUES("3243", "2964", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3244", "2964", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3245", "2964", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3246", "2964", "_nectar_header_bg_height", "400");
INSERT INTO `wp_postmeta` VALUES("3247", "2964", "_nectar_header_bg_color", "#282828");
INSERT INTO `wp_postmeta` VALUES("3248", "2964", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3249", "2964", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3250", "2964", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3251", "2964", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3252", "2964", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3253", "2964", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3254", "2964", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3255", "2964", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("3256", "2964", "_wp_old_slug", "vinyl-record");
INSERT INTO `wp_postmeta` VALUES("3257", "2967", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3258", "2967", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("3259", "2967", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3260", "2967", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("3261", "2967", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("3262", "2967", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3263", "2967", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3264", "2967", "_portfolio_item_masonry_sizing", "wide");
INSERT INTO `wp_postmeta` VALUES("3265", "2967", "_nectar_external_project_url", "http://www.youtube.com/user/ThemeNectar");
INSERT INTO `wp_postmeta` VALUES("3266", "2967", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3267", "2967", "_nectar_project_excerpt", "External Link Example");
INSERT INTO `wp_postmeta` VALUES("3268", "2967", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3269", "2967", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3270", "2967", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3271", "2967", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("3272", "2967", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("3273", "2967", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3274", "2967", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3275", "2967", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3276", "2967", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3277", "2967", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3278", "2967", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3279", "2967", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3280", "2967", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("3281", "2967", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3282", "2967", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("3283", "2967", "_wpb_vc_js_interface_version", "2");
INSERT INTO `wp_postmeta` VALUES("3284", "2967", "_nectar_portfolio_extra_content", "");
INSERT INTO `wp_postmeta` VALUES("3285", "2967", "_nectar_portfolio_item_layout", "disabled");
INSERT INTO `wp_postmeta` VALUES("3286", "2967", "_nectar_portfolio_custom_thumbnail", "");
INSERT INTO `wp_postmeta` VALUES("3287", "2967", "_nectar_hide_featured", "off");
INSERT INTO `wp_postmeta` VALUES("3288", "2967", "_portfolio_item_masonry_sizing", "wide");
INSERT INTO `wp_postmeta` VALUES("3289", "2967", "_nectar_external_project_url", "http://www.youtube.com/user/ThemeNectar");
INSERT INTO `wp_postmeta` VALUES("3290", "2967", "nectar-metabox-portfolio-parent-override", "default");
INSERT INTO `wp_postmeta` VALUES("3291", "2967", "_nectar_project_excerpt", "External Link Example");
INSERT INTO `wp_postmeta` VALUES("3292", "2967", "_nectar_project_accent_color", "");
INSERT INTO `wp_postmeta` VALUES("3293", "2967", "_nectar_header_bg", "");
INSERT INTO `wp_postmeta` VALUES("3294", "2967", "_nectar_header_parallax", "off");
INSERT INTO `wp_postmeta` VALUES("3295", "2967", "_nectar_header_bg_height", "");
INSERT INTO `wp_postmeta` VALUES("3296", "2967", "_nectar_header_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("3297", "2967", "_nectar_header_font_color", "");
INSERT INTO `wp_postmeta` VALUES("3298", "2967", "_disable_transparent_header", "off");
INSERT INTO `wp_postmeta` VALUES("3299", "2967", "_nectar_video_m4v", "");
INSERT INTO `wp_postmeta` VALUES("3300", "2967", "_nectar_video_ogv", "");
INSERT INTO `wp_postmeta` VALUES("3301", "2967", "_nectar_video_height", "");
INSERT INTO `wp_postmeta` VALUES("3302", "2967", "_nectar_video_poster", "");
INSERT INTO `wp_postmeta` VALUES("3303", "2967", "_nectar_video_embed", "");
INSERT INTO `wp_postmeta` VALUES("3304", "2967", "_nectar_love", "0");
INSERT INTO `wp_postmeta` VALUES("4120", "526", "_edit_lock", "1421695243:1");
INSERT INTO `wp_postmeta` VALUES("4124", "615", "_edit_lock", "1421703417:1");
INSERT INTO `wp_postmeta` VALUES("4237", "118", "_wp_attached_file", "2014/02/get_in_touch.png");
INSERT INTO `wp_postmeta` VALUES("4238", "118", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:235;s:6:\"height\";i:257;s:4:\"file\";s:24:\"2014/02/get_in_touch.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"get_in_touch-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"get_in_touch-134x146.png\";s:5:\"width\";i:134;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"get_in_touch-46x50.png\";s:5:\"width\";i:46;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"get_in_touch-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"get_in_touch-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"get_in_touch-69x75.png\";s:5:\"width\";i:69;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4239", "119", "_wp_attached_file", "2014/02/infobox.png");
INSERT INTO `wp_postmeta` VALUES("4240", "119", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:167;s:6:\"height\";i:214;s:4:\"file\";s:19:\"2014/02/infobox.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"infobox-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"infobox-114x146.png\";s:5:\"width\";i:114;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:17:\"infobox-39x50.png\";s:5:\"width\";i:39;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:17:\"infobox-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:17:\"infobox-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:17:\"infobox-59x75.png\";s:5:\"width\";i:59;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4281", "466", "_wp_attached_file", "2014/05/transport_box_1.jpg");
INSERT INTO `wp_postmeta` VALUES("4282", "466", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:511;s:4:\"file\";s:27:\"2014/05/transport_box_1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"transport_box_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"transport_box_1-223x300.jpg\";s:5:\"width\";i:223;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"transport_box_1-109x146.jpg\";s:5:\"width\";i:109;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:25:\"transport_box_1-37x50.jpg\";s:5:\"width\";i:37;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:27:\"transport_box_1-380x470.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"blog\";a:4:{s:4:\"file\";s:27:\"transport_box_1-380x450.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:27:\"transport_box_1-380x480.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:25:\"transport_box_1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:27:\"transport_box_1-380x500.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:27:\"transport_box_1-380x450.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:27:\"transport_box_1-380x375.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:25:\"transport_box_1-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:25:\"transport_box_1-56x75.jpg\";s:5:\"width\";i:56;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4285", "468", "_wp_attached_file", "2014/05/transport_box_3.jpg");
INSERT INTO `wp_postmeta` VALUES("4286", "468", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:511;s:4:\"file\";s:27:\"2014/05/transport_box_3.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"transport_box_3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"transport_box_3-223x300.jpg\";s:5:\"width\";i:223;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"transport_box_3-109x146.jpg\";s:5:\"width\";i:109;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:25:\"transport_box_3-37x50.jpg\";s:5:\"width\";i:37;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:27:\"transport_box_3-380x470.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"blog\";a:4:{s:4:\"file\";s:27:\"transport_box_3-380x450.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:27:\"transport_box_3-380x480.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:25:\"transport_box_3-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:27:\"transport_box_3-380x500.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:27:\"transport_box_3-380x450.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:27:\"transport_box_3-380x375.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:25:\"transport_box_3-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:25:\"transport_box_3-56x75.jpg\";s:5:\"width\";i:56;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4287", "470", "_wp_attached_file", "2014/05/transport_box_4.jpg");
INSERT INTO `wp_postmeta` VALUES("4288", "470", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:511;s:4:\"file\";s:27:\"2014/05/transport_box_4.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"transport_box_4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"transport_box_4-223x300.jpg\";s:5:\"width\";i:223;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"transport_box_4-109x146.jpg\";s:5:\"width\";i:109;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:25:\"transport_box_4-37x50.jpg\";s:5:\"width\";i:37;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:27:\"transport_box_4-380x470.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"blog\";a:4:{s:4:\"file\";s:27:\"transport_box_4-380x450.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:27:\"transport_box_4-380x480.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:25:\"transport_box_4-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:27:\"transport_box_4-380x500.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:27:\"transport_box_4-380x450.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:27:\"transport_box_4-380x375.jpg\";s:5:\"width\";i:380;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:25:\"transport_box_4-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:25:\"transport_box_4-56x75.jpg\";s:5:\"width\";i:56;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4289", "475", "_wp_attached_file", "2014/05/lawyer_list_1.png");
INSERT INTO `wp_postmeta` VALUES("4290", "475", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2014/05/lawyer_list_1.png\";s:5:\"sizes\";a:1:{s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"lawyer_list_1-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4291", "476", "_wp_attached_file", "2014/05/lawyer_list_2.png");
INSERT INTO `wp_postmeta` VALUES("4292", "476", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2014/05/lawyer_list_2.png\";s:5:\"sizes\";a:1:{s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"lawyer_list_2-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4293", "477", "_wp_attached_file", "2014/05/lawyer_list_3.png");
INSERT INTO `wp_postmeta` VALUES("4294", "477", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2014/05/lawyer_list_3.png\";s:5:\"sizes\";a:1:{s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"lawyer_list_3-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4295", "478", "_wp_attached_file", "2014/05/lawyer_list_4.png");
INSERT INTO `wp_postmeta` VALUES("4296", "478", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2014/05/lawyer_list_4.png\";s:5:\"sizes\";a:1:{s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"lawyer_list_4-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4297", "479", "_wp_attached_file", "2014/05/lawyer_list_5.png");
INSERT INTO `wp_postmeta` VALUES("4298", "479", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2014/05/lawyer_list_5.png\";s:5:\"sizes\";a:1:{s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"lawyer_list_5-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4299", "480", "_wp_attached_file", "2014/05/lawyer_list_6.png");
INSERT INTO `wp_postmeta` VALUES("4300", "480", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2014/05/lawyer_list_6.png\";s:5:\"sizes\";a:1:{s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"lawyer_list_6-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4307", "489", "_wp_attached_file", "2014/05/boss_step_1.png");
INSERT INTO `wp_postmeta` VALUES("4308", "489", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:23:\"2014/05/boss_step_1.png\";s:5:\"sizes\";a:3:{s:5:\"50x50\";a:4:{s:4:\"file\";s:21:\"boss_step_1-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:21:\"boss_step_1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:21:\"boss_step_1-75x75.png\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4309", "490", "_wp_attached_file", "2014/05/boss_step_2.png");
INSERT INTO `wp_postmeta` VALUES("4310", "490", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:23:\"2014/05/boss_step_2.png\";s:5:\"sizes\";a:3:{s:5:\"50x50\";a:4:{s:4:\"file\";s:21:\"boss_step_2-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:21:\"boss_step_2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:21:\"boss_step_2-75x75.png\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4311", "491", "_wp_attached_file", "2014/05/boss_step_3.png");
INSERT INTO `wp_postmeta` VALUES("4312", "491", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:23:\"2014/05/boss_step_3.png\";s:5:\"sizes\";a:3:{s:5:\"50x50\";a:4:{s:4:\"file\";s:21:\"boss_step_3-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:21:\"boss_step_3-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:21:\"boss_step_3-75x75.png\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4395", "600", "_wp_attached_file", "2014/05/church_book_patern.jpg");
INSERT INTO `wp_postmeta` VALUES("4396", "600", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:523;s:6:\"height\";i:384;s:4:\"file\";s:30:\"2014/05/church_book_patern.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"church_book_patern-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"church_book_patern-300x220.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"church_book_patern-199x146.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:28:\"church_book_patern-50x37.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:37;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:28:\"church_book_patern-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:30:\"church_book_patern-523x375.jpg\";s:5:\"width\";i:523;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:30:\"church_book_patern-480x384.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:28:\"church_book_patern-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:29:\"church_book_patern-102x75.jpg\";s:5:\"width\";i:102;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4397", "602", "_wp_attached_file", "2014/05/how_it_works_1.png");
INSERT INTO `wp_postmeta` VALUES("4398", "602", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:98;s:6:\"height\";i:91;s:4:\"file\";s:26:\"2014/05/how_it_works_1.png\";s:5:\"sizes\";a:4:{s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"how_it_works_1-50x46.png\";s:5:\"width\";i:50;s:6:\"height\";i:46;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"how_it_works_1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"how_it_works_1-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"how_it_works_1-81x75.png\";s:5:\"width\";i:81;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4415", "3115", "_wp_attached_file", "2014/05/tools.png");
INSERT INTO `wp_postmeta` VALUES("4416", "3115", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:102;s:6:\"height\";i:100;s:4:\"file\";s:17:\"2014/05/tools.png\";s:5:\"sizes\";a:4:{s:5:\"50x50\";a:4:{s:4:\"file\";s:15:\"tools-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:15:\"tools-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:15:\"tools-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:15:\"tools-77x75.png\";s:5:\"width\";i:77;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4427", "639", "_wp_attached_file", "2014/05/teacher_box_1.png");
INSERT INTO `wp_postmeta` VALUES("4428", "639", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:118;s:4:\"file\";s:25:\"2014/05/teacher_box_1.png\";s:5:\"sizes\";a:4:{s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"teacher_box_1-50x46.png\";s:5:\"width\";i:50;s:6:\"height\";i:46;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"teacher_box_1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"teacher_box_1-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"teacher_box_1-81x75.png\";s:5:\"width\";i:81;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("4606", "3170", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("4607", "3170", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("4608", "3170", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("4609", "3170", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("4610", "3170", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("4611", "3170", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("4612", "3170", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("4613", "3170", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("4614", "3170", "mfn-page-items", "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");
INSERT INTO `wp_postmeta` VALUES("4615", "3170", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("4616", "3170", "mfn-page-items-seo", "Call now\n\n<h2 style=\"color: #2aabe4;\"><b>SF Mobile Notary</b></h2><h3 style=\"color: #2aabe4;\"><br>Real Estate Signings<br>Apostilles & Authentications<br>Consulate Legalizations</h3>\r\n[divider height=\"50\"]\r\n<h2 style=\"color: #2aabe4;\"><b>Call (415) 635-7419</b></h2><br>\r\n\r\n[button title=\"Online Scheduling Tool\" icon=\"\" icon_position=\"\" link=\"/scheduling/\" target=\"_blank\" color=\"#2aabe4\" font_color=\"white\" large=\"6\" class=\"\" download=\"\" onclick=\"\"]\n\n80px 0 0 0\n\nfadeIn\n\nForm\n\n<div class=\"order_form clearfix\" style=\"background: url(http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/10/blue-back.png) no-repeat right top; padding: 30px; border-radius: 20px 0 20px 20px;\">\r\n\r\n<h3><font color=\"white\">Question or request?</font></h3>\r\n<p style=\"color: white;\" class=\"big\">Submit this form and we will get back to you promptly.</p>\r\n[contact-form-7 id=\"4199\" title=\"New form\"]\r\n</div>\n\n10px 0 0 0\n\nfadeIn\n\n<img src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2014/10/signing.jpg\" alt=\"\"/>\n\nMobile Notary Public\n\n<a href=\"/mobile-notary/\">/mobile-notary/</a>\n\nfadeIn\n\n<img src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2014/10/san-francisco-notary-globe.jpg\" alt=\"\"/>\n\nApostilles and Authentications\n\n<a href=\"/apostille-authentication/\">/apostille-authentication/</a>\n\nfadeIn\n\n<img src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2014/10/houses.jpg\" alt=\"\"/>\n\nCertified Notary Signing Agent\n\n<a href=\"http://notarypublicsanfranciscoca.com/certified-notary-signing-agent/\">http://notarypublicsanfranciscoca.com/certified-notary-signing-agent/</a>\n\nfadeIn\n\nMobile Notary Service\n\n<div class=\"see_our_client\">\r\n<div class=\"left\">\r\n		[image src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/10/notary-public-SF-phone.png\" border=\"0\"]\r\n	</div>	\r\n	<div class=\"right\">\r\n		<h3 style=\"margin-top: 20px;\">Call to Book Our Mobile Notary Service</h3>\r\n		<p class=\"big\" style=\"margin-bottom: 25px;\">Notary Public San Francisco offers San Francisco businesses, residents and visitors on-demand, mobile notary services. Our SF notary public firm specializes in conducting real estate closing package signings and expediting California Secretary of State and US State Department apostille processing. We also assist you when you need help obtaining foreign consulate and embassy authentications required for legal recognition of documents overseas. Document printing, and local pick-up and delivery, FedEx/UPS/USPS drop off services available. Same-day, evening, and weekend appointments available.</p>\r\n		<a style=\"font-weight: bold;\" href=\"http://notarypublicsanfranciscoca.com/about-notary-public/\"><i style=\"margin-right: 3px;\" class=\"icon-plus-squared\"></i>Learn More</a>\r\n	</div>\r\n\r\n</div>\n\nfadeIn\n\nJohn Anthony Cavalli\n\n<div class=\"see_our_client\">\r\n	<div class=\"right\">\r\n		<h3 style=\"margin-top: 20px;\">John Anthony Cavalli<br>Certified Notary Signing Agent</h3>\r\n		<p class=\"big\" style=\"margin-bottom: 25px;\">Notary Public San Francisco was founded by Bay Area native John Anthony Cavalli after he retired from a highly successful 25-year corporate sales career at AT&T. John is prompt, professional, and personable. He receives excellent reviews for the manner in which he conducts real estate signing events and receives requests from all over the world for his expedited apostille processing services.</p>\r\n		<a style=\"font-weight: bold;\" href=\"http://notarypublicsanfranciscoca.com/about-notary-public/\"><i style=\"margin-right: 3px;\" class=\"icon-plus-squared\"></i>Read More About John</a>\r\n\r\n	</div>\r\n	<div class=\"left\">\r\n		[image src=\"http://notarypubliccastrovalley.com/wp-content/uploads/2015/05/notary-public-castro-valley-cavalli-john.jpg\" border=\"0\"]\r\n	</div>\r\n</div>\n\nfadeIn\n\nRecent Blog Posts\n\nline\n\nbounceIn\n\n3\n\nmasonry\n\n3\n\nContact Us\n\nicon\n\nfadeIn\n\n[list icon=\"icon-mail-line\" title=\"John@MobileNotarySanFrancisco.com\" link=\"#\" style=\"2\"]Questions?[/list]\r\n[list icon=\"icon-comment-line\" title=\"(415) 635-7419\" link=\"#\" style=\"2\"]Call us[/list]\n\nfadeIn\n\n[contact-form-7 id=\"20\" title=\"Contact page\"]\n\nfadeIn\n\n");
INSERT INTO `wp_postmeta` VALUES("4617", "3170", "mfn-post-css", ".welcome { overflow: hidden; }\r\n.welcome .left { width: 46%; float: left; }\r\n.welcome .right { width: 54%; float: left; background: #fff; padding: 26px 30px; -webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box; }\r\n\r\n.see_our_client { background: #fff; overflow: hidden; padding: 20px 20px 19px; }\r\n.see_our_client .left { width: 40%; float: left; text-align: center; }\r\n.see_our_client .right { width: 55%; margin-left: 5%; float: left; }\r\n\r\n@media only screen and (max-width: 767px) {\r\n\r\n	.welcome .left { width: 100%; float: none; }\r\n	.welcome .right { width: 100%; float: none; }\r\n\r\n	.see_our_client .left { width: 100%; float: none; }\r\n	.see_our_client .right { width: 100%; float: none; }\r\n\r\n}");
INSERT INTO `wp_postmeta` VALUES("4640", "3171", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("4641", "3171", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("4642", "3171", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("4643", "3171", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("4644", "3171", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("4645", "3171", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("4646", "3171", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("4647", "3171", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("4648", "3171", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("4649", "3171", "mfn-page-items", "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");
INSERT INTO `wp_postmeta` VALUES("4650", "3171", "mfn-page-items-seo", "Contact Us\n\n<h2 style=\"margin: 0;\">Contact Us</h2>\n\nfadeIn\n\nicon-mail-line\n\n<big style=\"padding-top: 20px; display: block\"><font color=\"white\">Email</font></big>\r\n<h4><a href=\"mailto:john@mobilenotarysanfrancisco.com\"><font color=\"white\">john@mobilenotarysanfrancisco.com</font></a></h4>\r\n\r\n<big style=\"padding-top: 20px; display: block\"><font color=\"white\">Phone</font></big>\r\n<h4><a href=\"tel:4156357419\"><font color=\"white\">(415) 635-7419</font></a></h4>\r\n\r\n<big style=\"padding-top: 20px; display: block\"><font color=\"white\">Fax</font></big>\r\n<h4><a href=\"tel:5103736770\"><font color=\"white\">(510) 373-6770</font></a></h4>\n\n2\n\nfadeIn\n\n<p><h2><center><font color=\"#2aabe4\">Notary Hours</font></h2></p><br<<h3>Available Every Day<br>7<sup>am</sup> - 7<sup>pm</sup></h3></center>\n\nfadeIn\n\nContact Form Instructions\n\n<div style=\"text-align: right;\">\r\n<h3>Write a message</h3>\r\n<p><big>Use this form to request a notary appointment or if you have questions.</big></p>\r\n<p style=\"color: #a8a8a8;\"><big>Our profiles in social media:</big></p>\r\n</div>\r\n<div style=\"float: right;\">\r\n[icon_bar icon=\"icon-facebook\" link=\"https://www.facebook.com/notarypubliccastrovalley\" target=\"_blank\" size=\"small\" social=\"facebook\"][icon_bar icon=\"icon-gplus\" link=\"https://plus.google.com/104846059146714084563/posts?cfem=1\" target=\"_blank\" size=\"small\" social=\"google\"][icon_bar icon=\"icon-linkedin\" link=\"https://www.linkedin.com/\" target=\"\" size=\"small\" social=\"linkedin\"]\r\n</div>\n\nfadeIn\n\nContact form\n\n[contact-form-7 id=\"447\" title=\"Contact page\"]\n\nfadeIn\n\n");
INSERT INTO `wp_postmeta` VALUES("4672", "20", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:31:\"Please fill the required field.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";}");
INSERT INTO `wp_postmeta` VALUES("4673", "20", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:50:\"BeVet - BeTheme <wordpress@themes.muffingroup.com>\";s:4:\"body\";s:131:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on BeVet - BeTheme (http://themes.muffingroup.com/be/vet)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:27:\"Reply-To: noreply@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("4674", "20", "_mail", "a:8:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:54:\"[your-name] <wordpress@mobilenotarysanfranciscoca.com>\";s:4:\"body\";s:176:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Canine Companion and Concierge\'s website.\";s:9:\"recipient\";s:35:\"john@mobilenotarysanfranciscoca.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("4675", "20", "_form", "<div class=\"column one-third\"><label>Name:</label>[text* your-name]</div>\n<div class=\"column one-third\"><label>E-mail address:</label>[email* your-email]</div>\n<div class=\"column one-third\"><label>Subject:</label>[text your-subject]</div>\n<div class=\"column one\"><label>Message:</label>[textarea your-message x4]</div>\n<div class=\"column one\">[submit \"Send message\"]</div>");
INSERT INTO `wp_postmeta` VALUES("4676", "20", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("4677", "20", "_locale", "en_US");
INSERT INTO `wp_postmeta` VALUES("4678", "3173", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("4679", "3173", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("4680", "3173", "_menu_item_object_id", "3170");
INSERT INTO `wp_postmeta` VALUES("4681", "3173", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("4682", "3173", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("4683", "3173", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4684", "3173", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("4685", "3173", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("4686", "3173", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("4687", "3173", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("4698", "3175", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("4699", "3175", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("4700", "3175", "_menu_item_object_id", "3171");
INSERT INTO `wp_postmeta` VALUES("4701", "3175", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("4702", "3175", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("4703", "3175", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4704", "3175", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("4705", "3175", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("4706", "3175", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("4707", "3175", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("4724", "654", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4725", "76", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4726", "70", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4727", "72", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4729", "65", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4734", "1832", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4735", "1835", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4736", "1838", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4737", "1841", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4738", "1829", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4739", "1851", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4740", "2946", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4741", "2964", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4742", "2967", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4743", "629", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("4766", "3170", "_edit_lock", "1453905422:1");
INSERT INTO `wp_postmeta` VALUES("4767", "3170", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("4768", "3170", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("4769", "3170", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("4770", "3170", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("4771", "3170", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4772", "3170", "_yoast_wpseo_title", "Mobile Notary San Francisco | Apostille & Consulate Service");
INSERT INTO `wp_postmeta` VALUES("4773", "3170", "_yoast_wpseo_focuskw", "mobile notary, apostille, authentication, notary public");
INSERT INTO `wp_postmeta` VALUES("4774", "3170", "_yoast_wpseo_linkdex", "37");
INSERT INTO `wp_postmeta` VALUES("4820", "3171", "_edit_lock", "1445995234:1");
INSERT INTO `wp_postmeta` VALUES("4821", "3171", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("4822", "3171", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("4823", "3171", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("4824", "3171", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("4825", "3171", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4826", "3202", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("4827", "3202", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("4828", "3202", "_menu_item_object_id", "3171");
INSERT INTO `wp_postmeta` VALUES("4829", "3202", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("4830", "3202", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("4831", "3202", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("4832", "3202", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("4833", "3202", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("4835", "3202", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("4836", "3202", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("4933", "3171", "_yoast_wpseo_title", "Contact Notary Public San Francisco | Mobile Notary SF");
INSERT INTO `wp_postmeta` VALUES("4934", "3171", "_yoast_wpseo_metadesc", "Schedule a notary appointment by calling or texting (415) 635-7419 or by sending an email message to john@notarypublicsanfranciscoca.com.");
INSERT INTO `wp_postmeta` VALUES("4957", "3170", "_yoast_wpseo_metadesc", "Notary Public San Francisco is a mobile notary and certified notary signing agent serving San Francisco and the SF Bay Area. Call 415.635.7419");
INSERT INTO `wp_postmeta` VALUES("4995", "168", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("4996", "168", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/beauty?mfn-c=pink&mfn-l=beauty&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("4997", "168", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("4998", "168", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("4999", "168", "_thumbnail_id", "1028");
INSERT INTO `wp_postmeta` VALUES("5000", "168", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5001", "168", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/beauty?mfn-c=pink&mfn-l=beauty&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5002", "168", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5003", "168", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5004", "1044", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5005", "1044", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/business?mfn-l=business&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5006", "1044", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5007", "1044", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5008", "1044", "_thumbnail_id", "1029");
INSERT INTO `wp_postmeta` VALUES("5009", "1044", "_dp_original", "168");
INSERT INTO `wp_postmeta` VALUES("5010", "1044", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5011", "1044", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/business?mfn-l=business&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5012", "1044", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5013", "1044", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5014", "1044", "_dp_original", "168");
INSERT INTO `wp_postmeta` VALUES("5015", "1049", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5016", "1049", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/church?mfn-c=violet&mfn-l=church");
INSERT INTO `wp_postmeta` VALUES("5017", "1049", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5018", "1049", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5019", "1049", "_dp_original", "1044");
INSERT INTO `wp_postmeta` VALUES("5020", "1049", "_thumbnail_id", "1030");
INSERT INTO `wp_postmeta` VALUES("5021", "1049", "_wp_old_slug", "bechurch");
INSERT INTO `wp_postmeta` VALUES("5022", "1049", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5023", "1049", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/church?mfn-c=violet&mfn-l=church");
INSERT INTO `wp_postmeta` VALUES("5024", "1049", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5025", "1049", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5026", "1049", "_dp_original", "1044");
INSERT INTO `wp_postmeta` VALUES("5027", "1049", "_wp_old_slug", "bechurch");
INSERT INTO `wp_postmeta` VALUES("5028", "1050", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5029", "1050", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/creative?mfn-c=violet&mfn-h=classic&mfn-l=creative&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5030", "1050", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5031", "1050", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5032", "1050", "_dp_original", "1049");
INSERT INTO `wp_postmeta` VALUES("5033", "1050", "_thumbnail_id", "1031");
INSERT INTO `wp_postmeta` VALUES("5034", "1050", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5035", "1050", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/creative?mfn-c=violet&mfn-h=classic&mfn-l=creative&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5036", "1050", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5037", "1050", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5038", "1050", "_dp_original", "1049");
INSERT INTO `wp_postmeta` VALUES("5039", "1057", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5040", "1057", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/hotel?mfn-c=chocolate&mfn-l=hotel");
INSERT INTO `wp_postmeta` VALUES("5041", "1057", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5042", "1057", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5043", "1057", "_dp_original", "1050");
INSERT INTO `wp_postmeta` VALUES("5044", "1057", "_thumbnail_id", "1032");
INSERT INTO `wp_postmeta` VALUES("5045", "1057", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5046", "1057", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/hotel?mfn-c=chocolate&mfn-l=hotel");
INSERT INTO `wp_postmeta` VALUES("5047", "1057", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5048", "1057", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5049", "1057", "_dp_original", "1050");
INSERT INTO `wp_postmeta` VALUES("5050", "1057", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5051", "1057", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5052", "1057", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5053", "1057", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5054", "1060", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5055", "1060", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/landing-page?mfn-c=orange&mfn-h=simple&mfn-l=landing&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5056", "1060", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5057", "1060", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5058", "1060", "_dp_original", "1057");
INSERT INTO `wp_postmeta` VALUES("5059", "1060", "_thumbnail_id", "1033");
INSERT INTO `wp_postmeta` VALUES("5060", "1060", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5061", "1060", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/landing-page?mfn-c=orange&mfn-h=simple&mfn-l=landing&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5062", "1060", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5063", "1060", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5064", "1060", "_dp_original", "1057");
INSERT INTO `wp_postmeta` VALUES("5065", "1064", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/lawyer?mfn-c=brown&mfn-h=classic&mfn-l=lawyer");
INSERT INTO `wp_postmeta` VALUES("5066", "1064", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5067", "1064", "_thumbnail_id", "1034");
INSERT INTO `wp_postmeta` VALUES("5068", "1064", "_dp_original", "1060");
INSERT INTO `wp_postmeta` VALUES("5069", "1064", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5070", "1064", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5071", "1064", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/lawyer?mfn-c=brown&mfn-h=classic&mfn-l=lawyer");
INSERT INTO `wp_postmeta` VALUES("5072", "1064", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5073", "1064", "_dp_original", "1060");
INSERT INTO `wp_postmeta` VALUES("5074", "1064", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5075", "1064", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5076", "1065", "_dp_original", "1064");
INSERT INTO `wp_postmeta` VALUES("5077", "1065", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5078", "1065", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5079", "1065", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/mechanic?mfn-c=yellow&mfn-l=mechanic");
INSERT INTO `wp_postmeta` VALUES("5080", "1065", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5081", "1065", "_thumbnail_id", "1035");
INSERT INTO `wp_postmeta` VALUES("5082", "1065", "_dp_original", "1064");
INSERT INTO `wp_postmeta` VALUES("5083", "1065", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5084", "1065", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5085", "1065", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/mechanic?mfn-c=yellow&mfn-l=mechanic");
INSERT INTO `wp_postmeta` VALUES("5086", "1065", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5087", "1065", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5088", "1066", "_dp_original", "1065");
INSERT INTO `wp_postmeta` VALUES("5089", "1066", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5090", "1066", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5091", "1066", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/medic?mfn-c=sea&mfn-l=medic&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5092", "1066", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5093", "1066", "_thumbnail_id", "1036");
INSERT INTO `wp_postmeta` VALUES("5094", "1066", "_dp_original", "1065");
INSERT INTO `wp_postmeta` VALUES("5095", "1066", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5096", "1066", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5097", "1066", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/medic?mfn-c=sea&mfn-l=medic&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5098", "1066", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5099", "1066", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5100", "1067", "_dp_original", "1066");
INSERT INTO `wp_postmeta` VALUES("5101", "1067", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5102", "1067", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5103", "1067", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/restaurant?mfn-c=olive&mfn-l=restaurant&mfn-f=Courgette");
INSERT INTO `wp_postmeta` VALUES("5104", "1067", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5105", "1067", "_thumbnail_id", "1037");
INSERT INTO `wp_postmeta` VALUES("5106", "1067", "_dp_original", "1066");
INSERT INTO `wp_postmeta` VALUES("5107", "1067", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5108", "1067", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5109", "1067", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/restaurant?mfn-c=olive&mfn-l=restaurant&mfn-f=Courgette");
INSERT INTO `wp_postmeta` VALUES("5110", "1067", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5111", "1067", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5112", "1068", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5113", "1068", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/school?mfn-c=orange&mfn-l=school&mfn-f=Courgette");
INSERT INTO `wp_postmeta` VALUES("5114", "1068", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5115", "1068", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5116", "1068", "_dp_original", "1067");
INSERT INTO `wp_postmeta` VALUES("5117", "1068", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5118", "1068", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/school?mfn-c=orange&mfn-l=school&mfn-f=Courgette");
INSERT INTO `wp_postmeta` VALUES("5119", "1068", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5120", "1068", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5121", "1068", "_dp_original", "1067");
INSERT INTO `wp_postmeta` VALUES("5122", "1068", "_thumbnail_id", "1038");
INSERT INTO `wp_postmeta` VALUES("5123", "1069", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5124", "1069", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/shop?mfn-c=red&mfn-l=shop&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5125", "1069", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5126", "1069", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5127", "1069", "_dp_original", "1068");
INSERT INTO `wp_postmeta` VALUES("5128", "1069", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5129", "1069", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/shop?mfn-c=red&mfn-l=shop&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5130", "1069", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5131", "1069", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5132", "1069", "_dp_original", "1068");
INSERT INTO `wp_postmeta` VALUES("5133", "1069", "_thumbnail_id", "1039");
INSERT INTO `wp_postmeta` VALUES("5134", "1069", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5135", "1070", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5136", "1070", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/transport?mfn-c=green&mfn-l=transport");
INSERT INTO `wp_postmeta` VALUES("5137", "1070", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5138", "1070", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5139", "1070", "_dp_original", "1069");
INSERT INTO `wp_postmeta` VALUES("5140", "1070", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5141", "1070", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/transport?mfn-c=green&mfn-l=transport");
INSERT INTO `wp_postmeta` VALUES("5142", "1070", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5143", "1070", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5144", "1070", "_dp_original", "1069");
INSERT INTO `wp_postmeta` VALUES("5145", "1070", "_thumbnail_id", "1040");
INSERT INTO `wp_postmeta` VALUES("5146", "1070", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5147", "1167", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5148", "1167", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/wedding?mfn-c=gold&mfn-l=wedding&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5149", "1167", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5150", "1167", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5151", "1167", "_dp_original", "1070");
INSERT INTO `wp_postmeta` VALUES("5152", "1167", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5153", "1167", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/wedding?mfn-c=gold&mfn-l=wedding&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5154", "1167", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5155", "1167", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5156", "1167", "_dp_original", "1070");
INSERT INTO `wp_postmeta` VALUES("5157", "1167", "_thumbnail_id", "1041");
INSERT INTO `wp_postmeta` VALUES("5158", "1167", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5159", "1563", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5160", "1563", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5161", "1563", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/wedding?mfn-c=gold&mfn-l=wedding&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5162", "1563", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/wedding?mfn-c=gold&mfn-l=wedding&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5163", "1563", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5164", "1563", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5165", "1563", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5166", "1563", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5167", "1563", "_dp_original", "1167");
INSERT INTO `wp_postmeta` VALUES("5168", "1563", "_thumbnail_id", "1564");
INSERT INTO `wp_postmeta` VALUES("5169", "1563", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5170", "1566", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5171", "1566", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5172", "1566", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/wedding?mfn-c=gold&mfn-l=wedding&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5173", "1566", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/wedding?mfn-c=gold&mfn-l=wedding&mfn-f=Lato");
INSERT INTO `wp_postmeta` VALUES("5174", "1566", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5175", "1566", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5176", "1566", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5177", "1566", "mfn-post-target", "0");
INSERT INTO `wp_postmeta` VALUES("5178", "1566", "_dp_original", "1563");
INSERT INTO `wp_postmeta` VALUES("5179", "1566", "_thumbnail_id", "1567");
INSERT INTO `wp_postmeta` VALUES("5180", "1566", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5181", "1734", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/renovate?mfn-box&mfn-c=one&mfn-o=1d3e93&mfn-l=renovate&mfn-h=stack,left");
INSERT INTO `wp_postmeta` VALUES("5182", "1734", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5183", "1734", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5184", "1734", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/renovate?mfn-box&mfn-c=one&mfn-o=1d3e93&mfn-l=renovate&mfn-h=stack,left");
INSERT INTO `wp_postmeta` VALUES("5185", "1734", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5186", "1734", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5187", "1734", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5188", "1734", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5189", "1734", "_dp_original", "1566");
INSERT INTO `wp_postmeta` VALUES("5190", "1734", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5191", "1734", "_thumbnail_id", "1735");
INSERT INTO `wp_postmeta` VALUES("5192", "1736", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5193", "1736", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5194", "1736", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/blog?mfn-h=classic&mfn-c=one&mfn-o=face43&mfn-l=blogger");
INSERT INTO `wp_postmeta` VALUES("5195", "1736", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/blog?mfn-h=classic&mfn-c=one&mfn-o=face43&mfn-l=blogger");
INSERT INTO `wp_postmeta` VALUES("5196", "1736", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5197", "1736", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5198", "1736", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5199", "1736", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5200", "1736", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5201", "1736", "_dp_original", "1734");
INSERT INTO `wp_postmeta` VALUES("5202", "1736", "_thumbnail_id", "1737");
INSERT INTO `wp_postmeta` VALUES("5203", "1738", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5204", "1738", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5205", "1738", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/portfolio?mfn-h=below&mfn-c=one&mfn-o=23cce0&mfn-l=portfolio");
INSERT INTO `wp_postmeta` VALUES("5206", "1738", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/portfolio?mfn-h=below&mfn-c=one&mfn-o=23cce0&mfn-l=portfolio");
INSERT INTO `wp_postmeta` VALUES("5207", "1738", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5208", "1738", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5209", "1738", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5210", "1738", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5211", "1738", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5212", "1738", "_dp_original", "1736");
INSERT INTO `wp_postmeta` VALUES("5213", "1738", "_thumbnail_id", "1739");
INSERT INTO `wp_postmeta` VALUES("5214", "1779", "_thumbnail_id", "1780");
INSERT INTO `wp_postmeta` VALUES("5215", "1779", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5216", "1779", "_dp_original", "1738");
INSERT INTO `wp_postmeta` VALUES("5217", "1779", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5218", "1779", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5219", "1779", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5220", "1779", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5221", "1779", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5222", "1779", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/resume?mfn-h=below&mfn-box&mfn-min&mfn-f=Lato&mfn-o=000000&mfn-c=one&mfn-l=resume");
INSERT INTO `wp_postmeta` VALUES("5223", "1779", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5224", "1779", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/resume?mfn-h=below&mfn-box&mfn-min&mfn-f=Lato&mfn-o=000000&mfn-c=one&mfn-l=resume");
INSERT INTO `wp_postmeta` VALUES("5225", "1782", "_thumbnail_id", "1783");
INSERT INTO `wp_postmeta` VALUES("5226", "1782", "_dp_original", "1779");
INSERT INTO `wp_postmeta` VALUES("5227", "1782", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("5228", "1782", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5229", "1782", "mfn-post-target", "1");
INSERT INTO `wp_postmeta` VALUES("5230", "1782", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5231", "1782", "mfn-post-link_title", "View demo");
INSERT INTO `wp_postmeta` VALUES("5232", "1782", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/photo?mfn-o=face43&mfn-c=one&mfn-l=photo&mfn-h=simple");
INSERT INTO `wp_postmeta` VALUES("5233", "1782", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5234", "1782", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5235", "1782", "mfn-post-link", "http://themes.muffingroup.com/betheme/home/photo?mfn-o=face43&mfn-c=one&mfn-l=photo&mfn-h=simple");
INSERT INTO `wp_postmeta` VALUES("5239", "3170", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5240", "3170", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("5241", "3170", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("5242", "3170", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("5243", "3170", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("5244", "3170", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("5245", "3170", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("5246", "3170", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("5247", "3170", "mfn-page-items", "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");
INSERT INTO `wp_postmeta` VALUES("5248", "3170", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5249", "3170", "mfn-page-items-seo", "Call now\n\n<h2 style=\"color: #2aabe4;\"><b>SF Mobile Notary</b></h2><h3 style=\"color: #2aabe4;\"><br>Real Estate Signings<br>Apostilles & Authentications<br>Consulate Legalizations</h3>\r\n[divider height=\"50\"]\r\n<h2 style=\"color: #2aabe4;\"><b>Call (415) 635-7419</b></h2><br>\r\n\r\n[button title=\"Online Scheduling Tool\" icon=\"\" icon_position=\"\" link=\"/scheduling/\" target=\"_blank\" color=\"#2aabe4\" font_color=\"white\" large=\"6\" class=\"\" download=\"\" onclick=\"\"]\n\n80px 0 0 0\n\nfadeIn\n\nForm\n\n<div class=\"order_form clearfix\" style=\"background: url(http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/10/blue-back.png) no-repeat right top; padding: 30px; border-radius: 20px 0 20px 20px;\">\r\n\r\n<h3><font color=\"white\">Question or request?</font></h3>\r\n<p style=\"color: white;\" class=\"big\">Submit this form and we will get back to you promptly.</p>\r\n[contact-form-7 id=\"4199\" title=\"New form\"]\r\n</div>\n\n10px 0 0 0\n\nfadeIn\n\n<img src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2014/10/signing.jpg\" alt=\"\"/>\n\nMobile Notary Public\n\n<a href=\"/mobile-notary/\">/mobile-notary/</a>\n\nfadeIn\n\n<img src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2014/10/san-francisco-notary-globe.jpg\" alt=\"\"/>\n\nApostilles and Authentications\n\n<a href=\"/apostille-authentication/\">/apostille-authentication/</a>\n\nfadeIn\n\n<img src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2014/10/houses.jpg\" alt=\"\"/>\n\nCertified Notary Signing Agent\n\n<a href=\"http://notarypublicsanfranciscoca.com/certified-notary-signing-agent/\">http://notarypublicsanfranciscoca.com/certified-notary-signing-agent/</a>\n\nfadeIn\n\nMobile Notary Service\n\n<div class=\"see_our_client\">\r\n<div class=\"left\">\r\n		[image src=\"http://notarypublicsanfranciscoca.com/wp-content/uploads/2015/10/notary-public-SF-phone.png\" border=\"0\"]\r\n	</div>	\r\n	<div class=\"right\">\r\n		<h3 style=\"margin-top: 20px;\">Call to Book Our Mobile Notary Service</h3>\r\n		<p class=\"big\" style=\"margin-bottom: 25px;\">Notary Public San Francisco offers San Francisco businesses, residents and visitors on-demand, mobile notary services. Our SF notary public firm specializes in conducting real estate closing package signings and expediting California Secretary of State and US State Department apostille processing. We also assist you when you need help obtaining foreign consulate and embassy authentications required for legal recognition of documents overseas. Document printing, and local pick-up and delivery, FedEx/UPS/USPS drop off services available. Same-day, evening, and weekend appointments available.</p>\r\n		<a style=\"font-weight: bold;\" href=\"http://notarypublicsanfranciscoca.com/about-notary-public/\"><i style=\"margin-right: 3px;\" class=\"icon-plus-squared\"></i>Learn More</a>\r\n	</div>\r\n\r\n</div>\n\nfadeIn\n\nJohn Anthony Cavalli\n\n<div class=\"see_our_client\">\r\n	<div class=\"right\">\r\n		<h3 style=\"margin-top: 20px;\">John Anthony Cavalli<br>Certified Notary Signing Agent</h3>\r\n		<p class=\"big\" style=\"margin-bottom: 25px;\">Notary Public San Francisco was founded by Bay Area native John Anthony Cavalli after he retired from a highly successful 25-year corporate sales career at AT&T. John is prompt, professional, and personable. He receives excellent reviews for the manner in which he conducts real estate signing events and receives requests from all over the world for his expedited apostille processing services.</p>\r\n		<a style=\"font-weight: bold;\" href=\"http://notarypublicsanfranciscoca.com/about-notary-public/\"><i style=\"margin-right: 3px;\" class=\"icon-plus-squared\"></i>Read More About John</a>\r\n\r\n	</div>\r\n	<div class=\"left\">\r\n		[image src=\"http://notarypubliccastrovalley.com/wp-content/uploads/2015/05/notary-public-castro-valley-cavalli-john.jpg\" border=\"0\"]\r\n	</div>\r\n</div>\n\nfadeIn\n\nRecent Blog Posts\n\nline\n\nbounceIn\n\n3\n\nmasonry\n\n3\n\nContact Us\n\nicon\n\nfadeIn\n\n[list icon=\"icon-mail-line\" title=\"John@MobileNotarySanFrancisco.com\" link=\"#\" style=\"2\"]Questions?[/list]\r\n[list icon=\"icon-comment-line\" title=\"(415) 635-7419\" link=\"#\" style=\"2\"]Call us[/list]\n\nfadeIn\n\n[contact-form-7 id=\"20\" title=\"Contact page\"]\n\nfadeIn\n\n");
INSERT INTO `wp_postmeta` VALUES("5250", "3170", "mfn-post-css", ".welcome { overflow: hidden; }\r\n.welcome .left { width: 46%; float: left; }\r\n.welcome .right { width: 54%; float: left; background: #fff; padding: 26px 30px; -webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box; }\r\n\r\n.see_our_client { background: #fff; overflow: hidden; padding: 20px 20px 19px; }\r\n.see_our_client .left { width: 40%; float: left; text-align: center; }\r\n.see_our_client .right { width: 55%; margin-left: 5%; float: left; }\r\n\r\n@media only screen and (max-width: 767px) {\r\n\r\n	.welcome .left { width: 100%; float: none; }\r\n	.welcome .right { width: 100%; float: none; }\r\n\r\n	.see_our_client .left { width: 100%; float: none; }\r\n	.see_our_client .right { width: 100%; float: none; }\r\n\r\n}");
INSERT INTO `wp_postmeta` VALUES("5273", "3171", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5274", "3171", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5275", "3171", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("5276", "3171", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("5277", "3171", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("5278", "3171", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("5279", "3171", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("5280", "3171", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("5281", "3171", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("5282", "3171", "mfn-page-items", "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");
INSERT INTO `wp_postmeta` VALUES("5283", "3171", "mfn-page-items-seo", "Contact Us\n\n<h2 style=\"margin: 0;\">Contact Us</h2>\n\nfadeIn\n\nicon-mail-line\n\n<big style=\"padding-top: 20px; display: block\"><font color=\"white\">Email</font></big>\r\n<h4><a href=\"mailto:john@mobilenotarysanfrancisco.com\"><font color=\"white\">john@mobilenotarysanfrancisco.com</font></a></h4>\r\n\r\n<big style=\"padding-top: 20px; display: block\"><font color=\"white\">Phone</font></big>\r\n<h4><a href=\"tel:4156357419\"><font color=\"white\">(415) 635-7419</font></a></h4>\r\n\r\n<big style=\"padding-top: 20px; display: block\"><font color=\"white\">Fax</font></big>\r\n<h4><a href=\"tel:5103736770\"><font color=\"white\">(510) 373-6770</font></a></h4>\n\n2\n\nfadeIn\n\n<p><h2><center><font color=\"#2aabe4\">Notary Hours</font></h2></p><br<<h3>Available Every Day<br>7<sup>am</sup> - 7<sup>pm</sup></h3></center>\n\nfadeIn\n\nContact Form Instructions\n\n<div style=\"text-align: right;\">\r\n<h3>Write a message</h3>\r\n<p><big>Use this form to request a notary appointment or if you have questions.</big></p>\r\n<p style=\"color: #a8a8a8;\"><big>Our profiles in social media:</big></p>\r\n</div>\r\n<div style=\"float: right;\">\r\n[icon_bar icon=\"icon-facebook\" link=\"https://www.facebook.com/notarypubliccastrovalley\" target=\"_blank\" size=\"small\" social=\"facebook\"][icon_bar icon=\"icon-gplus\" link=\"https://plus.google.com/104846059146714084563/posts?cfem=1\" target=\"_blank\" size=\"small\" social=\"google\"][icon_bar icon=\"icon-linkedin\" link=\"https://www.linkedin.com/\" target=\"\" size=\"small\" social=\"linkedin\"]\r\n</div>\n\nfadeIn\n\nContact form\n\n[contact-form-7 id=\"447\" title=\"Contact page\"]\n\nfadeIn\n\n");
INSERT INTO `wp_postmeta` VALUES("5284", "3231", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5285", "3231", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5286", "3231", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("5287", "3231", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("5288", "3231", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("5289", "3231", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("5290", "3231", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("5291", "3231", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("5292", "3231", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("5293", "3231", "mfn-page-items", "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");
INSERT INTO `wp_postmeta` VALUES("5294", "3231", "mfn-page-items-seo", "About Notary Public Castro Valley\n\n<p><h2><font color=\"#00a99e\">About Notary Public San Francisco</font></h2></p>\r\n<p class=\"regular\" \"><font size=\"+1\" >Notary Public San Francisco is a mobile notary service that specializes in assisting the community with notarization of signatures on loan packages, apostilles, authentications, and all other documents that require notarized signatures. </font></p>\r\n\r\n<p class=\"regular\" \"><font size=\"+1\" >Our California Secretary of State-commissioned notaries public are <b>Certified Notary Signing Agents</b>, who will meet you in your home, office, or a public space in or near San Francisco.</font></p>\n\nfadeIn\n\n<p><h3><center><font color=\"#2aabe4\">Operating Hours</font></center></h3></p><ul><li><label>Monday - Friday</label><span>7<sup>am</sup> - 7<sup>pm</sup></span></li><li><label>Late Evenings and Weekends</label><span><font size=\"3\">Call (415) 635-7419 for Availability</font></span></li></ul>\n\nfadeIn\n\n<font color=\"white\">Call (415) 635-7419 to Schedule an Appointment</font>\n\nicon-brush\n\n<font color=\"white\">Committed to service excellence and protecting our community.</font>\n\narrows\n\nfadeIn\n\nOur Services Include\n\n<h3 style=\"margin: 0;\">Fast, Dependable Notary Services</h3>We understand that time is money and the importance of getting the job completed correctly the first time. Our business practices ensure excellence and accuracy.\n\nleft\n\nfadeIn\n\nOur Services Include\n\n<h3 style=\"margin: 0;\">Low Cost Mobile Notary Services</h3>\r\nNotary Public San Francisco works with agencies, corporations, individuals, escrow offices, law firms, nonprofit organizations, and title companies in San Francisco.\n\nleft\n\nfadeIn\n\nhttp://notarypubliccastrovalley.com/wp-content/uploads/2015/05/notary-public-castro-valley-cavalli-john.jpg\n\n200\n\n200\n\ncenter\n\nfadeIn\n\nAbout John Cavalli\n\n<h3>About John Anthony Cavalli</h3>John Anthony Cavalli is a mobile notary public who travels to your home, office, or public location. Same-day, evening, and weekend appointments available. John specializes in home loans. He can also help expedite processing of your California Secretary of State and US State Department apostilles and authentications and foreign consulate and embassy authentications. John is bonded and insured, carrying a $100,000 Errors and Omissions policy. He accepts documents in person or by courier, US mail, email, and download.\n\nleft\n\nfadeIn\n\nhttp://notarypubliccastrovalley.com/wp-content/uploads/2014/10/hayward-notary-public.jpg\n\ncenter\n\nfadeIn\n\n");
INSERT INTO `wp_postmeta` VALUES("5305", "20", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:31:\"Please fill the required field.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";}");
INSERT INTO `wp_postmeta` VALUES("5306", "20", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:50:\"BeVet - BeTheme <wordpress@themes.muffingroup.com>\";s:4:\"body\";s:131:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on BeVet - BeTheme (http://themes.muffingroup.com/be/vet)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:27:\"Reply-To: noreply@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("5307", "20", "_mail", "a:8:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:54:\"[your-name] <wordpress@mobilenotarysanfranciscoca.com>\";s:4:\"body\";s:176:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Canine Companion and Concierge\'s website.\";s:9:\"recipient\";s:35:\"john@mobilenotarysanfranciscoca.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("5308", "20", "_form", "<div class=\"column one-third\"><label>Name:</label>[text* your-name]</div>\n<div class=\"column one-third\"><label>E-mail address:</label>[email* your-email]</div>\n<div class=\"column one-third\"><label>Subject:</label>[text your-subject]</div>\n<div class=\"column one\"><label>Message:</label>[textarea your-message x4]</div>\n<div class=\"column one\">[submit \"Send message\"]</div>");
INSERT INTO `wp_postmeta` VALUES("5309", "20", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("5310", "20", "_locale", "en_US");
INSERT INTO `wp_postmeta` VALUES("5311", "3233", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("5312", "3233", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("5313", "3233", "_menu_item_object_id", "3170");
INSERT INTO `wp_postmeta` VALUES("5314", "3233", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("5315", "3233", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("5316", "3233", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5317", "3233", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("5318", "3233", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("5319", "3233", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("5320", "3233", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("5321", "3234", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("5322", "3234", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("5323", "3234", "_menu_item_object_id", "3231");
INSERT INTO `wp_postmeta` VALUES("5324", "3234", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("5325", "3234", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("5326", "3234", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5327", "3234", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("5328", "3234", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("5329", "3234", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("5330", "3234", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("5331", "3235", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("5332", "3235", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("5333", "3235", "_menu_item_object_id", "3171");
INSERT INTO `wp_postmeta` VALUES("5334", "3235", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("5335", "3235", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("5336", "3235", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5337", "3235", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("5338", "3235", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("5339", "3235", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("5340", "3235", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("5351", "3231", "_edit_lock", "1445240359:1");
INSERT INTO `wp_postmeta` VALUES("5352", "3231", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("5353", "3231", "vc_teaser", "a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5354", "3231", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("5355", "3231", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("5356", "3231", "_wpb_vc_js_interface_version", "0");
INSERT INTO `wp_postmeta` VALUES("5407", "3325", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("5408", "3325", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("5409", "3325", "_menu_item_object_id", "3231");
INSERT INTO `wp_postmeta` VALUES("5410", "3325", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("5411", "3325", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("5412", "3325", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5413", "3325", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("5414", "3325", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("5416", "3325", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("5417", "3325", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("5442", "3355", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("5443", "3355", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("5444", "3355", "_menu_item_object_id", "3170");
INSERT INTO `wp_postmeta` VALUES("5445", "3355", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("5446", "3355", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("5447", "3355", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("5448", "3355", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("5449", "3355", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("5451", "3355", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("5452", "3355", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("5589", "1162", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5590", "1162", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5591", "1162", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("5592", "1162", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("5593", "1162", "mfn-post-sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("5594", "1162", "mfn-post-layout", "no-sidebar");
INSERT INTO `wp_postmeta` VALUES("5595", "1162", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5596", "1162", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("5597", "1162", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("5598", "1162", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("5599", "1162", "mfn-post-sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("5600", "1162", "mfn-post-layout", "no-sidebar");
INSERT INTO `wp_postmeta` VALUES("5601", "1162", "_thumbnail_id", "1679");
INSERT INTO `wp_postmeta` VALUES("5602", "1162", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("6154", "618", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("6155", "618", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("6156", "618", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("6157", "618", "mfn-post-sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("6158", "618", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("6159", "618", "mfn-page-items", "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");
INSERT INTO `wp_postmeta` VALUES("6160", "618", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("6161", "618", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("6162", "618", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("6163", "618", "mfn-post-sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("6164", "618", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("6165", "618", "mfn-page-items", "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